package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on versions-maven-plugin. Call <pre>  mvn versions:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Apr 23 19:50:34 BST 2009
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:versions-maven-plugin:1.0-alpha-3", 0 );
        append( sb, "", 0 );

        append( sb, "Versions Maven Plugin 1.0-alpha-3", 0 );
        append( sb, "Versions Plugin for Maven 2. The Versions Plugin updates the versions of components in the POM.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 19 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "commit".equals( goal ) )
        {
            append( sb, "versions:commit", 0 );
            append( sb, "Removes the initial backup of the pom, thereby accepting the changes.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dependency-updates-report".equals( goal ) )
        {
            append( sb, "versions:dependency-updates-report", 0 );
            append( sb, "Created by IntelliJ IDEA.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "display-dependency-updates".equals( goal ) )
        {
            append( sb, "versions:display-dependency-updates", 0 );
            append( sb, "Displays all dependencies that have newer versions available.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "display-dependency-updates-report".equals( goal ) )
        {
            append( sb, "versions:display-dependency-updates-report", 0 );
            append( sb, "This report summarizes all project dependencies for which newer versions may exist. For convenience, the new versions are segregated by incremental, minor, and major changes, since each tends to have a different level of effort (and risk) involved when upgrading.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of groupId:artifactId keys, which indicate that the corresponding artifact(s) should be omitted from the report (even when showAll is true). For example:\n<excludes>\n\u00a0\u00a0\u00a0\u00a0<exclude>com.oracle:ojdbc14</exclude>\n</excludes>", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );

                append( sb, "showAll (Default: false)", 2 );
                append( sb, "If true, show all unexcluded dependencies in the report - even those that have no updates available.", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "display-plugin-updates".equals( goal ) )
        {
            append( sb, "versions:display-plugin-updates", 0 );
            append( sb, "Displays all plugins that have newer versions available.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "versions:help", 0 );
            append( sb, "Display help information on versions-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0versions:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "lock-snapshots".equals( goal ) )
        {
            append( sb, "versions:lock-snapshots", 0 );
            append( sb, "Attempts to resolve unlocked snapshot dependency versions to the locked timestamp versions used in the build. For example, an unlocked snapshot version like \'1.0-SNAPSHOT\' could be resolved to \'1.0-20090128.202731-1\'. If a timestamped snapshot is not available, then the version will remained unchanged. This would be the case if the dependency is only available in the local repository and not in a remote snapshot repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resolve-ranges".equals( goal ) )
        {
            append( sb, "versions:resolve-ranges", 0 );
            append( sb, "Attempts to resolve dependency version ranges to the specific version being used in the build. For example a version range of \'[1.0, 1.2)\' would be resolved to the specific version currently in use \'1.1\'.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "revert".equals( goal ) )
        {
            append( sb, "versions:revert", 0 );
            append( sb, "Restores the pom from the initial backup.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "simple-report".equals( goal ) )
        {
            append( sb, "versions:simple-report", 0 );
            append( sb, "Created by IntelliJ IDEA.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );

                append( sb, "skip", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "unlock-snapshots".equals( goal ) )
        {
            append( sb, "versions:unlock-snapshots", 0 );
            append( sb, "Attempts to resolve unlocked snapshot dependency versions to the locked timestamp versions used in the build. For example, an unlocked snapshot version like \'1.0-SNAPSHOT\' could be resolved to \'1.0-20090128.202731-1\'. If a timestamped snapshot is not available, then the version will remained unchanged. This would be the case if the dependency is only available in the local repository and not in a remote snapshot repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-child-modules".equals( goal ) )
        {
            append( sb, "versions:update-child-modules", 0 );
            append( sb, "Scans the current projects child modules, updating the versions of any which use the current project to the version of the current project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-parent".equals( goal ) )
        {
            append( sb, "versions:update-parent", 0 );
            append( sb, "Sets the parent version to the latest parent version.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "parentVersion", 2 );
                append( sb, "Version specification to control artifact resolution.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-properties".equals( goal ) )
        {
            append( sb, "versions:update-properties", 0 );
            append( sb, "Sets properties to the latest versions of specific artifacts.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "autoLinkItems", 2 );
                append( sb, "Whether properties linking versions should be auto-detected or not.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeProperties", 2 );
                append( sb, "A comma separated list of properties to not update.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includeProperties", 2 );
                append( sb, "A comma separated list of properties to update.", 3 );
                append( sb, "", 0 );

                append( sb, "properties", 2 );
                append( sb, "Any restrictions that apply to specific properties.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "use-latest-releases".equals( goal ) )
        {
            append( sb, "versions:use-latest-releases", 0 );
            append( sb, "Replaces any release versions with the latest release version.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "use-latest-versions".equals( goal ) )
        {
            append( sb, "versions:use-latest-versions", 0 );
            append( sb, "Replaces any version with the latest version.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "use-next-releases".equals( goal ) )
        {
            append( sb, "versions:use-next-releases", 0 );
            append( sb, "Replaces any release versions with the next release version (if it has been released).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "use-next-versions".equals( goal ) )
        {
            append( sb, "versions:use-next-versions", 0 );
            append( sb, "Replaces any version with the latest version.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "use-releases".equals( goal ) )
        {
            append( sb, "versions:use-releases", 0 );
            append( sb, "Replaces any -SNAPSHOT versions with the corresponding release version (if it has been released).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allowSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonMethod", 2 );
                append( sb, "The versioning rule to use when comparing versions. Valid values are maven, numeric which will handle long version numbers provided all components are numeric, or mercury which will use the mercury version number comparison rules.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeReactor", 2 );
                append( sb, "Whether to skip processing dependencies that are produced as part of the current reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of artifact patterns to exclude. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBackupPoms", 2 );
                append( sb, "Controls whether a backup pom should be created (default is true).", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of artifact patterns to include. Follows the pattern \'groupId:artifactId:type:classifier:version\'.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencies", 2 );
                append( sb, "Whether to process the dependencies section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "processDependencyManagement", 2 );
                append( sb, "Whether to process the dependencyManagement section of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesUri", 2 );
                append( sb, "The Wagon URI of a ruleSet file containing the rules that control how to compare version numbers.", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
