/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.stax2.XMLInputFactory2;

public abstract class AbstractVersionsUpdaterMojo
extends AbstractMojo {
    private MavenProject project;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver resolver;
    protected MavenProjectBuilder projectBuilder;
    protected List reactorProjects;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected List remoteArtifactRepositories;
    protected List remotePluginRepositories;
    protected ArtifactRepository localRepository;
    private WagonManager wagonManager;
    private Settings settings;
    private String serverId;
    private String rulesUri;
    private Boolean generateBackupPoms;
    protected String comparisonMethod;
    protected Boolean allowSnapshots;
    private VersionsHelper helper;
    protected MavenSession session;
    protected PathTranslator pathTranslator;

    public VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper(this.artifactFactory, this.artifactMetadataSource, this.remoteArtifactRepositories, this.remotePluginRepositories, this.localRepository, this.wagonManager, this.settings, this.serverId, this.rulesUri, this.comparisonMethod, this.getLog());
        }
        return this.helper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outFile = this.project.getFile();
        this.process(outFile);
    }

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws MojoExecutionException {
        boolean includeSnapshots = Boolean.TRUE.equals(this.allowSnapshots);
        if (Boolean.TRUE.equals(allowingSnapshots)) {
            includeSnapshots = true;
        }
        if (Boolean.FALSE.equals(allowingSnapshots)) {
            includeSnapshots = false;
        }
        ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, usePluginRepositories);
        return artifactVersions.getLatestVersion(versionRange, includeSnapshots);
    }

    protected Comparator getVersionComparator() {
        return VersionComparators.getVersionComparator(this.comparisonMethod);
    }

    protected String getPropertyValue(StringBuffer pom, String property) {
        return this.project.getProperties().getProperty(property);
    }

    protected void process(File outFile) throws MojoExecutionException, MojoFailureException {
        try {
            StringBuffer input = this.readFile(outFile);
            ModifiedPomXMLEventReader newPom = this.newModifiedPomXER(input);
            this.update(newPom);
            if (newPom.isModified()) {
                if (Boolean.FALSE.equals(this.generateBackupPoms)) {
                    this.getLog().debug((CharSequence)"Skipping generation of backup file");
                } else {
                    File backupFile = new File(outFile.getParentFile(), outFile.getName() + ".versionsBackup");
                    if (!backupFile.exists()) {
                        this.getLog().debug((CharSequence)("Backing up " + outFile + " to " + backupFile));
                        FileUtils.copyFile((File)outFile, (File)backupFile);
                    } else {
                        this.getLog().debug((CharSequence)("Leaving existing backup " + backupFile + " unmodified"));
                    }
                }
                this.writeFile(outFile, input);
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected final ModifiedPomXMLEventReader newModifiedPomXER(StringBuffer input) {
        ModifiedPomXMLEventReader newPom = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            newPom = new ModifiedPomXMLEventReader(input, inputFactory);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        return newPom;
    }

    protected final void writeFile(File outFile, StringBuffer input) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        ((OutputStream)out).write(input.toString().getBytes("UTF-8"));
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final StringBuffer readFile(File outFile) throws IOException {
        BufferedInputStream reader = new BufferedInputStream(new FileInputStream(outFile));
        byte[] content = new byte[(int)outFile.length()];
        StringBuffer input = new StringBuffer(content.length);
        try {
            int length = reader.read(content, 0, content.length);
            input.append(new String(content, 0, length, "UTF-8"));
            StringBuffer stringBuffer = input;
            return stringBuffer;
        }
        finally {
            reader.close();
        }
    }

    protected abstract void update(ModifiedPomXMLEventReader var1) throws MojoExecutionException, MojoFailureException, XMLStreamException;

    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion) {
        this.getLog().debug((CharSequence)("Proposal is to update from " + currentVersion + " to " + updateVersion));
        if (updateVersion == null) {
            this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
            return false;
        }
        artifact.setVersion(updateVersion.toString());
        try {
            this.resolver.resolveAlways(artifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not resolve " + artifact.toString()), (Throwable)e);
            return false;
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not find " + artifact.toString()), (Throwable)e);
            return false;
        }
        if (currentVersion.equals(updateVersion.toString())) {
            this.getLog().info((CharSequence)("Current version of " + artifact.toString() + " is the latest."));
            return false;
        }
        return true;
    }

    protected ExpressionEvaluator getExpressionEvaluator() {
        return new VersionsExpressionEvaluator(this.session, this.pathTranslator, this.project);
    }
}

