/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.DisplayDependencyUpdatesRenderer;
import org.codehaus.mojo.versions.ordering.VersionComparators;

public class DisplayDependencyUpdatesReport
extends AbstractVersionsReport {
    protected ArrayList excludes;
    protected Boolean showAll;

    public boolean canGenerateReport() {
        return true;
    }

    protected void doGenerateReport(Locale locale, Sink sink) {
        TreeMap<String, MultiVersionSummary> artifacts = new TreeMap<String, MultiVersionSummary>();
        Iterator it = this.getProject().getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(artifact.getVersion());
            if (this.isExcluded(artifact)) continue;
            try {
                ArtifactVersion latestIncremental;
                ArtifactVersion latestMinor;
                ArtifactVersion latestMajor = this.findLatestVersion(artifact, VersionRange.createFromVersionSpec((String)("[" + artifact.getVersion() + ",)")), this.getAllowSnapshots(), false);
                MultiVersionSummary summary = new MultiVersionSummary(artifact, (ArtifactVersion)currentVersion, latestMajor, latestMinor = this.findLatestVersion(artifact, VersionRange.createFromVersionSpec((String)("[" + artifact.getVersion() + "," + (currentVersion.getMajorVersion() + 1) + ".0.0)")), this.getAllowSnapshots(), false), latestIncremental = this.findLatestVersion(artifact, VersionRange.createFromVersionSpec((String)("[" + artifact.getVersion() + "," + currentVersion.getMajorVersion() + "." + (currentVersion.getMinorVersion() + 1) + ".0)")), this.getAllowSnapshots(), false));
                if (!this.hasUpdates(summary)) continue;
                artifacts.put(artifact.getId(), summary);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Problem encountered while searching for newer versions:", (Throwable)e);
            }
        }
        DisplayDependencyUpdatesRenderer renderer = new DisplayDependencyUpdatesRenderer(sink, artifacts, VersionComparators.getVersionComparator(this.getComparisonMethod()));
        renderer.render();
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return "A report summarizing newer versions of the project's dependencies that may be available.";
    }

    public String getName(Locale locale) {
        return "Dependency ArtifactVersions";
    }

    public String getOutputName() {
        return "dependency-updates-report";
    }

    protected boolean hasUpdates(MultiVersionSummary summary) {
        if (Boolean.TRUE.equals(this.showAll)) {
            return true;
        }
        ArtifactVersion currentVersion = summary.getCurrentVersion();
        if (currentVersion.toString().equals(currentVersion.getQualifier())) {
            return true;
        }
        Comparator comparator = VersionComparators.getVersionComparator(this.getComparisonMethod());
        if (summary.getLatestIncremental() != null && comparator.compare(currentVersion, summary.getLatestIncremental()) < 0) {
            return true;
        }
        if (summary.getLatestMinor() != null && comparator.compare(currentVersion, summary.getLatestMinor()) < 0) {
            return true;
        }
        return summary.getLatestMajor() != null && comparator.compare(currentVersion, summary.getLatestMajor()) < 0;
    }

    protected boolean isExcluded(Artifact artifact) {
        if (this.excludes == null || this.excludes.size() == 0) {
            return false;
        }
        String candidate = artifact.getGroupId() + ":" + artifact.getArtifactId();
        return this.excludes.contains(candidate);
    }

    public boolean isExternalReport() {
        return false;
    }

    protected static class MultiVersionSummary {
        private final Artifact artifact;
        private final ArtifactVersion currentVersion;
        private final ArtifactVersion latestMajor;
        private final ArtifactVersion latestMinor;
        private final ArtifactVersion latestIncremental;

        public MultiVersionSummary(Artifact artifact, ArtifactVersion currentVersion, ArtifactVersion latestMajor, ArtifactVersion latestMinor, ArtifactVersion latestIncremental) {
            this.artifact = artifact;
            this.currentVersion = currentVersion;
            this.latestMajor = latestMajor;
            this.latestMinor = latestMinor;
            this.latestIncremental = latestIncremental;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public ArtifactVersion getCurrentVersion() {
            return this.currentVersion;
        }

        public ArtifactVersion getLatestMajor() {
            return this.latestMajor;
        }

        public ArtifactVersion getLatestMinor() {
            return this.latestMinor;
        }

        public ArtifactVersion getLatestIncremental() {
            return this.latestIncremental;
        }
    }
}

