/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class UpdatePropertiesMojo
extends AbstractVersionsUpdaterMojo {
    private Property[] properties;
    private String includeProperties = null;
    private String excludeProperties = null;
    private Boolean autoLinkItems;

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        PropertyVersions[] propertyVersions;
        try {
            propertyVersions = PomHelper.getPropertyVersions(this.getHelper(), this.getProject(), this.getExpressionEvaluator());
        }
        catch (ExpressionEvaluationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                properties.put(this.properties[i].getName(), this.properties[i]);
            }
        }
        HashMap<String, PropertyVersions> versions = new HashMap<String, PropertyVersions>();
        if (this.autoLinkItems == null || Boolean.TRUE.equals(this.autoLinkItems)) {
            for (int i = 0; i < propertyVersions.length; ++i) {
                versions.put(propertyVersions[i].getName(), propertyVersions[i]);
                if (properties.containsKey(propertyVersions[i].getName())) continue;
                properties.put(propertyVersions[i].getName(), new Property(propertyVersions[i]));
            }
        }
        this.getLog().info((CharSequence)"Searching for properties to update");
        Iterator i = properties.values().iterator();
        while (i.hasNext()) {
            VersionRange range;
            Dependency[] dependencies;
            Property property = (Property)i.next();
            if (this.includeProperties != null && this.includeProperties.indexOf(property.getName()) < 0) {
                this.getLog().debug((CharSequence)("Skipping update of property ${" + property.getName() + "}"));
                continue;
            }
            if (this.excludeProperties != null && this.excludeProperties.indexOf(property.getName()) >= 0) {
                this.getLog().debug((CharSequence)("Ignoring update of property ${" + property.getName() + "}"));
                continue;
            }
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}"));
            PropertyVersions version = (PropertyVersions)versions.get(property.getName());
            if (version == null || !version.isAssociated()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Looks like this property is not " + "associated with any dependency..."));
                version = new PropertyVersions(null, property.getName(), this.getHelper());
            }
            if (!property.isAutoLinkDependencies()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Removing any autoLinkDependencies"));
                version.clearAssociations();
            }
            if ((dependencies = property.getDependencies()) != null) {
                for (int j = 0; j < dependencies.length; ++j) {
                    try {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding association to " + dependencies[j]));
                        version.addAssociation(this.getHelper().createDependencyArtifact(dependencies[j]), false);
                        continue;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                    }
                }
            }
            ArtifactVersion[] artifactVersions = version.getVersions(!property.isBanSnapshots() && Boolean.TRUE.equals(this.allowSnapshots));
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions is " + Arrays.asList(artifactVersions)));
            try {
                if (property.getVersion() != null) {
                    range = VersionRange.createFromVersionSpec((String)property.getVersion());
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
                } else {
                    range = null;
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
                }
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            Object winner = null;
            for (int j = artifactVersions.length - 1; j >= 0; --j) {
                if (range != null && !range.containsVersion(artifactVersions[j])) continue;
                if (currentVersion.equals(artifactVersions[j].toString())) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: No newer version"));
                    break;
                }
                winner = artifactVersions[j];
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Newest version is: " + winner));
                break;
            }
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Current winner is: " + winner));
            if (property.isSearchReactor()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Searching reactor for a valid version..."));
                Set reactorArtifacts = this.getHelper().extractArtifacts(this.reactorProjects);
                ArtifactVersion[] reactorVersions = version.getVersions(reactorArtifacts);
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions from the reactor is " + Arrays.asList(reactorVersions)));
                Object fromReactor = null;
                if (reactorVersions.length > 0) {
                    for (int j = reactorVersions.length - 1; j >= 0; --j) {
                        if (range != null && !range.containsVersion(reactorVersions[j])) continue;
                        fromReactor = reactorVersions[j];
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has version " + fromReactor));
                        break;
                    }
                }
                if (!(fromReactor == null || winner == null && currentVersion.equals(fromReactor.toString()))) {
                    if (property.isPreferReactor()) {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has a version and we prefer the reactor"));
                        winner = fromReactor;
                    } else if (winner == null) {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has the only version"));
                        winner = fromReactor;
                    } else if (version.compare((ArtifactVersion)winner, (ArtifactVersion)fromReactor) < 0) {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has a newer version"));
                        winner = fromReactor;
                    } else {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has the same or older version"));
                    }
                }
            }
            if (winner == null || currentVersion.equals(winner.toString())) {
                this.getLog().info((CharSequence)("Property ${" + property.getName() + "}: Leaving unchanged as " + currentVersion.toString()));
                continue;
            }
            if (!PomHelper.setPropertyVersion(pom, version.getProfileId(), property.getName(), winner.toString())) continue;
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + currentVersion + " to " + winner));
        }
    }
}

