/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveRangesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private Boolean processProperties;
    private String includeProperties = null;
    private String excludeProperties = null;
    public final Pattern matchRangeRegex = Pattern.compile(",");

    public boolean isProcessingProperties() {
        return !Boolean.FALSE.equals(this.processProperties);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
        if (this.getProject().getModel().getDependencyManagement() != null && this.getProject().getModel().getDependencyManagement().getDependencies() != null && this.isProcessingDependencyManagement()) {
            this.resolveRanges(pom, this.getProject().getModel().getDependencyManagement().getDependencies());
        }
        if (this.isProcessingDependencies()) {
            this.resolveRanges(pom, this.getProject().getModel().getDependencies());
        }
        if (this.isProcessingProperties()) {
            this.resolvePropertyRanges(pom);
        }
    }

    private void resolveRanges(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        for (Dependency dep : dependencies) {
            Artifact artifact;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep) || !(versionMatcher = this.matchRangeRegex.matcher(dep.getVersion())).find() || (artifact = this.toArtifact(dep)) == null || !this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Resolving version range for dependency: " + artifact));
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null) {
                ArtifactVersion latestVersion = this.findLatestVersion(artifact, artifact.getVersionRange(), null, false);
                if (latestVersion != null) {
                    artifactVersion = latestVersion.toString();
                } else {
                    this.getLog().warn((CharSequence)("Not updating version " + artifact + " : could not resolve any versions"));
                }
            }
            if (artifactVersion == null) continue;
            if (PomHelper.setDependencyVersion(pom, artifact.getGroupId(), artifact.getArtifactId(), dep.getVersion(), artifactVersion)) {
                this.getLog().debug((CharSequence)("Version set to " + artifactVersion + " for dependency: " + artifact));
                continue;
            }
            this.getLog().warn((CharSequence)("Could not find the dependency " + artifact + " so unable to set version to " + artifactVersion));
        }
    }

    private void resolvePropertyRanges(ModifiedPomXMLEventReader pom) throws XMLStreamException, MojoExecutionException {
        Map<Property, PropertyVersions> propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), null, this.includeProperties, this.excludeProperties, true);
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null || !this.matchRangeRegex.matcher(currentVersion).find()) continue;
            property.setVersion(currentVersion);
            this.updatePropertyToNewestVersion(pom, property, version, currentVersion);
        }
    }
}

