/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="use-latest-versions", threadSafe=true)
public class UseLatestVersionsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    @Parameter(property="allowDowngrade", defaultValue="false")
    private boolean allowDowngrade;

    @Inject
    public UseLatestVersionsMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.allowDowngrade && this.allowSnapshots) {
            throw new MojoExecutionException("allowDowngrade is only valid with allowSnapshots equal to false");
        }
        super.execute();
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            DependencyManagement dependencyManagement;
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel(this.getProject()).getDependencyManagement()) != null) {
                this.useLatestVersions(pom, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestVersions(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useLatestVersions(pom, Collections.singletonList(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(this.getProject().getParent().getVersion()).withType("pom").build()));
            }
        }
        catch (IOException | ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useLatestVersions(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        Optional<Segment> unchangedSegment = SegmentUtils.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates, this.getLog());
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            DefaultArtifactVersion selectedVersion = new DefaultArtifactVersion(version);
            this.getLog().debug((CharSequence)("Selected version:" + selectedVersion));
            this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            try {
                ArtifactVersion[] newerVersions = versions.getNewerVersions(version, unchangedSegment, this.allowSnapshots, this.allowDowngrade);
                ArtifactVersion[] filteredVersions = newerVersions;
                if (filteredVersions.length <= 0) continue;
                String newVersion = filteredVersions[filteredVersions.length - 1].toString();
                if (this.getProject().getParent() != null) {
                    Artifact parentArtifact = this.getProject().getParentArtifact();
                    if (artifact.getId().equals(parentArtifact.getId()) && this.isProcessingParent() && PomHelper.setProjectParentVersion(pom, newVersion)) {
                        this.getLog().debug((CharSequence)("Made parent update from " + version + " to " + newVersion));
                        this.getChangeRecorder().recordUpdate("useLatestVersions", parentArtifact.getGroupId(), parentArtifact.getArtifactId(), version, newVersion);
                    }
                }
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion, this.getProject().getModel())) continue;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
                this.getChangeRecorder().recordUpdate("useLatestVersions", dep.getGroupId(), dep.getArtifactId(), version, newVersion);
            }
            catch (InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s:%s due to: %s", dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), e.getMessage()));
            }
        }
    }
}

