/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.recording.DefaultDependencyChangeRecord;
import org.codehaus.mojo.versions.recording.DefaultPropertyChangeRecord;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.SegmentUtils;

public abstract class UpdatePropertiesMojoBase
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="autoLinkItems", defaultValue="true")
    protected boolean autoLinkItems;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;
    @Parameter(property="includeParent", defaultValue="true")
    protected boolean includeParent = true;

    public UpdatePropertiesMojoBase(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    protected void update(ModifiedPomXMLEventReader pom, Map<Property, PropertyVersions> propertyVersions) throws XMLStreamException {
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            boolean canUpdateProperty = true;
            for (ArtifactAssociation association : version.getAssociations()) {
                if (this.isIncluded(association.getArtifact())) continue;
                this.getLog().info((CharSequence)("Not updating the property ${" + property.getName() + "} because it is used by artifact " + association.getArtifact().toString() + " and that artifact is not included in the list of  allowed artifacts to be updated."));
                canUpdateProperty = false;
                break;
            }
            if (!canUpdateProperty) continue;
            Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
            try {
                ArtifactVersion targetVersion = this.updatePropertyToNewestVersion(pom, property, version, currentVersion, this.allowDowngrade, unchangedSegment);
                if (targetVersion == null) continue;
                this.getChangeRecorder().recordChange(DefaultPropertyChangeRecord.builder().withProperty(property.getName()).withOldValue(currentVersion).withNewValue(targetVersion.toString()).build());
                for (ArtifactAssociation association : version.getAssociations()) {
                    if (!this.isIncluded(association.getArtifact())) continue;
                    this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(DependencyChangeRecord.ChangeKind.PROPERTY).withArtifact(association.getArtifact()).withOldVersion(currentVersion).withNewVersion(targetVersion.toString()).build());
                }
            }
            catch (InvalidVersionSpecificationException | MojoExecutionException | InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s due to: %s", property.getName(), property.getVersion(), e.getMessage()));
            }
        }
    }
}

