// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.5.1,
// any modifications will be overwritten.
// ==============================================================

package org.codehaus.mojo.versions.model.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.XMLConstants;
import javax.xml.stream.*;
import org.codehaus.mojo.versions.model.CoreExtension;
import org.codehaus.mojo.versions.model.CoreExtensions;

/**
 * Class CoreExtensionsStaxReader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class CoreExtensionsStaxReader
{

      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method read.
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    public CoreExtensions read( Reader reader, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );

        return read( xmlStreamReader, strict );
    } //-- CoreExtensions read( Reader, boolean )

    /**
     * Method read.
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    public CoreExtensions read( Reader reader )
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- CoreExtensions read( Reader )

    /**
     * Method read.
     * 
     * @param stream a stream object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    public CoreExtensions read( InputStream stream, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( stream );

        return read( xmlStreamReader, strict );
    } //-- CoreExtensions read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param stream a stream object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    public CoreExtensions read( InputStream stream )
        throws IOException, XMLStreamException
    {
        return read( stream, true );
    } //-- CoreExtensions read( InputStream )

    /**
     * Method read.
     * 
     * @param filePath a filePath object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    public CoreExtensions read( String filePath, boolean strict )
        throws IOException, XMLStreamException
    {
        java.io.File file = new java.io.File( filePath );
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURI().toURL().toExternalForm(), new FileInputStream( file ) );

        return read( xmlStreamReader, strict );
    } //-- CoreExtensions read( String, boolean )

    /**
     * Method read.
     * 
     * @param filePath a filePath object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    public CoreExtensions read( String filePath )
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- CoreExtensions read( String )

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XMLStreamReader xmlStreamReader, String tagName, String alias, java.util.Set parsed )
        throws XMLStreamException
    {
        if ( !( xmlStreamReader.getLocalName().equals( tagName ) || xmlStreamReader.getLocalName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XMLStreamException( "Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation() );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XMLStreamReader, String, String, java.util.Set )

    /**
     * Method checkUnknownElement.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws XMLStreamException XMLStreamException if any.
     */
    private void checkUnknownElement( XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( strict )
        {
            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
        }
        int unrecognizedTagCount = 1;
        while( unrecognizedTagCount != 0 )
        {
            xmlStreamReader.next();
            if ( xmlStreamReader.getEventType() == XMLStreamConstants.START_ELEMENT )
            {
                unrecognizedTagCount++;
            }
            else if ( xmlStreamReader.getEventType() == XMLStreamConstants.END_ELEMENT )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XMLStreamReader, boolean )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XMLStreamReader )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XMLStreamReader )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XMLStreamReader )

    /**
     * Method getDefaultValue.
     * 
     * @param s a s object.
     * @param v a v object.
     * @return String
     */
    private String getDefaultValue( String s, String v )
    {
        if ( s == null )
        {
            s = v;
        }
        return s;
    } //-- String getDefaultValue( String, String )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method nextTag.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return int
     */
    private int nextTag( XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        while ( true )
        {
            int eventType = xmlStreamReader.next();
            switch ( eventType )
            {
                case XMLStreamConstants.CHARACTERS:
                case XMLStreamConstants.CDATA:
                case XMLStreamConstants.SPACE:
                case XMLStreamConstants.PROCESSING_INSTRUCTION:
                case XMLStreamConstants.COMMENT:
                    break;
                case XMLStreamConstants.START_ELEMENT:
                case XMLStreamConstants.END_ELEMENT:
                    return eventType;
                default:
                    throw new XMLStreamException( "expected start or end tag", xmlStreamReader.getLocation() );
            }
        }
    } //-- int nextTag( XMLStreamReader )

    /**
     * Method parseCoreExtension.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtension
     */
    private CoreExtension parseCoreExtension( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        CoreExtension coreExtension = new CoreExtension();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "groupId", null, parsed ) )
            {
                coreExtension.setGroupId( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "artifactId", null, parsed ) )
            {
                coreExtension.setArtifactId( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "version", null, parsed ) )
            {
                coreExtension.setVersion( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "classLoadingStrategy", null, parsed ) )
            {
                coreExtension.setClassLoadingStrategy( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "self-first" ) ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return coreExtension;
    } //-- CoreExtension parseCoreExtension( XMLStreamReader, boolean )

    /**
     * Method parseCoreExtensions.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    private CoreExtensions parseCoreExtensions( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        CoreExtensions coreExtensions = new CoreExtensions();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( "extension".equals( xmlStreamReader.getLocalName() ) )
            {
                java.util.List extensions = coreExtensions.getExtensions();
                if ( extensions == null )
                {
                    extensions = new java.util.ArrayList/*<CoreExtension>*/();
                    coreExtensions.setExtensions( extensions );
                }
                coreExtensions.addExtension( parseCoreExtension( xmlStreamReader, strict ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return coreExtensions;
    } //-- CoreExtensions parseCoreExtensions( XMLStreamReader, boolean )

    /**
     * Method read.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return CoreExtensions
     */
    private CoreExtensions read( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while ( eventType != XMLStreamConstants.END_DOCUMENT )
        {
            if ( eventType == XMLStreamConstants.START_DOCUMENT )
            {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( strict && ! "extensions".equals( xmlStreamReader.getLocalName() ) )
                {
                    throw new XMLStreamException( "Expected root element 'extensions' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null );
                }
                CoreExtensions coreExtensions = parseCoreExtensions( xmlStreamReader, strict );
                coreExtensions.setModelEncoding( encoding );
                resolveReferences( coreExtensions );
                return coreExtensions;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException( "Expected root element 'extensions' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null );
    } //-- CoreExtensions read( XMLStreamReader, boolean )

    /**
     * Method resolveReferences.
     * 
     * @param value a value object.
     */
    private void resolveReferences( CoreExtensions value )
    {
        java.util.Map refs;
    } //-- void resolveReferences( CoreExtensions )

}
