/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.ResolverAdapter;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;

public class DefaultResolverAdapter
implements ResolverAdapter {
    private static final int LOOKUP_PARALLEL_THREADS = 12;
    private final ArtifactFactory artifactFactory;
    private final RepositorySystem repositorySystem;
    private final Log log;
    private final MavenSession mavenSession;
    private final List<RemoteRepository> remotePluginRepositories;
    private final List<RemoteRepository> remoteProjectRepositories;

    public DefaultResolverAdapter(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Log log, MavenSession mavenSession) {
        this.artifactFactory = artifactFactory;
        this.repositorySystem = repositorySystem;
        this.log = log;
        this.mavenSession = mavenSession;
        this.remoteProjectRepositories = Optional.of(mavenSession).map(MavenSession::getCurrentProject).map(MavenProject::getRemoteProjectRepositories).map(this::forceDailyRemoteRepositoriesRefreshPolicy).orElseGet(Collections::emptyList);
        this.remotePluginRepositories = Optional.of(mavenSession).map(MavenSession::getCurrentProject).map(MavenProject::getRemotePluginRepositories).map(this::forceDailyRemoteRepositoriesRefreshPolicy).orElseGet(Collections::emptyList);
    }

    private List<RemoteRepository> forceDailyRemoteRepositoriesRefreshPolicy(List<RemoteRepository> remoteRepositories) {
        return remoteRepositories.stream().map(remoteRepository -> {
            RepositoryPolicy snapshotPolicy = this.forceDailyUpdatePolicy(remoteRepository.getPolicy(true));
            RepositoryPolicy releasePolicy = this.forceDailyUpdatePolicy(remoteRepository.getPolicy(false));
            if (snapshotPolicy != null || releasePolicy != null) {
                RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepository);
                Optional.ofNullable(snapshotPolicy).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setSnapshotPolicy(arg_0));
                Optional.ofNullable(releasePolicy).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setReleasePolicy(arg_0));
                return builder.build();
            }
            return remoteRepository;
        }).collect(Collectors.toList());
    }

    private RepositoryPolicy forceDailyUpdatePolicy(RepositoryPolicy policy) {
        if (policy.isEnabled() && "never".equals(policy.getUpdatePolicy())) {
            return new RepositoryPolicy(true, "daily", policy.getChecksumPolicy());
        }
        return null;
    }

    @Override
    public void resolveArtifact(Artifact artifact, boolean usePluginRepositories) throws ArtifactResolutionException {
        try {
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.mavenSession.getRepositorySession(), new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), usePluginRepositories ? this.mavenSession.getCurrentProject().getRemotePluginRepositories() : this.mavenSession.getCurrentProject().getRemoteProjectRepositories(), this.getClass().getName()));
            artifact.setFile(artifactResult.getArtifact().getFile());
            artifact.setVersion(artifactResult.getArtifact().getVersion());
            artifact.setResolved(artifactResult.isResolved());
        }
        catch (org.eclipse.aether.resolution.ArtifactResolutionException e) {
            throw new ArtifactResolutionException(e.getMessage(), artifact, (Throwable)e);
        }
    }

    @Override
    public ArtifactVersions resolveArtifactVersions(Artifact artifact, boolean usePluginRepositories, boolean useProjectRepositories) throws VersionRetrievalException {
        try {
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(RepositoryUtils.toArtifact((Artifact)artifact).setVersion("(,)"), Stream.concat(usePluginRepositories ? this.remotePluginRepositories.stream() : Stream.empty(), useProjectRepositories ? this.remoteProjectRepositories.stream() : Stream.empty()).distinct().collect(Collectors.toList()), "lookupArtifactVersions");
            return new ArtifactVersions(artifact, this.repositorySystem.resolveVersionRange(this.mavenSession.getRepositorySession(), versionRangeRequest).getVersions().stream().map(v -> ArtifactVersionService.getArtifactVersion(v.toString())).collect(Collectors.toList()));
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionRetrievalException(e.getMessage(), artifact, e);
        }
        catch (RuntimeException e) {
            throw new VersionRetrievalException("Unable to retrieve versions for " + artifact, artifact, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<Dependency, ArtifactVersions> resolveDependencyVersions(Collection<Dependency> dependencies, boolean usePluginRepositories, boolean useProjectRepositories) throws VersionRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(12);
        try {
            Collection futures = dependencies.stream().map(d -> Pair.of((Object)d, executor.submit(() -> this.resolveArtifactVersions(this.artifactFactory.createArtifact((Dependency)d), usePluginRepositories, useProjectRepositories)))).collect(Collectors.toList());
            TreeMap<Dependency, ArtifactVersions> result = new TreeMap<Dependency, ArtifactVersions>(DependencyComparator.INSTANCE);
            for (Pair entry : futures) {
                try {
                    result.put((Dependency)entry.getKey(), (ArtifactVersions)((Future)entry.getValue()).get());
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof VersionRetrievalException) {
                        throw (VersionRetrievalException)e.getCause();
                    }
                    throw new VersionRetrievalException("Unable to resolve metadata for dependencies " + dependencies + ": " + e.getMessage(), null, e);
                }
            }
            TreeMap<Dependency, ArtifactVersions> treeMap = result;
            return treeMap;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public PluginUpdatesDetails resolvePluginVersions(Plugin plugin) throws VersionRetrievalException {
        String version = plugin.getVersion() != null ? plugin.getVersion() : "LATEST";
        Set<Dependency> pluginDependencies = Optional.ofNullable(plugin.getDependencies()).map(d -> d.stream().collect(Collectors.toCollection(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE)))).orElse(Collections.emptySet());
        SortedMap<Dependency, ArtifactVersions> pluginDependencyDetails = this.resolveDependencyVersions(pluginDependencies, false, true);
        Artifact pluginArtifact = this.artifactFactory.createMavenPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), version);
        ArtifactVersions allVersions = this.resolveArtifactVersions(pluginArtifact, true, false);
        return new PluginUpdatesDetails(allVersions, pluginDependencyDetails, true);
    }

    @Override
    public SortedMap<Plugin, PluginUpdatesDetails> resolvePluginVersions(Collection<Plugin> plugins) throws VersionRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(12);
        try {
            TreeMap<Object, PluginUpdatesDetails> pluginUpdates = new TreeMap<Object, PluginUpdatesDetails>(PluginComparator.INSTANCE);
            List futures = plugins.stream().map(p -> executor.submit(() -> new ImmutablePair(p, (Object)this.resolvePluginVersions((Plugin)p)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                pluginUpdates.put((Plugin)pair.getKey(), (PluginUpdatesDetails)pair.getValue());
            }
            TreeMap<Object, PluginUpdatesDetails> treeMap = pluginUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof VersionRetrievalException) {
                throw (VersionRetrievalException)e.getCause();
            }
            throw new VersionRetrievalException("Unable to acquire metadata for plugins " + plugins + ": " + e.getMessage(), null, e);
        }
        finally {
            executor.shutdown();
        }
    }
}

