package org.codehaus.mojo.wagon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on wagon-maven-plugin.<br/> Call <pre>  mvn wagon:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Apr 08 20:35:04 PDT 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:wagon-maven-plugin:1.0-beta-4", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Wagon plugin", 0 );
        append( sb, "Maven 2 plugin that can be used to access various operations on a given URL using a supported maven wagon. Supports recursive upload, download, and list directory content functionality.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 9 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "copy".equals( goal ) )
        {
            append( sb, "wagon:copy", 0 );
            append( sb, "Copy artifacts from one Wagon repository to another Wagon repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "caseSensitive", 2 );
                append( sb, "Whether to consider remote path case sensitivity during scan", 3 );
                append( sb, "Expression: ${wagon.caseSensitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of Ant\'s excludes to scan for remote files", 3 );
                append( sb, "Expression: ${wagon.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "fromDir", 2 );
                append( sb, "Directory path relative to source\'s Wagon", 3 );
                append( sb, "Expression: ${wagon.fromDir}", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **)", 2 );
                append( sb, "Comma separated list of Ant\'s includes to scan for remote files", 3 );
                append( sb, "Expression: ${wagon.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "optimize (Default: false)", 2 );
                append( sb, "Optimize the upload by locally compressed all files in one bundle, upload the bundle, and finally remote uncompress the bundle. This only works with SCP\'s URL", 3 );
                append( sb, "Expression: ${wagon.optimize}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "The URL to the source repository.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.source}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceId (Default: source)", 2 );
                append( sb, "settings.xml\'s server id of the source repository. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.sourceId}", 3 );
                append( sb, "", 0 );

                append( sb, "target", 2 );
                append( sb, "The URL to the target repository.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.target}", 3 );
                append( sb, "", 0 );

                append( sb, "targetId (Default: target)", 2 );
                append( sb, "settings.xml\'s server id of the target repository. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.targetId}", 3 );
                append( sb, "", 0 );

                append( sb, "toDir", 2 );
                append( sb, "Remote path relative to target\'s url to copy files to.", 3 );
                append( sb, "Expression: ${wagon.toDir}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "download".equals( goal ) )
        {
            append( sb, "wagon:download", 0 );
            append( sb, "Transfers a set of files from a remote URL to a specified local directory.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "caseSensitive (Default: true)", 2 );
                append( sb, "Whether to consider remote path case sensitivity during scan", 3 );
                append( sb, "Expression: ${wagon.caseSensitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of Ant\'s excludes to scan for remote files", 3 );
                append( sb, "Expression: ${wagon.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "fromDir", 2 );
                append( sb, "Directory path relative to Wagon\'s URL", 3 );
                append( sb, "Expression: ${wagon.fromDir}", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: *)", 2 );
                append( sb, "Comma separated list of Ant\'s includes to scan for remote files", 3 );
                append( sb, "Expression: ${wagon.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "toDir (Default: ${project.build.directory}/wagon-plugin)", 2 );
                append( sb, "Local directory to download the remote resource ( tree ) to.", 3 );
                append( sb, "Expression: ${wagon.toDir}", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.url}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "download-single".equals( goal ) )
        {
            append( sb, "wagon:download-single", 0 );
            append( sb, "Download a single file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fromFile", 2 );
                append( sb, "Relative path to the URL.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.fromFile}", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "toDir", 2 );
                append( sb, "Directory to download the remote file to", 3 );
                append( sb, "Expression: ${wagon.toDir}", 3 );
                append( sb, "", 0 );

                append( sb, "toFile", 2 );
                append( sb, "File to download the remote file to. Use this option to rename the file after download. When toDir is present, this argument is ignored", 3 );
                append( sb, "Expression: ${wagon.toFile}", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.url}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "exist".equals( goal ) )
        {
            append( sb, "wagon:exist", 0 );
            append( sb, "Check for the existing of remote resource.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "resource", 2 );
                append( sb, "relative path to a remote resource", 3 );
                append( sb, "Expression: ${wagon.resource}", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.url}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "wagon:help", 0 );
            append( sb, "Display help information on wagon-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0wagon:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "list".equals( goal ) )
        {
            append( sb, "wagon:list", 0 );
            append( sb, "Lists the content of the specified directory (remotePath) under a specified repository (url)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "caseSensitive (Default: true)", 2 );
                append( sb, "Whether to consider remote path case sensitivity during scan", 3 );
                append( sb, "Expression: ${wagon.caseSensitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated list of Ant\'s excludes to scan for remote files", 3 );
                append( sb, "Expression: ${wagon.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "fromDir", 2 );
                append( sb, "Directory path relative to Wagon\'s URL", 3 );
                append( sb, "Expression: ${wagon.fromDir}", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: *)", 2 );
                append( sb, "Comma separated list of Ant\'s includes to scan for remote files", 3 );
                append( sb, "Expression: ${wagon.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.url}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "merge-maven-repos".equals( goal ) )
        {
            append( sb, "wagon:merge-maven-repos", 0 );
            append( sb, "Merge artifacts from one Maven repository to another Maven repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "optimize (Default: false)", 2 );
                append( sb, "Optimize the upload by locally compressed all files in one bundle, upload the bundle, and finally remote uncompress the bundle. This only works with SCP\'s URL", 3 );
                append( sb, "Expression: ${wagon.optimize}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "The URL to the source repository.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.source}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceId (Default: source)", 2 );
                append( sb, "settings.xml\'s server id of the source repository. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.sourceId}", 3 );
                append( sb, "", 0 );

                append( sb, "target", 2 );
                append( sb, "The URL to the target repository.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.target}", 3 );
                append( sb, "", 0 );

                append( sb, "targetId (Default: target)", 2 );
                append( sb, "settings.xml\'s server id of the target repository. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.targetId}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "upload".equals( goal ) )
        {
            append( sb, "wagon:upload", 0 );
            append( sb, "Upload multiple sets of files.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separate list of Ant\'s excludes to scan for local files", 3 );
                append( sb, "Expression: ${wagon.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "followSymLink (Default: false)", 2 );
                append( sb, "Follow local symbolic link if possible", 3 );
                append( sb, "Expression: ${wagon.followSymLink}", 3 );
                append( sb, "", 0 );

                append( sb, "fromDir (Default: ${project.basedir})", 2 );
                append( sb, "Local directory to upload to wagon\'s \'url/toDir\'", 3 );
                append( sb, "Expression: ${wagon.fromDir}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Comma separate list of Ant\'s includes to scan for local files", 3 );
                append( sb, "Expression: ${wagon.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "optimize (Default: false)", 2 );
                append( sb, "Optimize the upload by locally compressed all files in one bundle, upload the bundle, and finally remote uncompress the bundle.", 3 );
                append( sb, "Expression: ${wagon.optimize}", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "toDir", 2 );
                append( sb, "Remote path relative to Wagon\'s url to upload local files to.", 3 );
                append( sb, "Expression: ${wagon.toDir}", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.url}", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultExcludes (Default: true)", 2 );
                append( sb, "Use default exclude sets", 3 );
                append( sb, "Expression: ${wagon.useDefaultExcludes}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "upload-single".equals( goal ) )
        {
            append( sb, "wagon:upload-single", 0 );
            append( sb, "Upload a single file with option to change name", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fromFile", 2 );
                append( sb, "Path to a local file to be uploaded", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.fromFile}", 3 );
                append( sb, "", 0 );

                append( sb, "serverId (Default: serverId)", 2 );
                append( sb, "settings.xml\'s server id for the URL. This is used when wagon needs extra authentication information.", 3 );
                append( sb, "Expression: ${wagon.serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "Expression: ${wagon.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "toFile", 2 );
                append( sb, "Relative path to the URL. When blank, default to fromFile\'s file name.", 3 );
                append( sb, "Expression: ${wagon.toFile}", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${wagon.url}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
