/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.WagonDirectoryScanner;
import org.codehaus.mojo.wagon.shared.WagonDownload;
import org.codehaus.mojo.wagon.shared.WagonFileSet;
import org.codehaus.plexus.util.StringUtils;

public class DefaultWagonDownload
implements WagonDownload {
    public List getFileList(Wagon wagon, WagonFileSet fileSet, Log logger) throws WagonException {
        logger.info((CharSequence)("Scanning remote file system: " + wagon.getRepository().getUrl() + " ..."));
        WagonDirectoryScanner dirScan = new WagonDirectoryScanner();
        dirScan.setLogger(logger);
        dirScan.setWagon(wagon);
        dirScan.setExcludes(fileSet.getExcludes());
        dirScan.setIncludes(fileSet.getIncludes());
        dirScan.setCaseSensitive(fileSet.isCaseSensitive());
        dirScan.setDirectory(fileSet.getDirectory());
        if (fileSet.isUseDefaultExcludes()) {
            dirScan.addDefaultExcludes();
        }
        dirScan.scan();
        return dirScan.getFilesIncluded();
    }

    public void download(Wagon wagon, WagonFileSet remoteFileSet, Log logger) throws WagonException {
        List fileList = this.getFileList(wagon, remoteFileSet, logger);
        String url = wagon.getRepository().getUrl() + "/";
        if (fileList.size() == 0) {
            logger.info((CharSequence)"Nothing to download.");
            return;
        }
        for (String remoteFile : fileList) {
            File destination = new File(remoteFileSet.getDownloadDirectory() + "/" + remoteFile);
            if (!StringUtils.isBlank((String)remoteFileSet.getDirectory())) {
                remoteFile = remoteFileSet.getDirectory() + "/" + remoteFile;
            }
            logger.info((CharSequence)("Downloading " + url + remoteFile + " to " + destination + " ..."));
            wagon.get(remoteFile, destination);
        }
    }

    public boolean exists(Wagon wagon, String resource) throws WagonException {
        return wagon.resourceExists(resource);
    }
}

