/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class AbstractWas6Mojo
extends AbstractMojo {
    private File wasHome;
    private File workingDirectory;
    private boolean verbose;
    private boolean failOnError;
    private int retryCount;
    private MavenProject mavenProject;
    private Settings settings;
    private File logFile;
    private File traceFile;
    private ResourceManager resourceManager;
    private boolean skip;

    protected File getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected File getWasHome() {
        return this.wasHome;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected File getWsAntExecutable() throws MojoExecutionException {
        File binDir = new File(this.wasHome, "bin");
        File[] candidates = binDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                dir.equals(AbstractWas6Mojo.this.wasHome);
                return name.startsWith("ws_ant");
            }
        });
        if (candidates.length != 1) {
            throw new MojoExecutionException("Couldn't find ws_ant[.sh|.bat], candidates: " + ArrayUtils.toString((Object)candidates));
        }
        File wsAnt = candidates[0];
        this.getLog().info((CharSequence)("wsAnt location: " + wsAnt.getAbsolutePath()));
        return wsAnt;
    }

    private File getBuildScript() throws MojoExecutionException {
        try {
            InputStream inputStream = this.resourceManager.getResourceAsInputStream("build.xml");
            String scriptSource = IOUtils.toString((InputStream)inputStream);
            Document buildScriptDocument = DocumentHelper.parseText((String)scriptSource);
            this.configureTaskAttribute(buildScriptDocument, "wasHome", this.wasHome);
            this.configureTaskAttribute(buildScriptDocument, "failonerror", Boolean.toString(this.failOnError));
            Element projectElement = buildScriptDocument.getRootElement();
            projectElement.addAttribute("default", this.getTaskName());
            this.configureBuildScript(buildScriptDocument);
            this.getWorkingDirectory().mkdirs();
            File buildScriptFile = new File(this.getWorkingDirectory(), "was6plugin-build." + System.currentTimeMillis() + ".xml");
            FileWriter writer = new FileWriter(buildScriptFile);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(buildScriptDocument);
            xmlWriter.flush();
            xmlWriter.close();
            return buildScriptFile;
        }
        catch (DocumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected Element getTaskElement(Document document) throws MojoExecutionException {
        Element element = (Element)document.selectSingleNode("//target[@name='" + this.getTaskName() + "']/" + this.getTaskName());
        if (element == null) {
            throw new MojoExecutionException("BUG: Task is not defined: " + this.getTaskName());
        }
        return element;
    }

    protected void configureTaskAttribute(Document document, String attributeName, Object value) throws MojoExecutionException {
        Element taskElement = this.getTaskElement(document);
        Attribute attribute = (Attribute)taskElement.selectSingleNode("@" + attributeName);
        if (attribute == null) {
            this.getLog().warn((CharSequence)("Build script does not contain attribute: " + attributeName));
            return;
        }
        if (value != null) {
            String valueToSet = value instanceof File ? ((File)value).getAbsolutePath() : value.toString();
            attribute.setText(valueToSet);
        } else {
            taskElement.remove(attribute);
        }
    }

    protected abstract void configureBuildScript(Document var1) throws MojoExecutionException;

    private Commandline getCommandline() throws MojoExecutionException {
        File buildScript = this.getBuildScript();
        Commandline commandLine = new Commandline();
        commandLine.addEnvironment("WAS_USER_SCRIPT", "");
        commandLine.setExecutable(this.getWsAntExecutable().getAbsolutePath());
        commandLine.setWorkingDirectory(this.mavenProject.getBuild().getDirectory());
        if (this.traceFile != null) {
            commandLine.createArg().setLine("-traceFile \"" + this.traceFile.getAbsolutePath() + "\"");
        }
        commandLine.createArg().setLine("-buildfile \"" + buildScript.getAbsolutePath() + "\"");
        if (!this.getSettings().isInteractiveMode() && !"servicedeploy".equals(this.getTaskName())) {
            commandLine.createArg().setValue("-noinput");
        }
        if (this.logFile != null) {
            commandLine.createArg().setLine("-logfile \"" + this.logFile.getAbsolutePath() + "\"");
        }
        if (this.isVerbose()) {
            commandLine.createArg().setValue("-verbose");
            commandLine.createArg().setValue("-debug");
        }
        commandLine.createArg().setValue(this.getTaskName());
        return commandLine;
    }

    protected abstract String getTaskName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSkip()) {
            if (this.wasHome == null) {
                throw new MojoExecutionException("wasHome not defined");
            }
            if (!this.wasHome.exists() && !this.wasHome.isDirectory()) {
                throw new MojoExecutionException(this.wasHome.getAbsolutePath() + " does not exist or is not a directory");
            }
            Commandline commandLine = this.getCommandline();
            boolean attemptExecution = true;
            while (attemptExecution) {
                try {
                    this.executeCmdLine(commandLine);
                    attemptExecution = false;
                }
                catch (MojoFailureException mfe) {
                    if (this.retryCount == 0) {
                        throw mfe;
                    }
                    --this.retryCount;
                    this.getLog().error((CharSequence)("Build Failed. Retrying. Retry Count is now: " + this.retryCount));
                }
            }
        } else {
            this.getLog().info((CharSequence)"Skipping execution");
        }
    }

    private void executeCmdLine(Commandline commandline) throws MojoFailureException {
        try {
            StreamConsumer errConsumer = this.getStreamConsumer("error");
            StreamConsumer infoConsumer = this.getStreamConsumer("info");
            this.getLog().debug((CharSequence)("Executing command line: " + StringUtils.join((Object[])commandline.getShellCommandline(), (String)" ")));
            int returncode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)infoConsumer, (StreamConsumer)errConsumer);
            String logmsg = "Return code: " + returncode;
            if (returncode != 0) {
                throw new MojoFailureException(logmsg);
            }
            this.getLog().info((CharSequence)logmsg);
        }
        catch (CommandLineException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    private StreamConsumer getStreamConsumer(final String level) {
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                if (level.equalsIgnoreCase("info")) {
                    AbstractWas6Mojo.this.getLog().info((CharSequence)line);
                } else {
                    AbstractWas6Mojo.this.getLog().error((CharSequence)line);
                }
            }
        };
        return consumer;
    }
}

