/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.webservice.tools.clientgen.ClientGen;

public class ClientGenMojo
extends AbstractMojo {
    private String inputWSDL;
    private String outputDir;
    private String packageName;
    private String serviceName;
    private Set artifacts;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic client gen beginning ");
        }
        try {
            ClientGen clientGen = new ClientGen();
            clientGen.setWSDL(this.inputWSDL);
            clientGen.setClientJar(new File(this.outputDir));
            clientGen.setClientPackageName(this.packageName);
            clientGen.setServiceName(this.serviceName);
            clientGen.setClasspath(WeblogicMojoUtilities.getDependencies(this.getArtifacts()));
            clientGen.generateClientJar();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during client gen ", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during listapps", ex);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic client gen successful ");
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String inInputWSDL) {
        this.inputWSDL = inInputWSDL;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String inOutputDir) {
        this.outputDir = inOutputDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String inServiceName) {
        this.serviceName = inServiceName;
    }

    public Set getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set inArtifacts) {
        this.artifacts = inArtifacts;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientGenMojo[");
        buffer.append("inputWSDL = ").append(this.inputWSDL);
        buffer.append(", outputDir = ").append(this.outputDir);
        buffer.append(", packageName = ").append(this.packageName);
        buffer.append(", serviceName = ").append(this.serviceName);
        buffer.append(", artifacts = ").append(this.artifacts);
        buffer.append("]");
        return buffer.toString();
    }
}

