/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.webservice.tools.clientgen.ClientGen;

public class ClientGenMojo
extends AbstractWeblogicMojo {
    private String inputWSDL;
    private String outputDir;
    private String packageName;
    private String serviceName;
    private boolean useEarDependency;
    private String warName;
    private boolean useServerTypes;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic client gen beginning ");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Plugin dependencies: " + this.getPluginArtifacts()));
        }
        try {
            ClientGen clientGen = new ClientGen();
            if (this.useEarDependency) {
                clientGen.setEar(WeblogicMojoUtilities.getEarFileName(this.getArtifacts()));
                clientGen.setWarName(this.warName);
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Weblogic client gen using ear " + WeblogicMojoUtilities.getEarFileName(this.getArtifacts()) + " with warName " + this.warName));
                }
            } else {
                clientGen.setWSDL(this.inputWSDL);
            }
            clientGen.setClientJar(new File(this.outputDir));
            clientGen.setClientPackageName(this.packageName);
            clientGen.setServiceName(this.serviceName);
            clientGen.setUseServerTypes(this.useServerTypes);
            clientGen.setClasspath(WeblogicMojoUtilities.getDependencies(this.getArtifacts(), this.getPluginArtifacts()));
            clientGen.generateClientJar();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during client gen ", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during listapps", ex);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic client gen successful ");
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String inInputWSDL) {
        this.inputWSDL = inInputWSDL;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String inOutputDir) {
        this.outputDir = inOutputDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String inServiceName) {
        this.serviceName = inServiceName;
    }

    public boolean isUseEarDependency() {
        return this.useEarDependency;
    }

    public void setUseEarDependency(boolean useEarDependency) {
        this.useEarDependency = useEarDependency;
    }

    public String getWarName() {
        return this.warName;
    }

    public void setWarName(String warName) {
        this.warName = warName;
    }

    public boolean isUseServerTypes() {
        return this.useServerTypes;
    }

    public void setUseServerTypes(boolean useServerTypes) {
        this.useServerTypes = useServerTypes;
    }

    public String toString() {
        return "ClientGenMojo{inputWSDL='" + this.inputWSDL + '\'' + ", outputDir='" + this.outputDir + '\'' + ", packageName='" + this.packageName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", useEarDependency=" + this.useEarDependency + ", warName='" + this.warName + '\'' + ", useServerTypes=" + this.useServerTypes + '}';
    }
}

