/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;
import org.codehaus.plexus.util.StringUtils;

public class JarResourcesGenerator
extends AbstractGenerator {
    private final Collection jarResources;
    private String libPath;

    public JarResourcesGenerator(MavenProject mavenProject, File resourceLoaderPath, String defaultTemplateResourceName, File outputFile, String templateFile, Collection jarResources, String mainClass, String webstartJarURL, String libPath) {
        super(mavenProject, resourceLoaderPath, defaultTemplateResourceName, outputFile, templateFile, mainClass, webstartJarURL);
        this.jarResources = jarResources;
        this.libPath = libPath;
    }

    protected String getDependenciesText() {
        String jarResourcesText = "";
        if (this.jarResources.size() != 0) {
            int multiplier = 100;
            StringBuffer buffer = new StringBuffer(100 * this.jarResources.size());
            buffer.append("\n");
            Iterator itr = this.jarResources.iterator();
            while (itr.hasNext()) {
                JarResource jarResource = (JarResource)itr.next();
                if (!jarResource.isIncludeInJnlp()) continue;
                buffer.append("<jar href=\"");
                if (StringUtils.isNotEmpty((String)this.libPath)) {
                    buffer.append(this.libPath);
                    buffer.append('/');
                }
                buffer.append(jarResource.getHrefValue());
                buffer.append("\"");
                if (jarResource.isOutputJarVersion()) {
                    buffer.append(" version=\"").append(jarResource.getVersion()).append("\"");
                }
                if (jarResource.getMainClass() != null) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            jarResourcesText = buffer.toString();
        }
        return jarResourcesText;
    }
}

