/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import com.canoo.webtest.ant.TestStepSequence;
import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.reporting.StepResult;
import org.apache.tools.ant.Location;

public class RootStepResult
extends StepResult {
    private String fWebtestName;
    private final String fWebtestDescription;
    private final Location fWebtestLocation;
    private final Configuration fConfiguration;
    private StepResult fLastFailingTaskResult;
    private Throwable fException;

    public RootStepResult(TestStepSequence step) {
        super(step);
        WebtestTask webtest = step.getContext().getWebtest();
        this.fWebtestName = webtest.getName();
        this.fWebtestDescription = webtest.getDescription();
        this.fWebtestLocation = webtest.getLocation();
        this.fConfiguration = step.getContext().getConfig();
    }

    public Configuration getConfig() {
        return this.fConfiguration;
    }

    public String getWebtestDescription() {
        return this.fWebtestDescription;
    }

    public String getWebtestName() {
        return this.fWebtestName;
    }

    public void setWebtestName(String name) {
        this.fWebtestName = name;
    }

    public Location getWebtestLocation() {
        return this.fWebtestLocation;
    }

    public boolean isError() {
        return this.fException != null && !this.isFailure();
    }

    public Throwable getException() {
        return this.fException;
    }

    public boolean isFailure() {
        return StepFailedException.isCausedByStepFailedException(this.fException);
    }

    public boolean isSuccessful() {
        return this.fException == null;
    }

    public StepResult getFailingTaskResult() {
        if (this.isSuccessful()) {
            return null;
        }
        return this.fLastFailingTaskResult;
    }

    protected void setLastFailingTaskResult(StepResult stepResult, Throwable throwable) {
        this.fLastFailingTaskResult = stepResult;
        this.fException = throwable;
    }
}

