/**
 * <copyright>
 * </copyright>
 *
 * $Id: DomFactory.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom;

import org.eclipse.emf.ecore.EFactory;
import org.openxma.dsl.dom.model.AggregateFunction;
import org.openxma.dsl.dom.model.AliasedExpression;
import org.openxma.dsl.dom.model.AltWhenClause;
import org.openxma.dsl.dom.model.ApplicationSession;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeFlag;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.AttributeSortOrder;
import org.openxma.dsl.dom.model.AttributeTextProperty;
import org.openxma.dsl.dom.model.AttributeValidationProperty;
import org.openxma.dsl.dom.model.AvailableFlag;
import org.openxma.dsl.dom.model.BetweenExpression;
import org.openxma.dsl.dom.model.BinaryExpression;
import org.openxma.dsl.dom.model.BooleanLiteralValue;
import org.openxma.dsl.dom.model.CallInputParameter;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;
import org.openxma.dsl.dom.model.CaseExpression;
import org.openxma.dsl.dom.model.CastFunction;
import org.openxma.dsl.dom.model.CollectionFunction;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DaoOperation;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.DeleteStatement;
import org.openxma.dsl.dom.model.DerivedFlag;
import org.openxma.dsl.dom.model.EmptyLiteralValue;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.ExpressionFlag;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.FromRange;
import org.openxma.dsl.dom.model.FunctionCall;
import org.openxma.dsl.dom.model.IElementWithNoName;
import org.openxma.dsl.dom.model.InClass;
import org.openxma.dsl.dom.model.InCollection;
import org.openxma.dsl.dom.model.InCollectionElements;
import org.openxma.dsl.dom.model.InExpression;
import org.openxma.dsl.dom.model.InsertStatement;
import org.openxma.dsl.dom.model.IntegerLiteralValue;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.JoinEntity;
import org.openxma.dsl.dom.model.LikeExpression;
import org.openxma.dsl.dom.model.LiteralValue;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.MemberOfExpression;
import org.openxma.dsl.dom.model.NotExpression;
import org.openxma.dsl.dom.model.NullLiteralValue;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.ParenthesizedExpression;
import org.openxma.dsl.dom.model.Property;
import org.openxma.dsl.dom.model.PropertyAssignment;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.PropertyValue;
import org.openxma.dsl.dom.model.QlStatement;
import org.openxma.dsl.dom.model.QuantifiedExpression;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;
import org.openxma.dsl.dom.model.QueryParameterReference;
import org.openxma.dsl.dom.model.QueryParameterValue;
import org.openxma.dsl.dom.model.ReadOnlyFlag;
import org.openxma.dsl.dom.model.RealLiteralValue;
import org.openxma.dsl.dom.model.RequiredFlag;
import org.openxma.dsl.dom.model.SelectClass;
import org.openxma.dsl.dom.model.SelectObject;
import org.openxma.dsl.dom.model.SelectProperties;
import org.openxma.dsl.dom.model.SelectStatement;
import org.openxma.dsl.dom.model.Service;
import org.openxma.dsl.dom.model.SortOrderElement;
import org.openxma.dsl.dom.model.StringLiteralValue;
import org.openxma.dsl.dom.model.SubQuery;
import org.openxma.dsl.dom.model.TransientFlag;
import org.openxma.dsl.dom.model.TrimFunction;
import org.openxma.dsl.dom.model.UnaryExpression;
import org.openxma.dsl.dom.model.UpdateStatement;
import org.openxma.dsl.dom.model.ValueObject;
import org.openxma.dsl.dom.model.WhenClause;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.openxma.dsl.dom.DomPackage
 * @generated
 */
public interface DomFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DomFactory eINSTANCE = org.openxma.dsl.dom.model.impl.DomFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service</em>'.
	 * @generated
	 */
	Service createService();

	/**
	 * Returns a new object of class '<em>Operation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation</em>'.
	 * @generated
	 */
	Operation createOperation();

	/**
	 * Returns a new object of class '<em>Delegate Operation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Delegate Operation</em>'.
	 * @generated
	 */
	DelegateOperation createDelegateOperation();

	/**
	 * Returns a new object of class '<em>Dao Operation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dao Operation</em>'.
	 * @generated
	 */
	DaoOperation createDaoOperation();

	/**
	 * Returns a new object of class '<em>Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Parameter</em>'.
	 * @generated
	 */
	Parameter createParameter();

	/**
	 * Returns a new object of class '<em>Value Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Object</em>'.
	 * @generated
	 */
	ValueObject createValueObject();

	/**
	 * Returns a new object of class '<em>Data View</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data View</em>'.
	 * @generated
	 */
	DataView createDataView();
	
	/**
	 * Returns a new object of class '<em>Data View</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data View</em>'.
	 * @generated NOT
	 */
	DataView createDefaultDataView(Entity entity);

	/**
	 * Returns a new object of class '<em>Feature Reference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Reference</em>'.
	 * @generated
	 */
	FeatureReference createFeatureReference();

	/**
	 * Returns a new object of class '<em>Mapper</em>'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mapper</em>'.
	 * @generated
	 */
    Mapper createMapper();

    /**
	 * Returns a new object of class '<em>Property Mapping</em>'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Mapping</em>'.
	 * @generated
	 */
    PropertyMapping createPropertyMapping();

    /**
	 * Returns a new object of class '<em>IElement With No Name</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IElement With No Name</em>'.
	 * @generated
	 */
	IElementWithNoName createIElementWithNoName();

	/**
	 * Returns a new object of class '<em>Aliased Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Aliased Expression</em>'.
	 * @generated
	 */
	AliasedExpression createAliasedExpression();

	/**
	 * Returns a new object of class '<em>Binary Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Binary Expression</em>'.
	 * @generated
	 */
	BinaryExpression createBinaryExpression();

	/**
	 * Returns a new object of class '<em>Not Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Not Expression</em>'.
	 * @generated
	 */
	NotExpression createNotExpression();

	/**
	 * Returns a new object of class '<em>In Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>In Expression</em>'.
	 * @generated
	 */
	InExpression createInExpression();

	/**
	 * Returns a new object of class '<em>Between Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Between Expression</em>'.
	 * @generated
	 */
	BetweenExpression createBetweenExpression();

	/**
	 * Returns a new object of class '<em>Like Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Like Expression</em>'.
	 * @generated
	 */
	LikeExpression createLikeExpression();

	/**
	 * Returns a new object of class '<em>Member Of Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Member Of Expression</em>'.
	 * @generated
	 */
	MemberOfExpression createMemberOfExpression();

	/**
	 * Returns a new object of class '<em>Unary Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unary Expression</em>'.
	 * @generated
	 */
	UnaryExpression createUnaryExpression();

	/**
	 * Returns a new object of class '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Entity</em>'.
	 * @generated
	 */
	Entity createEntity();

	/**
	 * Returns a new object of class '<em>Ql Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ql Statement</em>'.
	 * @generated
	 */
	QlStatement createQlStatement();

	/**
	 * Returns a new object of class '<em>Callable Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Callable Statement</em>'.
	 * @generated
	 */
	CallableStatement createCallableStatement();

	/**
	 * Returns a new object of class '<em>Call Input Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Call Input Parameter</em>'.
	 * @generated
	 */
	CallInputParameter createCallInputParameter();

	/**
	 * Returns a new object of class '<em>Call Output Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Call Output Parameter</em>'.
	 * @generated
	 */
	CallOutputParameter createCallOutputParameter();

	/**
	 * Returns a new object of class '<em>Insert Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Insert Statement</em>'.
	 * @generated
	 */
	InsertStatement createInsertStatement();

	/**
	 * Returns a new object of class '<em>Delete Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Delete Statement</em>'.
	 * @generated
	 */
	DeleteStatement createDeleteStatement();

	/**
	 * Returns a new object of class '<em>Update Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Update Statement</em>'.
	 * @generated
	 */
	UpdateStatement createUpdateStatement();

	/**
	 * Returns a new object of class '<em>Property Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Assignment</em>'.
	 * @generated
	 */
	PropertyAssignment createPropertyAssignment();

	/**
	 * Returns a new object of class '<em>Select Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Select Statement</em>'.
	 * @generated
	 */
	SelectStatement createSelectStatement();

	/**
	 * Returns a new object of class '<em>Sort Order Element</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sort Order Element</em>'.
	 * @generated
	 */
	SortOrderElement createSortOrderElement();

	/**
	 * Returns a new object of class '<em>Select Properties</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Select Properties</em>'.
	 * @generated
	 */
	SelectProperties createSelectProperties();

	/**
	 * Returns a new object of class '<em>Select Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Select Class</em>'.
	 * @generated
	 */
	SelectClass createSelectClass();

	/**
	 * Returns a new object of class '<em>Select Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Select Object</em>'.
	 * @generated
	 */
	SelectObject createSelectObject();

	/**
	 * Returns a new object of class '<em>From Range</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>From Range</em>'.
	 * @generated
	 */
	FromRange createFromRange();

	/**
	 * Returns a new object of class '<em>From Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>From Class</em>'.
	 * @generated
	 */
	FromClass createFromClass();

	/**
	 * Returns a new object of class '<em>In Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>In Class</em>'.
	 * @generated
	 */
	InClass createInClass();

	/**
	 * Returns a new object of class '<em>In Collection</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>In Collection</em>'.
	 * @generated
	 */
	InCollection createInCollection();

	/**
	 * Returns a new object of class '<em>In Collection Elements</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>In Collection Elements</em>'.
	 * @generated
	 */
	InCollectionElements createInCollectionElements();

	/**
	 * Returns a new object of class '<em>Join</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Join</em>'.
	 * @generated
	 */
	Join createJoin();

	/**
	 * Returns a new object of class '<em>Join Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Join Entity</em>'.
	 * @generated
	 */
	JoinEntity createJoinEntity();

	/**
	 * Returns a new object of class '<em>Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Expression</em>'.
	 * @generated
	 */
	Expression createExpression();

	/**
	 * Returns a new object of class '<em>Property Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Value</em>'.
	 * @generated
	 */
	PropertyValue createPropertyValue();

	/**
	 * Returns a new object of class '<em>Function Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Function Call</em>'.
	 * @generated
	 */
	FunctionCall createFunctionCall();

	/**
	 * Returns a new object of class '<em>Trim Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Trim Function</em>'.
	 * @generated
	 */
	TrimFunction createTrimFunction();

	/**
	 * Returns a new object of class '<em>Cast Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cast Function</em>'.
	 * @generated
	 */
	CastFunction createCastFunction();

	/**
	 * Returns a new object of class '<em>Aggregate Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Aggregate Function</em>'.
	 * @generated
	 */
	AggregateFunction createAggregateFunction();

	/**
	 * Returns a new object of class '<em>Query Parameter Reference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Query Parameter Reference</em>'.
	 * @generated
	 */
	QueryParameterReference createQueryParameterReference();

	/**
	 * Returns a new object of class '<em>Query Parameter Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Query Parameter Value</em>'.
	 * @generated
	 */
	QueryParameterValue createQueryParameterValue();

	/**
	 * Returns a new object of class '<em>Quantified Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quantified Expression</em>'.
	 * @generated
	 */
	QuantifiedExpression createQuantifiedExpression();

	/**
	 * Returns a new object of class '<em>Case Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Case Expression</em>'.
	 * @generated
	 */
	CaseExpression createCaseExpression();

	/**
	 * Returns a new object of class '<em>When Clause</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>When Clause</em>'.
	 * @generated
	 */
	WhenClause createWhenClause();

	/**
	 * Returns a new object of class '<em>Alt When Clause</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Alt When Clause</em>'.
	 * @generated
	 */
	AltWhenClause createAltWhenClause();

	/**
	 * Returns a new object of class '<em>Collection Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Collection Function</em>'.
	 * @generated
	 */
	CollectionFunction createCollectionFunction();

	/**
	 * Returns a new object of class '<em>Sub Query</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Query</em>'.
	 * @generated
	 */
	SubQuery createSubQuery();

	/**
	 * Returns a new object of class '<em>Parenthesized Expression</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Parenthesized Expression</em>'.
	 * @generated
	 */
	ParenthesizedExpression createParenthesizedExpression();

	/**
	 * Returns a new object of class '<em>Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Literal Value</em>'.
	 * @generated
	 */
	LiteralValue createLiteralValue();

	/**
	 * Returns a new object of class '<em>String Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Literal Value</em>'.
	 * @generated
	 */
	StringLiteralValue createStringLiteralValue();

	/**
	 * Returns a new object of class '<em>Integer Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Integer Literal Value</em>'.
	 * @generated
	 */
	IntegerLiteralValue createIntegerLiteralValue();

	/**
	 * Returns a new object of class '<em>Real Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Real Literal Value</em>'.
	 * @generated
	 */
	RealLiteralValue createRealLiteralValue();

	/**
	 * Returns a new object of class '<em>Boolean Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Literal Value</em>'.
	 * @generated
	 */
	BooleanLiteralValue createBooleanLiteralValue();

	/**
	 * Returns a new object of class '<em>Null Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Null Literal Value</em>'.
	 * @generated
	 */
	NullLiteralValue createNullLiteralValue();

	/**
	 * Returns a new object of class '<em>Empty Literal Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Empty Literal Value</em>'.
	 * @generated
	 */
	EmptyLiteralValue createEmptyLiteralValue();

	/**
	 * Returns a new object of class '<em>Dao</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dao</em>'.
	 * @generated
	 */
	Dao createDao();

	/**
	 * Returns a new object of class '<em>Query Operation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Query Operation</em>'.
	 * @generated
	 */
	QueryOperation createQueryOperation();

	/**
	 * Returns a new object of class '<em>Query Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Query Parameter</em>'.
	 * @generated
	 */
	QueryParameter createQueryParameter();

	/**
	 * Returns a new object of class '<em>Column</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Column</em>'.
	 * @generated
	 */
	Column createColumn();

	/**
	 * Returns a new object of class '<em>Many To One</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Many To One</em>'.
	 * @generated
	 */
	ManyToOne createManyToOne();

	/**
	 * Returns a new object of class '<em>One To One</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>One To One</em>'.
	 * @generated
	 */
	OneToOne createOneToOne();

	/**
	 * Returns a new object of class '<em>One To Many</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>One To Many</em>'.
	 * @generated
	 */
	OneToMany createOneToMany();

	/**
	 * Returns a new object of class '<em>Many To Many</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Many To Many</em>'.
	 * @generated
	 */
	ManyToMany createManyToMany();

	/**
	 * Returns a new object of class '<em>Data Base Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Base Constraint</em>'.
	 * @generated
	 */
	DataBaseConstraint createDataBaseConstraint();

	/**
	 * Returns a new object of class '<em>Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute</em>'.
	 * @generated
	 */
	Attribute createAttribute();

	/**
	 * Returns a new object of class '<em>Attribute Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Flag</em>'.
	 * @generated
	 */
	AttributeFlag createAttributeFlag();

	/**
	 * Returns a new object of class '<em>Expression Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Expression Flag</em>'.
	 * @generated
	 */
	ExpressionFlag createExpressionFlag();

	/**
	 * Returns a new object of class '<em>Required Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Required Flag</em>'.
	 * @generated
	 */
	RequiredFlag createRequiredFlag();

	/**
	 * Returns a new object of class '<em>Read Only Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Read Only Flag</em>'.
	 * @generated
	 */
	ReadOnlyFlag createReadOnlyFlag();

	/**
	 * Returns a new object of class '<em>Available Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Available Flag</em>'.
	 * @generated
	 */
	AvailableFlag createAvailableFlag();

	/**
	 * Returns a new object of class '<em>Derived Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived Flag</em>'.
	 * @generated
	 */
	DerivedFlag createDerivedFlag();

	/**
	 * Returns a new object of class '<em>Transient Flag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transient Flag</em>'.
	 * @generated
	 */
	TransientFlag createTransientFlag();

	/**
	 * Returns a new object of class '<em>Attribute Property</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Property</em>'.
	 * @generated
	 */
	AttributeProperty createAttributeProperty();

	/**
	 * Returns a new object of class '<em>Attribute Validation Property</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Validation Property</em>'.
	 * @generated
	 */
	AttributeValidationProperty createAttributeValidationProperty();

	/**
	 * Returns a new object of class '<em>Attribute Text Property</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Text Property</em>'.
	 * @generated
	 */
	AttributeTextProperty createAttributeTextProperty();

	/**
	 * Returns a new object of class '<em>Attribute Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Group</em>'.
	 * @generated
	 */
	AttributeGroup createAttributeGroup();

	/**
	 * Returns a new object of class '<em>Attribute Sort Order</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Sort Order</em>'.
	 * @generated
	 */
	AttributeSortOrder createAttributeSortOrder();

	/**
	 * Returns a new object of class '<em>Property</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property</em>'.
	 * @generated
	 */
	Property createProperty();

	/**
	 * Returns a new object of class '<em>Application Session</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Application Session</em>'.
	 * @generated
	 */
	ApplicationSession createApplicationSession();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	DomPackage getDomPackage();

} //DomFactory
