/**
 * <copyright>
 * </copyright>
 *
 * $Id: DomPackage.java 10627 2013-04-10 09:59:28Z dschwarz $
 */
package org.openxma.dsl.dom;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.openxma.dsl.core.CorePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.openxma.dsl.dom.DomFactory
 * @model kind="package"
 * @generated
 */
public interface DomPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "dom";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.openxma.org/dsl/dom/DomDsl";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "dom";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DomPackage eINSTANCE = org.openxma.dsl.dom.model.impl.DomPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ServiceImpl <em>Service</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ServiceImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getService()
	 * @generated
	 */
	int SERVICE = 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ComplexTypeImpl <em>Complex Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ComplexTypeImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getComplexType()
	 * @generated
	 */
	int COMPLEX_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int COMPLEX_TYPE__TXT_DESCRIPTION = CorePackage.MODEL_ELEMENT__TXT_DESCRIPTION;

    /**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_TYPE__NAME = CorePackage.MODEL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_TYPE__ATTRIBUTES = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>All Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_TYPE__ALL_ATTRIBUTES = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Complex Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_TYPE_FEATURE_COUNT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int SERVICE__TXT_DESCRIPTION = CorePackage.MODEL_ELEMENT__TXT_DESCRIPTION;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DependantImpl <em>Dependant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DependantImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDependant()
	 * @generated
	 */
	int DEPENDANT = 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl <em>Delegate Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DelegateOperationImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDelegateOperation()
	 * @generated
	 */
	int DELEGATE_OPERATION = 6;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.OperationImpl <em>Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.OperationImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getOperation()
	 * @generated
	 */
	int OPERATION = 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ParameterImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getParameter()
	 * @generated
	 */
	int PARAMETER = 5;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ValueObjectImpl <em>Value Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ValueObjectImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getValueObject()
	 * @generated
	 */
	int VALUE_OBJECT = 8;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DataViewImpl <em>Data View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DataViewImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDataView()
	 * @generated
	 */
	int DATA_VIEW = 9;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.PresentableFeatureImpl <em>Presentable Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.PresentableFeatureImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPresentableFeature()
	 * @generated
	 */
	int PRESENTABLE_FEATURE = 81;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl <em>Feature Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.FeatureReferenceImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFeatureReference()
	 * @generated
	 */
	int FEATURE_REFERENCE = 10;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.IElementWithNoNameImpl <em>IElement With No Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.IElementWithNoNameImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getIElementWithNoName()
	 * @generated
	 */
	int IELEMENT_WITH_NO_NAME = 80;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.EntityImpl <em>Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.EntityImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getEntity()
	 * @generated
	 */
	int ENTITY = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__NAME = CorePackage.MODEL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__DEPENDENCIES = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__OPERATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Delegate Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__DELEGATE_OPERATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Service</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_FEATURE_COUNT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Dependant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDANT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DaoFeatureImpl <em>Dao Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DaoFeatureImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDaoFeature()
	 * @generated
	 */
	int DAO_FEATURE = 27;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DaoImpl <em>Dao</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DaoImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDao()
	 * @generated
	 */
	int DAO = 28;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ColumnImpl <em>Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ColumnImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getColumn()
	 * @generated
	 */
	int COLUMN = 31;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl <em>Many To One</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ManyToOneImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getManyToOne()
	 * @generated
	 */
	int MANY_TO_ONE = 32;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.OneToOneImpl <em>One To One</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.OneToOneImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getOneToOne()
	 * @generated
	 */
	int ONE_TO_ONE = 33;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.OneToManyImpl <em>One To Many</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.OneToManyImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getOneToMany()
	 * @generated
	 */
	int ONE_TO_MANY = 34;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ManyToManyImpl <em>Many To Many</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ManyToManyImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getManyToMany()
	 * @generated
	 */
	int MANY_TO_MANY = 35;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl <em>Data Base Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDataBaseConstraint()
	 * @generated
	 */
	int DATA_BASE_CONSTRAINT = 36;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributeImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE = 14;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributePropertyImpl <em>Attribute Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributePropertyImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeProperty()
	 * @generated
	 */
	int ATTRIBUTE_PROPERTY = 22;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributeFlagImpl <em>Attribute Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributeFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeFlag()
	 * @generated
	 */
	int ATTRIBUTE_FLAG = 15;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ExpressionFlagImpl <em>Expression Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ExpressionFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getExpressionFlag()
	 * @generated
	 */
	int EXPRESSION_FLAG = 16;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.RequiredFlagImpl <em>Required Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.RequiredFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getRequiredFlag()
	 * @generated
	 */
	int REQUIRED_FLAG = 17;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ReadOnlyFlagImpl <em>Read Only Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ReadOnlyFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getReadOnlyFlag()
	 * @generated
	 */
	int READ_ONLY_FLAG = 18;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AvailableFlagImpl <em>Available Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AvailableFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAvailableFlag()
	 * @generated
	 */
	int AVAILABLE_FLAG = 19;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DerivedFlagImpl <em>Derived Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DerivedFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDerivedFlag()
	 * @generated
	 */
	int DERIVED_FLAG = 20;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.TransientFlagImpl <em>Transient Flag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.TransientFlagImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getTransientFlag()
	 * @generated
	 */
	int TRANSIENT_FLAG = 21;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributeValidationPropertyImpl <em>Attribute Validation Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributeValidationPropertyImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeValidationProperty()
	 * @generated
	 */
	int ATTRIBUTE_VALIDATION_PROPERTY = 23;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl <em>Attribute Text Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeTextProperty()
	 * @generated
	 */
	int ATTRIBUTE_TEXT_PROPERTY = 24;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl <em>Attribute Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributeGroupImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeGroup()
	 * @generated
	 */
	int ATTRIBUTE_GROUP = 25;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl <em>Attribute Sort Order</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeSortOrder()
	 * @generated
	 */
	int ATTRIBUTE_SORT_ORDER = 26;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.PropertyImpl <em>Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.PropertyImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getProperty()
	 * @generated
	 */
	int PROPERTY = 3;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY__TXT_DESCRIPTION = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 0;

    /**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__TYPE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__NAME = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__DEFAULT_VALUE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_FEATURE_COUNT = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DaoOperationImpl <em>Dao Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DaoOperationImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDaoOperation()
	 * @generated
	 */
	int DAO_OPERATION = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_OPERATION__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_OPERATION__MANY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_OPERATION__NAME = 2;

	/**
	 * The number of structural features of the '<em>Dao Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_OPERATION_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__TYPE = DAO_OPERATION__TYPE;

	/**
	 * The feature id for the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__MANY = DAO_OPERATION__MANY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__NAME = DAO_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int OPERATION__TXT_DESCRIPTION = DAO_OPERATION_FEATURE_COUNT + 0;

    /**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__PARAMETERS = DAO_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__EXPRESSION = DAO_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Delegate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__DELEGATE = DAO_OPERATION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_FEATURE_COUNT = DAO_OPERATION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ExpressionImpl <em>Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION = 58;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.QueryParameterImpl <em>Query Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.QueryParameterImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryParameter()
	 * @generated
	 */
	int QUERY_PARAMETER = 30;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_PARAMETER__ATTRIBUTE = 0;

	/**
	 * The number of structural features of the '<em>Query Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_PARAMETER_FEATURE_COUNT = 1;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__ATTRIBUTE = QUERY_PARAMETER__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__TYPE = QUERY_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__MANY = QUERY_PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__NAME = QUERY_PARAMETER_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_FEATURE_COUNT = QUERY_PARAMETER_FEATURE_COUNT + 3;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int DELEGATE_OPERATION__TXT_DESCRIPTION = CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>View</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_OPERATION__VIEW = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int DELEGATE_OPERATION__MANY = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 1;

    /**
	 * The feature id for the '<em><b>Repository</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_OPERATION__REPOSITORY = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_OPERATION__OPERATION = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Crud Operation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_OPERATION__CRUD_OPERATION_TYPE = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>View Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_OPERATION__VIEW_PARAMETER = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int DELEGATE_OPERATION__NAME = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 6;

    /**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int DELEGATE_OPERATION__FILTER = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 7;

    /**
	 * The number of structural features of the '<em>Delegate Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELEGATE_OPERATION_FEATURE_COUNT = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 8;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int VALUE_OBJECT__TXT_DESCRIPTION = COMPLEX_TYPE__TXT_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OBJECT__NAME = COMPLEX_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OBJECT__ATTRIBUTES = COMPLEX_TYPE__ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>All Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OBJECT__ALL_ATTRIBUTES = COMPLEX_TYPE__ALL_ATTRIBUTES;

	/**
	 * The number of structural features of the '<em>Value Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OBJECT_FEATURE_COUNT = COMPLEX_TYPE_FEATURE_COUNT + 0;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int DATA_VIEW__TXT_DESCRIPTION = COMPLEX_TYPE__TXT_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_VIEW__NAME = COMPLEX_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_VIEW__ATTRIBUTES = COMPLEX_TYPE__ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>All Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_VIEW__ALL_ATTRIBUTES = COMPLEX_TYPE__ALL_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Super Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_VIEW__SUPER_TYPE = COMPLEX_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature References</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_VIEW__FEATURE_REFERENCES = COMPLEX_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_VIEW_FEATURE_COUNT = COMPLEX_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTABLE_FEATURE__NAME = 0;

	/**
	 * The number of structural features of the '<em>Presentable Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRESENTABLE_FEATURE_FEATURE_COUNT = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__NAME = PRESENTABLE_FEATURE__NAME;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int FEATURE_REFERENCE__TXT_DESCRIPTION = PRESENTABLE_FEATURE_FEATURE_COUNT + 0;

    /**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__SOURCE = PRESENTABLE_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__ATTRIBUTE = PRESENTABLE_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>View</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__VIEW = PRESENTABLE_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>All</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__ALL = PRESENTABLE_FEATURE_FEATURE_COUNT + 4;

    /**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__PROPERTIES = PRESENTABLE_FEATURE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__TARGET = PRESENTABLE_FEATURE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Feature Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE_FEATURE_COUNT = PRESENTABLE_FEATURE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.MapperImpl <em>Mapper</em>}' class.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.MapperImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getMapper()
	 * @generated
	 */
    int MAPPER = 11;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__TXT_DESCRIPTION = CorePackage.MODEL_ELEMENT__TXT_DESCRIPTION;

    /**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__NAME = CorePackage.MODEL_ELEMENT__NAME;

    /**
	 * The feature id for the '<em><b>Left</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__LEFT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

    /**
	 * The feature id for the '<em><b>Bi Directional</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__BI_DIRECTIONAL = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

    /**
	 * The feature id for the '<em><b>To Left</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__TO_LEFT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

    /**
	 * The feature id for the '<em><b>To Right</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__TO_RIGHT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 3;

    /**
	 * The feature id for the '<em><b>Right</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__RIGHT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 4;

    /**
	 * The feature id for the '<em><b>Property Mappings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER__PROPERTY_MAPPINGS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 5;

    /**
	 * The number of structural features of the '<em>Mapper</em>' class.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int MAPPER_FEATURE_COUNT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 6;

    /**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl <em>Property Mapping</em>}' class.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.PropertyMappingImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPropertyMapping()
	 * @generated
	 */
    int PROPERTY_MAPPING = 12;

    /**
	 * The feature id for the '<em><b>Left</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY_MAPPING__LEFT = 0;

    /**
	 * The feature id for the '<em><b>Bi Directional</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY_MAPPING__BI_DIRECTIONAL = 1;

    /**
	 * The feature id for the '<em><b>To Left</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY_MAPPING__TO_LEFT = 2;

    /**
	 * The feature id for the '<em><b>To Right</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY_MAPPING__TO_RIGHT = 3;

    /**
	 * The feature id for the '<em><b>Right</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY_MAPPING__RIGHT = 4;

    /**
	 * The number of structural features of the '<em>Property Mapping</em>' class.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int PROPERTY_MAPPING_FEATURE_COUNT = 5;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int ENTITY__TXT_DESCRIPTION = COMPLEX_TYPE__TXT_DESCRIPTION;

    /**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__NAME = COMPLEX_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__ATTRIBUTES = COMPLEX_TYPE__ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>All Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__ALL_ATTRIBUTES = COMPLEX_TYPE__ALL_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Super Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SUPER_TYPE = COMPLEX_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribute Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__ATTRIBUTE_GROUPS = COMPLEX_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Conditions Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__CONDITIONS_BLOCK = COMPLEX_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Repository</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__REPOSITORY = COMPLEX_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__KEY = COMPLEX_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Sort Orders</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SORT_ORDERS = COMPLEX_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__IDENTIFIER = COMPLEX_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Version</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__VERSION = COMPLEX_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Required References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__REQUIRED_REFERENCES = COMPLEX_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Required Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__REQUIRED_ATTRIBUTES = COMPLEX_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_FEATURE_COUNT = COMPLEX_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__NAME = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int ATTRIBUTE__TXT_DESCRIPTION = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 1;

    /**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__IDENTIFIER = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__VERSION = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Composition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__COMPOSITION = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__TYPE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__MANY = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Incrementer Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__INCREMENTER_REFERENCE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DEFAULT_VALUE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Opposite</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__OPPOSITE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Attribut Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__ATTRIBUT_PROPERTIES = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Sort Order</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SORT_ORDER = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DATA_TYPE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Opposite Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__OPPOSITE_REFERENCE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Data Type Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DATA_TYPE_NAME = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Resolved Attribute List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__RESOLVED_ATTRIBUTE_LIST = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__REFERENCE = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Read Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__READ_ONLY = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__REQUIRED = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Derived</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DERIVED = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Transient</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__TRANSIENT = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 20;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 21;

	/**
	 * The number of structural features of the '<em>Attribute Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_PROPERTY_FEATURE_COUNT = 0;

	/**
	 * The number of structural features of the '<em>Attribute Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FLAG_FEATURE_COUNT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FLAG__EXPRESSION = ATTRIBUTE_FLAG_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Expression Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FLAG_FEATURE_COUNT = ATTRIBUTE_FLAG_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIRED_FLAG__EXPRESSION = EXPRESSION_FLAG__EXPRESSION;

	/**
	 * The number of structural features of the '<em>Required Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIRED_FLAG_FEATURE_COUNT = EXPRESSION_FLAG_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READ_ONLY_FLAG__EXPRESSION = EXPRESSION_FLAG__EXPRESSION;

	/**
	 * The number of structural features of the '<em>Read Only Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READ_ONLY_FLAG_FEATURE_COUNT = EXPRESSION_FLAG_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVAILABLE_FLAG__EXPRESSION = EXPRESSION_FLAG__EXPRESSION;

	/**
	 * The number of structural features of the '<em>Available Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVAILABLE_FLAG_FEATURE_COUNT = EXPRESSION_FLAG_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_FLAG__EXPRESSION = ATTRIBUTE_FLAG_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Derived Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_FLAG_FEATURE_COUNT = ATTRIBUTE_FLAG_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSIENT_FLAG__EXPRESSION = ATTRIBUTE_FLAG_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Transient Flag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSIENT_FLAG_FEATURE_COUNT = ATTRIBUTE_FLAG_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_VALIDATION_PROPERTY__FORMAT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Attribute Validation Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_VALIDATION_PROPERTY_FEATURE_COUNT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Label Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tooltip Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Unit Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Unit Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hstore Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 4;

    /**
	 * The number of structural features of the '<em>Attribute Text Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_PROPERTY_FEATURE_COUNT = ATTRIBUTE_PROPERTY_FEATURE_COUNT + 5;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int ATTRIBUTE_GROUP__TXT_DESCRIPTION = CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__KEY = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__UNIQUE = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__FILTER = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Sortorder</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__SORTORDER = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__NAME = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__ATTRIBUTES = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Resolved Attribute List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP__RESOLVED_ATTRIBUTE_LIST = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Attribute Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_GROUP_FEATURE_COUNT = CorePackage.IDOCUMENTABLE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_SORT_ORDER__ATTRIBUTE = 0;

	/**
	 * The feature id for the '<em><b>Asc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_SORT_ORDER__ASC = 1;

	/**
	 * The feature id for the '<em><b>Desc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_SORT_ORDER__DESC = 2;

	/**
	 * The number of structural features of the '<em>Attribute Sort Order</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_SORT_ORDER_FEATURE_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_FEATURE__ATTRIBUTE = 0;

	/**
	 * The number of structural features of the '<em>Dao Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_FEATURE_FEATURE_COUNT = 1;

    /**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int DAO__TXT_DESCRIPTION = CorePackage.MODEL_ELEMENT__TXT_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__NAME = CorePackage.MODEL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__ENTITY = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Table Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__TABLE_NAME = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Discriminator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__DISCRIMINATOR = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Qualifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__QUALIFIER = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__OPERATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Query Operation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__QUERY_OPERATION = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Data Base Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__DATA_BASE_CONSTRAINTS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__COLUMNS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Many To One Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__MANY_TO_ONE_ASSOCIATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>One To One Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__ONE_TO_ONE_ASSOCIATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>One To Many Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__ONE_TO_MANY_ASSOCIATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Many To Many Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__MANY_TO_MANY_ASSOCIATIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Primary Key Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__PRIMARY_KEY_COLUMN = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Natural Key Columns</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__NATURAL_KEY_COLUMNS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Version Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__VERSION_COLUMN = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Primary Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__PRIMARY_KEY = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Natural Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO__NATURAL_KEY = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>Dao</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DAO_FEATURE_COUNT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.QueryOperationImpl <em>Query Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.QueryOperationImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryOperation()
	 * @generated
	 */
	int QUERY_OPERATION = 29;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_OPERATION__TYPE = DAO_OPERATION__TYPE;

	/**
	 * The feature id for the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_OPERATION__MANY = DAO_OPERATION__MANY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_OPERATION__NAME = DAO_OPERATION__NAME;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int QUERY_OPERATION__TXT_DESCRIPTION = DAO_OPERATION_FEATURE_COUNT + 0;

    /**
	 * The feature id for the '<em><b>Query Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_OPERATION__QUERY_PARAMETERS = DAO_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_OPERATION__STATEMENT = DAO_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Query Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_OPERATION_FEATURE_COUNT = DAO_OPERATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__ATTRIBUTE = DAO_FEATURE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__COLUMN_NAME = DAO_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>User Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__USER_TYPE = DAO_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Column Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__COLUMN_TYPE = DAO_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN__COLUMNS = DAO_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLUMN_FEATURE_COUNT = DAO_FEATURE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE__ATTRIBUTE = DAO_FEATURE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE__COLUMN_NAME = DAO_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>User Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE__USER_TYPE = DAO_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sql Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE__SQL_TYPE = DAO_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE__COLUMNS = DAO_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Derived</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE__DERIVED = DAO_FEATURE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Many To One</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_ONE_FEATURE_COUNT = DAO_FEATURE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_TO_ONE__ATTRIBUTE = DAO_FEATURE__ATTRIBUTE;

	/**
	 * The number of structural features of the '<em>One To One</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_TO_ONE_FEATURE_COUNT = DAO_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_TO_MANY__ATTRIBUTE = DAO_FEATURE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_TO_MANY__COLUMN_NAME = DAO_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_TO_MANY__COLUMNS = DAO_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>One To Many</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_TO_MANY_FEATURE_COUNT = DAO_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_MANY__ATTRIBUTE = DAO_FEATURE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Table Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_MANY__TABLE_NAME = DAO_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_MANY__COLUMN_NAME = DAO_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_MANY__INVERSE = DAO_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Many To Many</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANY_TO_MANY_FEATURE_COUNT = DAO_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BASE_CONSTRAINT__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BASE_CONSTRAINT__NAME = 1;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BASE_CONSTRAINT__ATTRIBUTES = 2;

	/**
	 * The feature id for the '<em><b>Resolved Attribute List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BASE_CONSTRAINT__RESOLVED_ATTRIBUTE_LIST = 3;

	/**
	 * The number of structural features of the '<em>Data Base Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BASE_CONSTRAINT_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ApplicationSessionImpl <em>Application Session</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ApplicationSessionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getApplicationSession()
	 * @generated
	 */
	int APPLICATION_SESSION = 37;

	/**
	 * The feature id for the '<em><b>Txt Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int APPLICATION_SESSION__TXT_DESCRIPTION = CorePackage.MODEL_ELEMENT__TXT_DESCRIPTION;

    /**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_SESSION__NAME = CorePackage.MODEL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_SESSION__PROPERTIES = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_SESSION__FUNCTIONS = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Conditions Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_SESSION__CONDITIONS_BLOCK = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Application Session</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_SESSION_FEATURE_COUNT = CorePackage.MODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.QlStatementImpl <em>Ql Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.QlStatementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQlStatement()
	 * @generated
	 */
	int QL_STATEMENT = 38;

	/**
	 * The number of structural features of the '<em>Ql Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QL_STATEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.CallableStatementImpl <em>Callable Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.CallableStatementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCallableStatement()
	 * @generated
	 */
	int CALLABLE_STATEMENT = 39;

	/**
	 * The feature id for the '<em><b>Function Call</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_STATEMENT__FUNCTION_CALL = QL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_STATEMENT__NAME = QL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>In Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_STATEMENT__IN_PARAMETER = QL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Out Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_STATEMENT__OUT_PARAMETER = QL_STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Callable Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALLABLE_STATEMENT_FEATURE_COUNT = QL_STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.CallInputParameterImpl <em>Call Input Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.CallInputParameterImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCallInputParameter()
	 * @generated
	 */
	int CALL_INPUT_PARAMETER = 40;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_INPUT_PARAMETER__PARAMETER = 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_INPUT_PARAMETER__ATTRIBUTE = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_INPUT_PARAMETER__NAME = 2;

	/**
	 * The number of structural features of the '<em>Call Input Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_INPUT_PARAMETER_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.CallOutputParameterImpl <em>Call Output Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.CallOutputParameterImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCallOutputParameter()
	 * @generated
	 */
	int CALL_OUTPUT_PARAMETER = 41;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_OUTPUT_PARAMETER__NAME = 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_OUTPUT_PARAMETER__ATTRIBUTE = 1;

	/**
	 * The feature id for the '<em><b>Nested Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_OUTPUT_PARAMETER__NESTED_ATTRIBUTE = 2;

	/**
	 * The number of structural features of the '<em>Call Output Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_OUTPUT_PARAMETER_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.InsertStatementImpl <em>Insert Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.InsertStatementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInsertStatement()
	 * @generated
	 */
	int INSERT_STATEMENT = 42;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSERT_STATEMENT__ENTITY = QL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSERT_STATEMENT__EXPRESSION = QL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Select Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSERT_STATEMENT__SELECT_STATEMENT = QL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Insert Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSERT_STATEMENT_FEATURE_COUNT = QL_STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.DeleteStatementImpl <em>Delete Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.DeleteStatementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDeleteStatement()
	 * @generated
	 */
	int DELETE_STATEMENT = 43;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_STATEMENT__ENTITY = QL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_STATEMENT__NAME = QL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_STATEMENT__WHERE = QL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Delete Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_STATEMENT_FEATURE_COUNT = QL_STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.UpdateStatementImpl <em>Update Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.UpdateStatementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getUpdateStatement()
	 * @generated
	 */
	int UPDATE_STATEMENT = 44;

	/**
	 * The feature id for the '<em><b>Versioned</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_STATEMENT__VERSIONED = QL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_STATEMENT__ENTITY = QL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_STATEMENT__NAME = QL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Assignment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_STATEMENT__ASSIGNMENT = QL_STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_STATEMENT__WHERE = QL_STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Update Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_STATEMENT_FEATURE_COUNT = QL_STATEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.PropertyAssignmentImpl <em>Property Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.PropertyAssignmentImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPropertyAssignment()
	 * @generated
	 */
	int PROPERTY_ASSIGNMENT = 45;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ASSIGNMENT__PROPERTY = 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ASSIGNMENT__EXPRESSION = 1;

	/**
	 * The number of structural features of the '<em>Property Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ASSIGNMENT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl <em>Select Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.SelectStatementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectStatement()
	 * @generated
	 */
	int SELECT_STATEMENT = 46;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT__FROM = QL_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Join</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT__JOIN = QL_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT__WHERE = QL_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Group By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT__GROUP_BY = QL_STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Having</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT__HAVING = QL_STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Order By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT__ORDER_BY = QL_STATEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Select Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_STATEMENT_FEATURE_COUNT = QL_STATEMENT_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.SortOrderElementImpl <em>Sort Order Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.SortOrderElementImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSortOrderElement()
	 * @generated
	 */
	int SORT_ORDER_ELEMENT = 47;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_ORDER_ELEMENT__EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Sort Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_ORDER_ELEMENT__SORT_ORDER = 1;

	/**
	 * The number of structural features of the '<em>Sort Order Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_ORDER_ELEMENT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.SelectPropertiesImpl <em>Select Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.SelectPropertiesImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectProperties()
	 * @generated
	 */
	int SELECT_PROPERTIES = 48;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__FROM = SELECT_STATEMENT__FROM;

	/**
	 * The feature id for the '<em><b>Join</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__JOIN = SELECT_STATEMENT__JOIN;

	/**
	 * The feature id for the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__WHERE = SELECT_STATEMENT__WHERE;

	/**
	 * The feature id for the '<em><b>Group By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__GROUP_BY = SELECT_STATEMENT__GROUP_BY;

	/**
	 * The feature id for the '<em><b>Having</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__HAVING = SELECT_STATEMENT__HAVING;

	/**
	 * The feature id for the '<em><b>Order By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__ORDER_BY = SELECT_STATEMENT__ORDER_BY;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__DISTINCT = SELECT_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES__PROPERTIES = SELECT_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Select Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_PROPERTIES_FEATURE_COUNT = SELECT_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.SelectClassImpl <em>Select Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.SelectClassImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectClass()
	 * @generated
	 */
	int SELECT_CLASS = 49;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__FROM = SELECT_STATEMENT__FROM;

	/**
	 * The feature id for the '<em><b>Join</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__JOIN = SELECT_STATEMENT__JOIN;

	/**
	 * The feature id for the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__WHERE = SELECT_STATEMENT__WHERE;

	/**
	 * The feature id for the '<em><b>Group By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__GROUP_BY = SELECT_STATEMENT__GROUP_BY;

	/**
	 * The feature id for the '<em><b>Having</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__HAVING = SELECT_STATEMENT__HAVING;

	/**
	 * The feature id for the '<em><b>Order By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__ORDER_BY = SELECT_STATEMENT__ORDER_BY;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__CLASS = SELECT_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS__ARGUMENTS = SELECT_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Select Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_CLASS_FEATURE_COUNT = SELECT_STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.SelectObjectImpl <em>Select Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.SelectObjectImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectObject()
	 * @generated
	 */
	int SELECT_OBJECT = 50;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__FROM = SELECT_STATEMENT__FROM;

	/**
	 * The feature id for the '<em><b>Join</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__JOIN = SELECT_STATEMENT__JOIN;

	/**
	 * The feature id for the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__WHERE = SELECT_STATEMENT__WHERE;

	/**
	 * The feature id for the '<em><b>Group By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__GROUP_BY = SELECT_STATEMENT__GROUP_BY;

	/**
	 * The feature id for the '<em><b>Having</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__HAVING = SELECT_STATEMENT__HAVING;

	/**
	 * The feature id for the '<em><b>Order By</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__ORDER_BY = SELECT_STATEMENT__ORDER_BY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT__NAME = SELECT_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Select Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OBJECT_FEATURE_COUNT = SELECT_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.FromRangeImpl <em>From Range</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.FromRangeImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFromRange()
	 * @generated
	 */
	int FROM_RANGE = 51;

	/**
	 * The number of structural features of the '<em>From Range</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_RANGE_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.FromClassImpl <em>From Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.FromClassImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFromClass()
	 * @generated
	 */
	int FROM_CLASS = 52;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_CLASS__NAME = FROM_RANGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_CLASS__ENTITY = FROM_RANGE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Poperty Fetch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_CLASS__POPERTY_FETCH = FROM_RANGE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>From Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_CLASS_FEATURE_COUNT = FROM_RANGE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.InClassImpl <em>In Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.InClassImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInClass()
	 * @generated
	 */
	int IN_CLASS = 53;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_CLASS__NAME = FROM_RANGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_CLASS__CLASS = FROM_RANGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>In Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_CLASS_FEATURE_COUNT = FROM_RANGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.InCollectionImpl <em>In Collection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.InCollectionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInCollection()
	 * @generated
	 */
	int IN_COLLECTION = 54;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_COLLECTION__PATH = FROM_RANGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_COLLECTION__ALIAS = FROM_RANGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>In Collection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_COLLECTION_FEATURE_COUNT = FROM_RANGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.InCollectionElementsImpl <em>In Collection Elements</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.InCollectionElementsImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInCollectionElements()
	 * @generated
	 */
	int IN_COLLECTION_ELEMENTS = 55;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_COLLECTION_ELEMENTS__NAME = FROM_RANGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_COLLECTION_ELEMENTS__REFERENCE = FROM_RANGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>In Collection Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_COLLECTION_ELEMENTS_FEATURE_COUNT = FROM_RANGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.JoinEntityImpl <em>Join Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.JoinEntityImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getJoinEntity()
	 * @generated
	 */
	int JOIN_ENTITY = 57;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_ENTITY__NAME = 0;

	/**
	 * The number of structural features of the '<em>Join Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_ENTITY_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.JoinImpl <em>Join</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.JoinImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getJoin()
	 * @generated
	 */
	int JOIN = 56;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__NAME = JOIN_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__TYPE = JOIN_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Fetch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__FETCH = JOIN_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__ENTITY = JOIN_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__REFERENCE = JOIN_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Property Fetch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__PROPERTY_FETCH = JOIN_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__EXPRESSION = JOIN_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Join</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_FEATURE_COUNT = JOIN_ENTITY_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.PropertyValueImpl <em>Property Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.PropertyValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPropertyValue()
	 * @generated
	 */
	int PROPERTY_VALUE = 59;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_VALUE__NAME = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_VALUE__SEGMENTS = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Index</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_VALUE__INDEX = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Class Property</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_VALUE__CLASS_PROPERTY = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Property Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_VALUE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.FunctionCallImpl <em>Function Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.FunctionCallImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFunctionCall()
	 * @generated
	 */
	int FUNCTION_CALL = 60;

	/**
	 * The feature id for the '<em><b>Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__FUNCTION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__ARGUMENTS = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Function Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.TrimFunctionImpl <em>Trim Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.TrimFunctionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getTrimFunction()
	 * @generated
	 */
	int TRIM_FUNCTION = 61;

	/**
	 * The feature id for the '<em><b>Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIM_FUNCTION__FUNCTION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIM_FUNCTION__MODE = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Character</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIM_FUNCTION__CHARACTER = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIM_FUNCTION__FROM = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Trim Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIM_FUNCTION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.CastFunctionImpl <em>Cast Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.CastFunctionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCastFunction()
	 * @generated
	 */
	int CAST_FUNCTION = 62;

	/**
	 * The feature id for the '<em><b>Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_FUNCTION__FUNCTION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_FUNCTION__FROM = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_FUNCTION__NAME = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Cast Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_FUNCTION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl <em>Aggregate Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AggregateFunctionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAggregateFunction()
	 * @generated
	 */
	int AGGREGATE_FUNCTION = 63;

	/**
	 * The feature id for the '<em><b>Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION__FUNCTION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>All</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION__ALL = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION__DISTINCT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>From</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION__FROM = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Collection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION__COLLECTION = EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Aggregate Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_FUNCTION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.QueryParameterReferenceImpl <em>Query Parameter Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.QueryParameterReferenceImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryParameterReference()
	 * @generated
	 */
	int QUERY_PARAMETER_REFERENCE = 64;

	/**
	 * The number of structural features of the '<em>Query Parameter Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_PARAMETER_REFERENCE_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.QueryParameterValueImpl <em>Query Parameter Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.QueryParameterValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryParameterValue()
	 * @generated
	 */
	int QUERY_PARAMETER_VALUE = 65;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_PARAMETER_VALUE__PARAMETER = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_PARAMETER_VALUE__ATTRIBUTE = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Query Parameter Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_PARAMETER_VALUE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.QuantifiedExpressionImpl <em>Quantified Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.QuantifiedExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQuantifiedExpression()
	 * @generated
	 */
	int QUANTIFIED_EXPRESSION = 66;

	/**
	 * The feature id for the '<em><b>Quantifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTIFIED_EXPRESSION__QUANTIFIER = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTIFIED_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTIFIED_EXPRESSION__NAME = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Quantified Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTIFIED_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.CaseExpressionImpl <em>Case Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.CaseExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCaseExpression()
	 * @generated
	 */
	int CASE_EXPRESSION = 67;

	/**
	 * The feature id for the '<em><b>When Clause</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPRESSION__WHEN_CLAUSE = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Else Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPRESSION__ELSE_EXPRESSION = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Alt When Clause</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPRESSION__ALT_WHEN_CLAUSE = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Case Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.WhenClauseImpl <em>When Clause</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.WhenClauseImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getWhenClause()
	 * @generated
	 */
	int WHEN_CLAUSE = 68;

	/**
	 * The feature id for the '<em><b>When Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN_CLAUSE__WHEN_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Then Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN_CLAUSE__THEN_EXPRESSION = 1;

	/**
	 * The number of structural features of the '<em>When Clause</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN_CLAUSE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AltWhenClauseImpl <em>Alt When Clause</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AltWhenClauseImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAltWhenClause()
	 * @generated
	 */
	int ALT_WHEN_CLAUSE = 69;

	/**
	 * The feature id for the '<em><b>When Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALT_WHEN_CLAUSE__WHEN_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Then Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALT_WHEN_CLAUSE__THEN_EXPRESSION = 1;

	/**
	 * The number of structural features of the '<em>Alt When Clause</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALT_WHEN_CLAUSE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.CollectionFunctionImpl <em>Collection Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.CollectionFunctionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCollectionFunction()
	 * @generated
	 */
	int COLLECTION_FUNCTION = 70;

	/**
	 * The feature id for the '<em><b>Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_FUNCTION__FUNCTION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_FUNCTION__PROPERTY = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Collection Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_FUNCTION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.SubQueryImpl <em>Sub Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.SubQueryImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSubQuery()
	 * @generated
	 */
	int SUB_QUERY = 71;

	/**
	 * The feature id for the '<em><b>Queries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_QUERY__QUERIES = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Sub Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_QUERY_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.ParenthesizedExpressionImpl <em>Parenthesized Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.ParenthesizedExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getParenthesizedExpression()
	 * @generated
	 */
	int PARENTHESIZED_EXPRESSION = 72;

	/**
	 * The feature id for the '<em><b>Expressions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIZED_EXPRESSION__EXPRESSIONS = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parenthesized Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIZED_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.LiteralValueImpl <em>Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.LiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getLiteralValue()
	 * @generated
	 */
	int LITERAL_VALUE = 73;

	/**
	 * The number of structural features of the '<em>Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_VALUE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.StringLiteralValueImpl <em>String Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.StringLiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getStringLiteralValue()
	 * @generated
	 */
	int STRING_LITERAL_VALUE = 74;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_VALUE__VALUE = LITERAL_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_VALUE_FEATURE_COUNT = LITERAL_VALUE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.IntegerLiteralValueImpl <em>Integer Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.IntegerLiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getIntegerLiteralValue()
	 * @generated
	 */
	int INTEGER_LITERAL_VALUE = 75;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LITERAL_VALUE__VALUE = LITERAL_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Integer Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LITERAL_VALUE_FEATURE_COUNT = LITERAL_VALUE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.RealLiteralValueImpl <em>Real Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.RealLiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getRealLiteralValue()
	 * @generated
	 */
	int REAL_LITERAL_VALUE = 76;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REAL_LITERAL_VALUE__VALUE = LITERAL_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Real Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REAL_LITERAL_VALUE_FEATURE_COUNT = LITERAL_VALUE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.BooleanLiteralValueImpl <em>Boolean Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.BooleanLiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getBooleanLiteralValue()
	 * @generated
	 */
	int BOOLEAN_LITERAL_VALUE = 77;

	/**
	 * The feature id for the '<em><b>Is True</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
    int BOOLEAN_LITERAL_VALUE__IS_TRUE = LITERAL_VALUE_FEATURE_COUNT + 0;

    /**
	 * The number of structural features of the '<em>Boolean Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_LITERAL_VALUE_FEATURE_COUNT = LITERAL_VALUE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.NullLiteralValueImpl <em>Null Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.NullLiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getNullLiteralValue()
	 * @generated
	 */
	int NULL_LITERAL_VALUE = 78;

	/**
	 * The number of structural features of the '<em>Null Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL_VALUE_FEATURE_COUNT = LITERAL_VALUE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.EmptyLiteralValueImpl <em>Empty Literal Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.EmptyLiteralValueImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getEmptyLiteralValue()
	 * @generated
	 */
	int EMPTY_LITERAL_VALUE = 79;

	/**
	 * The number of structural features of the '<em>Empty Literal Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPTY_LITERAL_VALUE_FEATURE_COUNT = LITERAL_VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>No Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IELEMENT_WITH_NO_NAME__NO_NAME = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IElement With No Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IELEMENT_WITH_NO_NAME_FEATURE_COUNT = CorePackage.REFERENCEABLE_BY_XMADSL_VARIABLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.AliasedExpressionImpl <em>Aliased Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.AliasedExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAliasedExpression()
	 * @generated
	 */
	int ALIASED_EXPRESSION = 82;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALIASED_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALIASED_EXPRESSION__NAME = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Aliased Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALIASED_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.BinaryExpressionImpl <em>Binary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.BinaryExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getBinaryExpression()
	 * @generated
	 */
	int BINARY_EXPRESSION = 83;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__LEFT = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__RIGHT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Binary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.NotExpressionImpl <em>Not Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.NotExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getNotExpression()
	 * @generated
	 */
	int NOT_EXPRESSION = 84;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Not Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.InExpressionImpl <em>In Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.InExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInExpression()
	 * @generated
	 */
	int IN_EXPRESSION = 85;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Not</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_EXPRESSION__NOT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>In</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_EXPRESSION__IN = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>In Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IN_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.BetweenExpressionImpl <em>Between Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.BetweenExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getBetweenExpression()
	 * @generated
	 */
	int BETWEEN_EXPRESSION = 86;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BETWEEN_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Not</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BETWEEN_EXPRESSION__NOT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BETWEEN_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BETWEEN_EXPRESSION__LEFT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BETWEEN_EXPRESSION__RIGHT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Between Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BETWEEN_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.LikeExpressionImpl <em>Like Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.LikeExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getLikeExpression()
	 * @generated
	 */
	int LIKE_EXPRESSION = 87;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIKE_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Not</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIKE_EXPRESSION__NOT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIKE_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Like</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIKE_EXPRESSION__LIKE = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Escape</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIKE_EXPRESSION__ESCAPE = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Like Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIKE_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.MemberOfExpressionImpl <em>Member Of Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.MemberOfExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getMemberOfExpression()
	 * @generated
	 */
	int MEMBER_OF_EXPRESSION = 88;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_OF_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Not</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_OF_EXPRESSION__NOT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_OF_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Member Of</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_OF_EXPRESSION__MEMBER_OF = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Member Of Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_OF_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.impl.UnaryExpressionImpl <em>Unary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.impl.UnaryExpressionImpl
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getUnaryExpression()
	 * @generated
	 */
	int UNARY_EXPRESSION = 89;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.CrudOperationType <em>Crud Operation Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.CrudOperationType
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCrudOperationType()
	 * @generated
	 */
	int CRUD_OPERATION_TYPE = 90;

	/**
	 * The meta object id for the '{@link org.openxma.dsl.dom.model.DataBaseConstraintType <em>Data Base Constraint Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.openxma.dsl.dom.model.DataBaseConstraintType
	 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDataBaseConstraintType()
	 * @generated
	 */
	int DATA_BASE_CONSTRAINT_TYPE = 91;

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Service <em>Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service</em>'.
	 * @see org.openxma.dsl.dom.model.Service
	 * @generated
	 */
	EClass getService();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.Service#getDependencies <em>Dependencies</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Dependencies</em>'.
	 * @see org.openxma.dsl.dom.model.Service#getDependencies()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Dependencies();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Service#getDelegateOperations <em>Delegate Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Delegate Operations</em>'.
	 * @see org.openxma.dsl.dom.model.Service#getDelegateOperations()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_DelegateOperations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Service#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see org.openxma.dsl.dom.model.Service#getOperations()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Operations();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ComplexType <em>Complex Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Complex Type</em>'.
	 * @see org.openxma.dsl.dom.model.ComplexType
	 * @generated
	 */
	EClass getComplexType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.ComplexType#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attributes</em>'.
	 * @see org.openxma.dsl.dom.model.ComplexType#getAttributes()
	 * @see #getComplexType()
	 * @generated
	 */
	EReference getComplexType_Attributes();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.ComplexType#getAllAttributes <em>All Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Attributes</em>'.
	 * @see org.openxma.dsl.dom.model.ComplexType#getAllAttributes()
	 * @see #getComplexType()
	 * @generated
	 */
	EReference getComplexType_AllAttributes();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Dependant <em>Dependant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dependant</em>'.
	 * @see org.openxma.dsl.dom.model.Dependant
	 * @generated
	 */
	EClass getDependant();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation</em>'.
	 * @see org.openxma.dsl.dom.model.Operation
	 * @generated
	 */
	EClass getOperation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Operation#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see org.openxma.dsl.dom.model.Operation#getParameters()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Parameters();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Operation#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.Operation#getExpression()
	 * @see #getOperation()
	 * @generated
	 */
	EAttribute getOperation_Expression();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Operation#getDelegate <em>Delegate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Delegate</em>'.
	 * @see org.openxma.dsl.dom.model.Operation#getDelegate()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Delegate();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DelegateOperation <em>Delegate Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Delegate Operation</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation
	 * @generated
	 */
	EClass getDelegateOperation();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DelegateOperation#getView <em>View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>View</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getView()
	 * @see #getDelegateOperation()
	 * @generated
	 */
	EReference getDelegateOperation_View();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DelegateOperation#isMany <em>Many</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Many</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#isMany()
	 * @see #getDelegateOperation()
	 * @generated
	 */
    EAttribute getDelegateOperation_Many();

    /**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DelegateOperation#getRepository <em>Repository</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Repository</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getRepository()
	 * @see #getDelegateOperation()
	 * @generated
	 */
	EReference getDelegateOperation_Repository();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DelegateOperation#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Operation</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getOperation()
	 * @see #getDelegateOperation()
	 * @generated
	 */
	EReference getDelegateOperation_Operation();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DelegateOperation#getCrudOperationType <em>Crud Operation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Crud Operation Type</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getCrudOperationType()
	 * @see #getDelegateOperation()
	 * @generated
	 */
	EAttribute getDelegateOperation_CrudOperationType();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DelegateOperation#getViewParameter <em>View Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>View Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getViewParameter()
	 * @see #getDelegateOperation()
	 * @generated
	 */
	EReference getDelegateOperation_ViewParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DelegateOperation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getName()
	 * @see #getDelegateOperation()
	 * @generated
	 */
    EAttribute getDelegateOperation_Name();

    /**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.DelegateOperation#getFilter <em>Filter</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Filter</em>'.
	 * @see org.openxma.dsl.dom.model.DelegateOperation#getFilter()
	 * @see #getDelegateOperation()
	 * @generated
	 */
    EReference getDelegateOperation_Filter();

    /**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DaoOperation <em>Dao Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dao Operation</em>'.
	 * @see org.openxma.dsl.dom.model.DaoOperation
	 * @generated
	 */
	EClass getDaoOperation();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DaoOperation#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.openxma.dsl.dom.model.DaoOperation#getType()
	 * @see #getDaoOperation()
	 * @generated
	 */
	EReference getDaoOperation_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DaoOperation#isMany <em>Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Many</em>'.
	 * @see org.openxma.dsl.dom.model.DaoOperation#isMany()
	 * @see #getDaoOperation()
	 * @generated
	 */
	EAttribute getDaoOperation_Many();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DaoOperation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.DaoOperation#getName()
	 * @see #getDaoOperation()
	 * @generated
	 */
	EAttribute getDaoOperation_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.Parameter
	 * @generated
	 */
	EClass getParameter();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Parameter#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.openxma.dsl.dom.model.Parameter#getType()
	 * @see #getParameter()
	 * @generated
	 */
	EReference getParameter_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Parameter#isMany <em>Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Many</em>'.
	 * @see org.openxma.dsl.dom.model.Parameter#isMany()
	 * @see #getParameter()
	 * @generated
	 */
	EAttribute getParameter_Many();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Parameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.Parameter#getName()
	 * @see #getParameter()
	 * @generated
	 */
	EAttribute getParameter_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ValueObject <em>Value Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value Object</em>'.
	 * @see org.openxma.dsl.dom.model.ValueObject
	 * @generated
	 */
	EClass getValueObject();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DataView <em>Data View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data View</em>'.
	 * @see org.openxma.dsl.dom.model.DataView
	 * @generated
	 */
	EClass getDataView();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DataView#getSuperType <em>Super Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Type</em>'.
	 * @see org.openxma.dsl.dom.model.DataView#getSuperType()
	 * @see #getDataView()
	 * @generated
	 */
	EReference getDataView_SuperType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.DataView#getFeatureReferences <em>Feature References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Feature References</em>'.
	 * @see org.openxma.dsl.dom.model.DataView#getFeatureReferences()
	 * @see #getDataView()
	 * @generated
	 */
	EReference getDataView_FeatureReferences();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.FeatureReference <em>Feature Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature Reference</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference
	 * @generated
	 */
	EClass getFeatureReference();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.FeatureReference#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference#getSource()
	 * @see #getFeatureReference()
	 * @generated
	 */
	EReference getFeatureReference_Source();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.FeatureReference#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference#getAttribute()
	 * @see #getFeatureReference()
	 * @generated
	 */
	EReference getFeatureReference_Attribute();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.FeatureReference#getView <em>View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>View</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference#getView()
	 * @see #getFeatureReference()
	 * @generated
	 */
	EReference getFeatureReference_View();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.FeatureReference#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference#getProperties()
	 * @see #getFeatureReference()
	 * @generated
	 */
	EReference getFeatureReference_Properties();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.FeatureReference#isAll <em>All</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>All</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference#isAll()
	 * @see #getFeatureReference()
	 * @generated
	 */
	EAttribute getFeatureReference_All();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.FeatureReference#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see org.openxma.dsl.dom.model.FeatureReference#getTarget()
	 * @see #getFeatureReference()
	 * @generated
	 */
	EReference getFeatureReference_Target();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Mapper <em>Mapper</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mapper</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper
	 * @generated
	 */
    EClass getMapper();

    /**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Mapper#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Left</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper#getLeft()
	 * @see #getMapper()
	 * @generated
	 */
    EReference getMapper_Left();

    /**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Mapper#isBiDirectional <em>Bi Directional</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bi Directional</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper#isBiDirectional()
	 * @see #getMapper()
	 * @generated
	 */
    EAttribute getMapper_BiDirectional();

    /**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Mapper#isToLeft <em>To Left</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>To Left</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper#isToLeft()
	 * @see #getMapper()
	 * @generated
	 */
    EAttribute getMapper_ToLeft();

    /**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Mapper#isToRight <em>To Right</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>To Right</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper#isToRight()
	 * @see #getMapper()
	 * @generated
	 */
    EAttribute getMapper_ToRight();

    /**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Mapper#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Right</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper#getRight()
	 * @see #getMapper()
	 * @generated
	 */
    EReference getMapper_Right();

    /**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Mapper#getPropertyMappings <em>Property Mappings</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Property Mappings</em>'.
	 * @see org.openxma.dsl.dom.model.Mapper#getPropertyMappings()
	 * @see #getMapper()
	 * @generated
	 */
    EReference getMapper_PropertyMappings();

    /**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.PropertyMapping <em>Property Mapping</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property Mapping</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyMapping
	 * @generated
	 */
    EClass getPropertyMapping();

    /**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.PropertyMapping#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Left</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyMapping#getLeft()
	 * @see #getPropertyMapping()
	 * @generated
	 */
    EReference getPropertyMapping_Left();

    /**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.PropertyMapping#isBiDirectional <em>Bi Directional</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bi Directional</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyMapping#isBiDirectional()
	 * @see #getPropertyMapping()
	 * @generated
	 */
    EAttribute getPropertyMapping_BiDirectional();

    /**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.PropertyMapping#isToLeft <em>To Left</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>To Left</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyMapping#isToLeft()
	 * @see #getPropertyMapping()
	 * @generated
	 */
    EAttribute getPropertyMapping_ToLeft();

    /**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.PropertyMapping#isToRight <em>To Right</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>To Right</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyMapping#isToRight()
	 * @see #getPropertyMapping()
	 * @generated
	 */
    EAttribute getPropertyMapping_ToRight();

    /**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.PropertyMapping#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Right</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyMapping#getRight()
	 * @see #getPropertyMapping()
	 * @generated
	 */
    EReference getPropertyMapping_Right();

    /**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.IElementWithNoName <em>IElement With No Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IElement With No Name</em>'.
	 * @see org.openxma.dsl.dom.model.IElementWithNoName
	 * @generated
	 */
	EClass getIElementWithNoName();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.IElementWithNoName#getNoName <em>No Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>No Name</em>'.
	 * @see org.openxma.dsl.dom.model.IElementWithNoName#getNoName()
	 * @see #getIElementWithNoName()
	 * @generated
	 */
	EAttribute getIElementWithNoName_NoName();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Entity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.Entity
	 * @generated
	 */
	EClass getEntity();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Entity#getSuperType <em>Super Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Type</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getSuperType()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_SuperType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Entity#getAttributeGroups <em>Attribute Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attribute Groups</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getAttributeGroups()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_AttributeGroups();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.Entity#getConditionsBlock <em>Conditions Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Conditions Block</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getConditionsBlock()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_ConditionsBlock();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Entity#getRepository <em>Repository</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Repository</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getRepository()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Repository();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Entity#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getKey()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Key();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.Entity#getSortOrders <em>Sort Orders</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Sort Orders</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getSortOrders()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_SortOrders();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Entity#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Identifier</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getIdentifier()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Identifier();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Entity#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Version</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getVersion()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Version();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.Entity#getRequiredReferences <em>Required References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Required References</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getRequiredReferences()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_RequiredReferences();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.Entity#getRequiredAttributes <em>Required Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Required Attributes</em>'.
	 * @see org.openxma.dsl.dom.model.Entity#getRequiredAttributes()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_RequiredAttributes();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.QlStatement <em>Ql Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ql Statement</em>'.
	 * @see org.openxma.dsl.dom.model.QlStatement
	 * @generated
	 */
	EClass getQlStatement();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.CallableStatement <em>Callable Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Callable Statement</em>'.
	 * @see org.openxma.dsl.dom.model.CallableStatement
	 * @generated
	 */
	EClass getCallableStatement();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CallableStatement#isFunctionCall <em>Function Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function Call</em>'.
	 * @see org.openxma.dsl.dom.model.CallableStatement#isFunctionCall()
	 * @see #getCallableStatement()
	 * @generated
	 */
	EAttribute getCallableStatement_FunctionCall();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CallableStatement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.CallableStatement#getName()
	 * @see #getCallableStatement()
	 * @generated
	 */
	EAttribute getCallableStatement_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.CallableStatement#getInParameter <em>In Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>In Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.CallableStatement#getInParameter()
	 * @see #getCallableStatement()
	 * @generated
	 */
	EReference getCallableStatement_InParameter();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.CallableStatement#getOutParameter <em>Out Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Out Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.CallableStatement#getOutParameter()
	 * @see #getCallableStatement()
	 * @generated
	 */
	EReference getCallableStatement_OutParameter();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.CallInputParameter <em>Call Input Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Call Input Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.CallInputParameter
	 * @generated
	 */
	EClass getCallInputParameter();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.CallInputParameter#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.CallInputParameter#getParameter()
	 * @see #getCallInputParameter()
	 * @generated
	 */
	EReference getCallInputParameter_Parameter();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.CallInputParameter#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.CallInputParameter#getAttribute()
	 * @see #getCallInputParameter()
	 * @generated
	 */
	EReference getCallInputParameter_Attribute();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CallInputParameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.CallInputParameter#getName()
	 * @see #getCallInputParameter()
	 * @generated
	 */
	EAttribute getCallInputParameter_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.CallOutputParameter <em>Call Output Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Call Output Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.CallOutputParameter
	 * @generated
	 */
	EClass getCallOutputParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CallOutputParameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.CallOutputParameter#getName()
	 * @see #getCallOutputParameter()
	 * @generated
	 */
	EAttribute getCallOutputParameter_Name();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.CallOutputParameter#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.CallOutputParameter#getAttribute()
	 * @see #getCallOutputParameter()
	 * @generated
	 */
	EReference getCallOutputParameter_Attribute();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.CallOutputParameter#getNestedAttribute <em>Nested Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Nested Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.CallOutputParameter#getNestedAttribute()
	 * @see #getCallOutputParameter()
	 * @generated
	 */
	EReference getCallOutputParameter_NestedAttribute();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.InsertStatement <em>Insert Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Insert Statement</em>'.
	 * @see org.openxma.dsl.dom.model.InsertStatement
	 * @generated
	 */
	EClass getInsertStatement();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.InsertStatement#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.InsertStatement#getEntity()
	 * @see #getInsertStatement()
	 * @generated
	 */
	EReference getInsertStatement_Entity();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.InsertStatement#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.InsertStatement#getExpression()
	 * @see #getInsertStatement()
	 * @generated
	 */
	EReference getInsertStatement_Expression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.InsertStatement#getSelectStatement <em>Select Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Select Statement</em>'.
	 * @see org.openxma.dsl.dom.model.InsertStatement#getSelectStatement()
	 * @see #getInsertStatement()
	 * @generated
	 */
	EReference getInsertStatement_SelectStatement();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DeleteStatement <em>Delete Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Delete Statement</em>'.
	 * @see org.openxma.dsl.dom.model.DeleteStatement
	 * @generated
	 */
	EClass getDeleteStatement();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DeleteStatement#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.DeleteStatement#getEntity()
	 * @see #getDeleteStatement()
	 * @generated
	 */
	EReference getDeleteStatement_Entity();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DeleteStatement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.DeleteStatement#getName()
	 * @see #getDeleteStatement()
	 * @generated
	 */
	EAttribute getDeleteStatement_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.DeleteStatement#getWhere <em>Where</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Where</em>'.
	 * @see org.openxma.dsl.dom.model.DeleteStatement#getWhere()
	 * @see #getDeleteStatement()
	 * @generated
	 */
	EReference getDeleteStatement_Where();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.UpdateStatement <em>Update Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Update Statement</em>'.
	 * @see org.openxma.dsl.dom.model.UpdateStatement
	 * @generated
	 */
	EClass getUpdateStatement();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.UpdateStatement#isVersioned <em>Versioned</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Versioned</em>'.
	 * @see org.openxma.dsl.dom.model.UpdateStatement#isVersioned()
	 * @see #getUpdateStatement()
	 * @generated
	 */
	EAttribute getUpdateStatement_Versioned();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.UpdateStatement#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.UpdateStatement#getEntity()
	 * @see #getUpdateStatement()
	 * @generated
	 */
	EReference getUpdateStatement_Entity();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.UpdateStatement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.UpdateStatement#getName()
	 * @see #getUpdateStatement()
	 * @generated
	 */
	EAttribute getUpdateStatement_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.UpdateStatement#getAssignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Assignment</em>'.
	 * @see org.openxma.dsl.dom.model.UpdateStatement#getAssignment()
	 * @see #getUpdateStatement()
	 * @generated
	 */
	EReference getUpdateStatement_Assignment();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.UpdateStatement#getWhere <em>Where</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Where</em>'.
	 * @see org.openxma.dsl.dom.model.UpdateStatement#getWhere()
	 * @see #getUpdateStatement()
	 * @generated
	 */
	EReference getUpdateStatement_Where();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.PropertyAssignment <em>Property Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property Assignment</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyAssignment
	 * @generated
	 */
	EClass getPropertyAssignment();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.PropertyAssignment#getProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Property</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyAssignment#getProperty()
	 * @see #getPropertyAssignment()
	 * @generated
	 */
	EReference getPropertyAssignment_Property();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.PropertyAssignment#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyAssignment#getExpression()
	 * @see #getPropertyAssignment()
	 * @generated
	 */
	EReference getPropertyAssignment_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.SelectStatement <em>Select Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Select Statement</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement
	 * @generated
	 */
	EClass getSelectStatement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SelectStatement#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>From</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement#getFrom()
	 * @see #getSelectStatement()
	 * @generated
	 */
	EReference getSelectStatement_From();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SelectStatement#getJoin <em>Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Join</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement#getJoin()
	 * @see #getSelectStatement()
	 * @generated
	 */
	EReference getSelectStatement_Join();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.SelectStatement#getWhere <em>Where</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Where</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement#getWhere()
	 * @see #getSelectStatement()
	 * @generated
	 */
	EReference getSelectStatement_Where();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SelectStatement#getGroupBy <em>Group By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Group By</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement#getGroupBy()
	 * @see #getSelectStatement()
	 * @generated
	 */
	EReference getSelectStatement_GroupBy();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.SelectStatement#getHaving <em>Having</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Having</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement#getHaving()
	 * @see #getSelectStatement()
	 * @generated
	 */
	EReference getSelectStatement_Having();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SelectStatement#getOrderBy <em>Order By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Order By</em>'.
	 * @see org.openxma.dsl.dom.model.SelectStatement#getOrderBy()
	 * @see #getSelectStatement()
	 * @generated
	 */
	EReference getSelectStatement_OrderBy();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.SortOrderElement <em>Sort Order Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sort Order Element</em>'.
	 * @see org.openxma.dsl.dom.model.SortOrderElement
	 * @generated
	 */
	EClass getSortOrderElement();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.SortOrderElement#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.SortOrderElement#getExpression()
	 * @see #getSortOrderElement()
	 * @generated
	 */
	EReference getSortOrderElement_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.SortOrderElement#getSortOrder <em>Sort Order</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sort Order</em>'.
	 * @see org.openxma.dsl.dom.model.SortOrderElement#getSortOrder()
	 * @see #getSortOrderElement()
	 * @generated
	 */
	EAttribute getSortOrderElement_SortOrder();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.SelectProperties <em>Select Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Select Properties</em>'.
	 * @see org.openxma.dsl.dom.model.SelectProperties
	 * @generated
	 */
	EClass getSelectProperties();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.SelectProperties#isDistinct <em>Distinct</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distinct</em>'.
	 * @see org.openxma.dsl.dom.model.SelectProperties#isDistinct()
	 * @see #getSelectProperties()
	 * @generated
	 */
	EAttribute getSelectProperties_Distinct();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SelectProperties#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.openxma.dsl.dom.model.SelectProperties#getProperties()
	 * @see #getSelectProperties()
	 * @generated
	 */
	EReference getSelectProperties_Properties();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.SelectClass <em>Select Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Select Class</em>'.
	 * @see org.openxma.dsl.dom.model.SelectClass
	 * @generated
	 */
	EClass getSelectClass();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.SelectClass#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class</em>'.
	 * @see org.openxma.dsl.dom.model.SelectClass#getClass_()
	 * @see #getSelectClass()
	 * @generated
	 */
	EAttribute getSelectClass_Class();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SelectClass#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see org.openxma.dsl.dom.model.SelectClass#getArguments()
	 * @see #getSelectClass()
	 * @generated
	 */
	EReference getSelectClass_Arguments();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.SelectObject <em>Select Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Select Object</em>'.
	 * @see org.openxma.dsl.dom.model.SelectObject
	 * @generated
	 */
	EClass getSelectObject();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.SelectObject#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.SelectObject#getName()
	 * @see #getSelectObject()
	 * @generated
	 */
	EAttribute getSelectObject_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.FromRange <em>From Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>From Range</em>'.
	 * @see org.openxma.dsl.dom.model.FromRange
	 * @generated
	 */
	EClass getFromRange();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.FromClass <em>From Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>From Class</em>'.
	 * @see org.openxma.dsl.dom.model.FromClass
	 * @generated
	 */
	EClass getFromClass();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.FromClass#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.FromClass#getEntity()
	 * @see #getFromClass()
	 * @generated
	 */
	EReference getFromClass_Entity();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.FromClass#isPopertyFetch <em>Poperty Fetch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Poperty Fetch</em>'.
	 * @see org.openxma.dsl.dom.model.FromClass#isPopertyFetch()
	 * @see #getFromClass()
	 * @generated
	 */
	EAttribute getFromClass_PopertyFetch();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.InClass <em>In Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>In Class</em>'.
	 * @see org.openxma.dsl.dom.model.InClass
	 * @generated
	 */
	EClass getInClass();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InClass#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.InClass#getName()
	 * @see #getInClass()
	 * @generated
	 */
	EAttribute getInClass_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InClass#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class</em>'.
	 * @see org.openxma.dsl.dom.model.InClass#getClass_()
	 * @see #getInClass()
	 * @generated
	 */
	EAttribute getInClass_Class();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.InCollection <em>In Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>In Collection</em>'.
	 * @see org.openxma.dsl.dom.model.InCollection
	 * @generated
	 */
	EClass getInCollection();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InCollection#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Path</em>'.
	 * @see org.openxma.dsl.dom.model.InCollection#getPath()
	 * @see #getInCollection()
	 * @generated
	 */
	EAttribute getInCollection_Path();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InCollection#getAlias <em>Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alias</em>'.
	 * @see org.openxma.dsl.dom.model.InCollection#getAlias()
	 * @see #getInCollection()
	 * @generated
	 */
	EAttribute getInCollection_Alias();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.InCollectionElements <em>In Collection Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>In Collection Elements</em>'.
	 * @see org.openxma.dsl.dom.model.InCollectionElements
	 * @generated
	 */
	EClass getInCollectionElements();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InCollectionElements#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.InCollectionElements#getName()
	 * @see #getInCollectionElements()
	 * @generated
	 */
	EAttribute getInCollectionElements_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InCollectionElements#getReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference</em>'.
	 * @see org.openxma.dsl.dom.model.InCollectionElements#getReference()
	 * @see #getInCollectionElements()
	 * @generated
	 */
	EAttribute getInCollectionElements_Reference();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Join <em>Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Join</em>'.
	 * @see org.openxma.dsl.dom.model.Join
	 * @generated
	 */
	EClass getJoin();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Join#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.openxma.dsl.dom.model.Join#getType()
	 * @see #getJoin()
	 * @generated
	 */
	EAttribute getJoin_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Join#isFetch <em>Fetch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fetch</em>'.
	 * @see org.openxma.dsl.dom.model.Join#isFetch()
	 * @see #getJoin()
	 * @generated
	 */
	EAttribute getJoin_Fetch();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Join#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.Join#getEntity()
	 * @see #getJoin()
	 * @generated
	 */
	EReference getJoin_Entity();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Join#getReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reference</em>'.
	 * @see org.openxma.dsl.dom.model.Join#getReference()
	 * @see #getJoin()
	 * @generated
	 */
	EReference getJoin_Reference();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Join#isPropertyFetch <em>Property Fetch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Property Fetch</em>'.
	 * @see org.openxma.dsl.dom.model.Join#isPropertyFetch()
	 * @see #getJoin()
	 * @generated
	 */
	EAttribute getJoin_PropertyFetch();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.Join#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.Join#getExpression()
	 * @see #getJoin()
	 * @generated
	 */
	EReference getJoin_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.JoinEntity <em>Join Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Join Entity</em>'.
	 * @see org.openxma.dsl.dom.model.JoinEntity
	 * @generated
	 */
	EClass getJoinEntity();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.JoinEntity#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.JoinEntity#getName()
	 * @see #getJoinEntity()
	 * @generated
	 */
	EAttribute getJoinEntity_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.Expression
	 * @generated
	 */
	EClass getExpression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.PropertyValue <em>Property Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property Value</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyValue
	 * @generated
	 */
	EClass getPropertyValue();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.PropertyValue#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyValue#getName()
	 * @see #getPropertyValue()
	 * @generated
	 */
	EAttribute getPropertyValue_Name();

	/**
	 * Returns the meta object for the attribute list '{@link org.openxma.dsl.dom.model.PropertyValue#getSegments <em>Segments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Segments</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyValue#getSegments()
	 * @see #getPropertyValue()
	 * @generated
	 */
	EAttribute getPropertyValue_Segments();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.PropertyValue#getIndex <em>Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Index</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyValue#getIndex()
	 * @see #getPropertyValue()
	 * @generated
	 */
	EReference getPropertyValue_Index();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.PropertyValue#isClassProperty <em>Class Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class Property</em>'.
	 * @see org.openxma.dsl.dom.model.PropertyValue#isClassProperty()
	 * @see #getPropertyValue()
	 * @generated
	 */
	EAttribute getPropertyValue_ClassProperty();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.FunctionCall <em>Function Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Call</em>'.
	 * @see org.openxma.dsl.dom.model.FunctionCall
	 * @generated
	 */
	EClass getFunctionCall();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.FunctionCall#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function</em>'.
	 * @see org.openxma.dsl.dom.model.FunctionCall#getFunction()
	 * @see #getFunctionCall()
	 * @generated
	 */
	EAttribute getFunctionCall_Function();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.FunctionCall#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see org.openxma.dsl.dom.model.FunctionCall#getArguments()
	 * @see #getFunctionCall()
	 * @generated
	 */
	EReference getFunctionCall_Arguments();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.TrimFunction <em>Trim Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Trim Function</em>'.
	 * @see org.openxma.dsl.dom.model.TrimFunction
	 * @generated
	 */
	EClass getTrimFunction();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.TrimFunction#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function</em>'.
	 * @see org.openxma.dsl.dom.model.TrimFunction#getFunction()
	 * @see #getTrimFunction()
	 * @generated
	 */
	EAttribute getTrimFunction_Function();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.TrimFunction#getMode <em>Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mode</em>'.
	 * @see org.openxma.dsl.dom.model.TrimFunction#getMode()
	 * @see #getTrimFunction()
	 * @generated
	 */
	EAttribute getTrimFunction_Mode();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.TrimFunction#getCharacter <em>Character</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Character</em>'.
	 * @see org.openxma.dsl.dom.model.TrimFunction#getCharacter()
	 * @see #getTrimFunction()
	 * @generated
	 */
	EReference getTrimFunction_Character();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.TrimFunction#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>From</em>'.
	 * @see org.openxma.dsl.dom.model.TrimFunction#getFrom()
	 * @see #getTrimFunction()
	 * @generated
	 */
	EReference getTrimFunction_From();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.CastFunction <em>Cast Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cast Function</em>'.
	 * @see org.openxma.dsl.dom.model.CastFunction
	 * @generated
	 */
	EClass getCastFunction();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CastFunction#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function</em>'.
	 * @see org.openxma.dsl.dom.model.CastFunction#getFunction()
	 * @see #getCastFunction()
	 * @generated
	 */
	EAttribute getCastFunction_Function();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.CastFunction#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>From</em>'.
	 * @see org.openxma.dsl.dom.model.CastFunction#getFrom()
	 * @see #getCastFunction()
	 * @generated
	 */
	EReference getCastFunction_From();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CastFunction#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.CastFunction#getName()
	 * @see #getCastFunction()
	 * @generated
	 */
	EAttribute getCastFunction_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AggregateFunction <em>Aggregate Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Aggregate Function</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction
	 * @generated
	 */
	EClass getAggregateFunction();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AggregateFunction#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction#getFunction()
	 * @see #getAggregateFunction()
	 * @generated
	 */
	EAttribute getAggregateFunction_Function();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.AggregateFunction#getAggregateExpression <em>Aggregate Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Aggregate Expression</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction#getAggregateExpression()
	 * @see #getAggregateFunction()
	 * @generated
	 */
	EReference getAggregateFunction_AggregateExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AggregateFunction#isAll <em>All</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>All</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction#isAll()
	 * @see #getAggregateFunction()
	 * @generated
	 */
	EAttribute getAggregateFunction_All();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AggregateFunction#isDistinct <em>Distinct</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distinct</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction#isDistinct()
	 * @see #getAggregateFunction()
	 * @generated
	 */
	EAttribute getAggregateFunction_Distinct();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AggregateFunction#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>From</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction#getFrom()
	 * @see #getAggregateFunction()
	 * @generated
	 */
	EAttribute getAggregateFunction_From();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.AggregateFunction#getCollection <em>Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Collection</em>'.
	 * @see org.openxma.dsl.dom.model.AggregateFunction#getCollection()
	 * @see #getAggregateFunction()
	 * @generated
	 */
	EReference getAggregateFunction_Collection();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.QueryParameterReference <em>Query Parameter Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Parameter Reference</em>'.
	 * @see org.openxma.dsl.dom.model.QueryParameterReference
	 * @generated
	 */
	EClass getQueryParameterReference();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.QueryParameterValue <em>Query Parameter Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Parameter Value</em>'.
	 * @see org.openxma.dsl.dom.model.QueryParameterValue
	 * @generated
	 */
	EClass getQueryParameterValue();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.QueryParameterValue#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.QueryParameterValue#getParameter()
	 * @see #getQueryParameterValue()
	 * @generated
	 */
	EReference getQueryParameterValue_Parameter();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.QueryParameterValue#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.QueryParameterValue#getAttribute()
	 * @see #getQueryParameterValue()
	 * @generated
	 */
	EReference getQueryParameterValue_Attribute();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.QuantifiedExpression <em>Quantified Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Quantified Expression</em>'.
	 * @see org.openxma.dsl.dom.model.QuantifiedExpression
	 * @generated
	 */
	EClass getQuantifiedExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.QuantifiedExpression#getQuantifier <em>Quantifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Quantifier</em>'.
	 * @see org.openxma.dsl.dom.model.QuantifiedExpression#getQuantifier()
	 * @see #getQuantifiedExpression()
	 * @generated
	 */
	EAttribute getQuantifiedExpression_Quantifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.QuantifiedExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.QuantifiedExpression#getExpression()
	 * @see #getQuantifiedExpression()
	 * @generated
	 */
	EReference getQuantifiedExpression_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.QuantifiedExpression#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.QuantifiedExpression#getName()
	 * @see #getQuantifiedExpression()
	 * @generated
	 */
	EAttribute getQuantifiedExpression_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.CaseExpression <em>Case Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Case Expression</em>'.
	 * @see org.openxma.dsl.dom.model.CaseExpression
	 * @generated
	 */
	EClass getCaseExpression();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.CaseExpression#getWhenClause <em>When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>When Clause</em>'.
	 * @see org.openxma.dsl.dom.model.CaseExpression#getWhenClause()
	 * @see #getCaseExpression()
	 * @generated
	 */
	EReference getCaseExpression_WhenClause();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.CaseExpression#getElseExpression <em>Else Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Else Expression</em>'.
	 * @see org.openxma.dsl.dom.model.CaseExpression#getElseExpression()
	 * @see #getCaseExpression()
	 * @generated
	 */
	EReference getCaseExpression_ElseExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.CaseExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.CaseExpression#getExpression()
	 * @see #getCaseExpression()
	 * @generated
	 */
	EReference getCaseExpression_Expression();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.CaseExpression#getAltWhenClause <em>Alt When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Alt When Clause</em>'.
	 * @see org.openxma.dsl.dom.model.CaseExpression#getAltWhenClause()
	 * @see #getCaseExpression()
	 * @generated
	 */
	EReference getCaseExpression_AltWhenClause();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.WhenClause <em>When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>When Clause</em>'.
	 * @see org.openxma.dsl.dom.model.WhenClause
	 * @generated
	 */
	EClass getWhenClause();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.WhenClause#getWhenExpression <em>When Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>When Expression</em>'.
	 * @see org.openxma.dsl.dom.model.WhenClause#getWhenExpression()
	 * @see #getWhenClause()
	 * @generated
	 */
	EReference getWhenClause_WhenExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.WhenClause#getThenExpression <em>Then Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Then Expression</em>'.
	 * @see org.openxma.dsl.dom.model.WhenClause#getThenExpression()
	 * @see #getWhenClause()
	 * @generated
	 */
	EReference getWhenClause_ThenExpression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AltWhenClause <em>Alt When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Alt When Clause</em>'.
	 * @see org.openxma.dsl.dom.model.AltWhenClause
	 * @generated
	 */
	EClass getAltWhenClause();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.AltWhenClause#getWhenExpression <em>When Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>When Expression</em>'.
	 * @see org.openxma.dsl.dom.model.AltWhenClause#getWhenExpression()
	 * @see #getAltWhenClause()
	 * @generated
	 */
	EReference getAltWhenClause_WhenExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.AltWhenClause#getThenExpression <em>Then Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Then Expression</em>'.
	 * @see org.openxma.dsl.dom.model.AltWhenClause#getThenExpression()
	 * @see #getAltWhenClause()
	 * @generated
	 */
	EReference getAltWhenClause_ThenExpression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.CollectionFunction <em>Collection Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Function</em>'.
	 * @see org.openxma.dsl.dom.model.CollectionFunction
	 * @generated
	 */
	EClass getCollectionFunction();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.CollectionFunction#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function</em>'.
	 * @see org.openxma.dsl.dom.model.CollectionFunction#getFunction()
	 * @see #getCollectionFunction()
	 * @generated
	 */
	EAttribute getCollectionFunction_Function();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.CollectionFunction#getProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Property</em>'.
	 * @see org.openxma.dsl.dom.model.CollectionFunction#getProperty()
	 * @see #getCollectionFunction()
	 * @generated
	 */
	EReference getCollectionFunction_Property();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.SubQuery <em>Sub Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sub Query</em>'.
	 * @see org.openxma.dsl.dom.model.SubQuery
	 * @generated
	 */
	EClass getSubQuery();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.SubQuery#getQueries <em>Queries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Queries</em>'.
	 * @see org.openxma.dsl.dom.model.SubQuery#getQueries()
	 * @see #getSubQuery()
	 * @generated
	 */
	EReference getSubQuery_Queries();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ParenthesizedExpression <em>Parenthesized Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parenthesized Expression</em>'.
	 * @see org.openxma.dsl.dom.model.ParenthesizedExpression
	 * @generated
	 */
	EClass getParenthesizedExpression();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.ParenthesizedExpression#getExpressions <em>Expressions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expressions</em>'.
	 * @see org.openxma.dsl.dom.model.ParenthesizedExpression#getExpressions()
	 * @see #getParenthesizedExpression()
	 * @generated
	 */
	EReference getParenthesizedExpression_Expressions();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.LiteralValue <em>Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.LiteralValue
	 * @generated
	 */
	EClass getLiteralValue();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.StringLiteralValue <em>String Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.StringLiteralValue
	 * @generated
	 */
	EClass getStringLiteralValue();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.StringLiteralValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.openxma.dsl.dom.model.StringLiteralValue#getValue()
	 * @see #getStringLiteralValue()
	 * @generated
	 */
	EAttribute getStringLiteralValue_Value();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.IntegerLiteralValue <em>Integer Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.IntegerLiteralValue
	 * @generated
	 */
	EClass getIntegerLiteralValue();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.IntegerLiteralValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.openxma.dsl.dom.model.IntegerLiteralValue#getValue()
	 * @see #getIntegerLiteralValue()
	 * @generated
	 */
	EAttribute getIntegerLiteralValue_Value();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.RealLiteralValue <em>Real Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Real Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.RealLiteralValue
	 * @generated
	 */
	EClass getRealLiteralValue();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.RealLiteralValue#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.openxma.dsl.dom.model.RealLiteralValue#getValue()
	 * @see #getRealLiteralValue()
	 * @generated
	 */
	EAttribute getRealLiteralValue_Value();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.BooleanLiteralValue <em>Boolean Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.BooleanLiteralValue
	 * @generated
	 */
	EClass getBooleanLiteralValue();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.BooleanLiteralValue#isIsTrue <em>Is True</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is True</em>'.
	 * @see org.openxma.dsl.dom.model.BooleanLiteralValue#isIsTrue()
	 * @see #getBooleanLiteralValue()
	 * @generated
	 */
    EAttribute getBooleanLiteralValue_IsTrue();

    /**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.NullLiteralValue <em>Null Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.NullLiteralValue
	 * @generated
	 */
	EClass getNullLiteralValue();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.EmptyLiteralValue <em>Empty Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Empty Literal Value</em>'.
	 * @see org.openxma.dsl.dom.model.EmptyLiteralValue
	 * @generated
	 */
	EClass getEmptyLiteralValue();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DaoFeature <em>Dao Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dao Feature</em>'.
	 * @see org.openxma.dsl.dom.model.DaoFeature
	 * @generated
	 */
	EClass getDaoFeature();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.DaoFeature#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.DaoFeature#getAttribute()
	 * @see #getDaoFeature()
	 * @generated
	 */
	EReference getDaoFeature_Attribute();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Dao <em>Dao</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dao</em>'.
	 * @see org.openxma.dsl.dom.model.Dao
	 * @generated
	 */
	EClass getDao();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Dao#getEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getEntity()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_Entity();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Dao#getTableName <em>Table Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Table Name</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getTableName()
	 * @see #getDao()
	 * @generated
	 */
	EAttribute getDao_TableName();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Dao#getDiscriminator <em>Discriminator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Discriminator</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getDiscriminator()
	 * @see #getDao()
	 * @generated
	 */
	EAttribute getDao_Discriminator();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Dao#getQualifier <em>Qualifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qualifier</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getQualifier()
	 * @see #getDao()
	 * @generated
	 */
	EAttribute getDao_Qualifier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getDataBaseConstraints <em>Data Base Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data Base Constraints</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getDataBaseConstraints()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_DataBaseConstraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getOperations()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_Operations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getQueryOperation <em>Query Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Query Operation</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getQueryOperation()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_QueryOperation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getColumns <em>Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Columns</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getColumns()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_Columns();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getManyToOneAssociations <em>Many To One Associations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Many To One Associations</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getManyToOneAssociations()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_ManyToOneAssociations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getOneToOneAssociations <em>One To One Associations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>One To One Associations</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getOneToOneAssociations()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_OneToOneAssociations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getOneToManyAssociations <em>One To Many Associations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>One To Many Associations</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getOneToManyAssociations()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_OneToManyAssociations();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Dao#getManyToManyAssociations <em>Many To Many Associations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Many To Many Associations</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getManyToManyAssociations()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_ManyToManyAssociations();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Dao#getPrimaryKeyColumn <em>Primary Key Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Primary Key Column</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getPrimaryKeyColumn()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_PrimaryKeyColumn();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.Dao#getNaturalKeyColumns <em>Natural Key Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Natural Key Columns</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getNaturalKeyColumns()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_NaturalKeyColumns();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Dao#getVersionColumn <em>Version Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Version Column</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getVersionColumn()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_VersionColumn();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Dao#getPrimaryKey <em>Primary Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Primary Key</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getPrimaryKey()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_PrimaryKey();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Dao#getNaturalKey <em>Natural Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Natural Key</em>'.
	 * @see org.openxma.dsl.dom.model.Dao#getNaturalKey()
	 * @see #getDao()
	 * @generated
	 */
	EReference getDao_NaturalKey();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.QueryOperation <em>Query Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Operation</em>'.
	 * @see org.openxma.dsl.dom.model.QueryOperation
	 * @generated
	 */
	EClass getQueryOperation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.QueryOperation#getQueryParameters <em>Query Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Query Parameters</em>'.
	 * @see org.openxma.dsl.dom.model.QueryOperation#getQueryParameters()
	 * @see #getQueryOperation()
	 * @generated
	 */
	EReference getQueryOperation_QueryParameters();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.QueryOperation#getStatement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Statement</em>'.
	 * @see org.openxma.dsl.dom.model.QueryOperation#getStatement()
	 * @see #getQueryOperation()
	 * @generated
	 */
	EReference getQueryOperation_Statement();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.QueryParameter <em>Query Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Parameter</em>'.
	 * @see org.openxma.dsl.dom.model.QueryParameter
	 * @generated
	 */
	EClass getQueryParameter();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.QueryParameter#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.QueryParameter#getAttribute()
	 * @see #getQueryParameter()
	 * @generated
	 */
	EReference getQueryParameter_Attribute();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Column <em>Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Column</em>'.
	 * @see org.openxma.dsl.dom.model.Column
	 * @generated
	 */
	EClass getColumn();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Column#getColumnName <em>Column Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Column Name</em>'.
	 * @see org.openxma.dsl.dom.model.Column#getColumnName()
	 * @see #getColumn()
	 * @generated
	 */
	EAttribute getColumn_ColumnName();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.Column#getUserType <em>User Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>User Type</em>'.
	 * @see org.openxma.dsl.dom.model.Column#getUserType()
	 * @see #getColumn()
	 * @generated
	 */
	EReference getColumn_UserType();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Column#getColumnType <em>Column Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Column Type</em>'.
	 * @see org.openxma.dsl.dom.model.Column#getColumnType()
	 * @see #getColumn()
	 * @generated
	 */
	EReference getColumn_ColumnType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Column#getColumns <em>Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Columns</em>'.
	 * @see org.openxma.dsl.dom.model.Column#getColumns()
	 * @see #getColumn()
	 * @generated
	 */
	EReference getColumn_Columns();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ManyToOne <em>Many To One</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Many To One</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToOne
	 * @generated
	 */
	EClass getManyToOne();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.ManyToOne#getColumnName <em>Column Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Column Name</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToOne#getColumnName()
	 * @see #getManyToOne()
	 * @generated
	 */
	EAttribute getManyToOne_ColumnName();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.ManyToOne#getUserType <em>User Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>User Type</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToOne#getUserType()
	 * @see #getManyToOne()
	 * @generated
	 */
	EReference getManyToOne_UserType();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.ManyToOne#getSqlType <em>Sql Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Sql Type</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToOne#getSqlType()
	 * @see #getManyToOne()
	 * @generated
	 */
	EReference getManyToOne_SqlType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.ManyToOne#getColumns <em>Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Columns</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToOne#getColumns()
	 * @see #getManyToOne()
	 * @generated
	 */
	EReference getManyToOne_Columns();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.ManyToOne#isDerived <em>Derived</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Derived</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToOne#isDerived()
	 * @see #getManyToOne()
	 * @generated
	 */
	EAttribute getManyToOne_Derived();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.OneToOne <em>One To One</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>One To One</em>'.
	 * @see org.openxma.dsl.dom.model.OneToOne
	 * @generated
	 */
	EClass getOneToOne();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.OneToMany <em>One To Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>One To Many</em>'.
	 * @see org.openxma.dsl.dom.model.OneToMany
	 * @generated
	 */
	EClass getOneToMany();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.OneToMany#getColumnName <em>Column Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Column Name</em>'.
	 * @see org.openxma.dsl.dom.model.OneToMany#getColumnName()
	 * @see #getOneToMany()
	 * @generated
	 */
	EAttribute getOneToMany_ColumnName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.OneToMany#getColumns <em>Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Columns</em>'.
	 * @see org.openxma.dsl.dom.model.OneToMany#getColumns()
	 * @see #getOneToMany()
	 * @generated
	 */
	EReference getOneToMany_Columns();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ManyToMany <em>Many To Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Many To Many</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToMany
	 * @generated
	 */
	EClass getManyToMany();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.ManyToMany#getTableName <em>Table Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Table Name</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToMany#getTableName()
	 * @see #getManyToMany()
	 * @generated
	 */
	EAttribute getManyToMany_TableName();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.ManyToMany#getColumnName <em>Column Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Column Name</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToMany#getColumnName()
	 * @see #getManyToMany()
	 * @generated
	 */
	EAttribute getManyToMany_ColumnName();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.ManyToMany#isInverse <em>Inverse</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inverse</em>'.
	 * @see org.openxma.dsl.dom.model.ManyToMany#isInverse()
	 * @see #getManyToMany()
	 * @generated
	 */
	EAttribute getManyToMany_Inverse();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.PresentableFeature <em>Presentable Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Presentable Feature</em>'.
	 * @see org.openxma.dsl.dom.model.PresentableFeature
	 * @generated
	 */
	EClass getPresentableFeature();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.PresentableFeature#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.PresentableFeature#getName()
	 * @see #getPresentableFeature()
	 * @generated
	 */
	EAttribute getPresentableFeature_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AliasedExpression <em>Aliased Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Aliased Expression</em>'.
	 * @see org.openxma.dsl.dom.model.AliasedExpression
	 * @generated
	 */
	EClass getAliasedExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.AliasedExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.AliasedExpression#getExpression()
	 * @see #getAliasedExpression()
	 * @generated
	 */
	EReference getAliasedExpression_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AliasedExpression#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.AliasedExpression#getName()
	 * @see #getAliasedExpression()
	 * @generated
	 */
	EAttribute getAliasedExpression_Name();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.BinaryExpression <em>Binary Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Binary Expression</em>'.
	 * @see org.openxma.dsl.dom.model.BinaryExpression
	 * @generated
	 */
	EClass getBinaryExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.BinaryExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see org.openxma.dsl.dom.model.BinaryExpression#getLeft()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EReference getBinaryExpression_Left();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.BinaryExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.openxma.dsl.dom.model.BinaryExpression#getOperator()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EAttribute getBinaryExpression_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.BinaryExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see org.openxma.dsl.dom.model.BinaryExpression#getRight()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EReference getBinaryExpression_Right();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.NotExpression <em>Not Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Not Expression</em>'.
	 * @see org.openxma.dsl.dom.model.NotExpression
	 * @generated
	 */
	EClass getNotExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.NotExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.NotExpression#getExpression()
	 * @see #getNotExpression()
	 * @generated
	 */
	EReference getNotExpression_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.InExpression <em>In Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>In Expression</em>'.
	 * @see org.openxma.dsl.dom.model.InExpression
	 * @generated
	 */
	EClass getInExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.InExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.InExpression#getExpression()
	 * @see #getInExpression()
	 * @generated
	 */
	EReference getInExpression_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InExpression#isNot <em>Not</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Not</em>'.
	 * @see org.openxma.dsl.dom.model.InExpression#isNot()
	 * @see #getInExpression()
	 * @generated
	 */
	EAttribute getInExpression_Not();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.InExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.openxma.dsl.dom.model.InExpression#getOperator()
	 * @see #getInExpression()
	 * @generated
	 */
	EAttribute getInExpression_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.InExpression#getIn <em>In</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>In</em>'.
	 * @see org.openxma.dsl.dom.model.InExpression#getIn()
	 * @see #getInExpression()
	 * @generated
	 */
	EReference getInExpression_In();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.BetweenExpression <em>Between Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Between Expression</em>'.
	 * @see org.openxma.dsl.dom.model.BetweenExpression
	 * @generated
	 */
	EClass getBetweenExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.BetweenExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.BetweenExpression#getExpression()
	 * @see #getBetweenExpression()
	 * @generated
	 */
	EReference getBetweenExpression_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.BetweenExpression#isNot <em>Not</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Not</em>'.
	 * @see org.openxma.dsl.dom.model.BetweenExpression#isNot()
	 * @see #getBetweenExpression()
	 * @generated
	 */
	EAttribute getBetweenExpression_Not();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.BetweenExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.openxma.dsl.dom.model.BetweenExpression#getOperator()
	 * @see #getBetweenExpression()
	 * @generated
	 */
	EAttribute getBetweenExpression_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.BetweenExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see org.openxma.dsl.dom.model.BetweenExpression#getLeft()
	 * @see #getBetweenExpression()
	 * @generated
	 */
	EReference getBetweenExpression_Left();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.BetweenExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see org.openxma.dsl.dom.model.BetweenExpression#getRight()
	 * @see #getBetweenExpression()
	 * @generated
	 */
	EReference getBetweenExpression_Right();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.LikeExpression <em>Like Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Like Expression</em>'.
	 * @see org.openxma.dsl.dom.model.LikeExpression
	 * @generated
	 */
	EClass getLikeExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.LikeExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.LikeExpression#getExpression()
	 * @see #getLikeExpression()
	 * @generated
	 */
	EReference getLikeExpression_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.LikeExpression#isNot <em>Not</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Not</em>'.
	 * @see org.openxma.dsl.dom.model.LikeExpression#isNot()
	 * @see #getLikeExpression()
	 * @generated
	 */
	EAttribute getLikeExpression_Not();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.LikeExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.openxma.dsl.dom.model.LikeExpression#getOperator()
	 * @see #getLikeExpression()
	 * @generated
	 */
	EAttribute getLikeExpression_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.LikeExpression#getLike <em>Like</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Like</em>'.
	 * @see org.openxma.dsl.dom.model.LikeExpression#getLike()
	 * @see #getLikeExpression()
	 * @generated
	 */
	EReference getLikeExpression_Like();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.LikeExpression#getEscape <em>Escape</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Escape</em>'.
	 * @see org.openxma.dsl.dom.model.LikeExpression#getEscape()
	 * @see #getLikeExpression()
	 * @generated
	 */
	EReference getLikeExpression_Escape();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.MemberOfExpression <em>Member Of Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member Of Expression</em>'.
	 * @see org.openxma.dsl.dom.model.MemberOfExpression
	 * @generated
	 */
	EClass getMemberOfExpression();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.MemberOfExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.MemberOfExpression#getExpression()
	 * @see #getMemberOfExpression()
	 * @generated
	 */
	EReference getMemberOfExpression_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.MemberOfExpression#isNot <em>Not</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Not</em>'.
	 * @see org.openxma.dsl.dom.model.MemberOfExpression#isNot()
	 * @see #getMemberOfExpression()
	 * @generated
	 */
	EAttribute getMemberOfExpression_Not();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.MemberOfExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.openxma.dsl.dom.model.MemberOfExpression#getOperator()
	 * @see #getMemberOfExpression()
	 * @generated
	 */
	EAttribute getMemberOfExpression_Operator();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.MemberOfExpression#getMemberOf <em>Member Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Member Of</em>'.
	 * @see org.openxma.dsl.dom.model.MemberOfExpression#getMemberOf()
	 * @see #getMemberOfExpression()
	 * @generated
	 */
	EAttribute getMemberOfExpression_MemberOf();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.UnaryExpression <em>Unary Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Expression</em>'.
	 * @see org.openxma.dsl.dom.model.UnaryExpression
	 * @generated
	 */
	EClass getUnaryExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.UnaryExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.openxma.dsl.dom.model.UnaryExpression#getOperator()
	 * @see #getUnaryExpression()
	 * @generated
	 */
	EAttribute getUnaryExpression_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.UnaryExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.UnaryExpression#getExpression()
	 * @see #getUnaryExpression()
	 * @generated
	 */
	EReference getUnaryExpression_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DataBaseConstraint <em>Data Base Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Base Constraint</em>'.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraint
	 * @generated
	 */
	EClass getDataBaseConstraint();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DataBaseConstraint#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraint#getType()
	 * @see #getDataBaseConstraint()
	 * @generated
	 */
	EAttribute getDataBaseConstraint_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.DataBaseConstraint#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraint#getName()
	 * @see #getDataBaseConstraint()
	 * @generated
	 */
	EAttribute getDataBaseConstraint_Name();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.DataBaseConstraint#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Attributes</em>'.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraint#getAttributes()
	 * @see #getDataBaseConstraint()
	 * @generated
	 */
	EReference getDataBaseConstraint_Attributes();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.DataBaseConstraint#getResolvedAttributeList <em>Resolved Attribute List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Resolved Attribute List</em>'.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraint#getResolvedAttributeList()
	 * @see #getDataBaseConstraint()
	 * @generated
	 */
	EReference getDataBaseConstraint_ResolvedAttributeList();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identifier</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isIdentifier()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Identifier();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isVersion()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isComposition <em>Composition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Composition</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isComposition()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Composition();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.Attribute#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getType()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isMany <em>Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Many</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isMany()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Many();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#getDefaultValue <em>Default Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default Value</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getDefaultValue()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_DefaultValue();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Attribute#getOpposite <em>Opposite</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Opposite</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getOpposite()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Opposite();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.Attribute#getAttributProperties <em>Attribut Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attribut Properties</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getAttributProperties()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_AttributProperties();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Attribute#getSortOrder <em>Sort Order</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Sort Order</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getSortOrder()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_SortOrder();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Attribute#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Data Type</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getDataType()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_DataType();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Attribute#getOppositeReference <em>Opposite Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Opposite Reference</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getOppositeReference()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_OppositeReference();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#getDataTypeName <em>Data Type Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Data Type Name</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getDataTypeName()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_DataTypeName();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isReference()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Reference();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.Attribute#getResolvedAttributeList <em>Resolved Attribute List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Resolved Attribute List</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getResolvedAttributeList()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_ResolvedAttributeList();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isReadOnly <em>Read Only</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Read Only</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isReadOnly()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_ReadOnly();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isRequired <em>Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Required</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isRequired()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Required();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isDerived <em>Derived</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Derived</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isDerived()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Derived();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Attribute#isTransient <em>Transient</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transient</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#isTransient()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Transient();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.Attribute#getIncrementerReference <em>Incrementer Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Incrementer Reference</em>'.
	 * @see org.openxma.dsl.dom.model.Attribute#getIncrementerReference()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_IncrementerReference();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AttributeFlag <em>Attribute Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Flag</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeFlag
	 * @generated
	 */
	EClass getAttributeFlag();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ExpressionFlag <em>Expression Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expression Flag</em>'.
	 * @see org.openxma.dsl.dom.model.ExpressionFlag
	 * @generated
	 */
	EClass getExpressionFlag();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.ExpressionFlag#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.ExpressionFlag#getExpression()
	 * @see #getExpressionFlag()
	 * @generated
	 */
	EReference getExpressionFlag_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.RequiredFlag <em>Required Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Required Flag</em>'.
	 * @see org.openxma.dsl.dom.model.RequiredFlag
	 * @generated
	 */
	EClass getRequiredFlag();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ReadOnlyFlag <em>Read Only Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Read Only Flag</em>'.
	 * @see org.openxma.dsl.dom.model.ReadOnlyFlag
	 * @generated
	 */
	EClass getReadOnlyFlag();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AvailableFlag <em>Available Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Available Flag</em>'.
	 * @see org.openxma.dsl.dom.model.AvailableFlag
	 * @generated
	 */
	EClass getAvailableFlag();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.DerivedFlag <em>Derived Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Derived Flag</em>'.
	 * @see org.openxma.dsl.dom.model.DerivedFlag
	 * @generated
	 */
	EClass getDerivedFlag();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.DerivedFlag#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.DerivedFlag#getExpression()
	 * @see #getDerivedFlag()
	 * @generated
	 */
	EReference getDerivedFlag_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.TransientFlag <em>Transient Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transient Flag</em>'.
	 * @see org.openxma.dsl.dom.model.TransientFlag
	 * @generated
	 */
	EClass getTransientFlag();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.TransientFlag#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see org.openxma.dsl.dom.model.TransientFlag#getExpression()
	 * @see #getTransientFlag()
	 * @generated
	 */
	EReference getTransientFlag_Expression();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AttributeProperty <em>Attribute Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Property</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeProperty
	 * @generated
	 */
	EClass getAttributeProperty();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AttributeValidationProperty <em>Attribute Validation Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Validation Property</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeValidationProperty
	 * @generated
	 */
	EClass getAttributeValidationProperty();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.AttributeValidationProperty#getConstraints <em>Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraints</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeValidationProperty#getConstraints()
	 * @see #getAttributeValidationProperty()
	 * @generated
	 */
	EReference getAttributeValidationProperty_Constraints();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.AttributeValidationProperty#getFormat <em>Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Format</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeValidationProperty#getFormat()
	 * @see #getAttributeValidationProperty()
	 * @generated
	 */
	EReference getAttributeValidationProperty_Format();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AttributeTextProperty <em>Attribute Text Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Text Property</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty
	 * @generated
	 */
	EClass getAttributeTextProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeTextProperty#getLabelText <em>Label Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Label Text</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty#getLabelText()
	 * @see #getAttributeTextProperty()
	 * @generated
	 */
	EAttribute getAttributeTextProperty_LabelText();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeTextProperty#getTooltipText <em>Tooltip Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tooltip Text</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty#getTooltipText()
	 * @see #getAttributeTextProperty()
	 * @generated
	 */
	EAttribute getAttributeTextProperty_TooltipText();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeTextProperty#getUnitText <em>Unit Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit Text</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty#getUnitText()
	 * @see #getAttributeTextProperty()
	 * @generated
	 */
	EAttribute getAttributeTextProperty_UnitText();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.AttributeTextProperty#getUnitAttribute <em>Unit Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Unit Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty#getUnitAttribute()
	 * @see #getAttributeTextProperty()
	 * @generated
	 */
	EReference getAttributeTextProperty_UnitAttribute();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeTextProperty#getHstoreColumn <em>Hstore Column</em>}'.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hstore Column</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty#getHstoreColumn()
	 * @see #getAttributeTextProperty()
	 * @generated
	 */
    EAttribute getAttributeTextProperty_HstoreColumn();

    /**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AttributeGroup <em>Attribute Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Group</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup
	 * @generated
	 */
	EClass getAttributeGroup();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeGroup#isKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#isKey()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EAttribute getAttributeGroup_Key();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeGroup#isUnique <em>Unique</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unique</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#isUnique()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EAttribute getAttributeGroup_Unique();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeGroup#isFilter <em>Filter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Filter</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#isFilter()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EAttribute getAttributeGroup_Filter();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeGroup#isSortorder <em>Sortorder</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sortorder</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#isSortorder()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EAttribute getAttributeGroup_Sortorder();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeGroup#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#getName()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EAttribute getAttributeGroup_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.AttributeGroup#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Attributes</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#getAttributes()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EReference getAttributeGroup_Attributes();

	/**
	 * Returns the meta object for the reference list '{@link org.openxma.dsl.dom.model.AttributeGroup#getResolvedAttributeList <em>Resolved Attribute List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Resolved Attribute List</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeGroup#getResolvedAttributeList()
	 * @see #getAttributeGroup()
	 * @generated
	 */
	EReference getAttributeGroup_ResolvedAttributeList();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.AttributeSortOrder <em>Attribute Sort Order</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Sort Order</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeSortOrder
	 * @generated
	 */
	EClass getAttributeSortOrder();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.AttributeSortOrder#getAttribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Attribute</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeSortOrder#getAttribute()
	 * @see #getAttributeSortOrder()
	 * @generated
	 */
	EReference getAttributeSortOrder_Attribute();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeSortOrder#isAsc <em>Asc</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Asc</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeSortOrder#isAsc()
	 * @see #getAttributeSortOrder()
	 * @generated
	 */
	EAttribute getAttributeSortOrder_Asc();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.AttributeSortOrder#isDesc <em>Desc</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Desc</em>'.
	 * @see org.openxma.dsl.dom.model.AttributeSortOrder#isDesc()
	 * @see #getAttributeSortOrder()
	 * @generated
	 */
	EAttribute getAttributeSortOrder_Desc();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property</em>'.
	 * @see org.openxma.dsl.dom.model.Property
	 * @generated
	 */
	EClass getProperty();

	/**
	 * Returns the meta object for the reference '{@link org.openxma.dsl.dom.model.Property#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.openxma.dsl.dom.model.Property#getType()
	 * @see #getProperty()
	 * @generated
	 */
	EReference getProperty_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Property#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.openxma.dsl.dom.model.Property#getName()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.openxma.dsl.dom.model.Property#getDefaultValue <em>Default Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default Value</em>'.
	 * @see org.openxma.dsl.dom.model.Property#getDefaultValue()
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_DefaultValue();

	/**
	 * Returns the meta object for class '{@link org.openxma.dsl.dom.model.ApplicationSession <em>Application Session</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Application Session</em>'.
	 * @see org.openxma.dsl.dom.model.ApplicationSession
	 * @generated
	 */
	EClass getApplicationSession();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.ApplicationSession#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.openxma.dsl.dom.model.ApplicationSession#getProperties()
	 * @see #getApplicationSession()
	 * @generated
	 */
	EReference getApplicationSession_Properties();

	/**
	 * Returns the meta object for the containment reference list '{@link org.openxma.dsl.dom.model.ApplicationSession#getFunctions <em>Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Functions</em>'.
	 * @see org.openxma.dsl.dom.model.ApplicationSession#getFunctions()
	 * @see #getApplicationSession()
	 * @generated
	 */
	EReference getApplicationSession_Functions();

	/**
	 * Returns the meta object for the containment reference '{@link org.openxma.dsl.dom.model.ApplicationSession#getConditionsBlock <em>Conditions Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Conditions Block</em>'.
	 * @see org.openxma.dsl.dom.model.ApplicationSession#getConditionsBlock()
	 * @see #getApplicationSession()
	 * @generated
	 */
	EReference getApplicationSession_ConditionsBlock();

	/**
	 * Returns the meta object for enum '{@link org.openxma.dsl.dom.model.CrudOperationType <em>Crud Operation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Crud Operation Type</em>'.
	 * @see org.openxma.dsl.dom.model.CrudOperationType
	 * @generated
	 */
	EEnum getCrudOperationType();

	/**
	 * Returns the meta object for enum '{@link org.openxma.dsl.dom.model.DataBaseConstraintType <em>Data Base Constraint Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Data Base Constraint Type</em>'.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraintType
	 * @generated
	 */
	EEnum getDataBaseConstraintType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DomFactory getDomFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ServiceImpl <em>Service</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ServiceImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getService()
		 * @generated
		 */
		EClass SERVICE = eINSTANCE.getService();

		/**
		 * The meta object literal for the '<em><b>Dependencies</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__DEPENDENCIES = eINSTANCE.getService_Dependencies();

		/**
		 * The meta object literal for the '<em><b>Delegate Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__DELEGATE_OPERATIONS = eINSTANCE.getService_DelegateOperations();

		/**
		 * The meta object literal for the '<em><b>Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE__OPERATIONS = eINSTANCE.getService_Operations();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ComplexTypeImpl <em>Complex Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ComplexTypeImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getComplexType()
		 * @generated
		 */
		EClass COMPLEX_TYPE = eINSTANCE.getComplexType();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPLEX_TYPE__ATTRIBUTES = eINSTANCE.getComplexType_Attributes();

		/**
		 * The meta object literal for the '<em><b>All Attributes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPLEX_TYPE__ALL_ATTRIBUTES = eINSTANCE.getComplexType_AllAttributes();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DependantImpl <em>Dependant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DependantImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDependant()
		 * @generated
		 */
		EClass DEPENDANT = eINSTANCE.getDependant();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.OperationImpl <em>Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.OperationImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getOperation()
		 * @generated
		 */
		EClass OPERATION = eINSTANCE.getOperation();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__PARAMETERS = eINSTANCE.getOperation_Parameters();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPERATION__EXPRESSION = eINSTANCE.getOperation_Expression();

		/**
		 * The meta object literal for the '<em><b>Delegate</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__DELEGATE = eINSTANCE.getOperation_Delegate();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl <em>Delegate Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DelegateOperationImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDelegateOperation()
		 * @generated
		 */
		EClass DELEGATE_OPERATION = eINSTANCE.getDelegateOperation();

		/**
		 * The meta object literal for the '<em><b>View</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE_OPERATION__VIEW = eINSTANCE.getDelegateOperation_View();

		/**
		 * The meta object literal for the '<em><b>Many</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute DELEGATE_OPERATION__MANY = eINSTANCE.getDelegateOperation_Many();

        /**
		 * The meta object literal for the '<em><b>Repository</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE_OPERATION__REPOSITORY = eINSTANCE.getDelegateOperation_Repository();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE_OPERATION__OPERATION = eINSTANCE.getDelegateOperation_Operation();

		/**
		 * The meta object literal for the '<em><b>Crud Operation Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DELEGATE_OPERATION__CRUD_OPERATION_TYPE = eINSTANCE.getDelegateOperation_CrudOperationType();

		/**
		 * The meta object literal for the '<em><b>View Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELEGATE_OPERATION__VIEW_PARAMETER = eINSTANCE.getDelegateOperation_ViewParameter();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute DELEGATE_OPERATION__NAME = eINSTANCE.getDelegateOperation_Name();

        /**
		 * The meta object literal for the '<em><b>Filter</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EReference DELEGATE_OPERATION__FILTER = eINSTANCE.getDelegateOperation_Filter();

        /**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DaoOperationImpl <em>Dao Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DaoOperationImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDaoOperation()
		 * @generated
		 */
		EClass DAO_OPERATION = eINSTANCE.getDaoOperation();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO_OPERATION__TYPE = eINSTANCE.getDaoOperation_Type();

		/**
		 * The meta object literal for the '<em><b>Many</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DAO_OPERATION__MANY = eINSTANCE.getDaoOperation_Many();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DAO_OPERATION__NAME = eINSTANCE.getDaoOperation_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ParameterImpl <em>Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ParameterImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getParameter()
		 * @generated
		 */
		EClass PARAMETER = eINSTANCE.getParameter();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER__TYPE = eINSTANCE.getParameter_Type();

		/**
		 * The meta object literal for the '<em><b>Many</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARAMETER__MANY = eINSTANCE.getParameter_Many();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARAMETER__NAME = eINSTANCE.getParameter_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ValueObjectImpl <em>Value Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ValueObjectImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getValueObject()
		 * @generated
		 */
		EClass VALUE_OBJECT = eINSTANCE.getValueObject();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DataViewImpl <em>Data View</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DataViewImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDataView()
		 * @generated
		 */
		EClass DATA_VIEW = eINSTANCE.getDataView();

		/**
		 * The meta object literal for the '<em><b>Super Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_VIEW__SUPER_TYPE = eINSTANCE.getDataView_SuperType();

		/**
		 * The meta object literal for the '<em><b>Feature References</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_VIEW__FEATURE_REFERENCES = eINSTANCE.getDataView_FeatureReferences();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl <em>Feature Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.FeatureReferenceImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFeatureReference()
		 * @generated
		 */
		EClass FEATURE_REFERENCE = eINSTANCE.getFeatureReference();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_REFERENCE__SOURCE = eINSTANCE.getFeatureReference_Source();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_REFERENCE__ATTRIBUTE = eINSTANCE.getFeatureReference_Attribute();

		/**
		 * The meta object literal for the '<em><b>View</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_REFERENCE__VIEW = eINSTANCE.getFeatureReference_View();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_REFERENCE__PROPERTIES = eINSTANCE.getFeatureReference_Properties();

		/**
		 * The meta object literal for the '<em><b>All</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_REFERENCE__ALL = eINSTANCE.getFeatureReference_All();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_REFERENCE__TARGET = eINSTANCE.getFeatureReference_Target();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.MapperImpl <em>Mapper</em>}' class.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.MapperImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getMapper()
		 * @generated
		 */
        EClass MAPPER = eINSTANCE.getMapper();

        /**
		 * The meta object literal for the '<em><b>Left</b></em>' reference feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EReference MAPPER__LEFT = eINSTANCE.getMapper_Left();

        /**
		 * The meta object literal for the '<em><b>Bi Directional</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute MAPPER__BI_DIRECTIONAL = eINSTANCE.getMapper_BiDirectional();

        /**
		 * The meta object literal for the '<em><b>To Left</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute MAPPER__TO_LEFT = eINSTANCE.getMapper_ToLeft();

        /**
		 * The meta object literal for the '<em><b>To Right</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute MAPPER__TO_RIGHT = eINSTANCE.getMapper_ToRight();

        /**
		 * The meta object literal for the '<em><b>Right</b></em>' reference feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EReference MAPPER__RIGHT = eINSTANCE.getMapper_Right();

        /**
		 * The meta object literal for the '<em><b>Property Mappings</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EReference MAPPER__PROPERTY_MAPPINGS = eINSTANCE.getMapper_PropertyMappings();

        /**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl <em>Property Mapping</em>}' class.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.PropertyMappingImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPropertyMapping()
		 * @generated
		 */
        EClass PROPERTY_MAPPING = eINSTANCE.getPropertyMapping();

        /**
		 * The meta object literal for the '<em><b>Left</b></em>' reference feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EReference PROPERTY_MAPPING__LEFT = eINSTANCE.getPropertyMapping_Left();

        /**
		 * The meta object literal for the '<em><b>Bi Directional</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute PROPERTY_MAPPING__BI_DIRECTIONAL = eINSTANCE.getPropertyMapping_BiDirectional();

        /**
		 * The meta object literal for the '<em><b>To Left</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute PROPERTY_MAPPING__TO_LEFT = eINSTANCE.getPropertyMapping_ToLeft();

        /**
		 * The meta object literal for the '<em><b>To Right</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute PROPERTY_MAPPING__TO_RIGHT = eINSTANCE.getPropertyMapping_ToRight();

        /**
		 * The meta object literal for the '<em><b>Right</b></em>' reference feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EReference PROPERTY_MAPPING__RIGHT = eINSTANCE.getPropertyMapping_Right();

        /**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.IElementWithNoNameImpl <em>IElement With No Name</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.IElementWithNoNameImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getIElementWithNoName()
		 * @generated
		 */
		EClass IELEMENT_WITH_NO_NAME = eINSTANCE.getIElementWithNoName();

		/**
		 * The meta object literal for the '<em><b>No Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IELEMENT_WITH_NO_NAME__NO_NAME = eINSTANCE.getIElementWithNoName_NoName();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.EntityImpl <em>Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.EntityImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getEntity()
		 * @generated
		 */
		EClass ENTITY = eINSTANCE.getEntity();

		/**
		 * The meta object literal for the '<em><b>Super Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__SUPER_TYPE = eINSTANCE.getEntity_SuperType();

		/**
		 * The meta object literal for the '<em><b>Attribute Groups</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__ATTRIBUTE_GROUPS = eINSTANCE.getEntity_AttributeGroups();

		/**
		 * The meta object literal for the '<em><b>Conditions Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__CONDITIONS_BLOCK = eINSTANCE.getEntity_ConditionsBlock();

		/**
		 * The meta object literal for the '<em><b>Repository</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__REPOSITORY = eINSTANCE.getEntity_Repository();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__KEY = eINSTANCE.getEntity_Key();

		/**
		 * The meta object literal for the '<em><b>Sort Orders</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__SORT_ORDERS = eINSTANCE.getEntity_SortOrders();

		/**
		 * The meta object literal for the '<em><b>Identifier</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__IDENTIFIER = eINSTANCE.getEntity_Identifier();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__VERSION = eINSTANCE.getEntity_Version();

		/**
		 * The meta object literal for the '<em><b>Required References</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__REQUIRED_REFERENCES = eINSTANCE.getEntity_RequiredReferences();

		/**
		 * The meta object literal for the '<em><b>Required Attributes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__REQUIRED_ATTRIBUTES = eINSTANCE.getEntity_RequiredAttributes();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.QlStatementImpl <em>Ql Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.QlStatementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQlStatement()
		 * @generated
		 */
		EClass QL_STATEMENT = eINSTANCE.getQlStatement();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.CallableStatementImpl <em>Callable Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.CallableStatementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCallableStatement()
		 * @generated
		 */
		EClass CALLABLE_STATEMENT = eINSTANCE.getCallableStatement();

		/**
		 * The meta object literal for the '<em><b>Function Call</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALLABLE_STATEMENT__FUNCTION_CALL = eINSTANCE.getCallableStatement_FunctionCall();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALLABLE_STATEMENT__NAME = eINSTANCE.getCallableStatement_Name();

		/**
		 * The meta object literal for the '<em><b>In Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CALLABLE_STATEMENT__IN_PARAMETER = eINSTANCE.getCallableStatement_InParameter();

		/**
		 * The meta object literal for the '<em><b>Out Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CALLABLE_STATEMENT__OUT_PARAMETER = eINSTANCE.getCallableStatement_OutParameter();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.CallInputParameterImpl <em>Call Input Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.CallInputParameterImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCallInputParameter()
		 * @generated
		 */
		EClass CALL_INPUT_PARAMETER = eINSTANCE.getCallInputParameter();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CALL_INPUT_PARAMETER__PARAMETER = eINSTANCE.getCallInputParameter_Parameter();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CALL_INPUT_PARAMETER__ATTRIBUTE = eINSTANCE.getCallInputParameter_Attribute();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALL_INPUT_PARAMETER__NAME = eINSTANCE.getCallInputParameter_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.CallOutputParameterImpl <em>Call Output Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.CallOutputParameterImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCallOutputParameter()
		 * @generated
		 */
		EClass CALL_OUTPUT_PARAMETER = eINSTANCE.getCallOutputParameter();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CALL_OUTPUT_PARAMETER__NAME = eINSTANCE.getCallOutputParameter_Name();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CALL_OUTPUT_PARAMETER__ATTRIBUTE = eINSTANCE.getCallOutputParameter_Attribute();

		/**
		 * The meta object literal for the '<em><b>Nested Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CALL_OUTPUT_PARAMETER__NESTED_ATTRIBUTE = eINSTANCE.getCallOutputParameter_NestedAttribute();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.InsertStatementImpl <em>Insert Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.InsertStatementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInsertStatement()
		 * @generated
		 */
		EClass INSERT_STATEMENT = eINSTANCE.getInsertStatement();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INSERT_STATEMENT__ENTITY = eINSTANCE.getInsertStatement_Entity();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INSERT_STATEMENT__EXPRESSION = eINSTANCE.getInsertStatement_Expression();

		/**
		 * The meta object literal for the '<em><b>Select Statement</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INSERT_STATEMENT__SELECT_STATEMENT = eINSTANCE.getInsertStatement_SelectStatement();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DeleteStatementImpl <em>Delete Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DeleteStatementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDeleteStatement()
		 * @generated
		 */
		EClass DELETE_STATEMENT = eINSTANCE.getDeleteStatement();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELETE_STATEMENT__ENTITY = eINSTANCE.getDeleteStatement_Entity();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DELETE_STATEMENT__NAME = eINSTANCE.getDeleteStatement_Name();

		/**
		 * The meta object literal for the '<em><b>Where</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DELETE_STATEMENT__WHERE = eINSTANCE.getDeleteStatement_Where();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.UpdateStatementImpl <em>Update Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.UpdateStatementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getUpdateStatement()
		 * @generated
		 */
		EClass UPDATE_STATEMENT = eINSTANCE.getUpdateStatement();

		/**
		 * The meta object literal for the '<em><b>Versioned</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPDATE_STATEMENT__VERSIONED = eINSTANCE.getUpdateStatement_Versioned();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UPDATE_STATEMENT__ENTITY = eINSTANCE.getUpdateStatement_Entity();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPDATE_STATEMENT__NAME = eINSTANCE.getUpdateStatement_Name();

		/**
		 * The meta object literal for the '<em><b>Assignment</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UPDATE_STATEMENT__ASSIGNMENT = eINSTANCE.getUpdateStatement_Assignment();

		/**
		 * The meta object literal for the '<em><b>Where</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UPDATE_STATEMENT__WHERE = eINSTANCE.getUpdateStatement_Where();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.PropertyAssignmentImpl <em>Property Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.PropertyAssignmentImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPropertyAssignment()
		 * @generated
		 */
		EClass PROPERTY_ASSIGNMENT = eINSTANCE.getPropertyAssignment();

		/**
		 * The meta object literal for the '<em><b>Property</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_ASSIGNMENT__PROPERTY = eINSTANCE.getPropertyAssignment_Property();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_ASSIGNMENT__EXPRESSION = eINSTANCE.getPropertyAssignment_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl <em>Select Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.SelectStatementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectStatement()
		 * @generated
		 */
		EClass SELECT_STATEMENT = eINSTANCE.getSelectStatement();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_STATEMENT__FROM = eINSTANCE.getSelectStatement_From();

		/**
		 * The meta object literal for the '<em><b>Join</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_STATEMENT__JOIN = eINSTANCE.getSelectStatement_Join();

		/**
		 * The meta object literal for the '<em><b>Where</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_STATEMENT__WHERE = eINSTANCE.getSelectStatement_Where();

		/**
		 * The meta object literal for the '<em><b>Group By</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_STATEMENT__GROUP_BY = eINSTANCE.getSelectStatement_GroupBy();

		/**
		 * The meta object literal for the '<em><b>Having</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_STATEMENT__HAVING = eINSTANCE.getSelectStatement_Having();

		/**
		 * The meta object literal for the '<em><b>Order By</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_STATEMENT__ORDER_BY = eINSTANCE.getSelectStatement_OrderBy();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.SortOrderElementImpl <em>Sort Order Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.SortOrderElementImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSortOrderElement()
		 * @generated
		 */
		EClass SORT_ORDER_ELEMENT = eINSTANCE.getSortOrderElement();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SORT_ORDER_ELEMENT__EXPRESSION = eINSTANCE.getSortOrderElement_Expression();

		/**
		 * The meta object literal for the '<em><b>Sort Order</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SORT_ORDER_ELEMENT__SORT_ORDER = eINSTANCE.getSortOrderElement_SortOrder();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.SelectPropertiesImpl <em>Select Properties</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.SelectPropertiesImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectProperties()
		 * @generated
		 */
		EClass SELECT_PROPERTIES = eINSTANCE.getSelectProperties();

		/**
		 * The meta object literal for the '<em><b>Distinct</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SELECT_PROPERTIES__DISTINCT = eINSTANCE.getSelectProperties_Distinct();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_PROPERTIES__PROPERTIES = eINSTANCE.getSelectProperties_Properties();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.SelectClassImpl <em>Select Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.SelectClassImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectClass()
		 * @generated
		 */
		EClass SELECT_CLASS = eINSTANCE.getSelectClass();

		/**
		 * The meta object literal for the '<em><b>Class</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SELECT_CLASS__CLASS = eINSTANCE.getSelectClass_Class();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SELECT_CLASS__ARGUMENTS = eINSTANCE.getSelectClass_Arguments();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.SelectObjectImpl <em>Select Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.SelectObjectImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSelectObject()
		 * @generated
		 */
		EClass SELECT_OBJECT = eINSTANCE.getSelectObject();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SELECT_OBJECT__NAME = eINSTANCE.getSelectObject_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.FromRangeImpl <em>From Range</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.FromRangeImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFromRange()
		 * @generated
		 */
		EClass FROM_RANGE = eINSTANCE.getFromRange();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.FromClassImpl <em>From Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.FromClassImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFromClass()
		 * @generated
		 */
		EClass FROM_CLASS = eINSTANCE.getFromClass();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FROM_CLASS__ENTITY = eINSTANCE.getFromClass_Entity();

		/**
		 * The meta object literal for the '<em><b>Poperty Fetch</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FROM_CLASS__POPERTY_FETCH = eINSTANCE.getFromClass_PopertyFetch();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.InClassImpl <em>In Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.InClassImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInClass()
		 * @generated
		 */
		EClass IN_CLASS = eINSTANCE.getInClass();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_CLASS__NAME = eINSTANCE.getInClass_Name();

		/**
		 * The meta object literal for the '<em><b>Class</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_CLASS__CLASS = eINSTANCE.getInClass_Class();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.InCollectionImpl <em>In Collection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.InCollectionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInCollection()
		 * @generated
		 */
		EClass IN_COLLECTION = eINSTANCE.getInCollection();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_COLLECTION__PATH = eINSTANCE.getInCollection_Path();

		/**
		 * The meta object literal for the '<em><b>Alias</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_COLLECTION__ALIAS = eINSTANCE.getInCollection_Alias();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.InCollectionElementsImpl <em>In Collection Elements</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.InCollectionElementsImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInCollectionElements()
		 * @generated
		 */
		EClass IN_COLLECTION_ELEMENTS = eINSTANCE.getInCollectionElements();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_COLLECTION_ELEMENTS__NAME = eINSTANCE.getInCollectionElements_Name();

		/**
		 * The meta object literal for the '<em><b>Reference</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_COLLECTION_ELEMENTS__REFERENCE = eINSTANCE.getInCollectionElements_Reference();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.JoinImpl <em>Join</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.JoinImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getJoin()
		 * @generated
		 */
		EClass JOIN = eINSTANCE.getJoin();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JOIN__TYPE = eINSTANCE.getJoin_Type();

		/**
		 * The meta object literal for the '<em><b>Fetch</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JOIN__FETCH = eINSTANCE.getJoin_Fetch();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JOIN__ENTITY = eINSTANCE.getJoin_Entity();

		/**
		 * The meta object literal for the '<em><b>Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JOIN__REFERENCE = eINSTANCE.getJoin_Reference();

		/**
		 * The meta object literal for the '<em><b>Property Fetch</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JOIN__PROPERTY_FETCH = eINSTANCE.getJoin_PropertyFetch();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JOIN__EXPRESSION = eINSTANCE.getJoin_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.JoinEntityImpl <em>Join Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.JoinEntityImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getJoinEntity()
		 * @generated
		 */
		EClass JOIN_ENTITY = eINSTANCE.getJoinEntity();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JOIN_ENTITY__NAME = eINSTANCE.getJoinEntity_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ExpressionImpl <em>Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getExpression()
		 * @generated
		 */
		EClass EXPRESSION = eINSTANCE.getExpression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.PropertyValueImpl <em>Property Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.PropertyValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPropertyValue()
		 * @generated
		 */
		EClass PROPERTY_VALUE = eINSTANCE.getPropertyValue();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY_VALUE__NAME = eINSTANCE.getPropertyValue_Name();

		/**
		 * The meta object literal for the '<em><b>Segments</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY_VALUE__SEGMENTS = eINSTANCE.getPropertyValue_Segments();

		/**
		 * The meta object literal for the '<em><b>Index</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_VALUE__INDEX = eINSTANCE.getPropertyValue_Index();

		/**
		 * The meta object literal for the '<em><b>Class Property</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY_VALUE__CLASS_PROPERTY = eINSTANCE.getPropertyValue_ClassProperty();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.FunctionCallImpl <em>Function Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.FunctionCallImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getFunctionCall()
		 * @generated
		 */
		EClass FUNCTION_CALL = eINSTANCE.getFunctionCall();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FUNCTION_CALL__FUNCTION = eINSTANCE.getFunctionCall_Function();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_CALL__ARGUMENTS = eINSTANCE.getFunctionCall_Arguments();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.TrimFunctionImpl <em>Trim Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.TrimFunctionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getTrimFunction()
		 * @generated
		 */
		EClass TRIM_FUNCTION = eINSTANCE.getTrimFunction();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIM_FUNCTION__FUNCTION = eINSTANCE.getTrimFunction_Function();

		/**
		 * The meta object literal for the '<em><b>Mode</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIM_FUNCTION__MODE = eINSTANCE.getTrimFunction_Mode();

		/**
		 * The meta object literal for the '<em><b>Character</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRIM_FUNCTION__CHARACTER = eINSTANCE.getTrimFunction_Character();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRIM_FUNCTION__FROM = eINSTANCE.getTrimFunction_From();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.CastFunctionImpl <em>Cast Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.CastFunctionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCastFunction()
		 * @generated
		 */
		EClass CAST_FUNCTION = eINSTANCE.getCastFunction();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CAST_FUNCTION__FUNCTION = eINSTANCE.getCastFunction_Function();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAST_FUNCTION__FROM = eINSTANCE.getCastFunction_From();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CAST_FUNCTION__NAME = eINSTANCE.getCastFunction_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl <em>Aggregate Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AggregateFunctionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAggregateFunction()
		 * @generated
		 */
		EClass AGGREGATE_FUNCTION = eINSTANCE.getAggregateFunction();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AGGREGATE_FUNCTION__FUNCTION = eINSTANCE.getAggregateFunction_Function();

		/**
		 * The meta object literal for the '<em><b>Aggregate Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION = eINSTANCE.getAggregateFunction_AggregateExpression();

		/**
		 * The meta object literal for the '<em><b>All</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AGGREGATE_FUNCTION__ALL = eINSTANCE.getAggregateFunction_All();

		/**
		 * The meta object literal for the '<em><b>Distinct</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AGGREGATE_FUNCTION__DISTINCT = eINSTANCE.getAggregateFunction_Distinct();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AGGREGATE_FUNCTION__FROM = eINSTANCE.getAggregateFunction_From();

		/**
		 * The meta object literal for the '<em><b>Collection</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AGGREGATE_FUNCTION__COLLECTION = eINSTANCE.getAggregateFunction_Collection();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.QueryParameterReferenceImpl <em>Query Parameter Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.QueryParameterReferenceImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryParameterReference()
		 * @generated
		 */
		EClass QUERY_PARAMETER_REFERENCE = eINSTANCE.getQueryParameterReference();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.QueryParameterValueImpl <em>Query Parameter Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.QueryParameterValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryParameterValue()
		 * @generated
		 */
		EClass QUERY_PARAMETER_VALUE = eINSTANCE.getQueryParameterValue();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_PARAMETER_VALUE__PARAMETER = eINSTANCE.getQueryParameterValue_Parameter();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_PARAMETER_VALUE__ATTRIBUTE = eINSTANCE.getQueryParameterValue_Attribute();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.QuantifiedExpressionImpl <em>Quantified Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.QuantifiedExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQuantifiedExpression()
		 * @generated
		 */
		EClass QUANTIFIED_EXPRESSION = eINSTANCE.getQuantifiedExpression();

		/**
		 * The meta object literal for the '<em><b>Quantifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QUANTIFIED_EXPRESSION__QUANTIFIER = eINSTANCE.getQuantifiedExpression_Quantifier();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUANTIFIED_EXPRESSION__EXPRESSION = eINSTANCE.getQuantifiedExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QUANTIFIED_EXPRESSION__NAME = eINSTANCE.getQuantifiedExpression_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.CaseExpressionImpl <em>Case Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.CaseExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCaseExpression()
		 * @generated
		 */
		EClass CASE_EXPRESSION = eINSTANCE.getCaseExpression();

		/**
		 * The meta object literal for the '<em><b>When Clause</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CASE_EXPRESSION__WHEN_CLAUSE = eINSTANCE.getCaseExpression_WhenClause();

		/**
		 * The meta object literal for the '<em><b>Else Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CASE_EXPRESSION__ELSE_EXPRESSION = eINSTANCE.getCaseExpression_ElseExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CASE_EXPRESSION__EXPRESSION = eINSTANCE.getCaseExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Alt When Clause</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CASE_EXPRESSION__ALT_WHEN_CLAUSE = eINSTANCE.getCaseExpression_AltWhenClause();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.WhenClauseImpl <em>When Clause</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.WhenClauseImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getWhenClause()
		 * @generated
		 */
		EClass WHEN_CLAUSE = eINSTANCE.getWhenClause();

		/**
		 * The meta object literal for the '<em><b>When Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WHEN_CLAUSE__WHEN_EXPRESSION = eINSTANCE.getWhenClause_WhenExpression();

		/**
		 * The meta object literal for the '<em><b>Then Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WHEN_CLAUSE__THEN_EXPRESSION = eINSTANCE.getWhenClause_ThenExpression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AltWhenClauseImpl <em>Alt When Clause</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AltWhenClauseImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAltWhenClause()
		 * @generated
		 */
		EClass ALT_WHEN_CLAUSE = eINSTANCE.getAltWhenClause();

		/**
		 * The meta object literal for the '<em><b>When Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ALT_WHEN_CLAUSE__WHEN_EXPRESSION = eINSTANCE.getAltWhenClause_WhenExpression();

		/**
		 * The meta object literal for the '<em><b>Then Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ALT_WHEN_CLAUSE__THEN_EXPRESSION = eINSTANCE.getAltWhenClause_ThenExpression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.CollectionFunctionImpl <em>Collection Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.CollectionFunctionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCollectionFunction()
		 * @generated
		 */
		EClass COLLECTION_FUNCTION = eINSTANCE.getCollectionFunction();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COLLECTION_FUNCTION__FUNCTION = eINSTANCE.getCollectionFunction_Function();

		/**
		 * The meta object literal for the '<em><b>Property</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLLECTION_FUNCTION__PROPERTY = eINSTANCE.getCollectionFunction_Property();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.SubQueryImpl <em>Sub Query</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.SubQueryImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getSubQuery()
		 * @generated
		 */
		EClass SUB_QUERY = eINSTANCE.getSubQuery();

		/**
		 * The meta object literal for the '<em><b>Queries</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SUB_QUERY__QUERIES = eINSTANCE.getSubQuery_Queries();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ParenthesizedExpressionImpl <em>Parenthesized Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ParenthesizedExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getParenthesizedExpression()
		 * @generated
		 */
		EClass PARENTHESIZED_EXPRESSION = eINSTANCE.getParenthesizedExpression();

		/**
		 * The meta object literal for the '<em><b>Expressions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARENTHESIZED_EXPRESSION__EXPRESSIONS = eINSTANCE.getParenthesizedExpression_Expressions();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.LiteralValueImpl <em>Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.LiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getLiteralValue()
		 * @generated
		 */
		EClass LITERAL_VALUE = eINSTANCE.getLiteralValue();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.StringLiteralValueImpl <em>String Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.StringLiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getStringLiteralValue()
		 * @generated
		 */
		EClass STRING_LITERAL_VALUE = eINSTANCE.getStringLiteralValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_LITERAL_VALUE__VALUE = eINSTANCE.getStringLiteralValue_Value();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.IntegerLiteralValueImpl <em>Integer Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.IntegerLiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getIntegerLiteralValue()
		 * @generated
		 */
		EClass INTEGER_LITERAL_VALUE = eINSTANCE.getIntegerLiteralValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTEGER_LITERAL_VALUE__VALUE = eINSTANCE.getIntegerLiteralValue_Value();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.RealLiteralValueImpl <em>Real Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.RealLiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getRealLiteralValue()
		 * @generated
		 */
		EClass REAL_LITERAL_VALUE = eINSTANCE.getRealLiteralValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REAL_LITERAL_VALUE__VALUE = eINSTANCE.getRealLiteralValue_Value();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.BooleanLiteralValueImpl <em>Boolean Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.BooleanLiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getBooleanLiteralValue()
		 * @generated
		 */
		EClass BOOLEAN_LITERAL_VALUE = eINSTANCE.getBooleanLiteralValue();

		/**
		 * The meta object literal for the '<em><b>Is True</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute BOOLEAN_LITERAL_VALUE__IS_TRUE = eINSTANCE.getBooleanLiteralValue_IsTrue();

        /**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.NullLiteralValueImpl <em>Null Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.NullLiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getNullLiteralValue()
		 * @generated
		 */
		EClass NULL_LITERAL_VALUE = eINSTANCE.getNullLiteralValue();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.EmptyLiteralValueImpl <em>Empty Literal Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.EmptyLiteralValueImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getEmptyLiteralValue()
		 * @generated
		 */
		EClass EMPTY_LITERAL_VALUE = eINSTANCE.getEmptyLiteralValue();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DaoFeatureImpl <em>Dao Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DaoFeatureImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDaoFeature()
		 * @generated
		 */
		EClass DAO_FEATURE = eINSTANCE.getDaoFeature();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO_FEATURE__ATTRIBUTE = eINSTANCE.getDaoFeature_Attribute();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DaoImpl <em>Dao</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DaoImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDao()
		 * @generated
		 */
		EClass DAO = eINSTANCE.getDao();

		/**
		 * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__ENTITY = eINSTANCE.getDao_Entity();

		/**
		 * The meta object literal for the '<em><b>Table Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DAO__TABLE_NAME = eINSTANCE.getDao_TableName();

		/**
		 * The meta object literal for the '<em><b>Discriminator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DAO__DISCRIMINATOR = eINSTANCE.getDao_Discriminator();

		/**
		 * The meta object literal for the '<em><b>Qualifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DAO__QUALIFIER = eINSTANCE.getDao_Qualifier();

		/**
		 * The meta object literal for the '<em><b>Data Base Constraints</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__DATA_BASE_CONSTRAINTS = eINSTANCE.getDao_DataBaseConstraints();

		/**
		 * The meta object literal for the '<em><b>Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__OPERATIONS = eINSTANCE.getDao_Operations();

		/**
		 * The meta object literal for the '<em><b>Query Operation</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__QUERY_OPERATION = eINSTANCE.getDao_QueryOperation();

		/**
		 * The meta object literal for the '<em><b>Columns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__COLUMNS = eINSTANCE.getDao_Columns();

		/**
		 * The meta object literal for the '<em><b>Many To One Associations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__MANY_TO_ONE_ASSOCIATIONS = eINSTANCE.getDao_ManyToOneAssociations();

		/**
		 * The meta object literal for the '<em><b>One To One Associations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__ONE_TO_ONE_ASSOCIATIONS = eINSTANCE.getDao_OneToOneAssociations();

		/**
		 * The meta object literal for the '<em><b>One To Many Associations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__ONE_TO_MANY_ASSOCIATIONS = eINSTANCE.getDao_OneToManyAssociations();

		/**
		 * The meta object literal for the '<em><b>Many To Many Associations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__MANY_TO_MANY_ASSOCIATIONS = eINSTANCE.getDao_ManyToManyAssociations();

		/**
		 * The meta object literal for the '<em><b>Primary Key Column</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__PRIMARY_KEY_COLUMN = eINSTANCE.getDao_PrimaryKeyColumn();

		/**
		 * The meta object literal for the '<em><b>Natural Key Columns</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__NATURAL_KEY_COLUMNS = eINSTANCE.getDao_NaturalKeyColumns();

		/**
		 * The meta object literal for the '<em><b>Version Column</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__VERSION_COLUMN = eINSTANCE.getDao_VersionColumn();

		/**
		 * The meta object literal for the '<em><b>Primary Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__PRIMARY_KEY = eINSTANCE.getDao_PrimaryKey();

		/**
		 * The meta object literal for the '<em><b>Natural Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DAO__NATURAL_KEY = eINSTANCE.getDao_NaturalKey();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.QueryOperationImpl <em>Query Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.QueryOperationImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryOperation()
		 * @generated
		 */
		EClass QUERY_OPERATION = eINSTANCE.getQueryOperation();

		/**
		 * The meta object literal for the '<em><b>Query Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_OPERATION__QUERY_PARAMETERS = eINSTANCE.getQueryOperation_QueryParameters();

		/**
		 * The meta object literal for the '<em><b>Statement</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_OPERATION__STATEMENT = eINSTANCE.getQueryOperation_Statement();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.QueryParameterImpl <em>Query Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.QueryParameterImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getQueryParameter()
		 * @generated
		 */
		EClass QUERY_PARAMETER = eINSTANCE.getQueryParameter();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_PARAMETER__ATTRIBUTE = eINSTANCE.getQueryParameter_Attribute();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ColumnImpl <em>Column</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ColumnImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getColumn()
		 * @generated
		 */
		EClass COLUMN = eINSTANCE.getColumn();

		/**
		 * The meta object literal for the '<em><b>Column Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COLUMN__COLUMN_NAME = eINSTANCE.getColumn_ColumnName();

		/**
		 * The meta object literal for the '<em><b>User Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLUMN__USER_TYPE = eINSTANCE.getColumn_UserType();

		/**
		 * The meta object literal for the '<em><b>Column Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLUMN__COLUMN_TYPE = eINSTANCE.getColumn_ColumnType();

		/**
		 * The meta object literal for the '<em><b>Columns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COLUMN__COLUMNS = eINSTANCE.getColumn_Columns();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl <em>Many To One</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ManyToOneImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getManyToOne()
		 * @generated
		 */
		EClass MANY_TO_ONE = eINSTANCE.getManyToOne();

		/**
		 * The meta object literal for the '<em><b>Column Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MANY_TO_ONE__COLUMN_NAME = eINSTANCE.getManyToOne_ColumnName();

		/**
		 * The meta object literal for the '<em><b>User Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MANY_TO_ONE__USER_TYPE = eINSTANCE.getManyToOne_UserType();

		/**
		 * The meta object literal for the '<em><b>Sql Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MANY_TO_ONE__SQL_TYPE = eINSTANCE.getManyToOne_SqlType();

		/**
		 * The meta object literal for the '<em><b>Columns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MANY_TO_ONE__COLUMNS = eINSTANCE.getManyToOne_Columns();

		/**
		 * The meta object literal for the '<em><b>Derived</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MANY_TO_ONE__DERIVED = eINSTANCE.getManyToOne_Derived();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.OneToOneImpl <em>One To One</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.OneToOneImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getOneToOne()
		 * @generated
		 */
		EClass ONE_TO_ONE = eINSTANCE.getOneToOne();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.OneToManyImpl <em>One To Many</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.OneToManyImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getOneToMany()
		 * @generated
		 */
		EClass ONE_TO_MANY = eINSTANCE.getOneToMany();

		/**
		 * The meta object literal for the '<em><b>Column Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ONE_TO_MANY__COLUMN_NAME = eINSTANCE.getOneToMany_ColumnName();

		/**
		 * The meta object literal for the '<em><b>Columns</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ONE_TO_MANY__COLUMNS = eINSTANCE.getOneToMany_Columns();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ManyToManyImpl <em>Many To Many</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ManyToManyImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getManyToMany()
		 * @generated
		 */
		EClass MANY_TO_MANY = eINSTANCE.getManyToMany();

		/**
		 * The meta object literal for the '<em><b>Table Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MANY_TO_MANY__TABLE_NAME = eINSTANCE.getManyToMany_TableName();

		/**
		 * The meta object literal for the '<em><b>Column Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MANY_TO_MANY__COLUMN_NAME = eINSTANCE.getManyToMany_ColumnName();

		/**
		 * The meta object literal for the '<em><b>Inverse</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MANY_TO_MANY__INVERSE = eINSTANCE.getManyToMany_Inverse();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.PresentableFeatureImpl <em>Presentable Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.PresentableFeatureImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getPresentableFeature()
		 * @generated
		 */
		EClass PRESENTABLE_FEATURE = eINSTANCE.getPresentableFeature();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRESENTABLE_FEATURE__NAME = eINSTANCE.getPresentableFeature_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AliasedExpressionImpl <em>Aliased Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AliasedExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAliasedExpression()
		 * @generated
		 */
		EClass ALIASED_EXPRESSION = eINSTANCE.getAliasedExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ALIASED_EXPRESSION__EXPRESSION = eINSTANCE.getAliasedExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ALIASED_EXPRESSION__NAME = eINSTANCE.getAliasedExpression_Name();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.BinaryExpressionImpl <em>Binary Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.BinaryExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getBinaryExpression()
		 * @generated
		 */
		EClass BINARY_EXPRESSION = eINSTANCE.getBinaryExpression();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BINARY_EXPRESSION__LEFT = eINSTANCE.getBinaryExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BINARY_EXPRESSION__OPERATOR = eINSTANCE.getBinaryExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BINARY_EXPRESSION__RIGHT = eINSTANCE.getBinaryExpression_Right();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.NotExpressionImpl <em>Not Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.NotExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getNotExpression()
		 * @generated
		 */
		EClass NOT_EXPRESSION = eINSTANCE.getNotExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOT_EXPRESSION__EXPRESSION = eINSTANCE.getNotExpression_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.InExpressionImpl <em>In Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.InExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getInExpression()
		 * @generated
		 */
		EClass IN_EXPRESSION = eINSTANCE.getInExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IN_EXPRESSION__EXPRESSION = eINSTANCE.getInExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Not</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_EXPRESSION__NOT = eINSTANCE.getInExpression_Not();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IN_EXPRESSION__OPERATOR = eINSTANCE.getInExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>In</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IN_EXPRESSION__IN = eINSTANCE.getInExpression_In();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.BetweenExpressionImpl <em>Between Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.BetweenExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getBetweenExpression()
		 * @generated
		 */
		EClass BETWEEN_EXPRESSION = eINSTANCE.getBetweenExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BETWEEN_EXPRESSION__EXPRESSION = eINSTANCE.getBetweenExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Not</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BETWEEN_EXPRESSION__NOT = eINSTANCE.getBetweenExpression_Not();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BETWEEN_EXPRESSION__OPERATOR = eINSTANCE.getBetweenExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BETWEEN_EXPRESSION__LEFT = eINSTANCE.getBetweenExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BETWEEN_EXPRESSION__RIGHT = eINSTANCE.getBetweenExpression_Right();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.LikeExpressionImpl <em>Like Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.LikeExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getLikeExpression()
		 * @generated
		 */
		EClass LIKE_EXPRESSION = eINSTANCE.getLikeExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIKE_EXPRESSION__EXPRESSION = eINSTANCE.getLikeExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Not</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIKE_EXPRESSION__NOT = eINSTANCE.getLikeExpression_Not();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIKE_EXPRESSION__OPERATOR = eINSTANCE.getLikeExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Like</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIKE_EXPRESSION__LIKE = eINSTANCE.getLikeExpression_Like();

		/**
		 * The meta object literal for the '<em><b>Escape</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIKE_EXPRESSION__ESCAPE = eINSTANCE.getLikeExpression_Escape();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.MemberOfExpressionImpl <em>Member Of Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.MemberOfExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getMemberOfExpression()
		 * @generated
		 */
		EClass MEMBER_OF_EXPRESSION = eINSTANCE.getMemberOfExpression();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_OF_EXPRESSION__EXPRESSION = eINSTANCE.getMemberOfExpression_Expression();

		/**
		 * The meta object literal for the '<em><b>Not</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER_OF_EXPRESSION__NOT = eINSTANCE.getMemberOfExpression_Not();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER_OF_EXPRESSION__OPERATOR = eINSTANCE.getMemberOfExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Member Of</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER_OF_EXPRESSION__MEMBER_OF = eINSTANCE.getMemberOfExpression_MemberOf();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.UnaryExpressionImpl <em>Unary Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.UnaryExpressionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getUnaryExpression()
		 * @generated
		 */
		EClass UNARY_EXPRESSION = eINSTANCE.getUnaryExpression();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UNARY_EXPRESSION__OPERATOR = eINSTANCE.getUnaryExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UNARY_EXPRESSION__EXPRESSION = eINSTANCE.getUnaryExpression_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl <em>Data Base Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDataBaseConstraint()
		 * @generated
		 */
		EClass DATA_BASE_CONSTRAINT = eINSTANCE.getDataBaseConstraint();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_BASE_CONSTRAINT__TYPE = eINSTANCE.getDataBaseConstraint_Type();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATA_BASE_CONSTRAINT__NAME = eINSTANCE.getDataBaseConstraint_Name();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_BASE_CONSTRAINT__ATTRIBUTES = eINSTANCE.getDataBaseConstraint_Attributes();

		/**
		 * The meta object literal for the '<em><b>Resolved Attribute List</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_BASE_CONSTRAINT__RESOLVED_ATTRIBUTE_LIST = eINSTANCE.getDataBaseConstraint_ResolvedAttributeList();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributeImpl <em>Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributeImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE = eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '<em><b>Identifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__IDENTIFIER = eINSTANCE.getAttribute_Identifier();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__VERSION = eINSTANCE.getAttribute_Version();

		/**
		 * The meta object literal for the '<em><b>Composition</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__COMPOSITION = eINSTANCE.getAttribute_Composition();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__TYPE = eINSTANCE.getAttribute_Type();

		/**
		 * The meta object literal for the '<em><b>Many</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__MANY = eINSTANCE.getAttribute_Many();

		/**
		 * The meta object literal for the '<em><b>Default Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__DEFAULT_VALUE = eINSTANCE.getAttribute_DefaultValue();

		/**
		 * The meta object literal for the '<em><b>Opposite</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__OPPOSITE = eINSTANCE.getAttribute_Opposite();

		/**
		 * The meta object literal for the '<em><b>Attribut Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__ATTRIBUT_PROPERTIES = eINSTANCE.getAttribute_AttributProperties();

		/**
		 * The meta object literal for the '<em><b>Sort Order</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__SORT_ORDER = eINSTANCE.getAttribute_SortOrder();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__DATA_TYPE = eINSTANCE.getAttribute_DataType();

		/**
		 * The meta object literal for the '<em><b>Opposite Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__OPPOSITE_REFERENCE = eINSTANCE.getAttribute_OppositeReference();

		/**
		 * The meta object literal for the '<em><b>Data Type Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__DATA_TYPE_NAME = eINSTANCE.getAttribute_DataTypeName();

		/**
		 * The meta object literal for the '<em><b>Reference</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__REFERENCE = eINSTANCE.getAttribute_Reference();

		/**
		 * The meta object literal for the '<em><b>Resolved Attribute List</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__RESOLVED_ATTRIBUTE_LIST = eINSTANCE.getAttribute_ResolvedAttributeList();

		/**
		 * The meta object literal for the '<em><b>Read Only</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__READ_ONLY = eINSTANCE.getAttribute_ReadOnly();

		/**
		 * The meta object literal for the '<em><b>Required</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__REQUIRED = eINSTANCE.getAttribute_Required();

		/**
		 * The meta object literal for the '<em><b>Derived</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__DERIVED = eINSTANCE.getAttribute_Derived();

		/**
		 * The meta object literal for the '<em><b>Transient</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__TRANSIENT = eINSTANCE.getAttribute_Transient();

		/**
		 * The meta object literal for the '<em><b>Incrementer Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__INCREMENTER_REFERENCE = eINSTANCE.getAttribute_IncrementerReference();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributeFlagImpl <em>Attribute Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributeFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeFlag()
		 * @generated
		 */
		EClass ATTRIBUTE_FLAG = eINSTANCE.getAttributeFlag();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ExpressionFlagImpl <em>Expression Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ExpressionFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getExpressionFlag()
		 * @generated
		 */
		EClass EXPRESSION_FLAG = eINSTANCE.getExpressionFlag();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXPRESSION_FLAG__EXPRESSION = eINSTANCE.getExpressionFlag_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.RequiredFlagImpl <em>Required Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.RequiredFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getRequiredFlag()
		 * @generated
		 */
		EClass REQUIRED_FLAG = eINSTANCE.getRequiredFlag();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ReadOnlyFlagImpl <em>Read Only Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ReadOnlyFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getReadOnlyFlag()
		 * @generated
		 */
		EClass READ_ONLY_FLAG = eINSTANCE.getReadOnlyFlag();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AvailableFlagImpl <em>Available Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AvailableFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAvailableFlag()
		 * @generated
		 */
		EClass AVAILABLE_FLAG = eINSTANCE.getAvailableFlag();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.DerivedFlagImpl <em>Derived Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.DerivedFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDerivedFlag()
		 * @generated
		 */
		EClass DERIVED_FLAG = eINSTANCE.getDerivedFlag();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DERIVED_FLAG__EXPRESSION = eINSTANCE.getDerivedFlag_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.TransientFlagImpl <em>Transient Flag</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.TransientFlagImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getTransientFlag()
		 * @generated
		 */
		EClass TRANSIENT_FLAG = eINSTANCE.getTransientFlag();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSIENT_FLAG__EXPRESSION = eINSTANCE.getTransientFlag_Expression();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributePropertyImpl <em>Attribute Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributePropertyImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeProperty()
		 * @generated
		 */
		EClass ATTRIBUTE_PROPERTY = eINSTANCE.getAttributeProperty();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributeValidationPropertyImpl <em>Attribute Validation Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributeValidationPropertyImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeValidationProperty()
		 * @generated
		 */
		EClass ATTRIBUTE_VALIDATION_PROPERTY = eINSTANCE.getAttributeValidationProperty();

		/**
		 * The meta object literal for the '<em><b>Constraints</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS = eINSTANCE.getAttributeValidationProperty_Constraints();

		/**
		 * The meta object literal for the '<em><b>Format</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_VALIDATION_PROPERTY__FORMAT = eINSTANCE.getAttributeValidationProperty_Format();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl <em>Attribute Text Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeTextProperty()
		 * @generated
		 */
		EClass ATTRIBUTE_TEXT_PROPERTY = eINSTANCE.getAttributeTextProperty();

		/**
		 * The meta object literal for the '<em><b>Label Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT = eINSTANCE.getAttributeTextProperty_LabelText();

		/**
		 * The meta object literal for the '<em><b>Tooltip Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT = eINSTANCE.getAttributeTextProperty_TooltipText();

		/**
		 * The meta object literal for the '<em><b>Unit Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT = eINSTANCE.getAttributeTextProperty_UnitText();

		/**
		 * The meta object literal for the '<em><b>Unit Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE = eINSTANCE.getAttributeTextProperty_UnitAttribute();

		/**
		 * The meta object literal for the '<em><b>Hstore Column</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
		 * @generated
		 */
        EAttribute ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN = eINSTANCE.getAttributeTextProperty_HstoreColumn();

        /**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl <em>Attribute Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributeGroupImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeGroup()
		 * @generated
		 */
		EClass ATTRIBUTE_GROUP = eINSTANCE.getAttributeGroup();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_GROUP__KEY = eINSTANCE.getAttributeGroup_Key();

		/**
		 * The meta object literal for the '<em><b>Unique</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_GROUP__UNIQUE = eINSTANCE.getAttributeGroup_Unique();

		/**
		 * The meta object literal for the '<em><b>Filter</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_GROUP__FILTER = eINSTANCE.getAttributeGroup_Filter();

		/**
		 * The meta object literal for the '<em><b>Sortorder</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_GROUP__SORTORDER = eINSTANCE.getAttributeGroup_Sortorder();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_GROUP__NAME = eINSTANCE.getAttributeGroup_Name();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_GROUP__ATTRIBUTES = eINSTANCE.getAttributeGroup_Attributes();

		/**
		 * The meta object literal for the '<em><b>Resolved Attribute List</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_GROUP__RESOLVED_ATTRIBUTE_LIST = eINSTANCE.getAttributeGroup_ResolvedAttributeList();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl <em>Attribute Sort Order</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getAttributeSortOrder()
		 * @generated
		 */
		EClass ATTRIBUTE_SORT_ORDER = eINSTANCE.getAttributeSortOrder();

		/**
		 * The meta object literal for the '<em><b>Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_SORT_ORDER__ATTRIBUTE = eINSTANCE.getAttributeSortOrder_Attribute();

		/**
		 * The meta object literal for the '<em><b>Asc</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_SORT_ORDER__ASC = eINSTANCE.getAttributeSortOrder_Asc();

		/**
		 * The meta object literal for the '<em><b>Desc</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_SORT_ORDER__DESC = eINSTANCE.getAttributeSortOrder_Desc();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.PropertyImpl <em>Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.PropertyImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getProperty()
		 * @generated
		 */
		EClass PROPERTY = eINSTANCE.getProperty();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY__TYPE = eINSTANCE.getProperty_Type();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__NAME = eINSTANCE.getProperty_Name();

		/**
		 * The meta object literal for the '<em><b>Default Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__DEFAULT_VALUE = eINSTANCE.getProperty_DefaultValue();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.impl.ApplicationSessionImpl <em>Application Session</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.impl.ApplicationSessionImpl
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getApplicationSession()
		 * @generated
		 */
		EClass APPLICATION_SESSION = eINSTANCE.getApplicationSession();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference APPLICATION_SESSION__PROPERTIES = eINSTANCE.getApplicationSession_Properties();

		/**
		 * The meta object literal for the '<em><b>Functions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference APPLICATION_SESSION__FUNCTIONS = eINSTANCE.getApplicationSession_Functions();

		/**
		 * The meta object literal for the '<em><b>Conditions Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference APPLICATION_SESSION__CONDITIONS_BLOCK = eINSTANCE.getApplicationSession_ConditionsBlock();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.CrudOperationType <em>Crud Operation Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.CrudOperationType
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getCrudOperationType()
		 * @generated
		 */
		EEnum CRUD_OPERATION_TYPE = eINSTANCE.getCrudOperationType();

		/**
		 * The meta object literal for the '{@link org.openxma.dsl.dom.model.DataBaseConstraintType <em>Data Base Constraint Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.openxma.dsl.dom.model.DataBaseConstraintType
		 * @see org.openxma.dsl.dom.model.impl.DomPackageImpl#getDataBaseConstraintType()
		 * @generated
		 */
		EEnum DATA_BASE_CONSTRAINT_TYPE = eINSTANCE.getDataBaseConstraintType();

	}

} //DomPackage
