/*
 * generated by Xtext
 */
package org.openxma.dsl.dom.formatting;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;

/**
 * This class contains custom formatting description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation/latest/xtext.html#formatting on how and when to use it
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
public class DomDslFormatter extends AbstractDeclarativeFormatter {

    @Override
    public void configureFormatting(FormattingConfig c) {
        
        c.setWrappedLineIndentation(2);
        c.setAutoLinewrap(120);
        
        org.openxma.dsl.dom.services.DomDslGrammarAccess f = (org.openxma.dsl.dom.services.DomDslGrammarAccess) getGrammarAccess();

        c.setLinewrap(0, 1, 2).before(f.getSL_COMMENTRule());
        c.setLinewrap(0, 1, 2).before(f.getML_COMMENTRule());
        c.setLinewrap(0, 1, 1).after(f.getML_COMMENTRule());
        
        // qualified names
        c.setNoSpace().around(f.getQualifiedNameAccess().getFullStopKeyword_1_0());

        // validatorref
        c.setNoSpace().around(f.getValidatorReferenceAccess().getLeftParenthesisKeyword_1_0());
        c.setNoSpace().around(f.getValidatorReferenceAccess().getCommaKeyword_1_1_1_0());
        c.setNoSpace().before(f.getValidatorReferenceAccess().getRightParenthesisKeyword_1_2());

        // namespace
        c.setLinewrap(1).after(f.getModelAccess().getNameQualifiedNameParserRuleCall_1_1_0());
        // import
        c.setLinewrap(1, 1, 2).before(f.getImportAccess().getRule());
        c.setLinewrap(1, 1, 1).after(f.getImportAccess().getRule());
        
        // complex types
        c.setLinewrap(2).before(f.getModelElementAccess().getComplexTypeParserRuleCall_2());

        // entity
        c.setLinewrap(1).before(f.getEntityAccess().getEntityKeyword_0());
        c.setLinewrap(1).before(f.getEntityAccess().getRightCurlyBracketKeyword_6());
        c.setIndentation(f.getEntityAccess().getLeftCurlyBracketKeyword_3(), f.getEntityAccess().getRightCurlyBracketKeyword_6());

        // attribute
        c.setNoSpace().around(f.getAttributeAccess().getAttributeAction_0());
        c.setNoSpace().before(f.getAttributeAccess().getManyLeftSquareBracketRightSquareBracketKeyword_3_0());
        c.setLinewrap(1).before(f.getAttributeAccess().getRule());
        c.setLinewrap(1).before(f.getRequiredFlagAccess().getRequiredKeyword_0());
        setIndentationInclusive(c, f.getRequiredFlagAccess().getRequiredKeyword_0());
        c.setLinewrap(1).before(f.getReadOnlyFlagAccess().getReadonlyKeyword_0());
        setIndentationInclusive(c, f.getReadOnlyFlagAccess().getReadonlyKeyword_0());
        c.setLinewrap(1).before(f.getAvailableFlagAccess().getAvailableKeyword_0());
        setIndentationInclusive(c, f.getAvailableFlagAccess().getAvailableKeyword_0());
        c.setLinewrap(1).before(f.getDerivedFlagAccess().getDerivedKeyword_0());
        setIndentationInclusive(c, f.getDerivedFlagAccess().getDerivedKeyword_0());
        c.setLinewrap(1).before(f.getTransientFlagAccess().getTransientKeyword_0());
        setIndentationInclusive(c, f.getTransientFlagAccess().getTransientKeyword_0());
        // attribute text properties
        c.setLinewrap(1).before(f.getAttributeTextPropertyAccess().getTitleKeyword_0_0());
        setIndentationInclusive(c, f.getAttributeTextPropertyAccess().getTitleKeyword_0_0());
        c.setLinewrap(1).before(f.getAttributeTextPropertyAccess().getDescriptionKeyword_1_0());
        setIndentationInclusive(c, f.getAttributeTextPropertyAccess().getDescriptionKeyword_1_0());
        c.setLinewrap(1).before(f.getAttributeTextPropertyAccess().getUnitKeyword_2_0());
        setIndentationInclusive(c, f.getAttributeTextPropertyAccess().getUnitKeyword_2_0());
        // attribute validation properties
        c.setLinewrap(1).before(f.getAttributeValidationPropertyAccess().getConstraintsKeyword_0_0());
        setIndentationInclusive(c, f.getAttributeValidationPropertyAccess().getConstraintsKeyword_0_0());
        c.setLinewrap(1).before(f.getAttributeValidationPropertyAccess().getFormatKeyword_1_0());
        setIndentationInclusive(c, f.getAttributeValidationPropertyAccess().getFormatKeyword_1_0());

        // dataType
        c.setNoSpace().around(f.getDataTypeAndTypeParameterAccess().getLeftParenthesisKeyword_1_0());
        c.setNoSpace().before(f.getDataTypeAndTypeParameterAccess().getRightParenthesisKeyword_1_2());
        c.setNoSpace().around(f.getDataTypeAndTypeParameterAccess().getCommaKeyword_1_1_1_0());

        // attributeGroup
        c.setLinewrap(2).before(f.getAttributeGroupAccess().getKeyKeyKeyword_0_0_0());
        c.setLinewrap(2).before(f.getAttributeGroupAccess().getFilterFilterKeyword_0_2_0());
        c.setLinewrap(2).before(f.getAttributeGroupAccess().getSortorderSortorderKeyword_0_3_0());
        c.setLinewrap(2).before(f.getAttributeGroupAccess().getUniqueUniqueKeyword_0_1_0());
        c.setNoSpace().around(f.getAttributeGroupAccess().getCommaKeyword_4_0());
        c.setNoSpace().after(f.getAttributeGroupAccess().getLeftParenthesisKeyword_2());
        c.setNoSpace().before(f.getAttributeGroupAccess().getRightParenthesisKeyword_5());

        // operation
        c.setLinewrap(1).before(f.getOperationAccess().getOperationKeyword_0());
        c.setNoSpace().before(f.getOperationAccess().getLeftParenthesisKeyword_3());
        c.setNoSpace().around(f.getOperationAccess().getCommaKeyword_4_1_0());
        c.setNoSpace().before(f.getOperationAccess().getRightParenthesisKeyword_5());
        c.setNoSpace().before(f.getOperationAccess().getManyLeftSquareBracketRightSquareBracketKeyword_1_1_0());
        c.setNoSpace().after(f.getOperationAccess().getLeftParenthesisKeyword_3());

        // parameter
        c.setNoSpace().before(f.getParameterAccess().getTypeTypeCrossReference_0_0());
        c.setNoSpace().before(f.getParameterAccess().getManyLeftSquareBracketRightSquareBracketKeyword_1_0());

        // dao
        c.setLinewrap(2).before(f.getModelElementAccess().getDaoParserRuleCall_3());
        c.setLinewrap(1).before(f.getDataBaseConstraintAccess().getTypeDataBaseConstraintTypeEnumRuleCall_0_0());
        c.setNoSpace().after(f.getDataBaseConstraintAccess().getLeftParenthesisKeyword_2());
        c.setNoSpace().before(f.getDataBaseConstraintAccess().getRightParenthesisKeyword_5());
        c.setNoSpace().before(f.getDataBaseConstraintAccess().getCommaKeyword_4_0());
        c.setNoSpace().after(f.getDataBaseConstraintAccess().getCommaKeyword_4_0());
        c.setLinewrap(1).before(f.getDaoAccess().getTableKeyword_5_0());
        c.setLinewrap(1).before(f.getDaoAccess().getQualifierKeyword_7_0());
        c.setLinewrap(1).before(f.getDaoAccess().getDiscriminatorKeyword_6_0());
        c.setLinewrap(1).before(f.getColumnAccess().getColumnKeyword_0());
        c.setLinewrap(1).before(f.getManyToManyAccess().getManyToManyKeyword_0());
        c.setLinewrap(1).before(f.getOneToManyAccess().getOneToManyKeyword_0());
        c.setIndentation(f.getOneToManyAccess().getLeftCurlyBracketKeyword_3_0(), f.getOneToManyAccess().getRightCurlyBracketKeyword_3_2());
        c.setLinewrap(1).before(f.getOneToManyAccess().getRightCurlyBracketKeyword_3_2());
        c.setLinewrap(1).before(f.getOneToOneAccess().getOneToOneKeyword_0());
        c.setLinewrap(1).before(f.getManyToOneAccess().getManyToOneKeyword_0());
        c.setIndentation(f.getManyToOneAccess().getLeftCurlyBracketKeyword_5_0(), f.getManyToOneAccess().getRightCurlyBracketKeyword_5_2());
        c.setLinewrap(1).before(f.getManyToOneAccess().getRightCurlyBracketKeyword_5_2());
        c.setLinewrap(1).before(f.getDaoAccess().getRightCurlyBracketKeyword_10());
        c.setIndentation(f.getDaoAccess().getLeftCurlyBracketKeyword_4(), f.getDaoAccess().getRightCurlyBracketKeyword_10());
        c.setNoSpace().around(f.getManyToManyAccess().getFullStopKeyword_4_0());

        // dataView
        c.setLinewrap(1).before(f.getFeatureReferenceAccess().getSourceEntityCrossReference_0_0());
        c.setLinewrap(1).before(f.getDataViewAccess().getRightCurlyBracketKeyword_5());
        c.setIndentation(f.getDataViewAccess().getLeftCurlyBracketKeyword_3(), f.getDataViewAccess().getRightCurlyBracketKeyword_5());
        c.setNoSpace().after(f.getFeatureReferenceAccess().getLessThanSignKeyword_1_0_1_0_1_0());
        c.setNoSpace().before(f.getFeatureReferenceAccess().getLessThanSignKeyword_1_0_1_0_1_0());
//        c.setNoSpace().after(f.getFeatureReferenceAccess().getGreaterThanSignKeyword_1_0_1_0_1_2());
        c.setNoSpace().before(f.getFeatureReferenceAccess().getGreaterThanSignKeyword_1_0_1_0_1_2());
        c.setNoSpace().around(f.getFeatureReferenceAccess().getFullStopKeyword_1_0_0());
        c.setNoSpace().before(f.getFeatureReferenceAccess().getAllFullStopAsteriskKeyword_1_1_0());

        // valueObject
        c.setIndentation(f.getValueObjectAccess().getLeftCurlyBracketKeyword_2(), f.getValueObjectAccess().getRightCurlyBracketKeyword_4());
        c.setLinewrap(1).before(f.getValueObjectAccess().getRightCurlyBracketKeyword_4());

        c.setLinewrap(2).before(f.getModelElementAccess().getMapperParserRuleCall_4());
        c.setIndentation(f.getMapperAccess().getLeftCurlyBracketKeyword_6(), f.getMapperAccess().getRightCurlyBracketKeyword_8());
        c.setLinewrap(1).before(f.getMapperAccess().getRightCurlyBracketKeyword_8());
        c.setLinewrap(1).before(f.getMapperAccess().getPropertyMappingsAssignment_7());
        
        // service
        c.setLinewrap(2).before(f.getModelElementAccess().getServiceParserRuleCall_1());
        c.setLinewrap(1).before(f.getServiceAccess().getOperationsOperationParserRuleCall_4_0_0());
        c.setLinewrap(1).before(f.getDelegateOperationAccess().getGroup());
        c.setLinewrap(1).before(f.getDelegateOperationAccess().getDelegateOperationAction_0());
        c.setLinewrap(1).before(f.getServiceAccess().getRightCurlyBracketKeyword_5());
        c.setIndentation(f.getServiceAccess().getLeftCurlyBracketKeyword_3(), f.getServiceAccess().getRightCurlyBracketKeyword_5());
        c.setNoSpace().around(f.getServiceAccess().getCommaKeyword_2_2_0());
        c.setNoSpace().around(f.getDelegateOperationAccess().getFullStopKeyword_3());
        c.setNoSpace().before(f.getDelegateOperationAccess().getLeftParenthesisKeyword_4_1_1_0());
        c.setNoSpace().before(f.getDelegateOperationAccess().getOperationDaoOperationCrossReference_4_0_0());
        c.setNoSpace().around(f.getDelegateOperationAccess().getViewParameterDataViewCrossReference_4_1_1_1_0());
        c.setLinewrap(1).before(f.getDelegateOperationAccess().getFilterKeyword_6_0());
        setIndentationInclusive(c, f.getDelegateOperationAccess().getFilterKeyword_6_0());

        // context
        c.setLinewrap(2).before(f.getModelElementAccess().getApplicationSessionParserRuleCall_0());
        c.setIndentation(f.getApplicationSessionAccess().getLeftCurlyBracketKeyword_2(), f.getApplicationSessionAccess().getRightCurlyBracketKeyword_6());
        c.setLinewrap(1).before(f.getApplicationSessionAccess().getRightCurlyBracketKeyword_6());
        c.setLinewrap(1).before(f.getPropertyAccess().getPropertyKeyword_0());
        c.setLinewrap(1).before(f.getSessionFunctionAccess().getFunctionKeyword_0());
        c.setLinewrap(1).before(f.getConditionsBlockAccess().getConditionsKeyword_1());
        c.setLinewrap(1).before(f.getStatusFlagAccess().getNameIDTerminalRuleCall_0_0());
        c.setIndentation(f.getConditionsBlockAccess().getLeftCurlyBracketKeyword_2(), f.getConditionsBlockAccess().getRightCurlyBracketKeyword_4());
        c.setLinewrap(1).before(f.getConditionsBlockAccess().getRightCurlyBracketKeyword_4());

        c.setNoSpace().around(f.getSessionFunctionAccess().getLeftParenthesisKeyword_3());
        c.setNoSpace().around(f.getSessionFunctionAccess().getRightParenthesisKeyword_6());

        // expression
        c.setNoSpace().after(f.getParenExprAccess().getLeftParenthesisKeyword_0());
        c.setNoSpace().before(f.getParenExprAccess().getRightParenthesisKeyword_2());
        c.setNoSpace().around(f.getCallAccess().getLeftParenthesisKeyword_1());
        c.setNoSpace().before(f.getCallAccess().getRightParenthesisKeyword_3());

        // queryOperation
        c.setLinewrap(1).before(f.getQueryOperationAccess().getOperationKeyword_0());
        c.setNoSpace().before(f.getQueryOperationAccess().getLeftParenthesisKeyword_3());
        c.setNoSpace().around(f.getQueryOperationAccess().getCommaKeyword_4_1_0());
        c.setNoSpace().before(f.getQueryOperationAccess().getRightParenthesisKeyword_5());
        c.setNoSpace().before(f.getQueryOperationAccess().getManyLeftSquareBracketRightSquareBracketKeyword_1_1_0());
        c.setNoSpace().after(f.getQueryOperationAccess().getLeftParenthesisKeyword_3());
        // c.setNoSpace().before(f.getQueryOperationAccess().getColonKeyword_6());

        // qlStatement
        setIndentationInclusive(c, f.getJoinAccess().getGroup());
        // setIndentation(c, f.getJoinAccess().getRule());
        // setIndentation(c, f.getInsertStatementAccess().getInsertKeyword_0());
//        setIndentation(c, f.getUpdateStatementAccess().getUpdateKeyword_0());
        // setIndentation(c, f.getUpdateStatementAccess().getSetKeyword_6());
        setIndentationInclusive(c, f.getUpdateStatementAccess().getSetKeyword_6());
//        setIndentation(c, f.getUpdateStatementAccess().getWhereKeyword_9_0());
        // setIndentation(c, f.getUpdateStatementAccess().getAssignmentPropertyAssignmentParserRuleCall_7_0());
//        setIndentation(c, f.getUpdateStatementAccess().getAssignmentPropertyAssignmentParserRuleCall_7_0());
//        setIndentation(c, f.getUpdateStatementAccess().getAssignmentPropertyAssignmentParserRuleCall_8_1_0());
        // setIndentation(c, f.getUpdateStatementAccess().getAssignmentPropertyAssignmentParserRuleCall_8_1_0());
        setIndentationInclusive(c, f.getUpdateStatementAccess().getAssignmentAssignment_7());
         setIndentationInclusive(c, f.getUpdateStatementAccess().getAssignmentAssignment_8_1());
         setIndentationInclusive(c, f.getUpdateStatementAccess().getWhereAssignment_9_1());
         setIndentationInclusive(c, f.getDeleteStatementAccess().getWhereAssignment_5_1());

        setIndentationInclusive(c, f.getQlStatementRule());
//        setIndentation(c, f.getDeleteStatementAccess().getDeleteKeyword_0());
//        setIndentation(c, f.getDeleteStatementAccess().getWhereKeyword_5_0());
//        setIndentation(c, f.getDeleteStatementAccess().getFromKeyword_1());
//        setIndentation(c, f.getSelectStatementAccess().getGroup_0());
//        setIndentation(c, f.getSelectStatementAccess().getFromKeyword_1_0());
//        setIndentation(c, f.getSelectStatementAccess().getWhereKeyword_2_0());
//        setIndentation(c, f.getSelectStatementAccess().getOrderKeyword_4_0());
//        setIndentation(c, f.getSelectStatementAccess().getGroupKeyword_3_0());
        
        setIndentationInclusive(c, f.getSelectStatementAccess().getFromAssignment_1_1());
        setIndentationInclusive(c, f.getSelectStatementAccess().getFromAssignment_1_2_1_1());
        
        setIndentationInclusive(c, f.getSelectStatementAccess().getWhereAssignment_2_1());
//        setIndentation(c, f.getSelectStatementAccess().getWhereExpressionParserRuleCall_2_1_0());
        setIndentationInclusive(c, f.getSelectStatementAccess().getGroupByAssignment_3_2());
        setIndentationInclusive(c, f.getSelectStatementAccess().getGroupByAssignment_3_3_1());
        setIndentationInclusive(c, f.getSelectStatementAccess().getHavingAssignment_3_4_1());
        
//        setIndentation(c, f.getSelectPropertiesAccess().getGroup());
        // setIndentation(c, f.getSelectPropertiesAccess().getRule());
        // setIndentation(c, f.getSelectPropertiesAccess().getRule());
//        setIndentation(c, f.getSelectPropertiesAccess().getPropertiesAliasedExpressionParserRuleCall_2_1_0());
        setIndentationInclusive(c, f.getSelectPropertiesAccess().getPropertiesAssignment_1());
        setIndentationInclusive(c, f.getSelectPropertiesAccess().getPropertiesAssignment_2_1());
//        setIndentation(c, f.getRelationalExpressionAccess().getLikeExpressionExpressionAction_1_3_0());
//        setIndentation(c, f.getLogicalAndExpressionAccess().getRightPrefixExpressionParserRuleCall_1_2_0());
//        setIndentation(c, f.getLogicalOrExpressionAccess().getRightAssignment_1_2());
//        setIndentation(c, f.getCallableStatementAccess().getCallKeyword_0());
//        setIndentation(c, f.getCallableStatementAccess().getReturnKeyword_6_0());
        setIndentationInclusive(c, f.getCallableStatementAccess().getOutParameterAssignment_6_1());
        setIndentationInclusive(c, f.getCallableStatementAccess().getOutParameterAssignment_6_2_1());

        c.setLinewrap(1).before(f.getJoinAccess().getRule());
        c.setLinewrap(1).before(f.getDeleteStatementAccess().getDeleteKeyword_0());
        c.setLinewrap(1).before(f.getDeleteStatementAccess().getWhereKeyword_5_0());
        c.setLinewrap(1).before(f.getUpdateStatementAccess().getUpdateKeyword_0());
        c.setLinewrap(1).after(f.getUpdateStatementAccess().getSetKeyword_6());
        c.setLinewrap(1).before(f.getUpdateStatementAccess().getWhereKeyword_9_0());
        c.setLinewrap(1).before(f.getUpdateStatementAccess().getAssignmentPropertyAssignmentParserRuleCall_8_1_0());
        c.setLinewrap(1).before(f.getInsertStatementAccess().getInsertKeyword_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getSelectKeyword_0_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getFromKeyword_1_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getWhereKeyword_2_0());
        c.setLinewrap(1).after(f.getSelectStatementAccess().getWhereKeyword_2_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getOrderKeyword_4_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getGroupKeyword_3_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getGroupByAssignment_3_2());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getGroupByAssignment_3_3_1());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getHavingKeyword_3_4_0());
        c.setLinewrap(1).before(f.getSelectStatementAccess().getHavingAssignment_3_4_1());
//        c.setLinewrap(1).before(f.getSelectPropertiesAccess().getRule());
//        c.setLinewrap(4).before(f.getSelectPropertiesAccess().getPropertiesAliasedExpressionParserRuleCall_1_0());
//        c.setLinewrap(5).after(f.getSelectPropertiesAccess().getCommaKeyword_2_0());
//        c.setLinewrap(6).before(f.getSelectPropertiesAccess().getPropertiesAliasedExpressionParserRuleCall_2_1_0());
        c.setLinewrap(1).before(f.getSelectPropertiesAccess().getPropertiesAssignment_1());
        c.setLinewrap(1).before(f.getSelectPropertiesAccess().getPropertiesAssignment_2_1());
        c.setLinewrap(1).after(f.getLogicalAndExpressionAccess().getOperatorAndKeyword_1_1_0());
        c.setLinewrap(1).after(f.getLogicalOrExpressionAccess().getOperatorOrKeyword_1_1_0());
        c.setLinewrap(1).before(f.getCallableStatementAccess().getCallKeyword_0());
        c.setLinewrap(1).before(f.getCallableStatementAccess().getReturnKeyword_6_0());
//        c.setLinewrap(1).after(f.getCallableStatementAccess().getReturnKeyword_6_0());
//        c.setLinewrap(1).after(f.getCallableStatementAccess().getCommaKeyword_6_2_0());
//        c.setLinewrap(1).before(f.getCallableStatementAccess().getOutParameterCallOutputParameterParserRuleCall_6_1_0());
        c.setLinewrap(1).before(f.getCallableStatementAccess().getOutParameterAssignment_6_2_1());

        c.setNoSpace().around(f.getJoinAccess().getFullStopKeyword_4());
        c.setNoSpace().around(f.getPropertyValueAccess().getFullStopKeyword_1_0());
        c.setNoSpace().before(f.getSelectPropertiesAccess().getCommaKeyword_2_0());
        c.setNoSpace().around(f.getSelectClassAccess().getCommaKeyword_4_0());
        c.setNoSpace().around(f.getAggregateFunctionAccess().getLeftParenthesisKeyword_0_1());
        c.setNoSpace().around(f.getAggregateFunctionAccess().getLeftParenthesisKeyword_1_1());
        c.setNoSpace().around(f.getSelectStatementAccess().getCommaKeyword_1_2_1_0());
        c.setNoSpace().around(f.getSelectClassAccess().getLeftParenthesisKeyword_2());
        c.setNoSpace().around(f.getSelectClassAccess().getRightParenthesisKeyword_5());
        c.setNoSpace().before(f.getSelectStatementAccess().getCommaKeyword_3_3_0());
        c.setNoSpace().around(f.getSelectStatementAccess().getCommaKeyword_4_3_0());
        c.setNoSpace().around(f.getFunctionCallAccess().getLeftParenthesisKeyword_1());
        c.setNoSpace().around(f.getFunctionCallAccess().getRightParenthesisKeyword_4());
        c.setNoSpace().before(f.getCallableStatementAccess().getCommaKeyword_4_1_0());
        c.setNoSpace().before(f.getCallableStatementAccess().getCommaKeyword_6_2_0());
        c.setNoSpace().before(f.getAggregateFunctionAccess().getRightParenthesisKeyword_0_3());
        c.setNoSpace().before(f.getAggregateFunctionAccess().getRightParenthesisKeyword_1_3());
        c.setNoSpace().before(f.getUpdateStatementAccess().getCommaKeyword_8_0());

        c.setNoSpace().around(f.getCallableStatementAccess().getLeftParenthesisKeyword_3());
        c.setNoSpace().before(f.getCallableStatementAccess().getRightParenthesisKeyword_5());
        c.setNoSpace().around(f.getCallOutputParameterAccess().getFullStopKeyword_3_0());
        c.setNoSpace().around(f.getCallInputParameterAccess().getFullStopKeyword_2_0());

        c.setNoSpace().after(f.getQueryParameterValueAccess().getColonKeyword_0());
        c.setNoSpace().around(f.getQueryParameterValueAccess().getFullStopKeyword_2_0());
        c.setNoSpace().after(f.getCollectionFunctionAccess().getLeftParenthesisKeyword_1());
//        c.setNoSpace().after(f.getSubQueryAccess().getLeftParenthesisKeyword_0());

        c.setNoSpace().before(f.getSubQueryAccess().getRightParenthesisKeyword_3());
        c.setNoSpace().before(f.getCollectionFunctionAccess().getRightParenthesisKeyword_3());
        
        c.setNoSpace().after(f.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_0());
        c.setNoSpace().before(f.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3());

        c.setIndentation(f.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_0(), f.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3());
        c.setIndentation(f.getSubQueryAccess().getLeftParenthesisKeyword_0(), f.getSubQueryAccess().getRightParenthesisKeyword_3());
        
    }

    private void setIndentationInclusive(FormattingConfig c, EObject element) {
        c.setIndentationIncrement().before(element);
        c.setIndentationDecrement().after(element);
        
    }

}
