/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.ConditionsBlock;
import org.openxma.dsl.core.model.Function;
import org.openxma.dsl.core.model.ModelElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Application Session</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.ApplicationSession#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ApplicationSession#getFunctions <em>Functions</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ApplicationSession#getConditionsBlock <em>Conditions Block</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getApplicationSession()
 * @model
 * @generated
 */
public interface ApplicationSession extends ModelElement {
	/**
	 * Returns the value of the '<em><b>Properties</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Property}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Properties</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Properties</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getApplicationSession_Properties()
	 * @model containment="true"
	 * @generated
	 */
	EList<Property> getProperties();

	/**
	 * Returns the value of the '<em><b>Functions</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.core.model.Function}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Functions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Functions</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getApplicationSession_Functions()
	 * @model containment="true"
	 * @generated
	 */
	EList<Function> getFunctions();

	/**
	 * Returns the value of the '<em><b>Conditions Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Conditions Block</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Conditions Block</em>' containment reference.
	 * @see #setConditionsBlock(ConditionsBlock)
	 * @see org.openxma.dsl.dom.DomPackage#getApplicationSession_ConditionsBlock()
	 * @model containment="true"
	 * @generated
	 */
	ConditionsBlock getConditionsBlock();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.ApplicationSession#getConditionsBlock <em>Conditions Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Conditions Block</em>' containment reference.
	 * @see #getConditionsBlock()
	 * @generated
	 */
	void setConditionsBlock(ConditionsBlock value);

} // ApplicationSession
