/**
 * <copyright> </copyright>
 * 
 * $Id: Attribute.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.DataTypeAndTypeParameter;
import org.openxma.dsl.core.model.IDocumentable;
import org.openxma.dsl.core.model.IncrementerReference;
import org.openxma.dsl.core.model.ReferenceableByXmadslVariable;
import org.openxma.dsl.core.model.Type;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Attribute</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isVersion <em>Version</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isComposition <em>Composition</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getType <em>Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isMany <em>Many</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getIncrementerReference <em>Incrementer Reference</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getDefaultValue <em>Default Value</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getOpposite <em>Opposite</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getAttributProperties <em>Attribut Properties</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getSortOrder <em>Sort Order</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getDataType <em>Data Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getOppositeReference <em>Opposite Reference</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getDataTypeName <em>Data Type Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#getResolvedAttributeList <em>Resolved Attribute List</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isReference <em>Reference</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isReadOnly <em>Read Only</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isRequired <em>Required</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isDerived <em>Derived</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Attribute#isTransient <em>Transient</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getAttribute()
 * @model
 * @generated
 */
public interface Attribute extends ReferenceableByXmadslVariable, QueryParameterReference, PresentableFeature, IDocumentable {
    /**
	 * Returns the value of the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Identifier</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Identifier</em>' attribute.
	 * @see #setIdentifier(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Identifier()
	 * @model
	 * @generated
	 */
    boolean isIdentifier();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#isIdentifier <em>Identifier</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identifier</em>' attribute.
	 * @see #isIdentifier()
	 * @generated
	 */
    void setIdentifier(boolean value);

    /**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Version</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Version()
	 * @model
	 * @generated
	 */
    boolean isVersion();

    /**
     * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#isVersion <em>Version</em>}' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @param value
     *            the new value of the '<em>Version</em>' attribute.
     * @see #isVersion()
     * @generated
     */
    void setVersion(boolean value);

    /**
	 * Returns the value of the '<em><b>Composition</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Composition</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Composition</em>' attribute.
	 * @see #setComposition(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Composition()
	 * @model
	 * @generated
	 */
    boolean isComposition();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#isComposition <em>Composition</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Composition</em>' attribute.
	 * @see #isComposition()
	 * @generated
	 */
    void setComposition(boolean value);

    /**
	 * Returns the value of the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Type</em>' containment reference isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' containment reference.
	 * @see #setType(DataTypeAndTypeParameter)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Type()
	 * @model containment="true"
	 * @generated
	 */
    DataTypeAndTypeParameter getType();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#getType <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' containment reference.
	 * @see #getType()
	 * @generated
	 */
    void setType(DataTypeAndTypeParameter value);

    /**
	 * Returns the value of the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Many</em>' attribute isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Many</em>' attribute.
	 * @see #setMany(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Many()
	 * @model
	 * @generated
	 */
    boolean isMany();

    /**
     * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#isMany <em>Many</em>}' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @param value
     *            the new value of the '<em>Many</em>' attribute.
     * @see #isMany()
     * @generated
     */
    void setMany(boolean value);

    /**
	 * Returns the value of the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Default Value</em>' attribute isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Value</em>' attribute.
	 * @see #setDefaultValue(String)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_DefaultValue()
	 * @model
	 * @generated
	 */
    String getDefaultValue();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#getDefaultValue <em>Default Value</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Value</em>' attribute.
	 * @see #getDefaultValue()
	 * @generated
	 */
    void setDefaultValue(String value);

    /**
	 * Returns the value of the '<em><b>Opposite</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Opposite</em>' reference isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Opposite</em>' reference.
	 * @see #setOpposite(Attribute)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Opposite()
	 * @model
	 * @generated
	 */
    Attribute getOpposite();

    /**
     * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#getOpposite <em>Opposite</em>}' reference. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @param value
     *            the new value of the '<em>Opposite</em>' reference.
     * @see #getOpposite()
     * @generated
     */
    void setOpposite(Attribute value);

    /**
	 * Returns the value of the '<em><b>Attribut Properties</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.AttributeProperty}.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Attribut Properties</em>' containment reference list isn't clear, there really should
     * be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Attribut Properties</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_AttributProperties()
	 * @model containment="true"
	 * @generated
	 */
    EList<AttributeProperty> getAttributProperties();

    /**
	 * Returns the value of the '<em><b>Sort Order</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Sort Order</em>' reference isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Sort Order</em>' reference.
	 * @see #setSortOrder(AttributeGroup)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_SortOrder()
	 * @model
	 * @generated
	 */
    AttributeGroup getSortOrder();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#getSortOrder <em>Sort Order</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sort Order</em>' reference.
	 * @see #getSortOrder()
	 * @generated
	 */
    void setSortOrder(AttributeGroup value);

    /**
	 * Returns the value of the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Data Type</em>' reference isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Type</em>' reference.
	 * @see #setDataType(Type)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_DataType()
	 * @model resolveProxies="false" transient="true" volatile="true" derived="true"
	 * @generated
	 */
    Type getDataType();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#getDataType <em>Data Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Data Type</em>' reference.
	 * @see #getDataType()
	 * @generated
	 */
    void setDataType(Type value);

    /**
	 * Returns the value of the '<em><b>Opposite Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Opposite Reference</em>' reference isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Opposite Reference</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_OppositeReference()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    Attribute getOppositeReference();

    /**
	 * Returns the value of the '<em><b>Data Type Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Data Type Name</em>' attribute isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Type Name</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_DataTypeName()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    String getDataTypeName();

    /**
	 * Returns the value of the '<em><b>Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Reference</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Reference</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Reference()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    boolean isReference();

    /**
	 * Returns the value of the '<em><b>Resolved Attribute List</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Attribute}.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Resolved Attribute List</em>' reference list isn't clear, there really should be more
     * of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Resolved Attribute List</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_ResolvedAttributeList()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    EList<Attribute> getResolvedAttributeList();

    /**
	 * Returns the value of the '<em><b>Read Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Read Only</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Read Only</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_ReadOnly()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    boolean isReadOnly();

    /**
	 * Returns the value of the '<em><b>Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Required</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Required</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Required()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    boolean isRequired();

    /**
	 * Returns the value of the '<em><b>Derived</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Derived</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Derived</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Derived()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    boolean isDerived();

    /**
	 * Returns the value of the '<em><b>Transient</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Transient</em>' attribute isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Transient</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_Transient()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
    boolean isTransient();

    /**
	 * Returns the value of the '<em><b>Incrementer Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Incrementer Reference</em>' containment reference isn't clear, there really should be
     * more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Incrementer Reference</em>' containment reference.
	 * @see #setIncrementerReference(IncrementerReference)
	 * @see org.openxma.dsl.dom.DomPackage#getAttribute_IncrementerReference()
	 * @model containment="true"
	 * @generated
	 */
    IncrementerReference getIncrementerReference();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Attribute#getIncrementerReference <em>Incrementer Reference</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Incrementer Reference</em>' containment reference.
	 * @see #getIncrementerReference()
	 * @generated
	 */
    void setIncrementerReference(IncrementerReference value);

    /**
     * @modified
     * @return the label text for the field
     */
    public String getLabelText();

    /**
     * @modified
     * @return the hstore column name for the field
     */
    public String getHstoreColumn();

    /**
     * @modified
     */
    public boolean isHstore();

    /**
     * @modified
     * @return the unit text for the field
     */
    public String getUnitText();

    /**
     * @modified
     * @return the unit text for the field
     */
    public Attribute getUnitAttribute();

    public String getOriginalName();

    public void setOriginalName(String originalName);

    public String getOriginalContainerName();

    public void setOriginalContainerName(String originalContainerName);

} // Attribute
