/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.IDocumentable;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Attribute Group</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#isKey <em>Key</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#isUnique <em>Unique</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#isFilter <em>Filter</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#isSortorder <em>Sortorder</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#getAttributes <em>Attributes</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.AttributeGroup#getResolvedAttributeList <em>Resolved Attribute List</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup()
 * @model
 * @generated
 */
public interface AttributeGroup extends IDocumentable {
	/**
	 * Returns the value of the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Key</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Key</em>' attribute.
	 * @see #setKey(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_Key()
	 * @model
	 * @generated
	 */
	boolean isKey();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.AttributeGroup#isKey <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Key</em>' attribute.
	 * @see #isKey()
	 * @generated
	 */
	void setKey(boolean value);

	/**
	 * Returns the value of the '<em><b>Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Unique</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Unique</em>' attribute.
	 * @see #setUnique(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_Unique()
	 * @model
	 * @generated
	 */
	boolean isUnique();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.AttributeGroup#isUnique <em>Unique</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unique</em>' attribute.
	 * @see #isUnique()
	 * @generated
	 */
	void setUnique(boolean value);

	/**
	 * Returns the value of the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Filter</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Filter</em>' attribute.
	 * @see #setFilter(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_Filter()
	 * @model
	 * @generated
	 */
	boolean isFilter();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.AttributeGroup#isFilter <em>Filter</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Filter</em>' attribute.
	 * @see #isFilter()
	 * @generated
	 */
	void setFilter(boolean value);

	/**
	 * Returns the value of the '<em><b>Sortorder</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sortorder</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sortorder</em>' attribute.
	 * @see #setSortorder(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_Sortorder()
	 * @model
	 * @generated
	 */
	boolean isSortorder();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.AttributeGroup#isSortorder <em>Sortorder</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sortorder</em>' attribute.
	 * @see #isSortorder()
	 * @generated
	 */
	void setSortorder(boolean value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.AttributeGroup#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Attributes</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.AttributeSortOrder}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attributes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attributes</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_Attributes()
	 * @model containment="true"
	 * @generated
	 */
	EList<AttributeSortOrder> getAttributes();

	/**
	 * Returns the value of the '<em><b>Resolved Attribute List</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Attribute}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Resolved Attribute List</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Resolved Attribute List</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getAttributeGroup_ResolvedAttributeList()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<Attribute> getResolvedAttributeList();

} // AttributeGroup
