/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Callable Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.CallableStatement#isFunctionCall <em>Function Call</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.CallableStatement#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.CallableStatement#getInParameter <em>In Parameter</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.CallableStatement#getOutParameter <em>Out Parameter</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getCallableStatement()
 * @model
 * @generated
 */
public interface CallableStatement extends QlStatement {
	/**
	 * Returns the value of the '<em><b>Function Call</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Function Call</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Function Call</em>' attribute.
	 * @see #setFunctionCall(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getCallableStatement_FunctionCall()
	 * @model
	 * @generated
	 */
	boolean isFunctionCall();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.CallableStatement#isFunctionCall <em>Function Call</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Function Call</em>' attribute.
	 * @see #isFunctionCall()
	 * @generated
	 */
	void setFunctionCall(boolean value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.openxma.dsl.dom.DomPackage#getCallableStatement_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.CallableStatement#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>In Parameter</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.CallInputParameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>In Parameter</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>In Parameter</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getCallableStatement_InParameter()
	 * @model containment="true"
	 * @generated
	 */
	EList<CallInputParameter> getInParameter();

	/**
	 * Returns the value of the '<em><b>Out Parameter</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.CallOutputParameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Out Parameter</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Out Parameter</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getCallableStatement_OutParameter()
	 * @model containment="true"
	 * @generated
	 */
	EList<CallOutputParameter> getOutParameter();

} // CallableStatement
