/**
 * <copyright>
 * </copyright>
 *
 * $Id: Column.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.DataTypeAndTypeParameter;
import org.openxma.dsl.core.model.Type;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Column</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.Column#getColumnName <em>Column Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Column#getUserType <em>User Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Column#getColumnType <em>Column Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Column#getColumns <em>Columns</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getColumn()
 * @model
 * @generated
 */
public interface Column extends DaoFeature {
	/**
	 * Returns the value of the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Column Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Column Name</em>' attribute.
	 * @see #setColumnName(String)
	 * @see org.openxma.dsl.dom.DomPackage#getColumn_ColumnName()
	 * @model
	 * @generated
	 */
	String getColumnName();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Column#getColumnName <em>Column Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Column Name</em>' attribute.
	 * @see #getColumnName()
	 * @generated
	 */
	void setColumnName(String value);

	/**
	 * Returns the value of the '<em><b>User Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>User Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>User Type</em>' containment reference.
	 * @see #setUserType(DataTypeAndTypeParameter)
	 * @see org.openxma.dsl.dom.DomPackage#getColumn_UserType()
	 * @model containment="true"
	 * @generated
	 */
	DataTypeAndTypeParameter getUserType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Column#getUserType <em>User Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>User Type</em>' containment reference.
	 * @see #getUserType()
	 * @generated
	 */
	void setUserType(DataTypeAndTypeParameter value);

	/**
	 * Returns the value of the '<em><b>Column Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Column Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Column Type</em>' reference.
	 * @see #setColumnType(Type)
	 * @see org.openxma.dsl.dom.DomPackage#getColumn_ColumnType()
	 * @model
	 * @generated
	 */
	Type getColumnType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Column#getColumnType <em>Column Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Column Type</em>' reference.
	 * @see #getColumnType()
	 * @generated
	 */
	void setColumnType(Type value);

	/**
	 * Returns the value of the '<em><b>Columns</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Column}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Columns</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Columns</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getColumn_Columns()
	 * @model containment="true"
	 * @generated
	 */
	EList<Column> getColumns();
	/**
     *  @generated NOT
     */
    public Column getColumnDefinition(Attribute attribute);

} // Column
