/**
 * <copyright>
 * </copyright>
 *
 * $Id: ComplexType.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.ModelElement;
import org.openxma.dsl.core.model.Type;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Complex Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.ComplexType#getAttributes <em>Attributes</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ComplexType#getAllAttributes <em>All Attributes</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getComplexType()
 * @model abstract="true"
 * @generated
 */
public interface ComplexType extends ModelElement, Type {
	/**
	 * Returns the value of the '<em><b>Attributes</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Attribute}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attributes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attributes</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getComplexType_Attributes()
	 * @model containment="true"
	 * @generated
	 */
	EList<Attribute> getAttributes();

	/**
	 * Returns the value of the '<em><b>All Attributes</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Attribute}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Attributes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Attributes</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getComplexType_AllAttributes()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<Attribute> getAllAttributes();
	
	/**
	 * return the list of all Attributes including the Attributes of the SuperType
	 * @generated NOT
	 */
	public List<PresentableFeature> getAllPresentableFeaturesIncludingSuperType();		

} // ComplexType
