/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.ModelElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Dao</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getEntity <em>Entity</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getTableName <em>Table Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getDiscriminator <em>Discriminator</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getQualifier <em>Qualifier</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getQueryOperation <em>Query Operation</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getDataBaseConstraints <em>Data Base Constraints</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getColumns <em>Columns</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getManyToOneAssociations <em>Many To One Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getOneToOneAssociations <em>One To One Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getOneToManyAssociations <em>One To Many Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getManyToManyAssociations <em>Many To Many Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getPrimaryKeyColumn <em>Primary Key Column</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getNaturalKeyColumns <em>Natural Key Columns</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getVersionColumn <em>Version Column</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getPrimaryKey <em>Primary Key</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Dao#getNaturalKey <em>Natural Key</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getDao()
 * @model
 * @generated
 */
public interface Dao extends ModelElement, Dependant {
	/**
	 * Returns the value of the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Entity</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Entity</em>' reference.
	 * @see #setEntity(Entity)
	 * @see org.openxma.dsl.dom.DomPackage#getDao_Entity()
	 * @model
	 * @generated
	 */
	Entity getEntity();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Dao#getEntity <em>Entity</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entity</em>' reference.
	 * @see #getEntity()
	 * @generated
	 */
	void setEntity(Entity value);

	/**
	 * Returns the value of the '<em><b>Table Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Table Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Table Name</em>' attribute.
	 * @see #setTableName(String)
	 * @see org.openxma.dsl.dom.DomPackage#getDao_TableName()
	 * @model
	 * @generated
	 */
	String getTableName();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Dao#getTableName <em>Table Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Table Name</em>' attribute.
	 * @see #getTableName()
	 * @generated
	 */
	void setTableName(String value);

	/**
	 * Returns the value of the '<em><b>Discriminator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Discriminator</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Discriminator</em>' attribute.
	 * @see #setDiscriminator(String)
	 * @see org.openxma.dsl.dom.DomPackage#getDao_Discriminator()
	 * @model
	 * @generated
	 */
	String getDiscriminator();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Dao#getDiscriminator <em>Discriminator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Discriminator</em>' attribute.
	 * @see #getDiscriminator()
	 * @generated
	 */
	void setDiscriminator(String value);

	/**
	 * Returns the value of the '<em><b>Qualifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Qualifier</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Qualifier</em>' attribute.
	 * @see #setQualifier(String)
	 * @see org.openxma.dsl.dom.DomPackage#getDao_Qualifier()
	 * @model
	 * @generated
	 */
	String getQualifier();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Dao#getQualifier <em>Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Qualifier</em>' attribute.
	 * @see #getQualifier()
	 * @generated
	 */
	void setQualifier(String value);

	/**
	 * Returns the value of the '<em><b>Data Base Constraints</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.DataBaseConstraint}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Data Base Constraints</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Base Constraints</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_DataBaseConstraints()
	 * @model containment="true"
	 * @generated
	 */
	EList<DataBaseConstraint> getDataBaseConstraints();

	/**
	 * Returns the value of the '<em><b>Operations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Operation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_Operations()
	 * @model containment="true"
	 * @generated
	 */
	EList<Operation> getOperations();

	/**
	 * Returns the value of the '<em><b>Query Operation</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.QueryOperation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Query Operation</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Query Operation</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_QueryOperation()
	 * @model containment="true"
	 * @generated
	 */
	EList<QueryOperation> getQueryOperation();

	/**
	 * Returns the value of the '<em><b>Columns</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Column}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Columns</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Columns</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_Columns()
	 * @model containment="true"
	 * @generated
	 */
	EList<Column> getColumns();

	/**
	 * Returns the value of the '<em><b>Many To One Associations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.ManyToOne}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Many To One Associations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Many To One Associations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_ManyToOneAssociations()
	 * @model containment="true"
	 * @generated
	 */
	EList<ManyToOne> getManyToOneAssociations();

	/**
	 * Returns the value of the '<em><b>One To One Associations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.OneToOne}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>One To One Associations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>One To One Associations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_OneToOneAssociations()
	 * @model containment="true"
	 * @generated
	 */
	EList<OneToOne> getOneToOneAssociations();

	/**
	 * Returns the value of the '<em><b>One To Many Associations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.OneToMany}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>One To Many Associations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>One To Many Associations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_OneToManyAssociations()
	 * @model containment="true"
	 * @generated
	 */
	EList<OneToMany> getOneToManyAssociations();

	/**
	 * Returns the value of the '<em><b>Many To Many Associations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.ManyToMany}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Many To Many Associations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Many To Many Associations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_ManyToManyAssociations()
	 * @model containment="true"
	 * @generated
	 */
	EList<ManyToMany> getManyToManyAssociations();

	/**
	 * Returns the value of the '<em><b>Primary Key Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Primary Key Column</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Primary Key Column</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_PrimaryKeyColumn()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	Column getPrimaryKeyColumn();

	/**
	 * Returns the value of the '<em><b>Natural Key Columns</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Column}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Natural Key Columns</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Natural Key Columns</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_NaturalKeyColumns()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<Column> getNaturalKeyColumns();

	/**
	 * Returns the value of the '<em><b>Version Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version Column</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Version Column</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_VersionColumn()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	Column getVersionColumn();

	/**
	 * Returns the value of the '<em><b>Primary Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Primary Key</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Primary Key</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_PrimaryKey()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	DataBaseConstraint getPrimaryKey();

	/**
	 * Returns the value of the '<em><b>Natural Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Natural Key</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Natural Key</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getDao_NaturalKey()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	DataBaseConstraint getNaturalKey();

	/**
	 *  @generated NOT
	 */
	public Column getColumnDefinition(Attribute attribute);

	/**
	 *  @generated NOT
	 */
	public OneToMany getOneToMany(Attribute structuralFeature);

	/**
	 *  @generated NOT
	 */
	public ManyToMany getManyToMany(Attribute structuralFeature);

	/**
	 *  @generated NOT
	 */
	public ManyToOne getManyToOne(Attribute structuralFeature);

	/**
	 *  @generated NOT
	 */
	public OneToOne getOneToOne(Attribute structuralFeature);

	/**
	 *  @generated NOT
	 */
	public Collection<DataBaseConstraint> getDataBaseConstraintByType(final DataBaseConstraintType type);

} // Dao
