/**
 * <copyright>
 * </copyright>
 *
 * $Id: DataView.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data View</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.DataView#getSuperType <em>Super Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DataView#getFeatureReferences <em>Feature References</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getDataView()
 * @model
 * @generated
 */
public interface DataView extends ComplexType {
	/**
	 * Returns the value of the '<em><b>Super Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Super Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Super Type</em>' reference.
	 * @see #setSuperType(DataView)
	 * @see org.openxma.dsl.dom.DomPackage#getDataView_SuperType()
	 * @model
	 * @generated
	 */
	DataView getSuperType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DataView#getSuperType <em>Super Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Super Type</em>' reference.
	 * @see #getSuperType()
	 * @generated
	 */
	void setSuperType(DataView value);

	/**
	 * Returns the value of the '<em><b>Feature References</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.FeatureReference}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Feature References</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Feature References</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getDataView_FeatureReferences()
	 * @model containment="true"
	 * @generated
	 */
	EList<FeatureReference> getFeatureReferences();

	/**
	 * @generated NOT
	 */
	EList<Attribute> getReferencedAssociations();

	/**
	 * @return true or false whether all required features of the given entity are included
	 * @generated NOT
	 */
	boolean includesAllRequiredFeaturesFor(Entity entity);
	
	/**
	 * @return true or false whether this dataview includes the identifier attribute of the given entity
	 * @generated NOT
	 */
	boolean includesIdentifierFor(Entity entity);
	
	/**
	 * @return true or false whether this dataview includes the key attribute of the given entity
	 * @generated NOT
	 */
	boolean includesKeyFor(Entity entity);
	/**
	 * @return true or false whether this dataview includes the version attribute of the given entity
	 * @generated NOT
	 */
	boolean includesVersionFor(Entity entity);


} // DataView
