/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.openxma.dsl.core.model.IDocumentable;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Delegate Operation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getView <em>View</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#isMany <em>Many</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getRepository <em>Repository</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getOperation <em>Operation</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getCrudOperationType <em>Crud Operation Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getViewParameter <em>View Parameter</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.DelegateOperation#getFilter <em>Filter</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation()
 * @model
 * @generated
 */
public interface DelegateOperation extends IDocumentable {
	/**
	 * Returns the value of the '<em><b>View</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>View</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>View</em>' reference.
	 * @see #setView(DataView)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_View()
	 * @model
	 * @generated
	 */
	DataView getView();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getView <em>View</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>View</em>' reference.
	 * @see #getView()
	 * @generated
	 */
	void setView(DataView value);

	/**
	 * Returns the value of the '<em><b>Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Many</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Many</em>' attribute.
	 * @see #setMany(boolean)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_Many()
	 * @model
	 * @generated
	 */
    boolean isMany();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#isMany <em>Many</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Many</em>' attribute.
	 * @see #isMany()
	 * @generated
	 */
    void setMany(boolean value);

    /**
	 * Returns the value of the '<em><b>Repository</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Repository</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Repository</em>' reference.
	 * @see #setRepository(Dao)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_Repository()
	 * @model
	 * @generated
	 */
	Dao getRepository();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getRepository <em>Repository</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Repository</em>' reference.
	 * @see #getRepository()
	 * @generated
	 */
	void setRepository(Dao value);

	/**
	 * Returns the value of the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operation</em>' reference.
	 * @see #setOperation(DaoOperation)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_Operation()
	 * @model
	 * @generated
	 */
	DaoOperation getOperation();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getOperation <em>Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' reference.
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(DaoOperation value);

	/**
	 * Returns the value of the '<em><b>Crud Operation Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.openxma.dsl.dom.model.CrudOperationType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Crud Operation Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Crud Operation Type</em>' attribute.
	 * @see org.openxma.dsl.dom.model.CrudOperationType
	 * @see #setCrudOperationType(CrudOperationType)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_CrudOperationType()
	 * @model
	 * @generated
	 */
	CrudOperationType getCrudOperationType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getCrudOperationType <em>Crud Operation Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Crud Operation Type</em>' attribute.
	 * @see org.openxma.dsl.dom.model.CrudOperationType
	 * @see #getCrudOperationType()
	 * @generated
	 */
	void setCrudOperationType(CrudOperationType value);

	/**
	 * Returns the value of the '<em><b>View Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>View Parameter</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>View Parameter</em>' reference.
	 * @see #setViewParameter(DataView)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_ViewParameter()
	 * @model
	 * @generated
	 */
	DataView getViewParameter();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getViewParameter <em>View Parameter</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>View Parameter</em>' reference.
	 * @see #getViewParameter()
	 * @generated
	 */
	void setViewParameter(DataView value);


	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Name</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_Name()
	 * @model
	 * @generated
	 */
    String getName();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
    void setName(String value);

    /**
	 * Returns the value of the '<em><b>Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Filter</em>' containment reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Filter</em>' containment reference.
	 * @see #setFilter(Expression)
	 * @see org.openxma.dsl.dom.DomPackage#getDelegateOperation_Filter()
	 * @model containment="true"
	 * @generated
	 */
    Expression getFilter();

    /**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.DelegateOperation#getFilter <em>Filter</em>}' containment reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Filter</em>' containment reference.
	 * @see #getFilter()
	 * @generated
	 */
    void setFilter(Expression value);

    /**
	 * @generated NOT
	 */
	boolean isUpdateOperation();

	/**
	 * @generated NOT
	 */
	boolean isCreateOperation();

	/**
	 * @generated NOT
	 */
	boolean isReadOperation();
	
	/**
	 * @generated NOT
	 */
	boolean isDeleteOperation();

} // DelegateOperation
