/**
 * <copyright>
 * </copyright>
 *
 * $Id: Entity.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.ConditionsBlock;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Entity</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getSuperType <em>Super Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getAttributeGroups <em>Attribute Groups</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getConditionsBlock <em>Conditions Block</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getRepository <em>Repository</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getKey <em>Key</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getSortOrders <em>Sort Orders</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getVersion <em>Version</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getRequiredReferences <em>Required References</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Entity#getRequiredAttributes <em>Required Attributes</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getEntity()
 * @model
 * @generated
 */
public interface Entity extends ComplexType, Dependant {
	/**
	 * Returns the value of the '<em><b>Super Type</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Super Type</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Super Type</em>' reference.
	 * @see #setSuperType(Entity)
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_SuperType()
	 * @model
	 * @generated
	 */
	Entity getSuperType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Entity#getSuperType <em>Super Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Super Type</em>' reference.
	 * @see #getSuperType()
	 * @generated
	 */
	void setSuperType(Entity value);

	/**
	 * Returns the value of the '<em><b>Attribute Groups</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attribute Groups</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attribute Groups</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_AttributeGroups()
	 * @model containment="true"
	 * @generated
	 */
	EList<AttributeGroup> getAttributeGroups();

	/**
	 * Returns the value of the '<em><b>Conditions Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Conditions Block</em>' containment reference
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Conditions Block</em>' containment reference.
	 * @see #setConditionsBlock(ConditionsBlock)
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_ConditionsBlock()
	 * @model containment="true"
	 * @generated
	 */
	ConditionsBlock getConditionsBlock();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Entity#getConditionsBlock <em>Conditions Block</em>}' containment reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Conditions Block</em>' containment reference.
	 * @see #getConditionsBlock()
	 * @generated
	 */
	void setConditionsBlock(ConditionsBlock value);

	/**
	 * Returns the value of the '<em><b>Repository</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Repository</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Repository</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_Repository()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	Dao getRepository();

	/**
	 * Returns the value of the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Key</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Key</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_Key()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	AttributeGroup getKey();

	/**
	 * Returns the value of the '<em><b>Sort Orders</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sort Orders</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sort Orders</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_SortOrders()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<AttributeGroup> getSortOrders();

	/**
	 * Returns the value of the '<em><b>Identifier</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identifier</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Identifier</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_Identifier()
	 * @model resolveProxies="false" transient="true" changeable="false"
	 *        volatile="true" derived="true"
	 * @generated
	 */
	Attribute getIdentifier();

	/**
	 * Returns the value of the '<em><b>Version</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Version</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_Version()
	 * @model resolveProxies="false" transient="true" changeable="false"
	 *        volatile="true" derived="true"
	 * @generated
	 */
	Attribute getVersion();

	/**
	 * Returns the value of the '<em><b>Required References</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Attribute}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Required References</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Required References</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_RequiredReferences()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<Attribute> getRequiredReferences();

	/**
	 * Returns the value of the '<em><b>Required Attributes</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Attribute}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Required Attributes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Required Attributes</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getEntity_RequiredAttributes()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	EList<Attribute> getRequiredAttributes();

	/**
	 * @generated NOT
	 */
	void setDas(Dao das);


	/**
	 * Returns a collection of the self-contained copies of each attribute.
	 * 
	 * @return
	 * @generated NOT
	 */
	Collection<Attribute> copyAttributes();

	/**
	 * @param name
	 *            the name of the attribute to match
	 * @return the attribute matching the given name
	 * @generated NOT
	 */
	Attribute getAttributeByName(String name);

	/**
	 * @generated NOT
	 */
	DataView getDefaultDataView();

	/**
	 * @return the name of the default created <code>DataView</code> for the
	 *         given entity
	 * @generated NOT
	 */
	String getDefaultDataViewName();
	
	/**
	 * @generated NOT
	 */
	EList<Attribute> getResolvedAttributeList() ;

} // Entity
