/**
 * <copyright>
 * </copyright>
 *
 * $Id: ManyToOne.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.SqlType;
import org.openxma.dsl.core.model.Type;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Many To One</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.ManyToOne#getColumnName <em>Column Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ManyToOne#getUserType <em>User Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ManyToOne#getSqlType <em>Sql Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ManyToOne#getColumns <em>Columns</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.ManyToOne#isDerived <em>Derived</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getManyToOne()
 * @model
 * @generated
 */
public interface ManyToOne extends DaoFeature {
	/**
	 * Returns the value of the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Column Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Column Name</em>' attribute.
	 * @see #setColumnName(String)
	 * @see org.openxma.dsl.dom.DomPackage#getManyToOne_ColumnName()
	 * @model
	 * @generated
	 */
	String getColumnName();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.ManyToOne#getColumnName <em>Column Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Column Name</em>' attribute.
	 * @see #getColumnName()
	 * @generated
	 */
	void setColumnName(String value);

	/**
	 * Returns the value of the '<em><b>User Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>User Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>User Type</em>' reference.
	 * @see #setUserType(Type)
	 * @see org.openxma.dsl.dom.DomPackage#getManyToOne_UserType()
	 * @model
	 * @generated
	 */
	Type getUserType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.ManyToOne#getUserType <em>User Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>User Type</em>' reference.
	 * @see #getUserType()
	 * @generated
	 */
	void setUserType(Type value);

	/**
	 * Returns the value of the '<em><b>Sql Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sql Type</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sql Type</em>' reference.
	 * @see #setSqlType(SqlType)
	 * @see org.openxma.dsl.dom.DomPackage#getManyToOne_SqlType()
	 * @model
	 * @generated
	 */
	SqlType getSqlType();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.ManyToOne#getSqlType <em>Sql Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sql Type</em>' reference.
	 * @see #getSqlType()
	 * @generated
	 */
	void setSqlType(SqlType value);

	/**
	 * Returns the value of the '<em><b>Columns</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Column}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Columns</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Columns</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getManyToOne_Columns()
	 * @model containment="true"
	 * @generated
	 */
	EList<Column> getColumns();

	/**
	 * Returns the value of the '<em><b>Derived</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Derived</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Derived</em>' attribute.
	 * @see org.openxma.dsl.dom.DomPackage#getManyToOne_Derived()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	boolean isDerived();

} // ManyToOne
