/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.IDocumentable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Operation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.Operation#getParameters <em>Parameters</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Operation#getExpression <em>Expression</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Operation#getDelegate <em>Delegate</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getOperation()
 * @model
 * @generated
 */
public interface Operation extends DaoOperation, IDocumentable {
	/**
	 * Returns the value of the '<em><b>Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Parameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parameters</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getOperation_Parameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<Parameter> getParameters();

	/**
	 * Returns the value of the '<em><b>Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Expression</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Expression</em>' attribute.
	 * @see #setExpression(String)
	 * @see org.openxma.dsl.dom.DomPackage#getOperation_Expression()
	 * @model
	 * @generated
	 */
	String getExpression();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.Operation#getExpression <em>Expression</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Expression</em>' attribute.
	 * @see #getExpression()
	 * @generated
	 */
	void setExpression(String value);

	/**
	 * Returns the value of the '<em><b>Delegate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Delegate</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Delegate</em>' reference.
	 * @see org.openxma.dsl.dom.DomPackage#getOperation_Delegate()
	 * @model resolveProxies="false" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	DelegateOperation getDelegate();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	void setDelegate(DelegateOperation delegateOperation);

} // Operation
