/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.IDocumentable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Query Operation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.QueryOperation#getQueryParameters <em>Query Parameters</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.QueryOperation#getStatement <em>Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getQueryOperation()
 * @model
 * @generated
 */
public interface QueryOperation extends DaoOperation, IDocumentable {
	/**
	 * Returns the value of the '<em><b>Query Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.QueryParameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Query Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Query Parameters</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getQueryOperation_QueryParameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<QueryParameter> getQueryParameters();

	/**
	 * Returns the value of the '<em><b>Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Statement</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Statement</em>' containment reference.
	 * @see #setStatement(QlStatement)
	 * @see org.openxma.dsl.dom.DomPackage#getQueryOperation_Statement()
	 * @model containment="true"
	 * @generated
	 */
	QlStatement getStatement();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.QueryOperation#getStatement <em>Statement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Statement</em>' containment reference.
	 * @see #getStatement()
	 * @generated
	 */
	void setStatement(QlStatement value);

} // QueryOperation
