/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Select Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.SelectStatement#getFrom <em>From</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.SelectStatement#getJoin <em>Join</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.SelectStatement#getWhere <em>Where</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.SelectStatement#getGroupBy <em>Group By</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.SelectStatement#getHaving <em>Having</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.SelectStatement#getOrderBy <em>Order By</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement()
 * @model
 * @generated
 */
public interface SelectStatement extends QlStatement {
	/**
	 * Returns the value of the '<em><b>From</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.FromRange}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>From</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>From</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement_From()
	 * @model containment="true"
	 * @generated
	 */
	EList<FromRange> getFrom();

	/**
	 * Returns the value of the '<em><b>Join</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Join}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Join</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Join</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement_Join()
	 * @model containment="true"
	 * @generated
	 */
	EList<Join> getJoin();

	/**
	 * Returns the value of the '<em><b>Where</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Where</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Where</em>' containment reference.
	 * @see #setWhere(Expression)
	 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement_Where()
	 * @model containment="true"
	 * @generated
	 */
	Expression getWhere();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.SelectStatement#getWhere <em>Where</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Where</em>' containment reference.
	 * @see #getWhere()
	 * @generated
	 */
	void setWhere(Expression value);

	/**
	 * Returns the value of the '<em><b>Group By</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Expression}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Group By</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Group By</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement_GroupBy()
	 * @model containment="true"
	 * @generated
	 */
	EList<Expression> getGroupBy();

	/**
	 * Returns the value of the '<em><b>Having</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Having</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Having</em>' containment reference.
	 * @see #setHaving(Expression)
	 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement_Having()
	 * @model containment="true"
	 * @generated
	 */
	Expression getHaving();

	/**
	 * Sets the value of the '{@link org.openxma.dsl.dom.model.SelectStatement#getHaving <em>Having</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Having</em>' containment reference.
	 * @see #getHaving()
	 * @generated
	 */
	void setHaving(Expression value);

	/**
	 * Returns the value of the '<em><b>Order By</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.SortOrderElement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Order By</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Order By</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getSelectStatement_OrderBy()
	 * @model containment="true"
	 * @generated
	 */
	EList<SortOrderElement> getOrderBy();

} // SelectStatement
