/**
 * <copyright>
 * </copyright>
 *
 * $Id: Service.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model;

import org.eclipse.emf.common.util.EList;
import org.openxma.dsl.core.model.ModelElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Service</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.Service#getDependencies <em>Dependencies</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Service#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.Service#getDelegateOperations <em>Delegate Operations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.openxma.dsl.dom.DomPackage#getService()
 * @model
 * @generated
 */
public interface Service extends ModelElement, Dependant {
	/**
	 * Returns the value of the '<em><b>Dependencies</b></em>' reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Dependant}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Dependencies</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Dependencies</em>' reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getService_Dependencies()
	 * @model
	 * @generated
	 */
	EList<Dependant> getDependencies();

	/**
	 * Returns the value of the '<em><b>Delegate Operations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.DelegateOperation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Delegate Operations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Delegate Operations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getService_DelegateOperations()
	 * @model containment="true"
	 * @generated
	 */
	EList<DelegateOperation> getDelegateOperations();

	/**
	 * Returns the value of the '<em><b>Operations</b></em>' containment reference list.
	 * The list contents are of type {@link org.openxma.dsl.dom.model.Operation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operations</em>' containment reference list.
	 * @see org.openxma.dsl.dom.DomPackage#getService_Operations()
	 * @model containment="true"
	 * @generated
	 */
	EList<Operation> getOperations();

} // Service
