/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.AggregateFunction;
import org.openxma.dsl.dom.model.CollectionFunction;
import org.openxma.dsl.dom.model.Expression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Aggregate Function</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl#getFunction <em>Function</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl#getAggregateExpression <em>Aggregate Expression</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl#isAll <em>All</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl#isDistinct <em>Distinct</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl#getFrom <em>From</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AggregateFunctionImpl#getCollection <em>Collection</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AggregateFunctionImpl extends ExpressionImpl implements AggregateFunction {
	/**
	 * The default value of the '{@link #getFunction() <em>Function</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFunction()
	 * @generated
	 * @ordered
	 */
	protected static final String FUNCTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFunction() <em>Function</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFunction()
	 * @generated
	 * @ordered
	 */
	protected String function = FUNCTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAggregateExpression() <em>Aggregate Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregateExpression()
	 * @generated
	 * @ordered
	 */
	protected Expression aggregateExpression;

	/**
	 * The default value of the '{@link #isAll() <em>All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAll()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ALL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAll() <em>All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAll()
	 * @generated
	 * @ordered
	 */
	protected boolean all = ALL_EDEFAULT;

	/**
	 * The default value of the '{@link #isDistinct() <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDistinct()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISTINCT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDistinct() <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDistinct()
	 * @generated
	 * @ordered
	 */
	protected boolean distinct = DISTINCT_EDEFAULT;

	/**
	 * The default value of the '{@link #getFrom() <em>From</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFrom()
	 * @generated
	 * @ordered
	 */
	protected static final String FROM_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFrom() <em>From</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFrom()
	 * @generated
	 * @ordered
	 */
	protected String from = FROM_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCollection() <em>Collection</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollection()
	 * @generated
	 * @ordered
	 */
	protected CollectionFunction collection;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AggregateFunctionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.AGGREGATE_FUNCTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFunction() {
		return function;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFunction(String newFunction) {
		String oldFunction = function;
		function = newFunction;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__FUNCTION, oldFunction, function));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression getAggregateExpression() {
		return aggregateExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAggregateExpression(Expression newAggregateExpression, NotificationChain msgs) {
		Expression oldAggregateExpression = aggregateExpression;
		aggregateExpression = newAggregateExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION, oldAggregateExpression, newAggregateExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAggregateExpression(Expression newAggregateExpression) {
		if (newAggregateExpression != aggregateExpression) {
			NotificationChain msgs = null;
			if (aggregateExpression != null)
				msgs = ((InternalEObject)aggregateExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION, null, msgs);
			if (newAggregateExpression != null)
				msgs = ((InternalEObject)newAggregateExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION, null, msgs);
			msgs = basicSetAggregateExpression(newAggregateExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION, newAggregateExpression, newAggregateExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAll() {
		return all;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAll(boolean newAll) {
		boolean oldAll = all;
		all = newAll;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__ALL, oldAll, all));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDistinct() {
		return distinct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDistinct(boolean newDistinct) {
		boolean oldDistinct = distinct;
		distinct = newDistinct;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__DISTINCT, oldDistinct, distinct));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFrom() {
		return from;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFrom(String newFrom) {
		String oldFrom = from;
		from = newFrom;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__FROM, oldFrom, from));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionFunction getCollection() {
		return collection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCollection(CollectionFunction newCollection, NotificationChain msgs) {
		CollectionFunction oldCollection = collection;
		collection = newCollection;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__COLLECTION, oldCollection, newCollection);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollection(CollectionFunction newCollection) {
		if (newCollection != collection) {
			NotificationChain msgs = null;
			if (collection != null)
				msgs = ((InternalEObject)collection).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.AGGREGATE_FUNCTION__COLLECTION, null, msgs);
			if (newCollection != null)
				msgs = ((InternalEObject)newCollection).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.AGGREGATE_FUNCTION__COLLECTION, null, msgs);
			msgs = basicSetCollection(newCollection, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.AGGREGATE_FUNCTION__COLLECTION, newCollection, newCollection));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION:
				return basicSetAggregateExpression(null, msgs);
			case DomPackage.AGGREGATE_FUNCTION__COLLECTION:
				return basicSetCollection(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.AGGREGATE_FUNCTION__FUNCTION:
				return getFunction();
			case DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION:
				return getAggregateExpression();
			case DomPackage.AGGREGATE_FUNCTION__ALL:
				return isAll();
			case DomPackage.AGGREGATE_FUNCTION__DISTINCT:
				return isDistinct();
			case DomPackage.AGGREGATE_FUNCTION__FROM:
				return getFrom();
			case DomPackage.AGGREGATE_FUNCTION__COLLECTION:
				return getCollection();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.AGGREGATE_FUNCTION__FUNCTION:
				setFunction((String)newValue);
				return;
			case DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION:
				setAggregateExpression((Expression)newValue);
				return;
			case DomPackage.AGGREGATE_FUNCTION__ALL:
				setAll((Boolean)newValue);
				return;
			case DomPackage.AGGREGATE_FUNCTION__DISTINCT:
				setDistinct((Boolean)newValue);
				return;
			case DomPackage.AGGREGATE_FUNCTION__FROM:
				setFrom((String)newValue);
				return;
			case DomPackage.AGGREGATE_FUNCTION__COLLECTION:
				setCollection((CollectionFunction)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.AGGREGATE_FUNCTION__FUNCTION:
				setFunction(FUNCTION_EDEFAULT);
				return;
			case DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION:
				setAggregateExpression((Expression)null);
				return;
			case DomPackage.AGGREGATE_FUNCTION__ALL:
				setAll(ALL_EDEFAULT);
				return;
			case DomPackage.AGGREGATE_FUNCTION__DISTINCT:
				setDistinct(DISTINCT_EDEFAULT);
				return;
			case DomPackage.AGGREGATE_FUNCTION__FROM:
				setFrom(FROM_EDEFAULT);
				return;
			case DomPackage.AGGREGATE_FUNCTION__COLLECTION:
				setCollection((CollectionFunction)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.AGGREGATE_FUNCTION__FUNCTION:
				return FUNCTION_EDEFAULT == null ? function != null : !FUNCTION_EDEFAULT.equals(function);
			case DomPackage.AGGREGATE_FUNCTION__AGGREGATE_EXPRESSION:
				return aggregateExpression != null;
			case DomPackage.AGGREGATE_FUNCTION__ALL:
				return all != ALL_EDEFAULT;
			case DomPackage.AGGREGATE_FUNCTION__DISTINCT:
				return distinct != DISTINCT_EDEFAULT;
			case DomPackage.AGGREGATE_FUNCTION__FROM:
				return FROM_EDEFAULT == null ? from != null : !FROM_EDEFAULT.equals(from);
			case DomPackage.AGGREGATE_FUNCTION__COLLECTION:
				return collection != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (function: ");
		result.append(function);
		result.append(", all: ");
		result.append(all);
		result.append(", distinct: ");
		result.append(distinct);
		result.append(", from: ");
		result.append(from);
		result.append(')');
		return result.toString();
	}

} //AggregateFunctionImpl
