/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.ConditionsBlock;
import org.openxma.dsl.core.model.Function;
import org.openxma.dsl.core.model.impl.ModelElementImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.ApplicationSession;
import org.openxma.dsl.dom.model.Property;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Application Session</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ApplicationSessionImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ApplicationSessionImpl#getFunctions <em>Functions</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ApplicationSessionImpl#getConditionsBlock <em>Conditions Block</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ApplicationSessionImpl extends ModelElementImpl implements ApplicationSession {
	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<Property> properties;

	/**
	 * The cached value of the '{@link #getFunctions() <em>Functions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFunctions()
	 * @generated
	 * @ordered
	 */
	protected EList<Function> functions;

	/**
	 * The cached value of the '{@link #getConditionsBlock() <em>Conditions Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditionsBlock()
	 * @generated
	 * @ordered
	 */
	protected ConditionsBlock conditionsBlock;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ApplicationSessionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.APPLICATION_SESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Property> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<Property>(Property.class, this, DomPackage.APPLICATION_SESSION__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Function> getFunctions() {
		if (functions == null) {
			functions = new EObjectContainmentEList<Function>(Function.class, this, DomPackage.APPLICATION_SESSION__FUNCTIONS);
		}
		return functions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConditionsBlock getConditionsBlock() {
		return conditionsBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConditionsBlock(ConditionsBlock newConditionsBlock, NotificationChain msgs) {
		ConditionsBlock oldConditionsBlock = conditionsBlock;
		conditionsBlock = newConditionsBlock;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK, oldConditionsBlock, newConditionsBlock);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConditionsBlock(ConditionsBlock newConditionsBlock) {
		if (newConditionsBlock != conditionsBlock) {
			NotificationChain msgs = null;
			if (conditionsBlock != null)
				msgs = ((InternalEObject)conditionsBlock).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK, null, msgs);
			if (newConditionsBlock != null)
				msgs = ((InternalEObject)newConditionsBlock).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK, null, msgs);
			msgs = basicSetConditionsBlock(newConditionsBlock, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK, newConditionsBlock, newConditionsBlock));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.APPLICATION_SESSION__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
			case DomPackage.APPLICATION_SESSION__FUNCTIONS:
				return ((InternalEList<?>)getFunctions()).basicRemove(otherEnd, msgs);
			case DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK:
				return basicSetConditionsBlock(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.APPLICATION_SESSION__PROPERTIES:
				return getProperties();
			case DomPackage.APPLICATION_SESSION__FUNCTIONS:
				return getFunctions();
			case DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK:
				return getConditionsBlock();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.APPLICATION_SESSION__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends Property>)newValue);
				return;
			case DomPackage.APPLICATION_SESSION__FUNCTIONS:
				getFunctions().clear();
				getFunctions().addAll((Collection<? extends Function>)newValue);
				return;
			case DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK:
				setConditionsBlock((ConditionsBlock)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.APPLICATION_SESSION__PROPERTIES:
				getProperties().clear();
				return;
			case DomPackage.APPLICATION_SESSION__FUNCTIONS:
				getFunctions().clear();
				return;
			case DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK:
				setConditionsBlock((ConditionsBlock)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.APPLICATION_SESSION__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case DomPackage.APPLICATION_SESSION__FUNCTIONS:
				return functions != null && !functions.isEmpty();
			case DomPackage.APPLICATION_SESSION__CONDITIONS_BLOCK:
				return conditionsBlock != null;
		}
		return super.eIsSet(featureID);
	}

} //ApplicationSessionImpl
