/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.AttributeSortOrder;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Attribute Group</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#getTxtDescription <em>Txt Description</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#isKey <em>Key</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#isUnique <em>Unique</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#isFilter <em>Filter</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#isSortorder <em>Sortorder</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#getAttributes <em>Attributes</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeGroupImpl#getResolvedAttributeList <em>Resolved Attribute List</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AttributeGroupImpl extends MinimalEObjectImpl.Container implements AttributeGroup {
	/**
	 * The default value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected static final String TXT_DESCRIPTION_EDEFAULT = null;

    /**
	 * The cached value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected String txtDescription = TXT_DESCRIPTION_EDEFAULT;

    /**
	 * The default value of the '{@link #isKey() <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isKey()
	 * @generated
	 * @ordered
	 */
	protected static final boolean KEY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isKey() <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isKey()
	 * @generated
	 * @ordered
	 */
	protected boolean key = KEY_EDEFAULT;

	/**
	 * The default value of the '{@link #isUnique() <em>Unique</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUnique()
	 * @generated
	 * @ordered
	 */
	protected static final boolean UNIQUE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUnique() <em>Unique</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUnique()
	 * @generated
	 * @ordered
	 */
	protected boolean unique = UNIQUE_EDEFAULT;

	/**
	 * The default value of the '{@link #isFilter() <em>Filter</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFilter()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FILTER_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFilter() <em>Filter</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFilter()
	 * @generated
	 * @ordered
	 */
	protected boolean filter = FILTER_EDEFAULT;

	/**
	 * The default value of the '{@link #isSortorder() <em>Sortorder</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSortorder()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SORTORDER_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isSortorder() <em>Sortorder</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSortorder()
	 * @generated
	 * @ordered
	 */
	protected boolean sortorder = SORTORDER_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAttributes() <em>Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<AttributeSortOrder> attributes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeGroupImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ATTRIBUTE_GROUP;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getTxtDescription() {
		return txtDescription;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setTxtDescription(String newTxtDescription) {
		String oldTxtDescription = txtDescription;
		txtDescription = newTxtDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_GROUP__TXT_DESCRIPTION, oldTxtDescription, txtDescription));
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isKey() {
		return key;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKey(boolean newKey) {
		boolean oldKey = key;
		key = newKey;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_GROUP__KEY, oldKey, key));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isUnique() {
		return unique;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUnique(boolean newUnique) {
		boolean oldUnique = unique;
		unique = newUnique;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_GROUP__UNIQUE, oldUnique, unique));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFilter() {
		return filter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFilter(boolean newFilter) {
		boolean oldFilter = filter;
		filter = newFilter;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_GROUP__FILTER, oldFilter, filter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSortorder() {
		return sortorder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSortorder(boolean newSortorder) {
		boolean oldSortorder = sortorder;
		sortorder = newSortorder;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_GROUP__SORTORDER, oldSortorder, sortorder));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_GROUP__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AttributeSortOrder> getAttributes() {
		if (attributes == null) {
			attributes = new EObjectContainmentEList<AttributeSortOrder>(AttributeSortOrder.class, this, DomPackage.ATTRIBUTE_GROUP__ATTRIBUTES);
		}
		return attributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<Attribute> getResolvedAttributeList() {
	    EList<Attribute> allAttributeHolders = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.ATTRIBUTE_GROUP__RESOLVED_ATTRIBUTE_LIST);
		for (AttributeSortOrder attributeSortOrder : getAttributes()) {
			if (attributeSortOrder.getAttribute()!=null) {
				allAttributeHolders.addAll(attributeSortOrder.getAttribute().getResolvedAttributeList());
			}
		}
		return allAttributeHolders;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_GROUP__ATTRIBUTES:
				return ((InternalEList<?>)getAttributes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_GROUP__TXT_DESCRIPTION:
				return getTxtDescription();
			case DomPackage.ATTRIBUTE_GROUP__KEY:
				return isKey();
			case DomPackage.ATTRIBUTE_GROUP__UNIQUE:
				return isUnique();
			case DomPackage.ATTRIBUTE_GROUP__FILTER:
				return isFilter();
			case DomPackage.ATTRIBUTE_GROUP__SORTORDER:
				return isSortorder();
			case DomPackage.ATTRIBUTE_GROUP__NAME:
				return getName();
			case DomPackage.ATTRIBUTE_GROUP__ATTRIBUTES:
				return getAttributes();
			case DomPackage.ATTRIBUTE_GROUP__RESOLVED_ATTRIBUTE_LIST:
				return getResolvedAttributeList();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_GROUP__TXT_DESCRIPTION:
				setTxtDescription((String)newValue);
				return;
			case DomPackage.ATTRIBUTE_GROUP__KEY:
				setKey((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE_GROUP__UNIQUE:
				setUnique((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE_GROUP__FILTER:
				setFilter((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE_GROUP__SORTORDER:
				setSortorder((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE_GROUP__NAME:
				setName((String)newValue);
				return;
			case DomPackage.ATTRIBUTE_GROUP__ATTRIBUTES:
				getAttributes().clear();
				getAttributes().addAll((Collection<? extends AttributeSortOrder>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_GROUP__TXT_DESCRIPTION:
				setTxtDescription(TXT_DESCRIPTION_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_GROUP__KEY:
				setKey(KEY_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_GROUP__UNIQUE:
				setUnique(UNIQUE_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_GROUP__FILTER:
				setFilter(FILTER_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_GROUP__SORTORDER:
				setSortorder(SORTORDER_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_GROUP__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_GROUP__ATTRIBUTES:
				getAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_GROUP__TXT_DESCRIPTION:
				return TXT_DESCRIPTION_EDEFAULT == null ? txtDescription != null : !TXT_DESCRIPTION_EDEFAULT.equals(txtDescription);
			case DomPackage.ATTRIBUTE_GROUP__KEY:
				return key != KEY_EDEFAULT;
			case DomPackage.ATTRIBUTE_GROUP__UNIQUE:
				return unique != UNIQUE_EDEFAULT;
			case DomPackage.ATTRIBUTE_GROUP__FILTER:
				return filter != FILTER_EDEFAULT;
			case DomPackage.ATTRIBUTE_GROUP__SORTORDER:
				return sortorder != SORTORDER_EDEFAULT;
			case DomPackage.ATTRIBUTE_GROUP__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DomPackage.ATTRIBUTE_GROUP__ATTRIBUTES:
				return attributes != null && !attributes.isEmpty();
			case DomPackage.ATTRIBUTE_GROUP__RESOLVED_ATTRIBUTE_LIST:
				return !getResolvedAttributeList().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (txtDescription: ");
		result.append(txtDescription);
		result.append(", key: ");
		result.append(key);
		result.append(", unique: ");
		result.append(unique);
		result.append(", filter: ");
		result.append(filter);
		result.append(", sortorder: ");
		result.append(sortorder);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //AttributeGroupImpl
