/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributeImpl.java 10627 2013-04-10 09:59:28Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.CorePackage;
import org.openxma.dsl.core.CoreFactory;
import org.openxma.dsl.core.model.DataTypeAndTypeParameter;
import org.openxma.dsl.core.model.IDocumentable;
import org.openxma.dsl.core.model.IncrementerReference;
import org.openxma.dsl.core.model.TrueLiteral;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.core.model.ValidatorReference;
import org.openxma.dsl.core.model.impl.ReferenceableByXmadslVariableImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.AttributeValidationProperty;
import org.openxma.dsl.dom.model.DerivedFlag;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.PresentableFeature;
import org.openxma.dsl.dom.model.QueryParameterReference;
import org.openxma.dsl.dom.model.ReadOnlyFlag;
import org.openxma.dsl.dom.model.RequiredFlag;
import org.openxma.dsl.dom.model.TransientFlag;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Attribute</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getTxtDescription <em>Txt Description</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isVersion <em>Version</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isComposition <em>Composition</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isMany <em>Many</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getIncrementerReference <em>Incrementer Reference</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getDefaultValue <em>Default Value</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getOpposite <em>Opposite</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getAttributProperties <em>Attribut Properties</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getSortOrder <em>Sort Order</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getDataType <em>Data Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getOppositeReference <em>Opposite Reference</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getDataTypeName <em>Data Type Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#getResolvedAttributeList <em>Resolved Attribute List</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isReference <em>Reference</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isReadOnly <em>Read Only</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isRequired <em>Required</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isDerived <em>Derived</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeImpl#isTransient <em>Transient</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AttributeImpl extends ReferenceableByXmadslVariableImpl implements Attribute {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected static final String TXT_DESCRIPTION_EDEFAULT = null;

    /**
	 * The cached value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected String txtDescription = TXT_DESCRIPTION_EDEFAULT;

    /**
	 * The default value of the '{@link #isIdentifier() <em>Identifier</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isIdentifier()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IDENTIFIER_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIdentifier() <em>Identifier</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isIdentifier()
	 * @generated
	 * @ordered
	 */
	protected boolean identifier = IDENTIFIER_EDEFAULT;

	/**
	 * The default value of the '{@link #isVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVersion()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VERSION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isVersion()
	 * @generated
	 * @ordered
	 */
	protected boolean version = VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #isComposition() <em>Composition</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isComposition()
	 * @generated
	 * @ordered
	 */
	protected static final boolean COMPOSITION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isComposition() <em>Composition</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isComposition()
	 * @generated
	 * @ordered
	 */
	protected boolean composition = COMPOSITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected DataTypeAndTypeParameter type;

	/**
	 * The default value of the '{@link #isMany() <em>Many</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isMany()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MANY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMany() <em>Many</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #isMany()
	 * @generated
	 * @ordered
	 */
	protected boolean many = MANY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getIncrementerReference()
	 * <em>Incrementer Reference</em>}' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getIncrementerReference()
	 * @generated
	 * @ordered
	 */
	protected IncrementerReference incrementerReference;

	/**
	 * The default value of the '{@link #getDefaultValue() <em>Default Value</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getDefaultValue()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFAULT_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefaultValue() <em>Default Value</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getDefaultValue()
	 * @generated
	 * @ordered
	 */
	protected String defaultValue = DEFAULT_VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOpposite() <em>Opposite</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getOpposite()
	 * @generated
	 * @ordered
	 */
	protected Attribute opposite;

	/**
	 * The cached value of the '{@link #getAttributProperties()
	 * <em>Attribut Properties</em>}' containment reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getAttributProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<AttributeProperty> attributProperties;

	/**
	 * The cached value of the '{@link #getSortOrder() <em>Sort Order</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSortOrder()
	 * @generated
	 * @ordered
	 */
	protected AttributeGroup sortOrder;

	/**
	 * The default value of the '{@link #getDataTypeName() <em>Data Type Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getDataTypeName()
	 * @generated
	 * @ordered
	 */
	protected static final String DATA_TYPE_NAME_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isReference() <em>Reference</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isReference()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REFERENCE_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isReadOnly() <em>Read Only</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isReadOnly()
	 * @generated
	 * @ordered
	 */
	protected static final boolean READ_ONLY_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isRequired() <em>Required</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isRequired()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REQUIRED_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isDerived() <em>Derived</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isDerived()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DERIVED_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isTransient() <em>Transient</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isTransient()
	 * @generated
	 * @ordered
	 */
	protected static final boolean TRANSIENT_EDEFAULT = false;

	private Boolean readOnly;
	private Boolean required;
	private Boolean derived;
	private Boolean transientFlag;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ATTRIBUTE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getTxtDescription() {
		return txtDescription;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setTxtDescription(String newTxtDescription) {
		String oldTxtDescription = txtDescription;
		txtDescription = newTxtDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__TXT_DESCRIPTION, oldTxtDescription, txtDescription));
	}

    /**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Type getDataType() {
		if (getType() != null && getType().getDataType() instanceof Type) {
			return (Type) getType().getDataType();
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void setDataType(Type newDataType) {
		if (getType() == null) {
			DataTypeAndTypeParameter dataTypeAndTypeParameter = CoreFactory.eINSTANCE.createDataTypeAndTypeParameter();
			dataTypeAndTypeParameter.setDataType(newDataType);
			setType(dataTypeAndTypeParameter);
		} else {
			getType().setDataType(newDataType);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Attribute getOppositeReference() {
		if (oppositeReference == null) {
			if (opposite != null) {
				oppositeReference = opposite;
			} else if (getDataType() instanceof Entity) {
				Entity entity = (Entity) getDataType();
				for (Iterator<Attribute> iterator = entity.getAllAttributes().iterator(); null == oppositeReference
						&& iterator.hasNext();) {
					Attribute attribute = iterator.next();
					if (this.equals(attribute.getOpposite())) {
						oppositeReference = attribute;
					}
				}
			}
		}
		return oppositeReference;
	}

	private Attribute oppositeReference;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String getDataTypeName() {
		return getDataType() != null ? getDataType().getName() : "";
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isReference() {
		return getDataType() instanceof Entity;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<Attribute> getResolvedAttributeList() {
	    EList<Attribute> resolvedAttributeList = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.ATTRIBUTE__RESOLVED_ATTRIBUTE_LIST);
		if (isReference()) {
			Entity entity = (Entity) getDataType();
			resolvedAttributeList.addAll(entity.getResolvedAttributeList());
		} else {
		    resolvedAttributeList.add(this);
		}
		return resolvedAttributeList;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(boolean newIdentifier) {
		boolean oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__IDENTIFIER, oldIdentifier, identifier));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(boolean newVersion) {
		boolean oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isComposition() {
		return composition;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setComposition(boolean newComposition) {
		boolean oldComposition = composition;
		composition = newComposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__COMPOSITION, oldComposition, composition));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataTypeAndTypeParameter getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetType(DataTypeAndTypeParameter newType, NotificationChain msgs) {
		DataTypeAndTypeParameter oldType = type;
		type = newType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__TYPE, oldType, newType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(DataTypeAndTypeParameter newType) {
		if (newType != type) {
			NotificationChain msgs = null;
			if (type != null)
				msgs = ((InternalEObject)type).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.ATTRIBUTE__TYPE, null, msgs);
			if (newType != null)
				msgs = ((InternalEObject)newType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.ATTRIBUTE__TYPE, null, msgs);
			msgs = basicSetType(newType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__TYPE, newType, newType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isMany() {
		return many;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setMany(boolean newMany) {
		boolean oldMany = many;
		many = newMany;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__MANY, oldMany, many));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultValue(String newDefaultValue) {
		String oldDefaultValue = defaultValue;
		defaultValue = newDefaultValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__DEFAULT_VALUE, oldDefaultValue, defaultValue));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute getOpposite() {
		if (opposite != null && opposite.eIsProxy()) {
			InternalEObject oldOpposite = (InternalEObject)opposite;
			opposite = (Attribute)eResolveProxy(oldOpposite);
			if (opposite != oldOpposite) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.ATTRIBUTE__OPPOSITE, oldOpposite, opposite));
			}
		}
		return opposite;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute basicGetOpposite() {
		return opposite;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setOpposite(Attribute newOpposite) {
		Attribute oldOpposite = opposite;
		opposite = newOpposite;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__OPPOSITE, oldOpposite, opposite));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AttributeProperty> getAttributProperties() {
		if (attributProperties == null) {
			attributProperties = new EObjectContainmentEList<AttributeProperty>(AttributeProperty.class, this, DomPackage.ATTRIBUTE__ATTRIBUT_PROPERTIES);
		}
		return attributProperties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeGroup getSortOrder() {
		if (sortOrder != null && sortOrder.eIsProxy()) {
			InternalEObject oldSortOrder = (InternalEObject)sortOrder;
			sortOrder = (AttributeGroup)eResolveProxy(oldSortOrder);
			if (sortOrder != oldSortOrder) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.ATTRIBUTE__SORT_ORDER, oldSortOrder, sortOrder));
			}
		}
		return sortOrder;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeGroup basicGetSortOrder() {
		return sortOrder;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSortOrder(AttributeGroup newSortOrder) {
		AttributeGroup oldSortOrder = sortOrder;
		sortOrder = newSortOrder;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__SORT_ORDER, oldSortOrder, sortOrder));
	}

	/**
	 * @modified
	 */
	public boolean isReadOnly() {
		if (readOnly == null) {
			readOnly = Iterables.any(getAttributProperties(), new Predicate<AttributeProperty>() {
				public boolean apply(AttributeProperty attributeProperty) {
					if (attributeProperty instanceof ReadOnlyFlag) {
						return Iterators.any(((ReadOnlyFlag) attributeProperty).getExpression().eAllContents(),
								new Predicate<EObject>() {
									public boolean apply(EObject eObject) {
										return eObject instanceof TrueLiteral;
									}
								});
					}
					return false;
				}
			})
					|| (isDerived() && isTransient());

		}
		return readOnly;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isSetReadOnly() {
		return readOnly != null;
	}

	/**
	 * @modified
	 */
	public boolean isRequired() {
		if (required == null) {
			required = Iterables.any(getAttributProperties(), new Predicate<AttributeProperty>() {
				public boolean apply(AttributeProperty attributeProperty) {
					if (attributeProperty instanceof RequiredFlag) {
						return Iterators.any(((RequiredFlag) attributeProperty).getExpression().eAllContents(),
										new Predicate<EObject>() {
												public boolean apply(EObject eObject) {
														return eObject instanceof TrueLiteral;
												}
										});
				}
				return false;
		}
});

}		return required;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isSetRequired() {
		return required != null;
	}

	/**
	 * @modified
	 */
	public boolean isDerived() {
		if (derived == null) {
			derived = Iterables.any(getAttributProperties(), new Predicate<AttributeProperty>() {
				public boolean apply(AttributeProperty arg0) {
					return arg0 instanceof DerivedFlag && ((DerivedFlag) arg0).getExpression() instanceof TrueLiteral;
				}
			});
		}
		return derived;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isSetDerived() {
		return derived != null;
	}

	/**
	 * @modified
	 */
	public boolean isTransient() {
		if (transientFlag == null) {
			transientFlag = Iterables.any(getAttributProperties(), new Predicate<AttributeProperty>() {
				public boolean apply(AttributeProperty arg0) {
					return arg0 instanceof TransientFlag && ((TransientFlag) arg0).getExpression() instanceof TrueLiteral;
				}
			});
		}
		return transientFlag;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public boolean isSetTransient() {
		return transientFlag != null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public IncrementerReference getIncrementerReference() {
		return incrementerReference;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIncrementerReference(IncrementerReference newIncrementerReference,
			NotificationChain msgs) {
		IncrementerReference oldIncrementerReference = incrementerReference;
		incrementerReference = newIncrementerReference;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE, oldIncrementerReference, newIncrementerReference);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncrementerReference(IncrementerReference newIncrementerReference) {
		if (newIncrementerReference != incrementerReference) {
			NotificationChain msgs = null;
			if (incrementerReference != null)
				msgs = ((InternalEObject)incrementerReference).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE, null, msgs);
			if (newIncrementerReference != null)
				msgs = ((InternalEObject)newIncrementerReference).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE, null, msgs);
			msgs = basicSetIncrementerReference(newIncrementerReference, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE, newIncrementerReference, newIncrementerReference));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE__TYPE:
				return basicSetType(null, msgs);
			case DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE:
				return basicSetIncrementerReference(null, msgs);
			case DomPackage.ATTRIBUTE__ATTRIBUT_PROPERTIES:
				return ((InternalEList<?>)getAttributProperties()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE__NAME:
				return getName();
			case DomPackage.ATTRIBUTE__TXT_DESCRIPTION:
				return getTxtDescription();
			case DomPackage.ATTRIBUTE__IDENTIFIER:
				return isIdentifier();
			case DomPackage.ATTRIBUTE__VERSION:
				return isVersion();
			case DomPackage.ATTRIBUTE__COMPOSITION:
				return isComposition();
			case DomPackage.ATTRIBUTE__TYPE:
				return getType();
			case DomPackage.ATTRIBUTE__MANY:
				return isMany();
			case DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE:
				return getIncrementerReference();
			case DomPackage.ATTRIBUTE__DEFAULT_VALUE:
				return getDefaultValue();
			case DomPackage.ATTRIBUTE__OPPOSITE:
				if (resolve) return getOpposite();
				return basicGetOpposite();
			case DomPackage.ATTRIBUTE__ATTRIBUT_PROPERTIES:
				return getAttributProperties();
			case DomPackage.ATTRIBUTE__SORT_ORDER:
				if (resolve) return getSortOrder();
				return basicGetSortOrder();
			case DomPackage.ATTRIBUTE__DATA_TYPE:
				return getDataType();
			case DomPackage.ATTRIBUTE__OPPOSITE_REFERENCE:
				return getOppositeReference();
			case DomPackage.ATTRIBUTE__DATA_TYPE_NAME:
				return getDataTypeName();
			case DomPackage.ATTRIBUTE__RESOLVED_ATTRIBUTE_LIST:
				return getResolvedAttributeList();
			case DomPackage.ATTRIBUTE__REFERENCE:
				return isReference();
			case DomPackage.ATTRIBUTE__READ_ONLY:
				return isReadOnly();
			case DomPackage.ATTRIBUTE__REQUIRED:
				return isRequired();
			case DomPackage.ATTRIBUTE__DERIVED:
				return isDerived();
			case DomPackage.ATTRIBUTE__TRANSIENT:
				return isTransient();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE__NAME:
				setName((String)newValue);
				return;
			case DomPackage.ATTRIBUTE__TXT_DESCRIPTION:
				setTxtDescription((String)newValue);
				return;
			case DomPackage.ATTRIBUTE__IDENTIFIER:
				setIdentifier((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE__VERSION:
				setVersion((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE__COMPOSITION:
				setComposition((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE__TYPE:
				setType((DataTypeAndTypeParameter)newValue);
				return;
			case DomPackage.ATTRIBUTE__MANY:
				setMany((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE:
				setIncrementerReference((IncrementerReference)newValue);
				return;
			case DomPackage.ATTRIBUTE__DEFAULT_VALUE:
				setDefaultValue((String)newValue);
				return;
			case DomPackage.ATTRIBUTE__OPPOSITE:
				setOpposite((Attribute)newValue);
				return;
			case DomPackage.ATTRIBUTE__ATTRIBUT_PROPERTIES:
				getAttributProperties().clear();
				getAttributProperties().addAll((Collection<? extends AttributeProperty>)newValue);
				return;
			case DomPackage.ATTRIBUTE__SORT_ORDER:
				setSortOrder((AttributeGroup)newValue);
				return;
			case DomPackage.ATTRIBUTE__DATA_TYPE:
				setDataType((Type)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__TXT_DESCRIPTION:
				setTxtDescription(TXT_DESCRIPTION_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__IDENTIFIER:
				setIdentifier(IDENTIFIER_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__COMPOSITION:
				setComposition(COMPOSITION_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__TYPE:
				setType((DataTypeAndTypeParameter)null);
				return;
			case DomPackage.ATTRIBUTE__MANY:
				setMany(MANY_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE:
				setIncrementerReference((IncrementerReference)null);
				return;
			case DomPackage.ATTRIBUTE__DEFAULT_VALUE:
				setDefaultValue(DEFAULT_VALUE_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE__OPPOSITE:
				setOpposite((Attribute)null);
				return;
			case DomPackage.ATTRIBUTE__ATTRIBUT_PROPERTIES:
				getAttributProperties().clear();
				return;
			case DomPackage.ATTRIBUTE__SORT_ORDER:
				setSortOrder((AttributeGroup)null);
				return;
			case DomPackage.ATTRIBUTE__DATA_TYPE:
				setDataType((Type)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DomPackage.ATTRIBUTE__TXT_DESCRIPTION:
				return TXT_DESCRIPTION_EDEFAULT == null ? txtDescription != null : !TXT_DESCRIPTION_EDEFAULT.equals(txtDescription);
			case DomPackage.ATTRIBUTE__IDENTIFIER:
				return identifier != IDENTIFIER_EDEFAULT;
			case DomPackage.ATTRIBUTE__VERSION:
				return version != VERSION_EDEFAULT;
			case DomPackage.ATTRIBUTE__COMPOSITION:
				return composition != COMPOSITION_EDEFAULT;
			case DomPackage.ATTRIBUTE__TYPE:
				return type != null;
			case DomPackage.ATTRIBUTE__MANY:
				return many != MANY_EDEFAULT;
			case DomPackage.ATTRIBUTE__INCREMENTER_REFERENCE:
				return incrementerReference != null;
			case DomPackage.ATTRIBUTE__DEFAULT_VALUE:
				return DEFAULT_VALUE_EDEFAULT == null ? defaultValue != null : !DEFAULT_VALUE_EDEFAULT.equals(defaultValue);
			case DomPackage.ATTRIBUTE__OPPOSITE:
				return opposite != null;
			case DomPackage.ATTRIBUTE__ATTRIBUT_PROPERTIES:
				return attributProperties != null && !attributProperties.isEmpty();
			case DomPackage.ATTRIBUTE__SORT_ORDER:
				return sortOrder != null;
			case DomPackage.ATTRIBUTE__DATA_TYPE:
				return getDataType() != null;
			case DomPackage.ATTRIBUTE__OPPOSITE_REFERENCE:
				return getOppositeReference() != null;
			case DomPackage.ATTRIBUTE__DATA_TYPE_NAME:
				return DATA_TYPE_NAME_EDEFAULT == null ? getDataTypeName() != null : !DATA_TYPE_NAME_EDEFAULT.equals(getDataTypeName());
			case DomPackage.ATTRIBUTE__RESOLVED_ATTRIBUTE_LIST:
				return !getResolvedAttributeList().isEmpty();
			case DomPackage.ATTRIBUTE__REFERENCE:
				return isReference() != REFERENCE_EDEFAULT;
			case DomPackage.ATTRIBUTE__READ_ONLY:
				return isReadOnly() != READ_ONLY_EDEFAULT;
			case DomPackage.ATTRIBUTE__REQUIRED:
				return isRequired() != REQUIRED_EDEFAULT;
			case DomPackage.ATTRIBUTE__DERIVED:
				return isDerived() != DERIVED_EDEFAULT;
			case DomPackage.ATTRIBUTE__TRANSIENT:
				return isTransient() != TRANSIENT_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == QueryParameterReference.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == PresentableFeature.class) {
			switch (derivedFeatureID) {
				case DomPackage.ATTRIBUTE__NAME: return DomPackage.PRESENTABLE_FEATURE__NAME;
				default: return -1;
			}
		}
		if (baseClass == IDocumentable.class) {
			switch (derivedFeatureID) {
				case DomPackage.ATTRIBUTE__TXT_DESCRIPTION: return CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == QueryParameterReference.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == PresentableFeature.class) {
			switch (baseFeatureID) {
				case DomPackage.PRESENTABLE_FEATURE__NAME: return DomPackage.ATTRIBUTE__NAME;
				default: return -1;
			}
		}
		if (baseClass == IDocumentable.class) {
			switch (baseFeatureID) {
				case CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION: return DomPackage.ATTRIBUTE__TXT_DESCRIPTION;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", txtDescription: ");
		result.append(txtDescription);
		result.append(", identifier: ");
		result.append(identifier);
		result.append(", version: ");
		result.append(version);
		result.append(", composition: ");
		result.append(composition);
		result.append(", many: ");
		result.append(many);
		result.append(", defaultValue: ");
		result.append(defaultValue);
		result.append(')');
		return result.toString();
	}

    /**
	 * @modified
	 * @return the label text for the field
	 */
	public String getLabelText() {
		EList<AttributeProperty> attrProp = getAttributProperties();
		if (attrProp != null && attrProp.size() > 0) {
			return AttributePropertyImpl.getLabelText(getAttributProperties());
		}
		return null;
	}

    /**
	 * @modified
     * @return the hstore column name for the field
     */
    public String getHstoreColumn() {
        EList<AttributeProperty> attrProp = getAttributProperties();
        if (attrProp != null && attrProp.size() > 0) {
            return AttributePropertyImpl.getHstoreColumn(getAttributProperties());
        }
        return null;
    }

    /**
     * @modified
     * @return true if the hstore column name has been specified
     */
    public boolean isHstore() {
        return getHstoreColumn() != null;
    }
    
    /**
	 * @modified
	 * @return the label text for the field
	 */
	public String getTooltipText() {
		EList<AttributeProperty> attrProp = getAttributProperties();
		if (attrProp != null && attrProp.size() > 0) {
			return AttributePropertyImpl.getTooltipText(getAttributProperties());
		}
		return null;
	}

	/**
	 * @modified
	 * @return the unit text for the field
	 */
	public String getUnitText() {

		EList<AttributeProperty> attrProp = getAttributProperties();
		if (attrProp != null && attrProp.size() > 0) {
			return AttributePropertyImpl.getUnitText(getAttributProperties());
		}
		return null;
	}

	/**
	 * @modified
	 * @return the unit attribute for the attribute
	 */
	public Attribute getUnitAttribute() {

		EList<AttributeProperty> attrProp = getAttributProperties();
		if (attrProp != null && attrProp.size() > 0) {
			return AttributePropertyImpl.getUnitAttribute(getAttributProperties());
		}
		return null;
	}

	/**
	 * @modified
	 * @return the attribute
	 */
	public Attribute getAttribute() {
		return this;
	}

	/**
	 * @modified
	 */
	public boolean isOptional() {
		return !isRequired();
	}

	/**
	 * @modified
	 */
	public boolean isOne() {
		return !isMany();
	}
	
    /**
     * @modified
     * @return the attribute
     */   	
    public String getCalculatedName() {
    	return getName();
    }
    
    /**
     * @modified
     */	
	public ValidatorReference getFormat() {
		return getFormatInternal(getAttributProperties());
	}

    /**
     * @modified
     */		
	public static ValidatorReference getFormatInternal(EList<AttributeProperty> attributProperties) {
		for (AttributeProperty p : attributProperties) {
			if (p instanceof AttributeValidationProperty) {
				AttributeValidationProperty avp = (AttributeValidationProperty)p;
				return avp.getFormat();
			}
		}		
		return null;
	}
	
    private String originalName;

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getOriginalName() {
        return originalName;
    }
    
    private String originalContainerName;

    public void setOriginalContainerName(String originalContainerName) {
        this.originalContainerName = originalContainerName;
    }

    public String getOriginalContainerName() {
        return originalContainerName;
    }
	
} // AttributeImpl
