/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributePropertyImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.AttributeTextProperty;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Attribute Property</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class AttributePropertyImpl extends MinimalEObjectImpl.Container implements AttributeProperty {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributePropertyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ATTRIBUTE_PROPERTY;
	}
	
	/*	
	    * @modified
	    * @return the attributeTextProperty text for attributProperties
	    */
	   public static AttributeTextProperty getAttributeTextProperty(EList<AttributeProperty> attributProperties) {
	   		
			if (attributProperties != null) {
				for (AttributeProperty attributProperty: attributProperties) {
					if (attributProperty instanceof AttributeTextProperty && ((AttributeTextProperty)attributProperty).getLabelText() != null) {
						return ((AttributeTextProperty)attributProperty);
					}
				}
			}
			return null;
	   }

	    /*  
        * @modified
        * @return the attributeTextProperty text for attributProperties that contains the hstore column info
        */
       public static AttributeTextProperty getAttributeHstoreProperty(EList<AttributeProperty> attributProperties) {
            if (attributProperties != null) {
                for (AttributeProperty attributProperty: attributProperties) {
                    if (attributProperty instanceof AttributeTextProperty && ((AttributeTextProperty)attributProperty).getHstoreColumn() != null) {
                        return ((AttributeTextProperty)attributProperty);
                    }
                }
            }
            return null;
       }

		/*	
	    * @modified
	    * @return the label text for attributProperties
	    */
	   public static String getLabelText(EList<AttributeProperty> attributProperties) {
		   AttributeTextProperty txtProp = getAttributeTextProperty(attributProperties);
		   if (txtProp != null) {
			   return txtProp.getLabelText();
		   }
		   return null;
	   }

		/*	
	    * @modified
       * @return the Hstore Column name for attributProperties
       */
      public static String getHstoreColumn(EList<AttributeProperty> attributProperties) {
          AttributeTextProperty txtProp = getAttributeHstoreProperty(attributProperties);
          if (txtProp != null) {
              return txtProp.getHstoreColumn();
          }
          return null;
      }

		/*	
	    * @modified
	    * @return the tooltip text for attributProperties
	    */
	   public static String getTooltipText(EList<AttributeProperty> attributProperties) {
		   
		   AttributeTextProperty txtProp = getAttributeTextProperty(attributProperties);
		   if (txtProp != null) {
			   return txtProp.getTooltipText();
		   }
		   return null;
	   }

		/*	
	    * @modified
	    * @return the unit text for attributProperties
	    */
	   public static String getUnitText(EList<AttributeProperty> attributProperties) {
		   AttributeTextProperty txtProp = getAttributeTextProperty(attributProperties);
		   if (txtProp != null) {
			   return txtProp.getUnitText();
		   }
		   return null;
	   }

		/*	
	    * @modified
	    * @return the attribute for attributProperties
	    */
	   public static Attribute getUnitAttribute(EList<AttributeProperty> attributProperties) {
		   AttributeTextProperty txtProp = getAttributeTextProperty(attributProperties);
		   if (txtProp != null) {
			   return txtProp.getUnitAttribute();
		   }
		   return null;
	   }      

} //AttributePropertyImpl
