/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeSortOrder;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Attribute Sort Order</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl#getAttribute <em>Attribute</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl#isAsc <em>Asc</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeSortOrderImpl#isDesc <em>Desc</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AttributeSortOrderImpl extends MinimalEObjectImpl.Container implements AttributeSortOrder {
	/**
	 * The cached value of the '{@link #getAttribute() <em>Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttribute()
	 * @generated
	 * @ordered
	 */
	protected Attribute attribute;

	/**
	 * The default value of the '{@link #isAsc() <em>Asc</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAsc()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ASC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAsc() <em>Asc</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAsc()
	 * @generated
	 * @ordered
	 */
	protected boolean asc = ASC_EDEFAULT;

	/**
	 * The default value of the '{@link #isDesc() <em>Desc</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDesc()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DESC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDesc() <em>Desc</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDesc()
	 * @generated
	 * @ordered
	 */
	protected boolean desc = DESC_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeSortOrderImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ATTRIBUTE_SORT_ORDER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute getAttribute() {
		if (attribute != null && attribute.eIsProxy()) {
			InternalEObject oldAttribute = (InternalEObject)attribute;
			attribute = (Attribute)eResolveProxy(oldAttribute);
			if (attribute != oldAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.ATTRIBUTE_SORT_ORDER__ATTRIBUTE, oldAttribute, attribute));
			}
		}
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute basicGetAttribute() {
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttribute(Attribute newAttribute) {
		Attribute oldAttribute = attribute;
		attribute = newAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_SORT_ORDER__ATTRIBUTE, oldAttribute, attribute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAsc() {
		return asc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAsc(boolean newAsc) {
		boolean oldAsc = asc;
		asc = newAsc;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_SORT_ORDER__ASC, oldAsc, asc));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDesc() {
		return desc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDesc(boolean newDesc) {
		boolean oldDesc = desc;
		desc = newDesc;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_SORT_ORDER__DESC, oldDesc, desc));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_SORT_ORDER__ATTRIBUTE:
				if (resolve) return getAttribute();
				return basicGetAttribute();
			case DomPackage.ATTRIBUTE_SORT_ORDER__ASC:
				return isAsc();
			case DomPackage.ATTRIBUTE_SORT_ORDER__DESC:
				return isDesc();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_SORT_ORDER__ATTRIBUTE:
				setAttribute((Attribute)newValue);
				return;
			case DomPackage.ATTRIBUTE_SORT_ORDER__ASC:
				setAsc((Boolean)newValue);
				return;
			case DomPackage.ATTRIBUTE_SORT_ORDER__DESC:
				setDesc((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_SORT_ORDER__ATTRIBUTE:
				setAttribute((Attribute)null);
				return;
			case DomPackage.ATTRIBUTE_SORT_ORDER__ASC:
				setAsc(ASC_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_SORT_ORDER__DESC:
				setDesc(DESC_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_SORT_ORDER__ATTRIBUTE:
				return attribute != null;
			case DomPackage.ATTRIBUTE_SORT_ORDER__ASC:
				return asc != ASC_EDEFAULT;
			case DomPackage.ATTRIBUTE_SORT_ORDER__DESC:
				return desc != DESC_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (asc: ");
		result.append(asc);
		result.append(", desc: ");
		result.append(desc);
		result.append(')');
		return result.toString();
	}

} //AttributeSortOrderImpl
