/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributeTextPropertyImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeTextProperty;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Attribute Text Property</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl#getLabelText <em>Label Text</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl#getTooltipText <em>Tooltip Text</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl#getUnitText <em>Unit Text</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl#getUnitAttribute <em>Unit Attribute</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeTextPropertyImpl#getHstoreColumn <em>Hstore Column</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AttributeTextPropertyImpl extends AttributePropertyImpl implements AttributeTextProperty {
	/**
	 * The default value of the '{@link #getLabelText() <em>Label Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelText()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLabelText() <em>Label Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelText()
	 * @generated
	 * @ordered
	 */
	protected String labelText = LABEL_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getTooltipText() <em>Tooltip Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltipText()
	 * @generated
	 * @ordered
	 */
	protected static final String TOOLTIP_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTooltipText() <em>Tooltip Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltipText()
	 * @generated
	 * @ordered
	 */
	protected String tooltipText = TOOLTIP_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getUnitText() <em>Unit Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnitText()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIT_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUnitText() <em>Unit Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnitText()
	 * @generated
	 * @ordered
	 */
	protected String unitText = UNIT_TEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getUnitAttribute() <em>Unit Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnitAttribute()
	 * @generated
	 * @ordered
	 */
	protected Attribute unitAttribute;

	/**
	 * The default value of the '{@link #getHstoreColumn() <em>Hstore Column</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getHstoreColumn()
	 * @generated
	 * @ordered
	 */
    protected static final String HSTORE_COLUMN_EDEFAULT = null;

    /**
	 * The cached value of the '{@link #getHstoreColumn() <em>Hstore Column</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getHstoreColumn()
	 * @generated
	 * @ordered
	 */
    protected String hstoreColumn = HSTORE_COLUMN_EDEFAULT;

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeTextPropertyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ATTRIBUTE_TEXT_PROPERTY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabelText() {
		return labelText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabelText(String newLabelText) {
		String oldLabelText = labelText;
		labelText = newLabelText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT, oldLabelText, labelText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTooltipText() {
		return tooltipText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltipText(String newTooltipText) {
		String oldTooltipText = tooltipText;
		tooltipText = newTooltipText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT, oldTooltipText, tooltipText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUnitText() {
		return unitText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUnitText(String newUnitText) {
		String oldUnitText = unitText;
		unitText = newUnitText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT, oldUnitText, unitText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute getUnitAttribute() {
		if (unitAttribute != null && unitAttribute.eIsProxy()) {
			InternalEObject oldUnitAttribute = (InternalEObject)unitAttribute;
			unitAttribute = (Attribute)eResolveProxy(oldUnitAttribute);
			if (unitAttribute != oldUnitAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE, oldUnitAttribute, unitAttribute));
			}
		}
		return unitAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute basicGetUnitAttribute() {
		return unitAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUnitAttribute(Attribute newUnitAttribute) {
		Attribute oldUnitAttribute = unitAttribute;
		unitAttribute = newUnitAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE, oldUnitAttribute, unitAttribute));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getHstoreColumn() {
		return hstoreColumn;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setHstoreColumn(String newHstoreColumn) {
		String oldHstoreColumn = hstoreColumn;
		hstoreColumn = newHstoreColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN, oldHstoreColumn, hstoreColumn));
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT:
				return getLabelText();
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT:
				return getTooltipText();
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT:
				return getUnitText();
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE:
				if (resolve) return getUnitAttribute();
				return basicGetUnitAttribute();
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN:
				return getHstoreColumn();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT:
				setLabelText((String)newValue);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT:
				setTooltipText((String)newValue);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT:
				setUnitText((String)newValue);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE:
				setUnitAttribute((Attribute)newValue);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN:
				setHstoreColumn((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT:
				setLabelText(LABEL_TEXT_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT:
				setTooltipText(TOOLTIP_TEXT_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT:
				setUnitText(UNIT_TEXT_EDEFAULT);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE:
				setUnitAttribute((Attribute)null);
				return;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN:
				setHstoreColumn(HSTORE_COLUMN_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__LABEL_TEXT:
				return LABEL_TEXT_EDEFAULT == null ? labelText != null : !LABEL_TEXT_EDEFAULT.equals(labelText);
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__TOOLTIP_TEXT:
				return TOOLTIP_TEXT_EDEFAULT == null ? tooltipText != null : !TOOLTIP_TEXT_EDEFAULT.equals(tooltipText);
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_TEXT:
				return UNIT_TEXT_EDEFAULT == null ? unitText != null : !UNIT_TEXT_EDEFAULT.equals(unitText);
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__UNIT_ATTRIBUTE:
				return unitAttribute != null;
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY__HSTORE_COLUMN:
				return HSTORE_COLUMN_EDEFAULT == null ? hstoreColumn != null : !HSTORE_COLUMN_EDEFAULT.equals(hstoreColumn);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (labelText: ");
		result.append(labelText);
		result.append(", tooltipText: ");
		result.append(tooltipText);
		result.append(", unitText: ");
		result.append(unitText);
		result.append(", hstoreColumn: ");
		result.append(hstoreColumn);
		result.append(')');
		return result.toString();
	}

} //AttributeTextPropertyImpl
