/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributeValidationPropertyImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.Constraint;
import org.openxma.dsl.core.model.ValidatorReference;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.AttributeValidationProperty;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Attribute Validation Property</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeValidationPropertyImpl#getConstraints <em>Constraints</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.AttributeValidationPropertyImpl#getFormat <em>Format</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AttributeValidationPropertyImpl extends AttributePropertyImpl implements AttributeValidationProperty {
	/**
	 * The cached value of the '{@link #getConstraints() <em>Constraints</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConstraints()
	 * @generated
	 * @ordered
	 */
	protected EList<Constraint> constraints;

	/**
	 * The cached value of the '{@link #getFormat() <em>Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormat()
	 * @generated
	 * @ordered
	 */
	protected ValidatorReference format;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeValidationPropertyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ATTRIBUTE_VALIDATION_PROPERTY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Constraint> getConstraints() {
		if (constraints == null) {
			constraints = new EObjectContainmentEList<Constraint>(Constraint.class, this, DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS);
		}
		return constraints;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValidatorReference getFormat() {
		return format;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFormat(ValidatorReference newFormat, NotificationChain msgs) {
		ValidatorReference oldFormat = format;
		format = newFormat;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT, oldFormat, newFormat);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFormat(ValidatorReference newFormat) {
		if (newFormat != format) {
			NotificationChain msgs = null;
			if (format != null)
				msgs = ((InternalEObject)format).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT, null, msgs);
			if (newFormat != null)
				msgs = ((InternalEObject)newFormat).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT, null, msgs);
			msgs = basicSetFormat(newFormat, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT, newFormat, newFormat));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS:
				return ((InternalEList<?>)getConstraints()).basicRemove(otherEnd, msgs);
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT:
				return basicSetFormat(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS:
				return getConstraints();
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT:
				return getFormat();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS:
				getConstraints().clear();
				getConstraints().addAll((Collection<? extends Constraint>)newValue);
				return;
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT:
				setFormat((ValidatorReference)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS:
				getConstraints().clear();
				return;
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT:
				setFormat((ValidatorReference)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__CONSTRAINTS:
				return constraints != null && !constraints.isEmpty();
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY__FORMAT:
				return format != null;
		}
		return super.eIsSet(featureID);
	}

} //AttributeValidationPropertyImpl
