/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.CallInputParameter;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Callable Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CallableStatementImpl#isFunctionCall <em>Function Call</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CallableStatementImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CallableStatementImpl#getInParameter <em>In Parameter</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CallableStatementImpl#getOutParameter <em>Out Parameter</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CallableStatementImpl extends QlStatementImpl implements CallableStatement {
	/**
	 * The default value of the '{@link #isFunctionCall() <em>Function Call</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFunctionCall()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FUNCTION_CALL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFunctionCall() <em>Function Call</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFunctionCall()
	 * @generated
	 * @ordered
	 */
	protected boolean functionCall = FUNCTION_CALL_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInParameter() <em>In Parameter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInParameter()
	 * @generated
	 * @ordered
	 */
	protected EList<CallInputParameter> inParameter;

	/**
	 * The cached value of the '{@link #getOutParameter() <em>Out Parameter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutParameter()
	 * @generated
	 * @ordered
	 */
	protected EList<CallOutputParameter> outParameter;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallableStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.CALLABLE_STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFunctionCall() {
		return functionCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFunctionCall(boolean newFunctionCall) {
		boolean oldFunctionCall = functionCall;
		functionCall = newFunctionCall;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.CALLABLE_STATEMENT__FUNCTION_CALL, oldFunctionCall, functionCall));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.CALLABLE_STATEMENT__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CallInputParameter> getInParameter() {
		if (inParameter == null) {
			inParameter = new EObjectContainmentEList<CallInputParameter>(CallInputParameter.class, this, DomPackage.CALLABLE_STATEMENT__IN_PARAMETER);
		}
		return inParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CallOutputParameter> getOutParameter() {
		if (outParameter == null) {
			outParameter = new EObjectContainmentEList<CallOutputParameter>(CallOutputParameter.class, this, DomPackage.CALLABLE_STATEMENT__OUT_PARAMETER);
		}
		return outParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.CALLABLE_STATEMENT__IN_PARAMETER:
				return ((InternalEList<?>)getInParameter()).basicRemove(otherEnd, msgs);
			case DomPackage.CALLABLE_STATEMENT__OUT_PARAMETER:
				return ((InternalEList<?>)getOutParameter()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.CALLABLE_STATEMENT__FUNCTION_CALL:
				return isFunctionCall();
			case DomPackage.CALLABLE_STATEMENT__NAME:
				return getName();
			case DomPackage.CALLABLE_STATEMENT__IN_PARAMETER:
				return getInParameter();
			case DomPackage.CALLABLE_STATEMENT__OUT_PARAMETER:
				return getOutParameter();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.CALLABLE_STATEMENT__FUNCTION_CALL:
				setFunctionCall((Boolean)newValue);
				return;
			case DomPackage.CALLABLE_STATEMENT__NAME:
				setName((String)newValue);
				return;
			case DomPackage.CALLABLE_STATEMENT__IN_PARAMETER:
				getInParameter().clear();
				getInParameter().addAll((Collection<? extends CallInputParameter>)newValue);
				return;
			case DomPackage.CALLABLE_STATEMENT__OUT_PARAMETER:
				getOutParameter().clear();
				getOutParameter().addAll((Collection<? extends CallOutputParameter>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.CALLABLE_STATEMENT__FUNCTION_CALL:
				setFunctionCall(FUNCTION_CALL_EDEFAULT);
				return;
			case DomPackage.CALLABLE_STATEMENT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DomPackage.CALLABLE_STATEMENT__IN_PARAMETER:
				getInParameter().clear();
				return;
			case DomPackage.CALLABLE_STATEMENT__OUT_PARAMETER:
				getOutParameter().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.CALLABLE_STATEMENT__FUNCTION_CALL:
				return functionCall != FUNCTION_CALL_EDEFAULT;
			case DomPackage.CALLABLE_STATEMENT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DomPackage.CALLABLE_STATEMENT__IN_PARAMETER:
				return inParameter != null && !inParameter.isEmpty();
			case DomPackage.CALLABLE_STATEMENT__OUT_PARAMETER:
				return outParameter != null && !outParameter.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (functionCall: ");
		result.append(functionCall);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //CallableStatementImpl
