/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.AltWhenClause;
import org.openxma.dsl.dom.model.CaseExpression;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.WhenClause;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Case Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CaseExpressionImpl#getWhenClause <em>When Clause</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CaseExpressionImpl#getElseExpression <em>Else Expression</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CaseExpressionImpl#getExpression <em>Expression</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.CaseExpressionImpl#getAltWhenClause <em>Alt When Clause</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CaseExpressionImpl extends ExpressionImpl implements CaseExpression {
	/**
	 * The cached value of the '{@link #getWhenClause() <em>When Clause</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWhenClause()
	 * @generated
	 * @ordered
	 */
	protected EList<WhenClause> whenClause;

	/**
	 * The cached value of the '{@link #getElseExpression() <em>Else Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElseExpression()
	 * @generated
	 * @ordered
	 */
	protected Expression elseExpression;

	/**
	 * The cached value of the '{@link #getExpression() <em>Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExpression()
	 * @generated
	 * @ordered
	 */
	protected Expression expression;

	/**
	 * The cached value of the '{@link #getAltWhenClause() <em>Alt When Clause</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAltWhenClause()
	 * @generated
	 * @ordered
	 */
	protected EList<AltWhenClause> altWhenClause;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CaseExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.CASE_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<WhenClause> getWhenClause() {
		if (whenClause == null) {
			whenClause = new EObjectContainmentEList<WhenClause>(WhenClause.class, this, DomPackage.CASE_EXPRESSION__WHEN_CLAUSE);
		}
		return whenClause;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression getElseExpression() {
		return elseExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetElseExpression(Expression newElseExpression, NotificationChain msgs) {
		Expression oldElseExpression = elseExpression;
		elseExpression = newElseExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION, oldElseExpression, newElseExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElseExpression(Expression newElseExpression) {
		if (newElseExpression != elseExpression) {
			NotificationChain msgs = null;
			if (elseExpression != null)
				msgs = ((InternalEObject)elseExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION, null, msgs);
			if (newElseExpression != null)
				msgs = ((InternalEObject)newElseExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION, null, msgs);
			msgs = basicSetElseExpression(newElseExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION, newElseExpression, newElseExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression getExpression() {
		return expression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExpression(Expression newExpression, NotificationChain msgs) {
		Expression oldExpression = expression;
		expression = newExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.CASE_EXPRESSION__EXPRESSION, oldExpression, newExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExpression(Expression newExpression) {
		if (newExpression != expression) {
			NotificationChain msgs = null;
			if (expression != null)
				msgs = ((InternalEObject)expression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.CASE_EXPRESSION__EXPRESSION, null, msgs);
			if (newExpression != null)
				msgs = ((InternalEObject)newExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.CASE_EXPRESSION__EXPRESSION, null, msgs);
			msgs = basicSetExpression(newExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.CASE_EXPRESSION__EXPRESSION, newExpression, newExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AltWhenClause> getAltWhenClause() {
		if (altWhenClause == null) {
			altWhenClause = new EObjectContainmentEList<AltWhenClause>(AltWhenClause.class, this, DomPackage.CASE_EXPRESSION__ALT_WHEN_CLAUSE);
		}
		return altWhenClause;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.CASE_EXPRESSION__WHEN_CLAUSE:
				return ((InternalEList<?>)getWhenClause()).basicRemove(otherEnd, msgs);
			case DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION:
				return basicSetElseExpression(null, msgs);
			case DomPackage.CASE_EXPRESSION__EXPRESSION:
				return basicSetExpression(null, msgs);
			case DomPackage.CASE_EXPRESSION__ALT_WHEN_CLAUSE:
				return ((InternalEList<?>)getAltWhenClause()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.CASE_EXPRESSION__WHEN_CLAUSE:
				return getWhenClause();
			case DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION:
				return getElseExpression();
			case DomPackage.CASE_EXPRESSION__EXPRESSION:
				return getExpression();
			case DomPackage.CASE_EXPRESSION__ALT_WHEN_CLAUSE:
				return getAltWhenClause();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.CASE_EXPRESSION__WHEN_CLAUSE:
				getWhenClause().clear();
				getWhenClause().addAll((Collection<? extends WhenClause>)newValue);
				return;
			case DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION:
				setElseExpression((Expression)newValue);
				return;
			case DomPackage.CASE_EXPRESSION__EXPRESSION:
				setExpression((Expression)newValue);
				return;
			case DomPackage.CASE_EXPRESSION__ALT_WHEN_CLAUSE:
				getAltWhenClause().clear();
				getAltWhenClause().addAll((Collection<? extends AltWhenClause>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.CASE_EXPRESSION__WHEN_CLAUSE:
				getWhenClause().clear();
				return;
			case DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION:
				setElseExpression((Expression)null);
				return;
			case DomPackage.CASE_EXPRESSION__EXPRESSION:
				setExpression((Expression)null);
				return;
			case DomPackage.CASE_EXPRESSION__ALT_WHEN_CLAUSE:
				getAltWhenClause().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.CASE_EXPRESSION__WHEN_CLAUSE:
				return whenClause != null && !whenClause.isEmpty();
			case DomPackage.CASE_EXPRESSION__ELSE_EXPRESSION:
				return elseExpression != null;
			case DomPackage.CASE_EXPRESSION__EXPRESSION:
				return expression != null;
			case DomPackage.CASE_EXPRESSION__ALT_WHEN_CLAUSE:
				return altWhenClause != null && !altWhenClause.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //CaseExpressionImpl
