/**
 * <copyright>
 * </copyright>
 *
 * $Id: ColumnImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.DataTypeAndTypeParameter;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.Column;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Column</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ColumnImpl#getColumnName <em>Column Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ColumnImpl#getUserType <em>User Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ColumnImpl#getColumnType <em>Column Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ColumnImpl#getColumns <em>Columns</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ColumnImpl extends DaoFeatureImpl implements Column {
	/**
	 * The default value of the '{@link #getColumnName() <em>Column Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnName()
	 * @generated
	 * @ordered
	 */
	protected static final String COLUMN_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColumnName() <em>Column Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnName()
	 * @generated
	 * @ordered
	 */
	protected String columnName = COLUMN_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getUserType() <em>User Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserType()
	 * @generated
	 * @ordered
	 */
	protected DataTypeAndTypeParameter userType;

	/**
	 * The cached value of the '{@link #getColumnType() <em>Column Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnType()
	 * @generated
	 * @ordered
	 */
	protected Type columnType;

	/**
	 * The cached value of the '{@link #getColumns() <em>Columns</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumns()
	 * @generated
	 * @ordered
	 */
	protected EList<Column> columns;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ColumnImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.COLUMN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColumnName() {
		return columnName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumnName(String newColumnName) {
		String oldColumnName = columnName;
		columnName = newColumnName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.COLUMN__COLUMN_NAME, oldColumnName, columnName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataTypeAndTypeParameter getUserType() {
		return userType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUserType(DataTypeAndTypeParameter newUserType, NotificationChain msgs) {
		DataTypeAndTypeParameter oldUserType = userType;
		userType = newUserType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.COLUMN__USER_TYPE, oldUserType, newUserType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUserType(DataTypeAndTypeParameter newUserType) {
		if (newUserType != userType) {
			NotificationChain msgs = null;
			if (userType != null)
				msgs = ((InternalEObject)userType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.COLUMN__USER_TYPE, null, msgs);
			if (newUserType != null)
				msgs = ((InternalEObject)newUserType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.COLUMN__USER_TYPE, null, msgs);
			msgs = basicSetUserType(newUserType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.COLUMN__USER_TYPE, newUserType, newUserType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getColumnType() {
		if (columnType != null && columnType.eIsProxy()) {
			InternalEObject oldColumnType = (InternalEObject)columnType;
			columnType = (Type)eResolveProxy(oldColumnType);
			if (columnType != oldColumnType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.COLUMN__COLUMN_TYPE, oldColumnType, columnType));
			}
		}
		return columnType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type basicGetColumnType() {
		return columnType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumnType(Type newColumnType) {
		Type oldColumnType = columnType;
		columnType = newColumnType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.COLUMN__COLUMN_TYPE, oldColumnType, columnType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Column> getColumns() {
		if (columns == null) {
			columns = new EObjectContainmentEList<Column>(Column.class, this, DomPackage.COLUMN__COLUMNS);
		}
		return columns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.COLUMN__USER_TYPE:
				return basicSetUserType(null, msgs);
			case DomPackage.COLUMN__COLUMNS:
				return ((InternalEList<?>)getColumns()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.COLUMN__COLUMN_NAME:
				return getColumnName();
			case DomPackage.COLUMN__USER_TYPE:
				return getUserType();
			case DomPackage.COLUMN__COLUMN_TYPE:
				if (resolve) return getColumnType();
				return basicGetColumnType();
			case DomPackage.COLUMN__COLUMNS:
				return getColumns();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.COLUMN__COLUMN_NAME:
				setColumnName((String)newValue);
				return;
			case DomPackage.COLUMN__USER_TYPE:
				setUserType((DataTypeAndTypeParameter)newValue);
				return;
			case DomPackage.COLUMN__COLUMN_TYPE:
				setColumnType((Type)newValue);
				return;
			case DomPackage.COLUMN__COLUMNS:
				getColumns().clear();
				getColumns().addAll((Collection<? extends Column>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.COLUMN__COLUMN_NAME:
				setColumnName(COLUMN_NAME_EDEFAULT);
				return;
			case DomPackage.COLUMN__USER_TYPE:
				setUserType((DataTypeAndTypeParameter)null);
				return;
			case DomPackage.COLUMN__COLUMN_TYPE:
				setColumnType((Type)null);
				return;
			case DomPackage.COLUMN__COLUMNS:
				getColumns().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.COLUMN__COLUMN_NAME:
				return COLUMN_NAME_EDEFAULT == null ? columnName != null : !COLUMN_NAME_EDEFAULT.equals(columnName);
			case DomPackage.COLUMN__USER_TYPE:
				return userType != null;
			case DomPackage.COLUMN__COLUMN_TYPE:
				return columnType != null;
			case DomPackage.COLUMN__COLUMNS:
				return columns != null && !columns.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (columnName: ");
		result.append(columnName);
		result.append(')');
		return result.toString();
	}

	/**
     *  @generated NOT
     */
    public Column getColumnDefinition(Attribute attribute) {
        for (Column column : getColumns()) {
            if (column.getAttribute() !=null && column.getAttribute().getName().equals(attribute.getName())) {
                return column;
            }
        }
        return null;
    }

} //ColumnImpl
