/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.impl.ModelElementImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataBaseConstraintType;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.QueryOperation;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dao</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getEntity <em>Entity</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getTableName <em>Table Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getDiscriminator <em>Discriminator</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getQualifier <em>Qualifier</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getQueryOperation <em>Query Operation</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getDataBaseConstraints <em>Data Base Constraints</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getColumns <em>Columns</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getManyToOneAssociations <em>Many To One Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getOneToOneAssociations <em>One To One Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getOneToManyAssociations <em>One To Many Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getManyToManyAssociations <em>Many To Many Associations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getPrimaryKeyColumn <em>Primary Key Column</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getNaturalKeyColumns <em>Natural Key Columns</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getVersionColumn <em>Version Column</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getPrimaryKey <em>Primary Key</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DaoImpl#getNaturalKey <em>Natural Key</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DaoImpl extends ModelElementImpl implements Dao {
	/**
	 * The cached value of the '{@link #getEntity() <em>Entity</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntity()
	 * @generated
	 * @ordered
	 */
	protected Entity entity;

	/**
	 * The default value of the '{@link #getTableName() <em>Table Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTableName()
	 * @generated
	 * @ordered
	 */
	protected static final String TABLE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTableName() <em>Table Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTableName()
	 * @generated
	 * @ordered
	 */
	protected String tableName = TABLE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDiscriminator() <em>Discriminator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminator()
	 * @generated
	 * @ordered
	 */
	protected static final String DISCRIMINATOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDiscriminator() <em>Discriminator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminator()
	 * @generated
	 * @ordered
	 */
	protected String discriminator = DISCRIMINATOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getQualifier() <em>Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifier()
	 * @generated
	 * @ordered
	 */
	protected static final String QUALIFIER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getQualifier() <em>Qualifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifier()
	 * @generated
	 * @ordered
	 */
	protected String qualifier = QUALIFIER_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOperations() <em>Operations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperations()
	 * @generated
	 * @ordered
	 */
	protected EList<Operation> operations;

	/**
	 * The cached value of the '{@link #getQueryOperation() <em>Query Operation</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueryOperation()
	 * @generated
	 * @ordered
	 */
	protected EList<QueryOperation> queryOperation;

	/**
	 * The cached value of the '{@link #getDataBaseConstraints() <em>Data Base Constraints</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataBaseConstraints()
	 * @generated
	 * @ordered
	 */
	protected EList<DataBaseConstraint> dataBaseConstraints;

	/**
	 * The cached value of the '{@link #getColumns() <em>Columns</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumns()
	 * @generated
	 * @ordered
	 */
	protected EList<Column> columns;

	/**
	 * The cached value of the '{@link #getManyToOneAssociations() <em>Many To One Associations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManyToOneAssociations()
	 * @generated
	 * @ordered
	 */
	protected EList<ManyToOne> manyToOneAssociations;

	/**
	 * The cached value of the '{@link #getOneToOneAssociations() <em>One To One Associations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOneToOneAssociations()
	 * @generated
	 * @ordered
	 */
	protected EList<OneToOne> oneToOneAssociations;

	/**
	 * The cached value of the '{@link #getOneToManyAssociations() <em>One To Many Associations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOneToManyAssociations()
	 * @generated
	 * @ordered
	 */
	protected EList<OneToMany> oneToManyAssociations;

	/**
	 * The cached value of the '{@link #getManyToManyAssociations() <em>Many To Many Associations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManyToManyAssociations()
	 * @generated
	 * @ordered
	 */
	protected EList<ManyToMany> manyToManyAssociations;
	/**
	 * The cached value of the '{@link #getPrimaryKey() <em>DataBaseConstraint</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrimaryKey()
	 * @generated NOT
	 * @ordered
	 */
	protected DataBaseConstraint primaryKey;
	
	/**
	 * The cached value of the '{@link #getPrimaryKeyColumn() <em>Column</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrimaryKeyColumn()
	 * @generated NOT
	 * @ordered
	 */
	protected Column primaryKeyColumn;
	
	/**
	 * The cached value of the '{@link #getVersionColumn() <em>Column</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersionColumn()
	 * @generated NOT
	 * @ordered
	 */
	protected Column versionColumn;
	
	/**
	 * The cached value of the '{@link #getNaturalKey() <em>DataBaseConstraint</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntity()
	 * @generated NOT
	 * @ordered
	 */
	protected DataBaseConstraint naturalKey;
	
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DaoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.DAO;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entity getEntity() {
		if (entity != null && entity.eIsProxy()) {
			InternalEObject oldEntity = (InternalEObject)entity;
			entity = (Entity)eResolveProxy(oldEntity);
			if (entity != oldEntity) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.DAO__ENTITY, oldEntity, entity));
			}
		}
		return entity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entity basicGetEntity() {
		return entity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntity(Entity newEntity) {
		Entity oldEntity = entity;
		entity = newEntity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DAO__ENTITY, oldEntity, entity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTableName() {
		return tableName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTableName(String newTableName) {
		String oldTableName = tableName;
		tableName = newTableName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DAO__TABLE_NAME, oldTableName, tableName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDiscriminator() {
		return discriminator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDiscriminator(String newDiscriminator) {
		String oldDiscriminator = discriminator;
		discriminator = newDiscriminator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DAO__DISCRIMINATOR, oldDiscriminator, discriminator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getQualifier() {
		return qualifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQualifier(String newQualifier) {
		String oldQualifier = qualifier;
		qualifier = newQualifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DAO__QUALIFIER, oldQualifier, qualifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DataBaseConstraint> getDataBaseConstraints() {
		if (dataBaseConstraints == null) {
			dataBaseConstraints = new EObjectContainmentEList<DataBaseConstraint>(DataBaseConstraint.class, this, DomPackage.DAO__DATA_BASE_CONSTRAINTS);
		}
		return dataBaseConstraints;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Operation> getOperations() {
		if (operations == null) {
			operations = new EObjectContainmentEList<Operation>(Operation.class, this, DomPackage.DAO__OPERATIONS);
		}
		return operations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<QueryOperation> getQueryOperation() {
		if (queryOperation == null) {
			queryOperation = new EObjectContainmentEList<QueryOperation>(QueryOperation.class, this, DomPackage.DAO__QUERY_OPERATION);
		}
		return queryOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Column> getColumns() {
		if (columns == null) {
			columns = new EObjectContainmentEList<Column>(Column.class, this, DomPackage.DAO__COLUMNS);
		}
		return columns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ManyToOne> getManyToOneAssociations() {
		if (manyToOneAssociations == null) {
			manyToOneAssociations = new EObjectContainmentEList<ManyToOne>(ManyToOne.class, this, DomPackage.DAO__MANY_TO_ONE_ASSOCIATIONS);
		}
		return manyToOneAssociations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<OneToOne> getOneToOneAssociations() {
		if (oneToOneAssociations == null) {
			oneToOneAssociations = new EObjectContainmentEList<OneToOne>(OneToOne.class, this, DomPackage.DAO__ONE_TO_ONE_ASSOCIATIONS);
		}
		return oneToOneAssociations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<OneToMany> getOneToManyAssociations() {
		if (oneToManyAssociations == null) {
			oneToManyAssociations = new EObjectContainmentEList<OneToMany>(OneToMany.class, this, DomPackage.DAO__ONE_TO_MANY_ASSOCIATIONS);
		}
		return oneToManyAssociations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ManyToMany> getManyToManyAssociations() {
		if (manyToManyAssociations == null) {
			manyToManyAssociations = new EObjectContainmentEList<ManyToMany>(ManyToMany.class, this, DomPackage.DAO__MANY_TO_MANY_ASSOCIATIONS);
		}
		return manyToManyAssociations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Column getPrimaryKeyColumn() {
		if (primaryKeyColumn==null) {
			for (Column column : getColumns()) {
				if (null!=column.getAttribute() && column.getAttribute().isIdentifier()) {
					primaryKeyColumn = column;
				}
			}
		}
		return primaryKeyColumn;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Column getVersionColumn() {
		if (versionColumn==null) {
			for (Column column : getColumns()) {
				if (null!=column.getAttribute() && column.getAttribute().isVersion()) {
					versionColumn = column;
				}
			}
		}
		return versionColumn;
	}
	
	/**
	 *  @generated NOT
	 */
	public DataBaseConstraint getPrimaryKey() {
		if (primaryKey==null) {
			Iterator<DataBaseConstraint> iterator = getDataBaseConstraintByType(DataBaseConstraintType.PRIMARY).iterator();
			primaryKey= iterator.hasNext() ? iterator.next() : null;
		}
		return primaryKey;
	}

	/**
	 *  @generated NOT
	 */
	public DataBaseConstraint getNaturalKey() {
		if (naturalKey==null) {
			Iterator<DataBaseConstraint> iterator = getDataBaseConstraintByType(DataBaseConstraintType.NATURAL).iterator();
			naturalKey= iterator.hasNext() ? iterator.next() : null;
		}
		return naturalKey;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Column> getNaturalKeyColumns() {
	    EList<Column> naturalKeyColumns = new EObjectEList<Column>(Column.class, this, DomPackage.DAO__NATURAL_KEY_COLUMNS);
		if (naturalKeyColumns.isEmpty()) {
			DataBaseConstraint naturalKey = getNaturalKey();
			if (naturalKey != null) {
				for (Attribute attribute : naturalKey.getAttributes()) {
					naturalKeyColumns.add(getColumnDefinition(attribute));
				}
			}
		}
		return naturalKeyColumns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.DAO__OPERATIONS:
				return ((InternalEList<?>)getOperations()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__QUERY_OPERATION:
				return ((InternalEList<?>)getQueryOperation()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__DATA_BASE_CONSTRAINTS:
				return ((InternalEList<?>)getDataBaseConstraints()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__COLUMNS:
				return ((InternalEList<?>)getColumns()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__MANY_TO_ONE_ASSOCIATIONS:
				return ((InternalEList<?>)getManyToOneAssociations()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__ONE_TO_ONE_ASSOCIATIONS:
				return ((InternalEList<?>)getOneToOneAssociations()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__ONE_TO_MANY_ASSOCIATIONS:
				return ((InternalEList<?>)getOneToManyAssociations()).basicRemove(otherEnd, msgs);
			case DomPackage.DAO__MANY_TO_MANY_ASSOCIATIONS:
				return ((InternalEList<?>)getManyToManyAssociations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.DAO__ENTITY:
				if (resolve) return getEntity();
				return basicGetEntity();
			case DomPackage.DAO__TABLE_NAME:
				return getTableName();
			case DomPackage.DAO__DISCRIMINATOR:
				return getDiscriminator();
			case DomPackage.DAO__QUALIFIER:
				return getQualifier();
			case DomPackage.DAO__OPERATIONS:
				return getOperations();
			case DomPackage.DAO__QUERY_OPERATION:
				return getQueryOperation();
			case DomPackage.DAO__DATA_BASE_CONSTRAINTS:
				return getDataBaseConstraints();
			case DomPackage.DAO__COLUMNS:
				return getColumns();
			case DomPackage.DAO__MANY_TO_ONE_ASSOCIATIONS:
				return getManyToOneAssociations();
			case DomPackage.DAO__ONE_TO_ONE_ASSOCIATIONS:
				return getOneToOneAssociations();
			case DomPackage.DAO__ONE_TO_MANY_ASSOCIATIONS:
				return getOneToManyAssociations();
			case DomPackage.DAO__MANY_TO_MANY_ASSOCIATIONS:
				return getManyToManyAssociations();
			case DomPackage.DAO__PRIMARY_KEY_COLUMN:
				return getPrimaryKeyColumn();
			case DomPackage.DAO__NATURAL_KEY_COLUMNS:
				return getNaturalKeyColumns();
			case DomPackage.DAO__VERSION_COLUMN:
				return getVersionColumn();
			case DomPackage.DAO__PRIMARY_KEY:
				return getPrimaryKey();
			case DomPackage.DAO__NATURAL_KEY:
				return getNaturalKey();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.DAO__ENTITY:
				setEntity((Entity)newValue);
				return;
			case DomPackage.DAO__TABLE_NAME:
				setTableName((String)newValue);
				return;
			case DomPackage.DAO__DISCRIMINATOR:
				setDiscriminator((String)newValue);
				return;
			case DomPackage.DAO__QUALIFIER:
				setQualifier((String)newValue);
				return;
			case DomPackage.DAO__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection<? extends Operation>)newValue);
				return;
			case DomPackage.DAO__QUERY_OPERATION:
				getQueryOperation().clear();
				getQueryOperation().addAll((Collection<? extends QueryOperation>)newValue);
				return;
			case DomPackage.DAO__DATA_BASE_CONSTRAINTS:
				getDataBaseConstraints().clear();
				getDataBaseConstraints().addAll((Collection<? extends DataBaseConstraint>)newValue);
				return;
			case DomPackage.DAO__COLUMNS:
				getColumns().clear();
				getColumns().addAll((Collection<? extends Column>)newValue);
				return;
			case DomPackage.DAO__MANY_TO_ONE_ASSOCIATIONS:
				getManyToOneAssociations().clear();
				getManyToOneAssociations().addAll((Collection<? extends ManyToOne>)newValue);
				return;
			case DomPackage.DAO__ONE_TO_ONE_ASSOCIATIONS:
				getOneToOneAssociations().clear();
				getOneToOneAssociations().addAll((Collection<? extends OneToOne>)newValue);
				return;
			case DomPackage.DAO__ONE_TO_MANY_ASSOCIATIONS:
				getOneToManyAssociations().clear();
				getOneToManyAssociations().addAll((Collection<? extends OneToMany>)newValue);
				return;
			case DomPackage.DAO__MANY_TO_MANY_ASSOCIATIONS:
				getManyToManyAssociations().clear();
				getManyToManyAssociations().addAll((Collection<? extends ManyToMany>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.DAO__ENTITY:
				setEntity((Entity)null);
				return;
			case DomPackage.DAO__TABLE_NAME:
				setTableName(TABLE_NAME_EDEFAULT);
				return;
			case DomPackage.DAO__DISCRIMINATOR:
				setDiscriminator(DISCRIMINATOR_EDEFAULT);
				return;
			case DomPackage.DAO__QUALIFIER:
				setQualifier(QUALIFIER_EDEFAULT);
				return;
			case DomPackage.DAO__OPERATIONS:
				getOperations().clear();
				return;
			case DomPackage.DAO__QUERY_OPERATION:
				getQueryOperation().clear();
				return;
			case DomPackage.DAO__DATA_BASE_CONSTRAINTS:
				getDataBaseConstraints().clear();
				return;
			case DomPackage.DAO__COLUMNS:
				getColumns().clear();
				return;
			case DomPackage.DAO__MANY_TO_ONE_ASSOCIATIONS:
				getManyToOneAssociations().clear();
				return;
			case DomPackage.DAO__ONE_TO_ONE_ASSOCIATIONS:
				getOneToOneAssociations().clear();
				return;
			case DomPackage.DAO__ONE_TO_MANY_ASSOCIATIONS:
				getOneToManyAssociations().clear();
				return;
			case DomPackage.DAO__MANY_TO_MANY_ASSOCIATIONS:
				getManyToManyAssociations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.DAO__ENTITY:
				return entity != null;
			case DomPackage.DAO__TABLE_NAME:
				return TABLE_NAME_EDEFAULT == null ? tableName != null : !TABLE_NAME_EDEFAULT.equals(tableName);
			case DomPackage.DAO__DISCRIMINATOR:
				return DISCRIMINATOR_EDEFAULT == null ? discriminator != null : !DISCRIMINATOR_EDEFAULT.equals(discriminator);
			case DomPackage.DAO__QUALIFIER:
				return QUALIFIER_EDEFAULT == null ? qualifier != null : !QUALIFIER_EDEFAULT.equals(qualifier);
			case DomPackage.DAO__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case DomPackage.DAO__QUERY_OPERATION:
				return queryOperation != null && !queryOperation.isEmpty();
			case DomPackage.DAO__DATA_BASE_CONSTRAINTS:
				return dataBaseConstraints != null && !dataBaseConstraints.isEmpty();
			case DomPackage.DAO__COLUMNS:
				return columns != null && !columns.isEmpty();
			case DomPackage.DAO__MANY_TO_ONE_ASSOCIATIONS:
				return manyToOneAssociations != null && !manyToOneAssociations.isEmpty();
			case DomPackage.DAO__ONE_TO_ONE_ASSOCIATIONS:
				return oneToOneAssociations != null && !oneToOneAssociations.isEmpty();
			case DomPackage.DAO__ONE_TO_MANY_ASSOCIATIONS:
				return oneToManyAssociations != null && !oneToManyAssociations.isEmpty();
			case DomPackage.DAO__MANY_TO_MANY_ASSOCIATIONS:
				return manyToManyAssociations != null && !manyToManyAssociations.isEmpty();
			case DomPackage.DAO__PRIMARY_KEY_COLUMN:
				return getPrimaryKeyColumn() != null;
			case DomPackage.DAO__NATURAL_KEY_COLUMNS:
				return !getNaturalKeyColumns().isEmpty();
			case DomPackage.DAO__VERSION_COLUMN:
				return getVersionColumn() != null;
			case DomPackage.DAO__PRIMARY_KEY:
				return getPrimaryKey() != null;
			case DomPackage.DAO__NATURAL_KEY:
				return getNaturalKey() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (tableName: ");
		result.append(tableName);
		result.append(", discriminator: ");
		result.append(discriminator);
		result.append(", qualifier: ");
		result.append(qualifier);
		result.append(')');
		return result.toString();
	}
	
	/**
	 *  @generated NOT
	 */
	public Column getColumnDefinition(Attribute attribute) {
		for (Column column : getColumns()) {
			if (column.getAttribute() !=null && column.getAttribute().getName().equals(attribute.getName())) {
				return column;
			}
		}
		return null;
	}

	/**
	 *  @generated NOT
	 */
	public OneToMany getOneToMany(Attribute feature) {
		for (OneToMany oneToMany : getOneToManyAssociations()) {
			if (oneToMany.getAttribute().equals(feature)) {
				return oneToMany;
			}
		}
		return null;
	}

	/**
	 *  @generated NOT
	 */
	public ManyToMany getManyToMany(Attribute feature) {
		for (ManyToMany manyToMany : getManyToManyAssociations()) {
			if (manyToMany.getAttribute().equals(feature)) {
				return manyToMany;
			}
		}
		return null;
	}

	/**
	 *  @generated NOT
	 */
	public ManyToOne getManyToOne(Attribute feature) {
		for (ManyToOne manyToOne : getManyToOneAssociations()) {
			if (manyToOne.getAttribute().equals(feature)) {
				return manyToOne;
			}
		}
		return null;
	}

	/**
	 *  @generated NOT
	 */
	public OneToOne getOneToOne(Attribute feature) {
		EList<OneToOne> oneToManyAssociations = getOneToOneAssociations();
		for (OneToOne oneToOne : oneToManyAssociations) {
			if (oneToOne.getAttribute().equals(feature)) {
				return oneToOne;
			}
		}
		return null;
	}
	


	/**
	 *  @generated NOT
	 */
	public Collection<DataBaseConstraint> getDataBaseConstraintByType(final DataBaseConstraintType type) {
		return Collections2.filter(getDataBaseConstraints(), new Predicate<DataBaseConstraint>() {
			public boolean apply(DataBaseConstraint dataBaseConstraint) {
				return type.equals(dataBaseConstraint.getType());
			}
		});
	}

} //DaoImpl
