/**
 * <copyright>
 * </copyright>
 *
 * $Id: DataBaseConstraintImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.openxma.dsl.common.extensions.EObjectPropertiesAdapter;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataBaseConstraintType;
import org.openxma.dsl.dom.model.Entity;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Data Base Constraint</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl#getAttributes <em>Attributes</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DataBaseConstraintImpl#getResolvedAttributeList <em>Resolved Attribute List</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataBaseConstraintImpl extends MinimalEObjectImpl.Container implements DataBaseConstraint {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final DataBaseConstraintType TYPE_EDEFAULT = DataBaseConstraintType.NULL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected DataBaseConstraintType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAttributes() <em>Attributes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> attributes;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DataBaseConstraintImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.DATA_BASE_CONSTRAINT;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataBaseConstraintType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(DataBaseConstraintType newType) {
		DataBaseConstraintType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DATA_BASE_CONSTRAINT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DATA_BASE_CONSTRAINT__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Attribute> getAttributes() {
		if (attributes == null) {
			attributes = new EObjectResolvingEList<Attribute>(Attribute.class, this, DomPackage.DATA_BASE_CONSTRAINT__ATTRIBUTES);
		}
		return attributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<Attribute> getResolvedAttributeList() {
	    EList<Attribute> allAttributes = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.DATA_BASE_CONSTRAINT__RESOLVED_ATTRIBUTE_LIST);
		for (Attribute feature : getAttributes()) {
			List<Attribute> tempList = feature.getResolvedAttributeList();
			if (tempList != null) {
				allAttributes.addAll(tempList);
			}
		}
		for (Attribute attribute : allAttributes) {
			for (Attribute attributeHolder : allAttributes) {
				if (attributeHolder != attribute
						&& (attributeHolder.getName().equals(attribute.getName()) || getEntity(attributeHolder) != getEntity(attribute))) {
					String entityName = getEntity(attribute).getName();
					EObjectPropertiesAdapter.setProperty(attribute.getAttribute(), "fqn", entityName);
				}
			}
		}
		return allAttributes;
	}

	/**
	 * @generated NOT
	 */
	private  Entity getEntity(Attribute attributeHolder) {
		Attribute attr = attributeHolder.getAttribute();
		EObject container = (EObject) (attr.eContainer()!=null ? attr.eContainer() : EObjectPropertiesAdapter.getProperty(attributeHolder, "entity"));
		if (container instanceof Entity) {
			return (Entity)container;
		}
		return null;
	}

	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.DATA_BASE_CONSTRAINT__TYPE:
				return getType();
			case DomPackage.DATA_BASE_CONSTRAINT__NAME:
				return getName();
			case DomPackage.DATA_BASE_CONSTRAINT__ATTRIBUTES:
				return getAttributes();
			case DomPackage.DATA_BASE_CONSTRAINT__RESOLVED_ATTRIBUTE_LIST:
				return getResolvedAttributeList();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.DATA_BASE_CONSTRAINT__TYPE:
				setType((DataBaseConstraintType)newValue);
				return;
			case DomPackage.DATA_BASE_CONSTRAINT__NAME:
				setName((String)newValue);
				return;
			case DomPackage.DATA_BASE_CONSTRAINT__ATTRIBUTES:
				getAttributes().clear();
				getAttributes().addAll((Collection<? extends Attribute>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.DATA_BASE_CONSTRAINT__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case DomPackage.DATA_BASE_CONSTRAINT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DomPackage.DATA_BASE_CONSTRAINT__ATTRIBUTES:
				getAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.DATA_BASE_CONSTRAINT__TYPE:
				return type != TYPE_EDEFAULT;
			case DomPackage.DATA_BASE_CONSTRAINT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DomPackage.DATA_BASE_CONSTRAINT__ATTRIBUTES:
				return attributes != null && !attributes.isEmpty();
			case DomPackage.DATA_BASE_CONSTRAINT__RESOLVED_ATTRIBUTE_LIST:
				return !getResolvedAttributeList().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} // DataBaseConstraintImpl
