/**
 * <copyright>
 * </copyright>
 *
 * $Id: DataViewImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import static com.google.common.collect.Collections2.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeSortOrder;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.PresentableFeature;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Data View</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DataViewImpl#getSuperType <em>Super Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DataViewImpl#getFeatureReferences <em>Feature References</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataViewImpl extends ComplexTypeImpl implements DataView {

	/**
	 * @generated NOT
	 */
	private static final int ALL = 1;

	/**
	 * @generated NOT
	 */
	private static final int ATTRIBUTE = 5;

	/**
	 * The cached value of the '{@link #getSuperType() <em>Super Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSuperType()
	 * @generated
	 * @ordered
	 */
	protected DataView superType;
	/**
	 * The cached value of the '{@link #getFeatureReferences()
	 * <em>Feature References</em>}' containment reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getFeatureReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<FeatureReference> featureReferences;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DataViewImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.DATA_VIEW;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataView getSuperType() {
		if (superType != null && superType.eIsProxy()) {
			InternalEObject oldSuperType = (InternalEObject)superType;
			superType = (DataView)eResolveProxy(oldSuperType);
			if (superType != oldSuperType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.DATA_VIEW__SUPER_TYPE, oldSuperType, superType));
			}
		}
		return superType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataView basicGetSuperType() {
		return superType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuperType(DataView newSuperType) {
		DataView oldSuperType = superType;
		superType = newSuperType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DATA_VIEW__SUPER_TYPE, oldSuperType, superType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<FeatureReference> getFeatureReferences() {
		if (featureReferences == null) {
			featureReferences = new EObjectContainmentEList<FeatureReference>(FeatureReference.class, this, DomPackage.DATA_VIEW__FEATURE_REFERENCES);
		}
		return featureReferences;
	}

	/**
	 * @generated NOT
	 */
	public EList<Attribute> getReferencedAssociations() {
		EList<Attribute> referencedAssociations = new BasicEList<Attribute>();
		for (FeatureReference featureReference : getFeatureReferences()) {
			if (featureReference.getAttribute().isReference()) {
				referencedAssociations.add(featureReference.getAttribute());
			} else if (featureReference.isAll()) {
				referencedAssociations.addAll(featureReference.getSource().getRequiredReferences());
			}
		}
		return referencedAssociations;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.DATA_VIEW__FEATURE_REFERENCES:
				return ((InternalEList<?>)getFeatureReferences()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.DATA_VIEW__SUPER_TYPE:
				if (resolve) return getSuperType();
				return basicGetSuperType();
			case DomPackage.DATA_VIEW__FEATURE_REFERENCES:
				return getFeatureReferences();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.DATA_VIEW__SUPER_TYPE:
				setSuperType((DataView)newValue);
				return;
			case DomPackage.DATA_VIEW__FEATURE_REFERENCES:
				getFeatureReferences().clear();
				getFeatureReferences().addAll((Collection<? extends FeatureReference>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.DATA_VIEW__SUPER_TYPE:
				setSuperType((DataView)null);
				return;
			case DomPackage.DATA_VIEW__FEATURE_REFERENCES:
				getFeatureReferences().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.DATA_VIEW__SUPER_TYPE:
				return superType != null;
			case DomPackage.DATA_VIEW__FEATURE_REFERENCES:
				return featureReferences != null && !featureReferences.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * @generated NOT
	 */
	@Override
	public EList<Attribute> getAllAttributes() {
	    EList<Attribute> allAttributeHolders = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.DATA_VIEW__ALL_ATTRIBUTES);
		for (FeatureReference featureReference : getFeatureReferences()) {
			List<Attribute> tempList = allAttributeHolders(featureReference);
			if (tempList != null) {
				allAttributeHolders.addAll(tempList);
			}
		}
		if (getAttributes() != null && getAttributes().size() > 0) {
			allAttributeHolders.addAll(getAttributes());
		}
		return allAttributeHolders;
	}

	/**
	 * @generated NOT
	 */
	public List<PresentableFeature> getAllPresentableFeaturesIncludingSuperType() {
		List<PresentableFeature> presentableFeatureList = new ArrayList<PresentableFeature>();
		presentableFeatureList.addAll(getAttributes());

		for (FeatureReference fr : getFeatureReferences()) {
			int incExcType = getIncExcType(fr);
			switch (incExcType) {
			case ALL:
				if (fr.getSource() != null) {
					presentableFeatureList.addAll(fr.getSource().getAllPresentableFeaturesIncludingSuperType());
				}
				break;
			case ATTRIBUTE:
				presentableFeatureList.add(fr);
				break;
			default:
				throw new RuntimeException("Unsupported type of IncludeExclude for "
						+ ((ComplexType) fr.eContainer()).getName());
			}
		}

		if (getSuperType() != null) {
			presentableFeatureList.addAll(getSuperType().getAllPresentableFeaturesIncludingSuperType());
		}
		return presentableFeatureList;
	}

	/**
	 * @generated NOT
	 */
	public List<Attribute> allAttributeHolders(FeatureReference featureReference) {
		int incExcType = getIncExcType(featureReference);
		switch (incExcType) {
		case ALL:
			return (List<Attribute>) (featureReference.getSource() != null ? featureReference.getSource().getAllAttributes()
					: Lists.newArrayList());
		case ATTRIBUTE:
			List<Attribute> tempAttrList = Lists.newArrayList();
			if (featureReference.getAttribute() != null) {
				tempAttrList.add((Attribute) featureReference.getAttribute());
			}
			return tempAttrList;
		default:
			throw new RuntimeException("Unsupported type of IncludeExclude for "
					+ ((ComplexType) featureReference.eContainer()).getName());
		}
	}

	/**
	 * @generated NOT
	 */
	private int getIncExcType(FeatureReference incExcDef) {

		if (incExcDef.isAll()) {
			return ALL;
		}
		return ATTRIBUTE;
	}

	/**
	 * @generated NOT
	 */
	public boolean includesAllRequiredFeaturesFor(final Entity entity) {
		if (!includesAllFeaturesByWildcard(entity)) {
			List<Attribute> includedAttributes = resolveIncludedAttributes(filterIncludedFeaturesBySource(entity));
			return includedAttributes.containsAll(entity.getRequiredAttributes())
					&& Iterables.all(entity.getRequiredReferences(), new Predicate<Attribute>() {
						public boolean apply(Attribute structuralFeature) {
							Entity entity = (Entity) structuralFeature.getDataType();
							return includesIdentifierFor(entity);
						}
					});
		}
		return true;
	}

	/**
	 * @generated NOT
	 */
	public boolean includesIdentifierFor(Entity entity) {
		List<Attribute> includedFeatures = resolveIncludedAttributes(filterIncludedFeaturesBySource(entity));
		return Iterables.any(includedFeatures, new Predicate<Attribute>() {
			public boolean apply(Attribute structuralFeature) {
				if (structuralFeature instanceof Attribute) {
					Attribute attribute = (Attribute) structuralFeature;
					return attribute.isIdentifier();
				}
				return false;
			}
		});
	}

	/**
	 * @generated NOT
	 */
	public boolean includesKeyFor(Entity entity) {
		List<Attribute> includedFeatures = resolveIncludedAttributes(filterIncludedFeaturesBySource(entity));
		return includedFeatures.containsAll(Collections2.transform(
						entity.getKey().getAttributes(), new Function<AttributeSortOrder, Attribute>() {
							public Attribute apply(AttributeSortOrder from) {
								return from.getAttribute();
							}
						}));	
		
	}

	/**
	 * @generated NOT
	 */
	public boolean includesVersionFor(Entity entity) {
		List<Attribute> includedFeatures = resolveIncludedAttributes(filterIncludedFeaturesBySource(entity));
		return Iterables.any(includedFeatures, new Predicate<Attribute>() {
			public boolean apply(Attribute structuralFeature) {
				if (structuralFeature instanceof Attribute) {
					Attribute attribute = (Attribute) structuralFeature;
					return attribute.isVersion();
				}
				return false;
			}
		});
	}

	private Collection<FeatureReference> filterIncludedFeaturesBySource(final Entity entity) {
		return filter(getFeatureReferences(), new Predicate<FeatureReference>() {
			public boolean apply(FeatureReference featureReference) {
				return featureReference.getSource().equals(entity);
			}
		});
	}

	private List<Attribute> resolveIncludedAttributes(Collection<FeatureReference> featureReferences) {
		List<Attribute> structuralFeatures = Lists.newArrayList();
		for (FeatureReference featureReference : featureReferences) {
			if (featureReference.getAttribute() != null) {
				structuralFeatures.add(featureReference.getAttribute());
			} else if (featureReference.isAll()) {
				EList<Attribute> allAttributeHolders = featureReference.getSource().getAllAttributes();
				structuralFeatures.addAll(allAttributeHolders);
			}
		}
		return structuralFeatures;
	}

	private boolean includesAllFeaturesByWildcard(Entity entity) {
		return Iterables.any(filterIncludedFeaturesBySource(entity), new Predicate<FeatureReference>() {
			public boolean apply(FeatureReference input) {
				return input.isAll();
			}
		});
	}
	
	private String originalName;
	private String originalContainerName;

    public String getOriginalName() {
        return originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getOriginalContainerName() {
        return originalContainerName;
    }

    public void setOriginalContainerName(String originalContainerName) {
        this.originalContainerName = originalContainerName;
    }
	
	

} // DataViewImpl
