/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.CrudOperationType;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DaoOperation;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.Expression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Delegate Operation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getTxtDescription <em>Txt Description</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getView <em>View</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#isMany <em>Many</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getRepository <em>Repository</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getOperation <em>Operation</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getCrudOperationType <em>Crud Operation Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getViewParameter <em>View Parameter</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.DelegateOperationImpl#getFilter <em>Filter</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DelegateOperationImpl extends MinimalEObjectImpl.Container implements DelegateOperation {
	/**
	 * The default value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected static final String TXT_DESCRIPTION_EDEFAULT = null;

    /**
	 * The cached value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected String txtDescription = TXT_DESCRIPTION_EDEFAULT;

    /**
	 * The cached value of the '{@link #getView() <em>View</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getView()
	 * @generated
	 * @ordered
	 */
	protected DataView view;

	/**
	 * The default value of the '{@link #isMany() <em>Many</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isMany()
	 * @generated
	 * @ordered
	 */
    protected static final boolean MANY_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isMany() <em>Many</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isMany()
	 * @generated
	 * @ordered
	 */
    protected boolean many = MANY_EDEFAULT;

    /**
	 * The cached value of the '{@link #getRepository() <em>Repository</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepository()
	 * @generated
	 * @ordered
	 */
	protected Dao repository;

	/**
	 * The cached value of the '{@link #getOperation() <em>Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperation()
	 * @generated
	 * @ordered
	 */
	protected DaoOperation operation;

	/**
	 * The default value of the '{@link #getCrudOperationType() <em>Crud Operation Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCrudOperationType()
	 * @generated
	 * @ordered
	 */
	protected static final CrudOperationType CRUD_OPERATION_TYPE_EDEFAULT = CrudOperationType.NULL;

	/**
	 * The cached value of the '{@link #getCrudOperationType() <em>Crud Operation Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCrudOperationType()
	 * @generated
	 * @ordered
	 */
	protected CrudOperationType crudOperationType = CRUD_OPERATION_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getViewParameter() <em>View Parameter</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getViewParameter()
	 * @generated
	 * @ordered
	 */
	protected DataView viewParameter;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
    protected static final String NAME_EDEFAULT = null;

    /**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
    protected String name = NAME_EDEFAULT;

    /**
	 * The cached value of the '{@link #getFilter() <em>Filter</em>}' containment reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getFilter()
	 * @generated
	 * @ordered
	 */
    protected Expression filter;

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelegateOperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.DELEGATE_OPERATION;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getTxtDescription() {
		return txtDescription;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setTxtDescription(String newTxtDescription) {
		String oldTxtDescription = txtDescription;
		txtDescription = newTxtDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__TXT_DESCRIPTION, oldTxtDescription, txtDescription));
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataView getView() {
		if (view != null && view.eIsProxy()) {
			InternalEObject oldView = (InternalEObject)view;
			view = (DataView)eResolveProxy(oldView);
			if (view != oldView) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.DELEGATE_OPERATION__VIEW, oldView, view));
			}
		}
		return view;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataView basicGetView() {
		return view;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setView(DataView newView) {
		DataView oldView = view;
		view = newView;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__VIEW, oldView, view));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isMany() {
		return many;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setMany(boolean newMany) {
		boolean oldMany = many;
		many = newMany;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__MANY, oldMany, many));
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dao getRepository() {
		if (repository != null && repository.eIsProxy()) {
			InternalEObject oldRepository = (InternalEObject)repository;
			repository = (Dao)eResolveProxy(oldRepository);
			if (repository != oldRepository) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.DELEGATE_OPERATION__REPOSITORY, oldRepository, repository));
			}
		}
		return repository;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dao basicGetRepository() {
		return repository;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRepository(Dao newRepository) {
		Dao oldRepository = repository;
		repository = newRepository;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__REPOSITORY, oldRepository, repository));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DaoOperation getOperation() {
		if (operation != null && operation.eIsProxy()) {
			InternalEObject oldOperation = (InternalEObject)operation;
			operation = (DaoOperation)eResolveProxy(oldOperation);
			if (operation != oldOperation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.DELEGATE_OPERATION__OPERATION, oldOperation, operation));
			}
		}
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DaoOperation basicGetOperation() {
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperation(DaoOperation newOperation) {
		DaoOperation oldOperation = operation;
		operation = newOperation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__OPERATION, oldOperation, operation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CrudOperationType getCrudOperationType() {
		return crudOperationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCrudOperationType(CrudOperationType newCrudOperationType) {
		CrudOperationType oldCrudOperationType = crudOperationType;
		crudOperationType = newCrudOperationType == null ? CRUD_OPERATION_TYPE_EDEFAULT : newCrudOperationType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__CRUD_OPERATION_TYPE, oldCrudOperationType, crudOperationType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataView getViewParameter() {
		if (viewParameter != null && viewParameter.eIsProxy()) {
			InternalEObject oldViewParameter = (InternalEObject)viewParameter;
			viewParameter = (DataView)eResolveProxy(oldViewParameter);
			if (viewParameter != oldViewParameter) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.DELEGATE_OPERATION__VIEW_PARAMETER, oldViewParameter, viewParameter));
			}
		}
		return viewParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataView basicGetViewParameter() {
		return viewParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setViewParameter(DataView newViewParameter) {
		DataView oldViewParameter = viewParameter;
		viewParameter = newViewParameter;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__VIEW_PARAMETER, oldViewParameter, viewParameter));
	}
	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getName() {
		return name;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__NAME, oldName, name));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Expression getFilter() {
		return filter;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain basicSetFilter(Expression newFilter, NotificationChain msgs) {
		Expression oldFilter = filter;
		filter = newFilter;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__FILTER, oldFilter, newFilter);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setFilter(Expression newFilter) {
		if (newFilter != filter) {
			NotificationChain msgs = null;
			if (filter != null)
				msgs = ((InternalEObject)filter).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.DELEGATE_OPERATION__FILTER, null, msgs);
			if (newFilter != null)
				msgs = ((InternalEObject)newFilter).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.DELEGATE_OPERATION__FILTER, null, msgs);
			msgs = basicSetFilter(newFilter, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.DELEGATE_OPERATION__FILTER, newFilter, newFilter));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.DELEGATE_OPERATION__FILTER:
				return basicSetFilter(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.DELEGATE_OPERATION__TXT_DESCRIPTION:
				return getTxtDescription();
			case DomPackage.DELEGATE_OPERATION__VIEW:
				if (resolve) return getView();
				return basicGetView();
			case DomPackage.DELEGATE_OPERATION__MANY:
				return isMany();
			case DomPackage.DELEGATE_OPERATION__REPOSITORY:
				if (resolve) return getRepository();
				return basicGetRepository();
			case DomPackage.DELEGATE_OPERATION__OPERATION:
				if (resolve) return getOperation();
				return basicGetOperation();
			case DomPackage.DELEGATE_OPERATION__CRUD_OPERATION_TYPE:
				return getCrudOperationType();
			case DomPackage.DELEGATE_OPERATION__VIEW_PARAMETER:
				if (resolve) return getViewParameter();
				return basicGetViewParameter();
			case DomPackage.DELEGATE_OPERATION__NAME:
				return getName();
			case DomPackage.DELEGATE_OPERATION__FILTER:
				return getFilter();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.DELEGATE_OPERATION__TXT_DESCRIPTION:
				setTxtDescription((String)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__VIEW:
				setView((DataView)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__MANY:
				setMany((Boolean)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__REPOSITORY:
				setRepository((Dao)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__OPERATION:
				setOperation((DaoOperation)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__CRUD_OPERATION_TYPE:
				setCrudOperationType((CrudOperationType)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__VIEW_PARAMETER:
				setViewParameter((DataView)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__NAME:
				setName((String)newValue);
				return;
			case DomPackage.DELEGATE_OPERATION__FILTER:
				setFilter((Expression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.DELEGATE_OPERATION__TXT_DESCRIPTION:
				setTxtDescription(TXT_DESCRIPTION_EDEFAULT);
				return;
			case DomPackage.DELEGATE_OPERATION__VIEW:
				setView((DataView)null);
				return;
			case DomPackage.DELEGATE_OPERATION__MANY:
				setMany(MANY_EDEFAULT);
				return;
			case DomPackage.DELEGATE_OPERATION__REPOSITORY:
				setRepository((Dao)null);
				return;
			case DomPackage.DELEGATE_OPERATION__OPERATION:
				setOperation((DaoOperation)null);
				return;
			case DomPackage.DELEGATE_OPERATION__CRUD_OPERATION_TYPE:
				setCrudOperationType(CRUD_OPERATION_TYPE_EDEFAULT);
				return;
			case DomPackage.DELEGATE_OPERATION__VIEW_PARAMETER:
				setViewParameter((DataView)null);
				return;
			case DomPackage.DELEGATE_OPERATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DomPackage.DELEGATE_OPERATION__FILTER:
				setFilter((Expression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.DELEGATE_OPERATION__TXT_DESCRIPTION:
				return TXT_DESCRIPTION_EDEFAULT == null ? txtDescription != null : !TXT_DESCRIPTION_EDEFAULT.equals(txtDescription);
			case DomPackage.DELEGATE_OPERATION__VIEW:
				return view != null;
			case DomPackage.DELEGATE_OPERATION__MANY:
				return many != MANY_EDEFAULT;
			case DomPackage.DELEGATE_OPERATION__REPOSITORY:
				return repository != null;
			case DomPackage.DELEGATE_OPERATION__OPERATION:
				return operation != null;
			case DomPackage.DELEGATE_OPERATION__CRUD_OPERATION_TYPE:
				return crudOperationType != CRUD_OPERATION_TYPE_EDEFAULT;
			case DomPackage.DELEGATE_OPERATION__VIEW_PARAMETER:
				return viewParameter != null;
			case DomPackage.DELEGATE_OPERATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DomPackage.DELEGATE_OPERATION__FILTER:
				return filter != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (txtDescription: ");
		result.append(txtDescription);
		result.append(", many: ");
		result.append(many);
		result.append(", crudOperationType: ");
		result.append(crudOperationType);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}
	
	/**
	 * @generated NOT
	 */
	public boolean isUpdateOperation() {
		return CrudOperationType.ALL.equals(getCrudOperationType())
				|| CrudOperationType.UPDATE.equals(getCrudOperationType());
	}

	/**
	 * @generated NOT
	 */
	public boolean isCreateOperation() {
		return CrudOperationType.ALL.equals(getCrudOperationType())
				|| CrudOperationType.CREATE.equals(getCrudOperationType());
	}

	/**
	 * @generated NOT
	 */
	public boolean isReadOperation() {
		return CrudOperationType.ALL.equals(getCrudOperationType())
				|| CrudOperationType.READ.equals(getCrudOperationType());
	}
	
	/**
	 * @generated NOT
	 */
	public boolean isDeleteOperation() {
		return CrudOperationType.ALL.equals(getCrudOperationType())
				|| CrudOperationType.DELETE.equals(getCrudOperationType());
	}

} //DelegateOperationImpl
