/**
 * <copyright>
 * </copyright>
 *
 * $Id: DomFactoryImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.openxma.dsl.dom.DomFactory;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.*;
import org.openxma.dsl.dom.model.AggregateFunction;
import org.openxma.dsl.dom.model.AliasedExpression;
import org.openxma.dsl.dom.model.AltWhenClause;
import org.openxma.dsl.dom.model.ApplicationSession;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeFlag;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.AttributeSortOrder;
import org.openxma.dsl.dom.model.AttributeTextProperty;
import org.openxma.dsl.dom.model.AttributeValidationProperty;
import org.openxma.dsl.dom.model.AvailableFlag;
import org.openxma.dsl.dom.model.BetweenExpression;
import org.openxma.dsl.dom.model.BinaryExpression;
import org.openxma.dsl.dom.model.BooleanLiteralValue;
import org.openxma.dsl.dom.model.CallInputParameter;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;
import org.openxma.dsl.dom.model.CaseExpression;
import org.openxma.dsl.dom.model.CastFunction;
import org.openxma.dsl.dom.model.CollectionFunction;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.CrudOperationType;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DaoOperation;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataBaseConstraintType;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.DeleteStatement;
import org.openxma.dsl.dom.model.DerivedFlag;
import org.openxma.dsl.dom.model.EmptyLiteralValue;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.ExpressionFlag;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.FromRange;
import org.openxma.dsl.dom.model.FunctionCall;
import org.openxma.dsl.dom.model.IElementWithNoName;
import org.openxma.dsl.dom.model.InClass;
import org.openxma.dsl.dom.model.InCollection;
import org.openxma.dsl.dom.model.InCollectionElements;
import org.openxma.dsl.dom.model.InExpression;
import org.openxma.dsl.dom.model.InsertStatement;
import org.openxma.dsl.dom.model.IntegerLiteralValue;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.JoinEntity;
import org.openxma.dsl.dom.model.LikeExpression;
import org.openxma.dsl.dom.model.LiteralValue;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.MemberOfExpression;
import org.openxma.dsl.dom.model.NotExpression;
import org.openxma.dsl.dom.model.NullLiteralValue;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.ParenthesizedExpression;
import org.openxma.dsl.dom.model.Property;
import org.openxma.dsl.dom.model.PropertyAssignment;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.PropertyValue;
import org.openxma.dsl.dom.model.QlStatement;
import org.openxma.dsl.dom.model.QuantifiedExpression;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;
import org.openxma.dsl.dom.model.QueryParameterReference;
import org.openxma.dsl.dom.model.QueryParameterValue;
import org.openxma.dsl.dom.model.ReadOnlyFlag;
import org.openxma.dsl.dom.model.RealLiteralValue;
import org.openxma.dsl.dom.model.RequiredFlag;
import org.openxma.dsl.dom.model.SelectClass;
import org.openxma.dsl.dom.model.SelectObject;
import org.openxma.dsl.dom.model.SelectProperties;
import org.openxma.dsl.dom.model.SelectStatement;
import org.openxma.dsl.dom.model.Service;
import org.openxma.dsl.dom.model.SortOrderElement;
import org.openxma.dsl.dom.model.StringLiteralValue;
import org.openxma.dsl.dom.model.SubQuery;
import org.openxma.dsl.dom.model.TransientFlag;
import org.openxma.dsl.dom.model.TrimFunction;
import org.openxma.dsl.dom.model.UnaryExpression;
import org.openxma.dsl.dom.model.UpdateStatement;
import org.openxma.dsl.dom.model.ValueObject;
import org.openxma.dsl.dom.model.WhenClause;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DomFactoryImpl extends EFactoryImpl implements DomFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DomFactory init() {
		try {
			DomFactory theDomFactory = (DomFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.openxma.org/dsl/dom/DomDsl"); 
			if (theDomFactory != null) {
				return theDomFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DomFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DomFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case DomPackage.SERVICE: return createService();
			case DomPackage.PROPERTY: return createProperty();
			case DomPackage.OPERATION: return createOperation();
			case DomPackage.PARAMETER: return createParameter();
			case DomPackage.DELEGATE_OPERATION: return createDelegateOperation();
			case DomPackage.DAO_OPERATION: return createDaoOperation();
			case DomPackage.VALUE_OBJECT: return createValueObject();
			case DomPackage.DATA_VIEW: return createDataView();
			case DomPackage.FEATURE_REFERENCE: return createFeatureReference();
			case DomPackage.MAPPER: return createMapper();
			case DomPackage.PROPERTY_MAPPING: return createPropertyMapping();
			case DomPackage.ENTITY: return createEntity();
			case DomPackage.ATTRIBUTE: return createAttribute();
			case DomPackage.ATTRIBUTE_FLAG: return createAttributeFlag();
			case DomPackage.EXPRESSION_FLAG: return createExpressionFlag();
			case DomPackage.REQUIRED_FLAG: return createRequiredFlag();
			case DomPackage.READ_ONLY_FLAG: return createReadOnlyFlag();
			case DomPackage.AVAILABLE_FLAG: return createAvailableFlag();
			case DomPackage.DERIVED_FLAG: return createDerivedFlag();
			case DomPackage.TRANSIENT_FLAG: return createTransientFlag();
			case DomPackage.ATTRIBUTE_PROPERTY: return createAttributeProperty();
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY: return createAttributeValidationProperty();
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY: return createAttributeTextProperty();
			case DomPackage.ATTRIBUTE_GROUP: return createAttributeGroup();
			case DomPackage.ATTRIBUTE_SORT_ORDER: return createAttributeSortOrder();
			case DomPackage.DAO: return createDao();
			case DomPackage.QUERY_OPERATION: return createQueryOperation();
			case DomPackage.QUERY_PARAMETER: return createQueryParameter();
			case DomPackage.COLUMN: return createColumn();
			case DomPackage.MANY_TO_ONE: return createManyToOne();
			case DomPackage.ONE_TO_ONE: return createOneToOne();
			case DomPackage.ONE_TO_MANY: return createOneToMany();
			case DomPackage.MANY_TO_MANY: return createManyToMany();
			case DomPackage.DATA_BASE_CONSTRAINT: return createDataBaseConstraint();
			case DomPackage.APPLICATION_SESSION: return createApplicationSession();
			case DomPackage.QL_STATEMENT: return createQlStatement();
			case DomPackage.CALLABLE_STATEMENT: return createCallableStatement();
			case DomPackage.CALL_INPUT_PARAMETER: return createCallInputParameter();
			case DomPackage.CALL_OUTPUT_PARAMETER: return createCallOutputParameter();
			case DomPackage.INSERT_STATEMENT: return createInsertStatement();
			case DomPackage.DELETE_STATEMENT: return createDeleteStatement();
			case DomPackage.UPDATE_STATEMENT: return createUpdateStatement();
			case DomPackage.PROPERTY_ASSIGNMENT: return createPropertyAssignment();
			case DomPackage.SELECT_STATEMENT: return createSelectStatement();
			case DomPackage.SORT_ORDER_ELEMENT: return createSortOrderElement();
			case DomPackage.SELECT_PROPERTIES: return createSelectProperties();
			case DomPackage.SELECT_CLASS: return createSelectClass();
			case DomPackage.SELECT_OBJECT: return createSelectObject();
			case DomPackage.FROM_RANGE: return createFromRange();
			case DomPackage.FROM_CLASS: return createFromClass();
			case DomPackage.IN_CLASS: return createInClass();
			case DomPackage.IN_COLLECTION: return createInCollection();
			case DomPackage.IN_COLLECTION_ELEMENTS: return createInCollectionElements();
			case DomPackage.JOIN: return createJoin();
			case DomPackage.JOIN_ENTITY: return createJoinEntity();
			case DomPackage.EXPRESSION: return createExpression();
			case DomPackage.PROPERTY_VALUE: return createPropertyValue();
			case DomPackage.FUNCTION_CALL: return createFunctionCall();
			case DomPackage.TRIM_FUNCTION: return createTrimFunction();
			case DomPackage.CAST_FUNCTION: return createCastFunction();
			case DomPackage.AGGREGATE_FUNCTION: return createAggregateFunction();
			case DomPackage.QUERY_PARAMETER_REFERENCE: return createQueryParameterReference();
			case DomPackage.QUERY_PARAMETER_VALUE: return createQueryParameterValue();
			case DomPackage.QUANTIFIED_EXPRESSION: return createQuantifiedExpression();
			case DomPackage.CASE_EXPRESSION: return createCaseExpression();
			case DomPackage.WHEN_CLAUSE: return createWhenClause();
			case DomPackage.ALT_WHEN_CLAUSE: return createAltWhenClause();
			case DomPackage.COLLECTION_FUNCTION: return createCollectionFunction();
			case DomPackage.SUB_QUERY: return createSubQuery();
			case DomPackage.PARENTHESIZED_EXPRESSION: return createParenthesizedExpression();
			case DomPackage.LITERAL_VALUE: return createLiteralValue();
			case DomPackage.STRING_LITERAL_VALUE: return createStringLiteralValue();
			case DomPackage.INTEGER_LITERAL_VALUE: return createIntegerLiteralValue();
			case DomPackage.REAL_LITERAL_VALUE: return createRealLiteralValue();
			case DomPackage.BOOLEAN_LITERAL_VALUE: return createBooleanLiteralValue();
			case DomPackage.NULL_LITERAL_VALUE: return createNullLiteralValue();
			case DomPackage.EMPTY_LITERAL_VALUE: return createEmptyLiteralValue();
			case DomPackage.IELEMENT_WITH_NO_NAME: return createIElementWithNoName();
			case DomPackage.ALIASED_EXPRESSION: return createAliasedExpression();
			case DomPackage.BINARY_EXPRESSION: return createBinaryExpression();
			case DomPackage.NOT_EXPRESSION: return createNotExpression();
			case DomPackage.IN_EXPRESSION: return createInExpression();
			case DomPackage.BETWEEN_EXPRESSION: return createBetweenExpression();
			case DomPackage.LIKE_EXPRESSION: return createLikeExpression();
			case DomPackage.MEMBER_OF_EXPRESSION: return createMemberOfExpression();
			case DomPackage.UNARY_EXPRESSION: return createUnaryExpression();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case DomPackage.CRUD_OPERATION_TYPE:
				return createCrudOperationTypeFromString(eDataType, initialValue);
			case DomPackage.DATA_BASE_CONSTRAINT_TYPE:
				return createDataBaseConstraintTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case DomPackage.CRUD_OPERATION_TYPE:
				return convertCrudOperationTypeToString(eDataType, instanceValue);
			case DomPackage.DATA_BASE_CONSTRAINT_TYPE:
				return convertDataBaseConstraintTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Service createService() {
		ServiceImpl service = new ServiceImpl();
		return service;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operation createOperation() {
		OperationImpl operation = new OperationImpl();
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DelegateOperation createDelegateOperation() {
		DelegateOperationImpl delegateOperation = new DelegateOperationImpl();
		return delegateOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DaoOperation createDaoOperation() {
		DaoOperationImpl daoOperation = new DaoOperationImpl();
		return daoOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Parameter createParameter() {
		ParameterImpl parameter = new ParameterImpl();
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueObject createValueObject() {
		ValueObjectImpl valueObject = new ValueObjectImpl();
		return valueObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataView createDataView() {
		DataViewImpl dataView = new DataViewImpl();
		return dataView;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public DataView createDefaultDataView(Entity entity) {
		DataView defaultDataView = createDataView();
		defaultDataView.setName(entity.getDefaultDataViewName());
		FeatureReference featureReference = DomFactory.eINSTANCE.createFeatureReference();
		featureReference.setSource(entity);
		featureReference.setAll(true);
		defaultDataView.getFeatureReferences().add(featureReference);
		return defaultDataView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureReference createFeatureReference() {
		FeatureReferenceImpl featureReference = new FeatureReferenceImpl();
		return featureReference;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Mapper createMapper() {
		MapperImpl mapper = new MapperImpl();
		return mapper;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public PropertyMapping createPropertyMapping() {
		PropertyMappingImpl propertyMapping = new PropertyMappingImpl();
		return propertyMapping;
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IElementWithNoName createIElementWithNoName() {
		IElementWithNoNameImpl iElementWithNoName = new IElementWithNoNameImpl();
		return iElementWithNoName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AliasedExpression createAliasedExpression() {
		AliasedExpressionImpl aliasedExpression = new AliasedExpressionImpl();
		return aliasedExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BinaryExpression createBinaryExpression() {
		BinaryExpressionImpl binaryExpression = new BinaryExpressionImpl();
		return binaryExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotExpression createNotExpression() {
		NotExpressionImpl notExpression = new NotExpressionImpl();
		return notExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InExpression createInExpression() {
		InExpressionImpl inExpression = new InExpressionImpl();
		return inExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BetweenExpression createBetweenExpression() {
		BetweenExpressionImpl betweenExpression = new BetweenExpressionImpl();
		return betweenExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LikeExpression createLikeExpression() {
		LikeExpressionImpl likeExpression = new LikeExpressionImpl();
		return likeExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemberOfExpression createMemberOfExpression() {
		MemberOfExpressionImpl memberOfExpression = new MemberOfExpressionImpl();
		return memberOfExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnaryExpression createUnaryExpression() {
		UnaryExpressionImpl unaryExpression = new UnaryExpressionImpl();
		return unaryExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entity createEntity() {
		EntityImpl entity = new EntityImpl();
		return entity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QlStatement createQlStatement() {
		QlStatementImpl qlStatement = new QlStatementImpl();
		return qlStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CallableStatement createCallableStatement() {
		CallableStatementImpl callableStatement = new CallableStatementImpl();
		return callableStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CallInputParameter createCallInputParameter() {
		CallInputParameterImpl callInputParameter = new CallInputParameterImpl();
		return callInputParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CallOutputParameter createCallOutputParameter() {
		CallOutputParameterImpl callOutputParameter = new CallOutputParameterImpl();
		return callOutputParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InsertStatement createInsertStatement() {
		InsertStatementImpl insertStatement = new InsertStatementImpl();
		return insertStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeleteStatement createDeleteStatement() {
		DeleteStatementImpl deleteStatement = new DeleteStatementImpl();
		return deleteStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UpdateStatement createUpdateStatement() {
		UpdateStatementImpl updateStatement = new UpdateStatementImpl();
		return updateStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PropertyAssignment createPropertyAssignment() {
		PropertyAssignmentImpl propertyAssignment = new PropertyAssignmentImpl();
		return propertyAssignment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SelectStatement createSelectStatement() {
		SelectStatementImpl selectStatement = new SelectStatementImpl();
		return selectStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SortOrderElement createSortOrderElement() {
		SortOrderElementImpl sortOrderElement = new SortOrderElementImpl();
		return sortOrderElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SelectProperties createSelectProperties() {
		SelectPropertiesImpl selectProperties = new SelectPropertiesImpl();
		return selectProperties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SelectClass createSelectClass() {
		SelectClassImpl selectClass = new SelectClassImpl();
		return selectClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SelectObject createSelectObject() {
		SelectObjectImpl selectObject = new SelectObjectImpl();
		return selectObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FromRange createFromRange() {
		FromRangeImpl fromRange = new FromRangeImpl();
		return fromRange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FromClass createFromClass() {
		FromClassImpl fromClass = new FromClassImpl();
		return fromClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InClass createInClass() {
		InClassImpl inClass = new InClassImpl();
		return inClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InCollection createInCollection() {
		InCollectionImpl inCollection = new InCollectionImpl();
		return inCollection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InCollectionElements createInCollectionElements() {
		InCollectionElementsImpl inCollectionElements = new InCollectionElementsImpl();
		return inCollectionElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join createJoin() {
		JoinImpl join = new JoinImpl();
		return join;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JoinEntity createJoinEntity() {
		JoinEntityImpl joinEntity = new JoinEntityImpl();
		return joinEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression createExpression() {
		ExpressionImpl expression = new ExpressionImpl();
		return expression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PropertyValue createPropertyValue() {
		PropertyValueImpl propertyValue = new PropertyValueImpl();
		return propertyValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FunctionCall createFunctionCall() {
		FunctionCallImpl functionCall = new FunctionCallImpl();
		return functionCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TrimFunction createTrimFunction() {
		TrimFunctionImpl trimFunction = new TrimFunctionImpl();
		return trimFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CastFunction createCastFunction() {
		CastFunctionImpl castFunction = new CastFunctionImpl();
		return castFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AggregateFunction createAggregateFunction() {
		AggregateFunctionImpl aggregateFunction = new AggregateFunctionImpl();
		return aggregateFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryParameterReference createQueryParameterReference() {
		QueryParameterReferenceImpl queryParameterReference = new QueryParameterReferenceImpl();
		return queryParameterReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryParameterValue createQueryParameterValue() {
		QueryParameterValueImpl queryParameterValue = new QueryParameterValueImpl();
		return queryParameterValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QuantifiedExpression createQuantifiedExpression() {
		QuantifiedExpressionImpl quantifiedExpression = new QuantifiedExpressionImpl();
		return quantifiedExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseExpression createCaseExpression() {
		CaseExpressionImpl caseExpression = new CaseExpressionImpl();
		return caseExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WhenClause createWhenClause() {
		WhenClauseImpl whenClause = new WhenClauseImpl();
		return whenClause;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AltWhenClause createAltWhenClause() {
		AltWhenClauseImpl altWhenClause = new AltWhenClauseImpl();
		return altWhenClause;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionFunction createCollectionFunction() {
		CollectionFunctionImpl collectionFunction = new CollectionFunctionImpl();
		return collectionFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SubQuery createSubQuery() {
		SubQueryImpl subQuery = new SubQueryImpl();
		return subQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParenthesizedExpression createParenthesizedExpression() {
		ParenthesizedExpressionImpl parenthesizedExpression = new ParenthesizedExpressionImpl();
		return parenthesizedExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiteralValue createLiteralValue() {
		LiteralValueImpl literalValue = new LiteralValueImpl();
		return literalValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringLiteralValue createStringLiteralValue() {
		StringLiteralValueImpl stringLiteralValue = new StringLiteralValueImpl();
		return stringLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntegerLiteralValue createIntegerLiteralValue() {
		IntegerLiteralValueImpl integerLiteralValue = new IntegerLiteralValueImpl();
		return integerLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RealLiteralValue createRealLiteralValue() {
		RealLiteralValueImpl realLiteralValue = new RealLiteralValueImpl();
		return realLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BooleanLiteralValue createBooleanLiteralValue() {
		BooleanLiteralValueImpl booleanLiteralValue = new BooleanLiteralValueImpl();
		return booleanLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NullLiteralValue createNullLiteralValue() {
		NullLiteralValueImpl nullLiteralValue = new NullLiteralValueImpl();
		return nullLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EmptyLiteralValue createEmptyLiteralValue() {
		EmptyLiteralValueImpl emptyLiteralValue = new EmptyLiteralValueImpl();
		return emptyLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dao createDao() {
		DaoImpl dao = new DaoImpl();
		return dao;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryOperation createQueryOperation() {
		QueryOperationImpl queryOperation = new QueryOperationImpl();
		return queryOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryParameter createQueryParameter() {
		QueryParameterImpl queryParameter = new QueryParameterImpl();
		return queryParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Column createColumn() {
		ColumnImpl column = new ColumnImpl();
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ManyToOne createManyToOne() {
		ManyToOneImpl manyToOne = new ManyToOneImpl();
		return manyToOne;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OneToOne createOneToOne() {
		OneToOneImpl oneToOne = new OneToOneImpl();
		return oneToOne;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OneToMany createOneToMany() {
		OneToManyImpl oneToMany = new OneToManyImpl();
		return oneToMany;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ManyToMany createManyToMany() {
		ManyToManyImpl manyToMany = new ManyToManyImpl();
		return manyToMany;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataBaseConstraint createDataBaseConstraint() {
		DataBaseConstraintImpl dataBaseConstraint = new DataBaseConstraintImpl();
		return dataBaseConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute createAttribute() {
		AttributeImpl attribute = new AttributeImpl();
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeFlag createAttributeFlag() {
		AttributeFlagImpl attributeFlag = new AttributeFlagImpl();
		return attributeFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionFlag createExpressionFlag() {
		ExpressionFlagImpl expressionFlag = new ExpressionFlagImpl();
		return expressionFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RequiredFlag createRequiredFlag() {
		RequiredFlagImpl requiredFlag = new RequiredFlagImpl();
		return requiredFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReadOnlyFlag createReadOnlyFlag() {
		ReadOnlyFlagImpl readOnlyFlag = new ReadOnlyFlagImpl();
		return readOnlyFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AvailableFlag createAvailableFlag() {
		AvailableFlagImpl availableFlag = new AvailableFlagImpl();
		return availableFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DerivedFlag createDerivedFlag() {
		DerivedFlagImpl derivedFlag = new DerivedFlagImpl();
		return derivedFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransientFlag createTransientFlag() {
		TransientFlagImpl transientFlag = new TransientFlagImpl();
		return transientFlag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeProperty createAttributeProperty() {
		AttributePropertyImpl attributeProperty = new AttributePropertyImpl();
		return attributeProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeValidationProperty createAttributeValidationProperty() {
		AttributeValidationPropertyImpl attributeValidationProperty = new AttributeValidationPropertyImpl();
		return attributeValidationProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeTextProperty createAttributeTextProperty() {
		AttributeTextPropertyImpl attributeTextProperty = new AttributeTextPropertyImpl();
		return attributeTextProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeGroup createAttributeGroup() {
		AttributeGroupImpl attributeGroup = new AttributeGroupImpl();
		return attributeGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeSortOrder createAttributeSortOrder() {
		AttributeSortOrderImpl attributeSortOrder = new AttributeSortOrderImpl();
		return attributeSortOrder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property createProperty() {
		PropertyImpl property = new PropertyImpl();
		return property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationSession createApplicationSession() {
		ApplicationSessionImpl applicationSession = new ApplicationSessionImpl();
		return applicationSession;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CrudOperationType createCrudOperationTypeFromString(EDataType eDataType, String initialValue) {
		CrudOperationType result = CrudOperationType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCrudOperationTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataBaseConstraintType createDataBaseConstraintTypeFromString(EDataType eDataType, String initialValue) {
		DataBaseConstraintType result = DataBaseConstraintType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDataBaseConstraintTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DomPackage getDomPackage() {
		return (DomPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DomPackage getPackage() {
		return DomPackage.eINSTANCE;
	}

} //DomFactoryImpl
